<?php
namespace jy_weishop;
defined('BY_JYA') or exit('error');
/*
	订单
*/
class order extends \plugin{
	//订单创建时，执行此方法，执行相关操作
	public $sendtypes=array(
		'1'=>'快递配送',
		'2'=>'自提/核销',
		'3'=>'虚拟发货',
	);
	public function create($params,$uid='',$url=''){
		$this->order=$params;
		$this->order['createtime']=TIMESTAMP;
		$uid=$uid?$uid:$_SESSION['uid'];
		$area_code=pdo_getcolumn('jy_weishop_member',array('mid'=>$params['mid']?:$uid),'area_code');
		$order=array(
			'uniacid'=>$_SESSION['uniacid'],
			'ordersn'=>$params['ordersn']?:get_ordersn($this->tablename('order'),'ordersn'),
			'mid'=>$params['mid']?:$uid,
			'price'=>$params['price'],
			'outnum_fee'=>$params['outnum_fee'],
			'goodsprice'=>$params['goodsprice'],
			'dispatchprice'=>$params['dispatchprice'],
			'level_de_price'=>$params['level_de_price'],
			'luck_de_price'=>$params['luck_de_price'],
			'buyxiu_de_price'=>$params['buyxiu_de_price'],
			'enough_de_price'=>$params['enough_de_price'],
			'coupon_de_price'=>$params['coupon_de_price'],
			'deductcredit'=>$params['deduct_credit'],
			'deductcredit2'=>$params['deduct_credit2'],
			'couponid'=>$params['couponid'],
			'remark'=>$params['remark'],
			'sendtype'=>$params['sendtype'],
			'addressid'=>$params['addressid'],
			'storeid'=>$params['storeid'],
			'merchid'=>$params['merchid']?:$params['goods']['0']['merchid'],
			'plugin_name'=>$params['plugin_name']?:$_SESSION['current_plugin'],
			'tableid'=>intval($params['tableid']),
			'area_code'=>$area_code,
			'isdish'=>intval($params['isdish']),
			'diyformdata'=>$params['diyfields'],
			'createtime'=>$params['createtime']?:TIMESTAMP,
			'teamid'=>intval($params['teamid']),
			'is_team'=>intval($params['is_team']),
			'send_status'=>intval($params['send_status']),
			'out_upfee'=>$params['out_upfee'],
			'api_id'=>$params['api_id']?:$params['goods']['0']['api_id'],
			'api_pluginname'=>$params['api_pluginname']?:$params['goods']['0']['api_pluginname'],
		);
		/*
			核销
		*/
		$num=0;
		$verifynum=0;
		foreach($params['goods'] as &$gv){
			$this->model('goods')->check_buy($gv['goodsid'],$gv['total'],$gv['optionid']);
			$goodsinfo=$this->pdo_get('goods',array('id'=>$gv['goodsid']),array('totalcnf','api_id','api_pluginname'));
			$gv['api_id']=$goodsinfo['api_id'];
			$gv['api_pluginname']=$goodsinfo['api_pluginname'];
			if($goodsinfo['totalcnf']==0){
					//拍下减库存
				if($gv['optionid']){
					pdo_update('jy_weishop_goods_option',array('stock -='=>$gv['total']),array('id'=>$gv['optionid']));
				}else{
					pdo_update('jy_weishop_goods',array('total -='=>$gv['total']),array('id'=>$gv['goodsid']));
				}
			}
			//判断订单核销分量
			$num +=1;
			if($gv['isverify']==1){
				$verifynum +=1;
			}
		}
		if($verifynum==$num && $verifynum>0){
			$order['isverify']=2;
		}elseif($verifynum<$num && $verifynum>0){
			$order['isverify']=1;
		}else{
			$order['isverify']=0;
		}
		//来源追加订单
		if($params['oldorderid']){
			$uporder=$order;
			unset($uporder['mid'],$uporder['uniacid'],$uporder['ordersn'],$uporder['createtime'],$uporder['storeid']);
			$order_id=$params['oldorderid'];
			$this->pdo_update('order',$uporder,array('id'=>$order_id));
		}else{
			$this->pdo_insert('order',$order);
			$order_id=$this->pdo_insertid();
		}
		$this->order['id']=$order_id;
		$this->order['ordersn']=$order['ordersn'];
		//店内取
		if(!$params['oldorderid'] && ($params['sendtype']==2 || $params['sendtype']==3 || $params['isdish']==1 || $params['make_type']==1 || $params['is_peisong']==1)){
			if($uid){
				$mobile=pdo_getcolumn('core_members',array('id'=>$uid),'mobile');	
				$nickname=pdo_getcolumn('core_members',array('id'=>$uid),'nickname');	
			}else{
				$mobile=$params['mobile']?$params['mobile']:'无';
				$nickname=$params['username']?$params['username']:'店面客户';
			}
			$address=pdo_get('core_address',array('id'=>$params['addressid']),array('pcd','address','mobile','name'));
			$address['pcd']=json_decode($address['pcd'],true);
			$addressinfo=$address['pcd']['province'].' '.$address['pcd']['city'].' '.$address['pcd']['district'].' '.$address['pcd']['street'].''.$address['address'];
			$daytime = mktime(0,0,0,date('m'),date('d'),date('Y'));
			$selfcount=pdo_count('jy_weishop_order_self',array('uniacid'=>$_SESSION['uniacid'],'createtime >'=>$daytime),'id');
			$daysnum=date('Ymd',time());
			$selfnumber='NO'.$daysnum.sprintf("%04d", $selfcount+1);
			$self=array(
				'uniacid'=>$_SESSION['uniacid'],
				'mid'=>$params['mid']?:$uid,
				'storeid'=>$params['storeid'],
				'orderid'=>$order_id,
				'table_id'=>intval($params['tableid']),
				'username'=>$address['name']?:$nickname,
				'mobile'=>$address['mobile']?:$mobile,
				'address'=>$addressinfo,
				'number'=>$selfnumber,
				'status'=>0,
				'type'=>intval($params['self_type']),
				'selftime'=>$params['selftime']?strtotime($params['selftime']):'',
				'out_time'=>trim($params['out_time']),
				'createtime'=>time()
			);
			$this->pdo_insert('order_self',$self);
		}
		//优惠券锁定
		if(!$params['oldorderid'] && $order['couponid']){
			pdo_update('jy_weishop_coupon_getlog',array('islock'=>1),array('id'=>$order['couponid'],'uniacid'=>$_SESSION['uniacid']));
		}
		//整理订单商品
		foreach($params['goods'] as $item){
			$new_order_goods=array(
				'uniacid'=>$_SESSION['uniacid'],
				'mid'=>$params['mid'],
				'orderid'=>$order_id,
				'goodsid'=>$item['goodsid'],
				'optionid'=>$item['optionid'],
				'price'=>$item['price'],
				'total'=>$item['total'],
				'merchid'=>$item['merchid'],
				'plugin_name'=>$this->session('fromplugin_name'),
				'frompid'=>$this->session('frompid'),
				'fee_desc'=>ijson_encode($fee_desc),
				'api_id'=>$item['api_id'],
				'api_pluginname'=>$item['api_pluginname'],
				'active'=>$item['active']?ijson_encode($item['active']):'',
				'createtime'=>TIMESTAMP,
			);
			if($new_order_goods['optionid']){
					$specs=$this->pdo_get('goods_option',array('id'=>$item['optionid']),'specs');
					$specstitle=explode("_",$specs['specs']);
					foreach($specstitle as &$spec){
						$spec=$this->pdo_getcolumn('goods_spec_item',array('id'=>$spec),'title');
					}
					$new_order_goods['optiondata']=implode(" ",$specstitle);
			}
			//来自直播间
			$room_goods=$this->session('room_goods');
			if($room_goods){
				if($room_goods[$item['goodsid']]){
					$new_order_goods['roomid']=$room_goods[$item['goodsid']];
				}
			}
			$new_order_goods['total_price']=$new_order_goods['price']*$new_order_goods['total'];
			$this->pdo_insert('order_goods',$new_order_goods);
			//清理购物车
			if($item['id']){
				$this->pdo_delete('member_cart',array('id'=>$item['id']));
			}
			//活动插件			
			$goods=$this->get('goods',array('id'=>$item['goodsid'],'uniacid'=>$_SESSION['uniacid']),array('id','active_plugin','active_id'));
			if($goods['active_plugin']){				
				$parameter=array(
					'active_plugin'=>$goods['active_plugin'],
					'active_id'=>$goods['active_id'],
					'goods_id'=>$goods['id'],
					'price'=>$new_order_goods['price'],
					'num'=>$item['total'],
					'optionid'=>$item['optionid'],
					'ordersn'=>$order['ordersn'],
					'order_id'=>$order_id,
					'mid'=>$order['mid'],
					'order_price'=>$order['price'],
				);
				//到指定活动插件下面model/order_create
				$this->model('activity')->order_create($parameter);
			}
			//买家秀清0
			if($item['buyxiu_de_price']>0){
				$this->model('activity')->get_buyxiu_up0($goods['id']);
			}
		}
		//设置单商户费用
		$this->setfee_desc($order_id);
		if(pdo_fieldexists($this->tablename('order_invoice'),'order_id')){
			pdo_query('alter table '.tablename($this->tablename('order_invoice')).' drop `order_id`;');
		}
		//发票
		if(!$params['oldorderid'] && $params['invoce']){
			$invoce=array(
				'orderid'=>$order_id,
				'uniacid'=>$_SESSION['uniacid'],
				'type'=>$params['invoce']['invoicetype'],
				'goodstype'=>$params['invoce']['invoicegoodstype'],
				'name'=>$params['invoce']['invoicename'],
				'code'=>$params['invoce']['invoicecode'],
				'email'=>$params['invoce']['email'],
			);
			$this->pdo_insert('order_invoice',$invoce);
		}
		//下单时送积分（非支付，完成时）
		$buy_credit_setting=$this->plugin_setting('buy_credit');		
		if($buy_credit_setting['open'] && $buy_credit_setting['time']=='create'){
			$this->buy_credit($order_id);
		}
		//赠品
		if($params['gift_id']){
			$new_gift=array(
				'uniacid'=>$_SESSION['uniacid'],
				'mid'=>$params['mid'],
				'order_id'=>$order_id,
				'gift_id'=>$params['gift_id'],
				'createtime'=>TIMESTAMP,
				'gifts'=>$this->pdo_getcolumn('goods_gift',array('id'=>$params['gift_id']),'gifts'),
			);
			$this->pdo_insert('order_gift',$new_gift);
		}
		$notice_setting=$this->plugin_setting('notice');
		if($params['plugin_name']=='jy_weidish'){
				$url=custom_url('jy_weidish/orderdetail//id='.$order_id,true);
		}
		$this->model('notice')->notice_create2buyer($this->order,$url);
		if($notice_setting['seller']){
			foreach($notice_setting['seller'] as $member){
					$this->model('notice')->notice_create2seller($this->order,$member['mid']);
			}
		}
		//打印
		$this->model('printmsg')->storeprint('',$order_id,0,0);
		$this->publish('order.create',$this->order);
		return $order_id;
	}
	
	public function get_order($order_id,$merchid=0){
		if($this->order && $this->order['id']==$order_id){
			return $this->order;
		}
		$this->order=$this->get('order',array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
		if($merchid){
			$this->order['goods']=$this->getall('order_goods',array('orderid'=>$order_id,'merchid'=>$merchid));
		}else{
			$this->order['goods']=$this->getall('order_goods',array('orderid'=>$order_id));
		}
		foreach($this->order['goods'] as &$goods){
			$goods_data=$this->get('goods',array('id'=>$goods['goodsid']),array('title','image','type','isverify','goodssn','productsn'));
			//商品规格
			if($goods['optionid']){
				$specs=pdo_getcolumn('jy_weishop_goods_option',array('id'=>$goods['optionid']),'specs');
				$specs=explode("_",$specs);
				foreach($specs as &$spec){
					$spec=pdo_getcolumn('jy_weishop_goods_spec_item',array('id'=>$spec),'title');
				}
				$goods['selespename']=implode("，",$specs);
			}
			$goods=array_merge($goods,$goods_data);
		}
		$this->order['express']=$this->get('order_express',array('orderid'=>$order_id));
		return $this->order;
	}
	
	//订单取消
	public function order_cancel($order_id,$istask=false){
		$this->get_order($order_id);
		if(!$this->order || $this->order['status'] !=0){
			if($istask){
				return false;
			}else{
				exi('订单不存在或者不支持取消！','error');
			}
		}
		$this->update('order',array('status'=>4),array('id'=>$order_id));
		$this->update('order_goods',array('status'=>4),array('orderid'=>$order_id));
		//恢复库存
		$getgoods=pdo_getall('jy_weishop_order_goods',array('uniacid'=>$_SESSION['uniacid'],'orderid'=>$order_id),array('goodsid','total','optionid'));
		foreach($getgoods as $item){
			if($item['optionid']){
				$this->update('goods_option',array('stock +='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['optionid']));
			}else{
				$this->update('goods',array('total +='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['goodsid']));
			}
		}
		//优惠券解锁
		if($this->order['couponid']){
			pdo_update('jy_weishop_coupon_getlog',array('islock'=>0),array('id'=>$this->order['couponid'],'uniacid'=>$_SESSION['uniacid']));
		}
		$notice_setting=$this->plugin_setting('notice');
		$this->model('notice')->notice_cancel2buyer($this->order);
		if($notice_setting['seller']){
			foreach($notice_setting['seller'] as $member){
				$this->model('notice')->notice_cancel2seller($this->order,$member['mid']);
			}
		}
	}
	//订单删除
	public function order_delete($order_id,$userdeleted=false){
		$this->get_order($order_id);
		if(!$this->order){
			exi('订单不存在或者不支持删除！','error');
		}
		if($userdeleted){
			$this->update('order',array('userdeleted'=>1),array('id'=>$order_id));
		}else{
			$this->update('order',array('deleted'=>1),array('id'=>$order_id));
		}
		if(!$this->order['status']){
			//恢复库存
			$getgoods=pdo_getall('jy_weishop_order_goods',array('uniacid'=>$_SESSION['uniacid'],'orderid'=>$order_id),array('goodsid','total','optionid'));
			foreach($getgoods as $item){
				if($item['optionid']){
					$this->update('goods_option',array('stock +='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['optionid']));
				}else{
					$this->update('goods',array('total +='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['goodsid']));
				}
			}
		}
	}
	public function order_rdelete($order_id){
		$this->get_order($order_id);
		if(!$this->order || $this->order['status']){
			exi('订单不存在或者不支持删除！','error');
		}
		pdo_delete('jy_weishop_order',array('uniacid'=>$_SESSION['uniacid'],'id'=>$order_id));
		if(!$this->order['status']){
			//恢复库存
			$getgoods=pdo_getall('jy_weishop_order_goods',array('uniacid'=>$_SESSION['uniacid'],'orderid'=>$order_id),array('goodsid','total','optionid'));
			foreach($getgoods as $item){
				if($item['optionid']){
					$this->update('goods_option',array('stock +='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['optionid']));
				}else{
					$this->update('goods',array('total +='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['goodsid']));
				}
			}
		}
	}
	//订单恢复
	public function order_reset($order_id,$userdeleted=false){
		$this->get_order($order_id);
		if(!$this->order){
			exi('订单不存在！','error');
		}
		if($userdeleted){
			$this->update('order',array('userdeleted'=>0),array('id'=>$order_id));
		}else{
			$this->update('order',array('deleted'=>0),array('id'=>$order_id));
		}
		if(!$this->order['status']){
			//恢复库存
			$getgoods=pdo_getall('jy_weishop_order_goods',array('uniacid'=>$_SESSION['uniacid'],'orderid'=>$order_id),array('goodsid','total','optionid'));
			foreach($getgoods as $item){
				if($item['optionid']){
					$this->model('goods')->check_buy($item['goodsid'],$item['total'],$item['optionid']);
					$this->update('goods_option',array('stock -='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['optionid']));
				}else{
					$this->model('goods')->check_buy($item['goodsid'],$item['total']);
					$this->update('goods',array('total -='=>$item['total']),array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['goodsid']));
				}
			}
		}
	}
	public function order_cancelfh($order_id){
		$this->update('order',array('status'=>1),array('id'=>$order_id));
		$this->update('order_goods',array('status'=>1),array('orderid'=>$order_id));
	}
	//支付
	public function order_pay($order_id,$params,$url=''){
		$this->get_order($order_id);
		if(!$this->order || $this->order['ispay']){
			exi('订单不存在或者已支付！','error');
		}
		$update=array(
				'status'=>$params['status']?:1,
				'paytype'=>$params['paytype'],
				'transid'=>$params['transid'],
		);
		if($params['paytype']=='hdfk'){
			$update['ispay']=0;
		}else{
			$update['ispay']=1;
			$update['paytime']=TIMESTAMP;
		}
		foreach($update as $key=>$value){
			$this->order[$key]=$value;
		}
		$this->pdo_update('order',$update,array('id'=>$order_id));
		//更新单商品支付状态
		$this->update('order_goods',array('status'=>1,'ispay'=>$update['ispay']),array('orderid'=>$order_id));
		$noticemids=array();
		foreach($this->order['goods'] as $item){
			$goodsinfo=$this->pdo_get('goods',array('id'=>$item['goodsid']),array('noticemid','totalcnf','noticetype'));
			if($goodsinfo['totalcnf']==1){
				//付款减库存
				if($item['optionid']){
					pdo_update('jy_weishop_goods_option',array('stock -='=>$item['total']),array('id'=>$item['optionid']));
				}else{
					pdo_update('jy_weishop_goods',array('total -='=>$item['total']),array('id'=>$item['goodsid']));
				}
			}
			pdo_update('jy_weishop_goods',array('salerealnum +='=>1,'salenum +='=>$item['total']),array('id'=>$item['goodsid']));			
			//直播数据更新
			pdo_update('core_account_wxapp_live_rooms',array('totalfee +='=>$item['total_price'],'salenum +='=>$item['total']),array('id'=>$item['roomid'],'uniacid'=>$_SESSION['uniacid']));
			//推送消息给卖家		
			if($goodsinfo['noticemid']){
				if(strpos($goodsinfo['noticetype'],';1;') !== false){
					if(!in_array($goodsinfo['noticemid'],$noticemids)){
						$noticemids[]=$goodsinfo['noticemid'];
					}
				}
			}
			//活动数据
			if($item['active']){
				$active=json_decode($item['active'],true);
				if($active['libao_id']){
					$this->pdo_update('sale_libao',array('status'=>1),array('id'=>$active['libao_id']));
				}
			}
		}
		foreach($noticemids as $n){
			$this->model('notice')->notice_pay2seller($this->order,$n,$url);
		}
		$notice_setting=$this->plugin_setting('notice');
		$this->model('notice')->notice_pay2buyer($this->order,$url);
		if($notice_setting['seller']){
			foreach($notice_setting['seller'] as $member){
				$this->model('notice')->notice_pay2seller($this->order,$member['mid'],$url);
			}
		}
		//推送消息给店员
		$sellers=pdo_getall('jy_weishop_store_worker',array('storeid'=>$this->order['store_id'],'status'=>1,'getmessage'=>1),'mid');
		if($sellers){
			foreach($sellers as $v){
				$this->model('notice')->notice_pay2seller($this->order,$v['mid'],$url);
			}
		}
		/*
			按商品虚拟商品和核销商品自动发货
			非拼团订单，才自动发货
		*/
		if($this->order['is_team']!=1 && $this->order['isdish']!=1){
			foreach($this->order['goods'] as $vv){
				//已经整理出了商品类型type,isverify，只要支持核销，无论什么商品都可以核销！
				if($vv['isverify']==1 && $vv['type']!=2){
					if($vv['type']==3){
						$this->order_send_verifygoods($order_id,$vv['goodsid'],$this->order['sendtype']);
					}elseif($vv['type']==0){
						//实体物品，需配送时，依然生成核销码，但是不刷新配送状态
						$this->order_send_verify($order_id,$vv['goodsid'],$this->order['sendtype']);
					}else{
						$this->order_send_verify($order_id,$vv['goodsid'],$this->order['sendtype']);
					}
				}elseif($vv['type']==1 || $vv['type']==2){
					//虚拟发货，如果是自动发货
					$goods=$this->pdo_get('goods',array('id'=>$vv['goodsid']),array('type','virtualsend','virtualsendcont','virtual_template_id'));
					if(($goods['virtualsend']) || $vv['type']==2){
						$vv=array_merge($vv,$goods);
						$this->order_send_virtual($order_id,$vv);
					}
				}
			}
		}
		//会员等级变更
		$this->model('member')->check_uplevel($this->order['mid'],1);
		//优惠券已使用
		if($this->order['couponid']){
			$this->model('coupon')->usecoupon($this->order['couponid']);
		}
		//购物送积分
		$buy_credit_setting=$this->plugin_setting('buy_credit');
		if($buy_credit_setting['open'] && $buy_credit_setting['time']=='pay'){
			$this->buy_credit($order_id);
		}
		//抵扣积分
		if($this->order['deductcredit']){
			$this->deduct_credit($order_id);
		}
		//购物送券，这里判断是否需要购物送券。如有需要，推送相关消息
		foreach($this->order['goods'] as $item){
			$coupon=$this->pdo_get('coupon_goodsendtask',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'goodsid'=>$item['goodsid']));
			if($coupon && $coupon['couponid'] && $coupon['sendpoint']==2 && $coupon['num'] >= $coupon['sendnum']){
				//购物送券活动存在，且发送时机为订单付款时，且剩余数量高于每个用户发送数量，此时尝试推送优惠券消息。
				$params=array(
					'mid'=>$this->order['mid'],
					'ac_type'=>'goods',
					'ac_id'=>$coupon['id'],
					'remark'=>'购物送券活动',
				);
				$this->model('coupon')->give_coupon($params);
			}
		}
		//满额送券，查找是否有符合条件的满额送券活动
		$coupon=$this->pdo_get('coupon_sendtasks',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'price <='=>$this->order['price']));
		if($coupon && $coupon['couponid'] && $coupon['sendpoint']==2 && $coupon['num'] >= $coupon['sendnum']){
			$params=array(
				'mid'=>$this->order['mid'],
				'ac_type'=>'order',
				'ac_id'=>$coupon['id'],
				'remark'=>'订单满额送券活动',
			);
			$this->model('coupon')->give_coupon($params);
		}
		//游戏营销，购物参与
		foreach($this->order['goods'] as $item){
			$game=$this->pdo_get('game',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'type'=>2,'time'=>2,'goodsid'=>$item['goodsid']));
			if($game){
				$params=array(
					'mid'=>$this->order['mid'],
					'game_id'=>$game['id'],
					'remark'=>'购物参与活动',
				);
				$this->model('game')->add_game($params);
			}
		}
		$game=$this->pdo_get('game',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'type'=>1,'time'=>2,'price <='=>$this->order['price']));
		if($game){
				$params=array(
					'mid'=>$this->order['mid'],
					'game_id'=>$game['id'],
					'remark'=>'购物参与活动',
				);
				$this->model('game')->add_game($params);
		}
		//自动派单，非拼团，非制作商品
		if($this->order['sendtype']==1 && $this->order['is_team']!=1 && $this->order['send_status']!=11){
			$citypeisong=$this->plugin_setting('citypeisong');
			if($this->plugin_exists('jy_peisong')){
				if($citypeisong['isopen']==1 && $citypeisong['set_peisonguser']==1){
					model('jy_peisong/order')->order_pai($this->order);
				}
			}
		}
		//打印
		$this->model('printmsg')->storeprint('',$order_id,0,1);
		$event=array(
			'type'=>'pay',
			'order'=>$this->order,
		);
		$this->publish('order.change',$event);
	}
	//发货
	public function order_send($order_id,$params=array()){
		$data=array(
			'uniacid'=>$_SESSION['uniacid'],
			'orderid'=>$order_id,
			'express_id'=>intval($params['express']),
			'expresssn'=>$params['expresssn'],
			'opensend_type'=>$params['opensend_type'],
			'createtime'=>TIMESTAMP,
		);
		$this->insert('order_express',$data);
		if($params['send_status']){
			$this->update('order',array('send_status'=>$params['send_status']),array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
		}else{
			$this->update('order',array('status'=>2,'sendtime'=>time()),array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			$this->update('order_goods',array('status'=>2,'sendtime'=>time()),array('orderid'=>$order_id));
			$this->get_order($order_id);
			$this->order['sendtime']=TIMESTAMP;
			$notice_setting=$this->plugin_setting('notice');
			$this->model('notice')->notice_send2buyer($this->order);
			if($notice_setting['seller']){
				foreach($notice_setting['seller'] as $member){
					$this->model('notice')->notice_send2seller($this->order,$member['mid']);
				}
			}
		}
	}
	//自动发货
	public function order_vsend($order_id,$params=array()){
		$this->update('order',array('status'=>2,'sendtime'=>TIMESTAMP,'finishtime'=>TIMESTAMP),array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
		$this->update('order_goods',array('status'=>2,'sendtime'=>TIMESTAMP,'finishtime'=>TIMESTAMP),array('orderid'=>$order_id));
		$this->get_order($order_id);
		$this->order['sendtime']=TIMESTAMP;
		$this->order['finishtime']=TIMESTAMP;
		$this->order['mobile']=pdo_getcolumn('core_members',array('id'=>$this->order['mid']),'mobile');	
		$this->order['nickname']=$nickname=pdo_getcolumn('core_members',array('id'=>$this->order['mid']),'nickname');
		$this->order_receive($order_id,true);
		$notice_setting=$this->plugin_setting('notice');
		$this->model('notice')->notice_vsend2buyer($this->order);
		if($notice_setting['seller']){
			foreach($notice_setting['seller'] as $member){
				$this->model('notice')->notice_send2seller($this->order,$member['mid']);
			}
		}
		
	}
	public function order_send_virtual($order_id,$goods=false){
		if(is_string($goods)){
			//兼容直接自定义发货内容的类型
			$content=$goods;
			$goods=false;
		}
		if(!$goods){
			$goodsid=$this->pdo_getcolumn('order_goods',array('orderid'=>$orderid),'goodsid');
			$goods=$this->pdo_get('goods',array('id'=>$goodsid),array('id','type','virtualsend','virtualsendcont','virtual_template_id'));
			if($content){
				$goods['virtualsendcont']=$content;
			}
		}
		$data=array(
			'uniacid'=>$_SESSION['uniacid'],
			'orderid'=>$order_id,
			'goodsid'=>$goods['goodsid'],
			'createtime'=>TIMESTAMP,
		);
		$virtualinfo='';
		for($i=0;$i<$goods['total'];$i++){
				$num=$i+1;
				$data['content']='';
				if($goods['type']==1){
					//发需虚拟物品
					for($i=0;$i<$goods['total'];$i++){
						$num=$i+1;
						$data['content'] .='发货信息('.$num.'):'.$goods['virtualsendcont'];
					}
				}else{
				//发卡密
					$virtual_data=$this->pdo_get('virtual_data',array('tempid'=>$goods['virtual_template_id'],'mid'=>0),array('id','fields'));
					$virtual_update=array(
						'mid'=>$this->order['mid'],
						'usetime'=>TIMESTAMP,
						'orderid'=>$this->order['id'],
						'ordersn'=>$this->order['ordersn'],
						'price'=>$this->order['price'],
					);
					$this->pdo_update('virtual_data',$virtual_update,array('id'=>$virtual_data['id']));
					//更新卡密库存
					$this->model('order')->up_virtualtotal($goods['virtual_template_id']);
					$virtual_temp=$this->pdo_get('virtual_temp',array('id'=>$goods['virtual_template_id']));
					if($virtual_data && $virtual_temp){
						$virtual_data['fields']=json_decode($virtual_data['fields'],true);
						$virtual_temp['fields']=json_decode($virtual_temp['fields'],true);
						foreach($virtual_temp['fields'] as $field){
							$data['content'].=$field['title'].'('.$num.')：'.$virtual_data['fields'][$field['kw']].' ';
						}
					}
					$data['virtualid']=$goods['virtual_template_id'];
				}
				$virtualinfo.=$data['content'];
				$this->pdo_insert('order_virtual',$data);
		}
		$this->order['virtualinfo']=$virtualinfo;
		$this->pdo_update('order',array('virtualsendinfo'=>$virtualinfo),array('id'=>$this->order['id']));
		//更新订单状态，发货
		$this->order_vsend($order_id);
		return true;
	}
	public function order_send_verify($order_id,$goodsid='',$sendtype=0){
		//自提核销
		$goods=$this->pdo_get('goods',array('id'=>$goodsid),array('verifytype','usetime'));
		$goods['total']=pdo_getcolumn('jy_weishop_order_goods',array('orderid'=>$order_id,'goodsid'=>$goodsid),'total');
		$order_verify=array(
			'uniacid'=>$_SESSION['uniacid'],
			'orderid'=>$order_id,
			'goodsid'=>$goodsid,
			'createtime'=>TIMESTAMP,
			'status'=>0,
			'store_id'=>$this->order['storeid'],
		);
		if($goods['usetime']){
			$order_verify['endtime']=TIMESTAMP+$goods['usetime']*86400;
		}
			if($goods['verifytype']==0){
				//按订单核销
				do{
					$verify_code=random(10);
				}while($this->pdo_getcolumn('order_verify',array('uniacid'=>$_SESSION['uniacid'],'verify_code'=>$verify_code),'id'));
				$data=array(
					'verifytype'=>0,
					'verify_code'=>$verify_code,
				);
				$order_verify=array_merge($data,$order_verify);
				
				$this->pdo_insert('order_verify',$order_verify);
			}elseif($goods['verifytype']==1){
				//按次核销
				do{
					$verify_code=random(10);
				}while($this->pdo_getcolumn('order_verify',array('uniacid'=>$_SESSION['uniacid'],'verify_code'=>$verify_code),'id'));
				
				$data=array(
					'verifytype'=>1,
					'verify_num'=>$goods['total'],
					'verify_code'=>$verify_code,
				);
				$order_verify=array_merge($data,$order_verify);
				$this->pdo_insert('order_verify',$order_verify);
			}elseif($goods['verifytype']==2){
				//按消费码核销
				
				for($i=0;$i<$goods['total'];$i++){
					do{
						$verify_code=random(10);
					}while($this->pdo_getcolumn('order_verify',array('uniacid'=>$_SESSION['uniacid'],'verify_code'=>$verify_code),'id'));
					$data=array(
						'verifytype'=>2,
						'verify_code'=>$verify_code,
					);
					$order_verify=array_merge($data,$order_verify);
					$this->pdo_insert('order_verify',$order_verify);
				}
				
			}
		if($sendtype!=1){
			$this->update('order',array('status'=>2),array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			$this->update('order_goods',array('status'=>2),array('orderid'=>$order_id));
		}
		return true;
	}
	public function order_verify($verify_code,$clerk_id){
		$order_verify=$this->pdo_get('order_verify',array('verify_code'=>$verify_code));
		if(!$order_verify){
			exi('核销码不存在！','error');
		}
		if($order_verify['status'] ){
			exi('核销码已被使用或已过期！','error');
		}
		if($order_verify['endtime'] && $order_verify['endtime']<TIMESTAMP){
			$this->pdo_update('order_verify',array('status'=>2),array('orderid'=>$order_verify['orderid']));
			exi('该核销码已过期！','error');
		}
		if($order_verify['verifytype']==0){
			//按订单核销
			$update=array(
				'status'=>1,
				'clerk_id'=>$clerk_id,
				'verifytime'=>TIMESTAMP,
			);
			$this->pdo_update('order_verify',$update,array('id'=>$order_verify['id']));
			$this->order_receive($order_verify['orderid']);
		}elseif($order_verify['verifytype']==1){
			//按次核销
			$verifydata=$order_verify['verifydata']?json_decode($order_verify['verifydata'],true):array();
			$verifydata[]=array(
				'clerk_id'=>$clerk_id,
				'verifytime'=>TIMESTAMP,
			);
			$update=array(
				'verifydata'=>ijson_encode($verifydata),
				'verify_num -='=>1,
			);
			if($order_verify['verify_num']==1){
				$update['status']=1;
			}
			$this->pdo_update('order_verify',$update,array('id'=>$order_verify['id']));
			if($update['status']==1){
				$this->order_receive($order_verify['orderid']);
			}
		}elseif($order_verify['verifytype']==2){
			//按消费码核销
			$update=array(
				'status'=>1,
				'clerk_id'=>$clerk_id,
				'verifytime'=>TIMESTAMP,
			);
			$this->pdo_update('order_verify',$update,array('id'=>$order_verify['id']));
			$check=$this->pdo_getcolumn('order_verify',array('orderid'=>$order_verify['orderid'],'status'=>0),'id');
			if(!$check){
				$this->order_receive($order_verify['orderid']);
			}
		}
		$order_verify['salerid']=$clerk_id;
		$event=array(
			'type'=>'order',
			'order'=>$order_verify,
		);
		$this->publish('order.verify',$event);
	}
	public function order_send_verifygoods($order_id,$goodsid='',$sendtype=0){
		//计次核销
		$goods=$this->pdo_get('goods',array('id'=>$goodsid),array('verifygoodsnum','verifygoodsdays','verifygoodslimittype','verifygoodslimitdate'));
		$goods['total']=pdo_getcolumn('jy_weishop_order_goods',array('orderid'=>$order_id,'goodsid'=>$goodsid),'total');
		$verifygoods=array(
			'uniacid'=>$_SESSION['uniacid'],
			'mid'=>$_SESSION['uid'],
			'orderid'=>$order_id,
			'ordergoodsid'=>$goodsid,
			'limitdays'=>$goods['verifygoodsdays'],
			'limitnum'=>$goods['verifygoodsnum'],
			'limittype'=>$goods['verifygoodslimittype'],
			'limitdate'=>$goods['verifygoodslimitdate'],
			'starttime'=>TIMESTAMP,
			'used'=>0,
			'storeid'=>$this->order['storeid'],
			'verifycode'=>random(10),
		);
		$this->pdo_insert('verifygoods',$verifygoods);
		if($sendtype!=1){
			$this->update('order',array('status'=>2),array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			$this->update('order_goods',array('status'=>2),array('orderid'=>$order_id));
		}
		return true;
	}
	public function order_verifygoods($verify_code,$clerk_id,$num=1,$remarks='',$noapi=false){
		$goods_verify=$this->pdo_get('verifygoods',array('verifycode'=>$verify_code));
		if(!$goods_verify){
			exi('核销码不存在！','error');
		}
		if (!(empty($goods_verify['limitnum']))){
			$verifygoodlogs = pdo_getall('jy_weishop_verifygoods_log',array('verifygoodsid'=>$goods_verify['id']));
			$verifynum = 0;
			foreach ($verifygoodlogs as $verifygoodlog ) 
			{
				$verifynum += intval($verifygoodlog['verifynum']);
			}
			$lastverifys = intval($goods_verify['limitnum']) - $verifynum;
			if ($lastverifys < 1) 
			{
				exi('核销次数已用完!', 'error');
			}
		}
		if (empty($goods_verify['limittype'])) {
			$goods_verify['limitdays']=$goods_verify['limitdays']?:365;
			$limitdate = intval($goods_verify['starttime']) + (intval($goods_verify['limitdays']) * 86400);
		}else{
			$limitdate = intval($goods_verify['limitdate']);
		}
		if ($limitdate < time()) {
			exi('该商品已过期!', 'error');
		}
		$jy_offlineapi = check_account_permission('jy_offlineapi');
		if($jy_offlineapi && !$noapi){
			$goods_verify['verifynum']=$num;
			$goods_verify['salerid']=$clerk_id;
			$isapi=model('jy_offlineapi/model')->send_api($goods_verify);
			if($isapi){
				return true;
			}
		}
		$log=array(
			'uniacid'=>$_SESSION['uniacid'],
			'verifygoodsid'=>$goods_verify['id'],
			'salerid'=>$clerk_id,
			'storeid'=>$goods_verify['storeid'],
			'verifynum'=>$num,
			'remarks'=>$remarks,
			'verifydate'=>time(),
		);
		$this->pdo_insert('verifygoods_log',$log);
		$logs=pdo_getsum('jy_weishop_verifygoods_log',array('verifygoodsid'=>$goods_verify['id']),'verifynum');
		if($logs==$goods_verify['limitnum'] && $goods_verify['limitnum']>0){
				$this->order_receive($goods_verify['orderid']);
		}
	}
	//确认收货，完成订单
	public function order_receive($order_id,$ismsg=false){
		$update=array('status'=>3,'finishtime'=>TIMESTAMP);
		$this->update('order',$update,array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
		$this->update('order_goods',$update,array('orderid'=>$order_id));
		$this->get_order($order_id);
		$notice_setting=$this->plugin_setting('notice');
		if(!$ismsg){
			$this->model('notice')->notice_receive2buyer($this->order);
			if($notice_setting['seller']){
				foreach($notice_setting['seller'] as $member){
					$this->model('notice')->notice_receive2seller($this->order,$member['mid']);
				}
			}
		}
		//购物送积分
		$buy_credit_setting=$this->plugin_setting('buy_credit');
		if($buy_credit_setting['open'] && $buy_credit_setting['time']=='complete'){
			$this->buy_credit($order_id);
		}
		//会员等级变更
		$this->model('member')->check_uplevel($this->order['mid']);
		//购物送券，这里判断是否需要购物送券。如有需要，推送相关消息
		$noticemids=array();
		foreach($this->order['goods'] as $item){
			$goodsinfo=$this->pdo_get('goods',array('id'=>$item['goodsid']),array('noticemid','totalcnf','noticetype'));
			$coupon=$this->pdo_get('coupon_goodsendtask',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'goodsid'=>$item['goodsid']));
			if($coupon && $coupon['couponid'] && $coupon['sendpoint']==1 && $coupon['num'] >= $coupon['sendnum']){
				//购物送券活动存在，且发送时机为订单付款时，且剩余数量高于每个用户发送数量，此时尝试推送优惠券消息。
				$params=array(
					'mid'=>$this->order['mid'],
					'ac_type'=>'goods',
					'ac_id'=>$coupon['id'],
					'remark'=>'购物送券活动',
				);
				$this->model('coupon')->give_coupon($params);
			}
			//更新单商品支付状态
			pdo_update('jy_weishop_order_goods',array('status'=>3),array('id'=>$item['id']));
			//推送消息给卖家		
			if($goodsinfo['noticemid']){
				if(strpos($goodsinfo['noticetype'],';2;') !== false){
					if(!in_array($goodsinfo['noticemid'],$noticemids)){
						$noticemids[]=$goodsinfo['noticemid'];
					}
				}
			}
		}
		if($noticemids){
			foreach($noticemids as $n){
				$this->model('notice')->notice_receive2seller($this->order,$n);	
			}
		}
		//满额送券，查找是否有符合条件的满额送券活动
		$coupon=$this->pdo_get('coupon_sendtasks',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'price >='=>$this->order['price']));
		if($coupon && $coupon['couponid'] && $coupon['sendpoint']==1 && $coupon['num'] >= $coupon['sendnum']){
			$params=array(
					'mid'=>$this->order['mid'],
					'ac_type'=>'order',
					'ac_id'=>$coupon['id'],
					'remark'=>'订单满额送券活动',
				);
				$this->model('coupon')->give_coupon($params);
		}
		//游戏营销，购物参与
		foreach($this->order['goods'] as $item){
			$game=$this->pdo_get('game',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'type'=>2,'time'=>1,'goodsid'=>$item['goodsid']));
			if($game){
				$params=array(
					'mid'=>$this->order['mid'],
					'game_id'=>$game['id'],
					'remark'=>'购物参与活动',
				);
				$this->model('game')->add_game($params);
			}
		}
		$game=$this->pdo_get('game',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'type'=>1,'time'=>1,'price <='=>$this->order['price']));
		if($game){
				$params=array(
					'mid'=>$this->order['mid'],
					'game_id'=>$game['id'],
					'remark'=>'购物参与活动',
				);
				$this->model('game')->add_game($params);
		}
		$event=array(
			'type'=>'complete',
			'order'=>$this->order,
		);
		$this->publish('order.change',$event);
	}
	public function buy_credit($order_id=0){
		if($order_id && !$this->order['id']){
			$this->get_order($order_id);
		}
		$buy_credit=$this->plugin_setting('buy_credit');
		if($buy_credit['type']==1){
			//根据订单金额赠送积分
			if(!$buy_credit['options']){
				return true;
			}
			foreach($buy_credit['options'] as $item){
				if($this->order['price']>=$item['start'] && $this->order['price']<=$item['end']){
					$credit=intval($this->order['price']*$item['credit']);
					break;
				}
			}
		}elseif($buy_credit['type']==2){
			//根据商品赠送积分
			$credit=0;
			foreach($this->order['goods'] as $goods){
				$goods_credit=$this->pdo_getcolumn('goods_credit',array('goods_id'=>$goods['goodsid']),'credit');
				if($goods_credit){
					$credit+=intval($goods_credit)*$goods['total'];
				}
			}
		}
		if($credit>0){
			model('core/member')->add_credit1($this->order['mid'],$credit,'购物送积分');
		}
		return true;
	}
	public function deduct_credit($order_id=0){
		if($order_id && !$this->order['id']){
			$this->get_order($order_id);
		}
		$saleset=$this->plugin_setting('saleset');
		if(!$saleset['deduct_credit1']){
			return false;
		}
		$delcredit1=intval($this->order['deductcredit']*$saleset['deduct_bili']);
		if($delcredit1>0){
			model('core/member')->cut_credit1($this->order['mid'],$delcredit1,'购物抵扣积分');
		}
		return true;
	}
	public function upprice($order_id=0,$price=0){
		if($order_id){
			$this->get_order($order_id);
		}
		$this->update('order',array('price'=>$price),array('id'=>$order_id));
		$pay_id=pdo_getcolumn('jy_weishop_order',array('uniacid'=>$_SESSION['uniacid'],'id'=>$order_id),'pay_id');
		$params=array(
			'fee'=>$price,
			'pay_id'=>$pay_id,
		);
		cfc('pay')->change_pay_fee($params);
		$this->model('notice')->notice_upprice($this->order);
		return true;
	}
	public function up_virtualtotal($tempid){
		$count=pdo_count('jy_weishop_virtual_data',array('uniacid'=>$_SESSION['uniacid'],'tempid'=>$tempid,'mid'=>0),'id');
		pdo_update('jy_weishop_goods',array('total'=>$count),array('uniacid'=>$_SESSION['uniacid'],'virtual_template_id'=>$tempid));
	}
	public function sendsubmsg($order_id){
		$this->get_order($order_id);
		$this->model('notice')->notice_pay2buyer($this->order);
		return true;
	}
	public function setfee_desc($order_id){
		$order=$this->get('order',array('id'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
		$goods=$this->getall('order_goods',array('orderid'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
		if(!$goods){
			return false;
		}
		$merch_num=pdo_count('jy_weishop_order_goods',array('orderid'=>$order_id,'merchid >'=>0,'uniacid'=>$_SESSION['uniacid']),'id');
		if(!$merch_num){
			return false;
		}
		//同一商户
		$onemerch_num=pdo_count('jy_weishop_order_goods',array('orderid'=>$order_id,'merchid'=>$order['merchid'],'uniacid'=>$_SESSION['uniacid']),'id');
		if($onemerch_num==$merch_num){
			foreach($goods as &$ov){
				$total_price=$ov['total_price']*$order['price']/$order['goodsprice'];
				pdo_update('jy_weishop_order_goods',array('fee_desc'=>'isorderfee','total_price'=>$total_price),array('orderid'=>$order_id,'uniacid'=>$_SESSION['uniacid']));
			}
			return false;
		}
		foreach($goods as &$item){
			if(!$item['merchid']){
				continue ;
			}
			$goodsprice=$item['price']*$item['total'];
			$feerate=$goodsprice/$order['goodsprice'];
			$syscoupon=$this->pdo_getcolumn('coupon',array('id'=>$order['couponid']),'merchid');
			//如果是商户自己的优惠券，就由商户支出
			if($syscoupon==$item['merchid']){
				$merchcoupon_num=pdo_count('jy_weishop_order_goods',array('orderid'=>$order_id,'merchid'=>$item['merchid'],'uniacid'=>$_SESSION['uniacid']),'id');
				if($merchcoupon_num){
					$coupon_de_price=$order['coupon_de_price']/$merchcoupon_num;
				}
			}else if($syscoupon){
				$coupon_de_price=0;
			}else{
				$coupon_de_price=$order['coupon_de_price']/$feerate;
			}
			//计算各种商户的运费
			$goodstype=$this->pdo_getcolumn('goods',array('id'=>$item['goodsid']),'type');
			if($goodstype){
				$dispatchprice=0;
			}else{
				$dispatchprice=$order['dispatchprice']*$feerate;
			}
			$fee_desc=array(
				'dispatchprice'=>$dispatchprice,
				'level_de_price'=>$order['level_de_price']*$feerate,
				'luck_de_price'=>$order['luck_de_price']*$feerate,
				'enough_de_price'=>$order['enough_de_price']*$feerate,
				'coupon_de_price'=>$coupon_de_price,
				'deductcredit'=>$order['deduct_credit']*$feerate,
				'deductcredit2'=>$order['deduct_credit2']*$feerate,
			);
			$total_price=$goodsprice-$fee_desc['dispatchprice']-$fee_desc['level_de_price']-$fee_desc['luck_de_price']-$fee_desc['enough_de_price']-$fee_desc['coupon_de_price']-$fee_desc['deductcredit']-$fee_desc['deductcredit2'];
			pdo_update('jy_weishop_order_goods',array('fee_desc'=>ijson_encode($fee_desc),'total_price'=>$total_price),array('id'=>$item['id'],'uniacid'=>$_SESSION['uniacid']));
		}
		return true;
	}
	public function send_orderverify($order_id){
		$this->get_order($order_id);
		/*
			按商品虚拟商品和核销商品自动发货
			非拼团订单，才自动发货
		*/
		if($this->order['is_team']!=1){
			foreach($this->order['goods'] as $vv){
				//已经整理出了商品类型type,isverify，只要支持核销，无论什么商品都可以核销！
				if($vv['isverify']==1 && $vv['type']!=2){
					if($vv['type']==3){
						$this->order_send_verifygoods($order_id,$vv['goodsid'],$this->order['sendtype']);
					}elseif($vv['type']==0){
						//实体物品，需配送时，依然生成核销码，但是不刷新配送状态
						$this->order_send_verify($order_id,$vv['goodsid'],$this->order['sendtype']);
					}else{
						$this->order_send_verify($order_id,$vv['goodsid'],$this->order['sendtype']);
					}
				}elseif($vv['type']==1 || $vv['type']==2){
					//虚拟发货，如果是自动发货
					$goods=$this->pdo_get('goods',array('id'=>$vv['goodsid']),array('type','virtualsend','virtualsendcont','virtual_template_id'));
					if(($goods['virtualsend']) || $vv['type']==2){
						$vv=array_merge($vv,$goods);
						$this->order_send_virtual($order_id,$vv);
					}
				}
			}
		}
		return true;
	}
	public function add_baobei($order_id,$msg='',$oldstatus=2,$mid=0,$api_id=0,$api_pluginname=''){
		$mid=$mid?:$_SESSION['uid'];
		$data=array(
			'uniacid'=>$_SESSION['uniacid'],
			'order_id'=>$order_id,
			'oldstatus'=>$oldstatus?:2,
			'api_id'=>$api_id,
			'api_pluginname'=>$api_pluginname,
			'mid'=>$mid,
			'msg'=>$msg?:'异常报备',
			'status'=>0,
			'createtime'=>TIMESTAMP,
		);
		$this->pdo_insert('baobei_log',$data);
		$logid=pdo_insertid();
		$this->pdo_update('order',array('status'=>7),array('id'=>$order_id));
		return $logid;
	}
}