<?php
namespace jy_weishop;
defined('BY_JYA') or exit('error');
/*
	营销活动
*/
class activity extends \plugin{
	private $private_activitys=array(
		'buyagain',
		'limit',
		'sales',
		'presell',
	);
	//创建活动
	public function create_active($goods_id,$active_id,$plugin_name,$isget=''){
		$goods=$this->get('goods',array('id'=>$goods_id,'uniacid'=>$_SESSION['uniacid']),array('id','active_plugin','active_id'));
		if(!$goods){
			exi('指定商品不存在！','error');
		}
		//参加了不同插件
		if($plugin_name!=$goods['active_plugin']){
			$need=true;
		}
		//参加了同插件，不同活动
		if($active_id!=$goods['active_id'] && $plugin_name==$goods['active_plugin']){
			$need=true;
		}
		if($goods['active_plugin'] && $goods['active_plugin']!='jy_friends_shop' && $need){
			//检查活动是否正常
			$active=$this->get_active_class($goods['active_plugin'])->get_active($goods['id'],$goods['active_id']);
			if($active){
				if($isget && $goods['active_plugin']!=$plugin_name){//仅前往获取活动信息
					exi('该商品已参与其他种类的活动，请勿重复添加~！','error');
				}else{
					exi('该商品已存在活动，请勿重复添加~！','error');
				}
			}
		}
		$update=array(
			'active_plugin'=>$plugin_name,
			'active_id'=>$active_id,
		);
		$this->update('goods',$update,array('id'=>$goods_id));
		return true;
	}
	//删除活动
	public function del_active($goods_id,$active_id,$plugin_name){
		$this->update('goods',array('active_plugin'=>'','active_id'=>0),array('id'=>$goods_id));
		return true;
	}
	//获取活动页信息
	public function active_url($goods_id,$active_id,$plugin_name){
		if(in_array($plugin_name,$this->private_activitys)){
			if($_SESSION['os']=='wxapp'){
				$url="/jy_weishop/activity/".$plugin_name."/active_detail.wxml";	
			}else{
				$url=$this->template_url("activity/{$plugin_name}/active_detail",true);
			}
			
		}elseif($plugin_name!='core'){
			if($_SESSION['os']=='wxapp'){
				$url="/".$plugin_name."/common/active_detail.wxml";	
			}else{
				$url=$this->plugin($plugin_name)->template_url('common/active_detail',true);
			}
		}
		return $url;
	}
	//检查是否存在活动
	public function check_active($goods_id){
		$goods=$this->get('goods',array('id'=>$goods_id,'uniacid'=>$_SESSION['uniacid']),array('id','active_plugin','active_id'));
		if(!$goods){
			exi('指定商品不存在！','error');
		}
		if($goods['active_plugin']  && $goods['active_plugin']!='jy_friends_shop'){
			$active=$this->get_active_class($goods['active_plugin'])->get_active($goods['id'],$goods['active_id']);
			if($active){
				return true;
			}
		}
		$get_sales=$this->get_sales($goods_id,true);
		if($get_sales['title']){
				return true;
		}
		return false;
	}
	//获取活动信息
	public function get_active($goods_id,$active_id,$plugin_name,$optionid=''){
		//if(method_exists($this->get_active_class($plugin_name),'get_active')){
			$active=$this->get_active_class($plugin_name)->get_active($goods_id,$active_id,$optionid);
			return $active?$active:array();
		//}
		return false;
	}
	//获取插件活动信息
	public function get_plugin($goods_id,$plugin_name){	
		//if(method_exists($this->plugin($plugin_name),'get_active')){
			if($plugin_name!='core'){
				$active=$this->plugin($plugin_name)->get_active($goods_id);
				return $active?$active:array();
			}
		//}
		return false;
	}
	//获取促销信息特价/运势等
	public function get_sales($goods_id,$check=false){
		$sale_offer=$this->plugin_setting('sale_offer');
		$sale_new=$this->plugin_setting('sale_new');
		$sale_offer['maxnum']=$sale_offer['maxnum']?:0;
		if($sale_offer['isopen'] || $check){
			$getoffer=$this->model('activity/sales')->getoffer();
			if($getoffer['list']){
				foreach($getoffer['list'] as $ov){
					if($ov['id']==$goods_id){
						$res=array('title'=>'今日特价','maxnum'=>$sale_offer['maxnum'],'discount'=>$sale_offer['discount'],'price'=>$ov['price']);
					}
				}
			}
		}
		if(!$res && $sale_new['isopen']){
			$getoffer=$this->model('activity/sales')->getnew(true);
			if($getoffer['list']){
				foreach($getoffer['list'] as $ov){
					if($ov['id']==$goods_id){
						$res=array('title'=>'新人专享','cant_buy'=>$ov['cant_buy'],'maxnum'=>1,'price'=>$ov['price']);
					}
				}
			}
		}
		return $res?$res:array();
	}
	//检查库存
	public function check_stock($goods_id,$plugin_name,$active_id,$num){
		return $this->get_active_class($plugin_name)->check_stock($goods_id,$active_id,$num);
	}
	//购买
	public function buy($goods_id,$plugin_name,$active_id,$num){
		
		return $this->get_active_class($plugin_name)->buy($goods_id,$active_id,$num);
	}
	/*
		参数说明
		$params=array(
			'mid'=>'会员ID',
			'goods_id'=>'商品ID',
			'active_id'=>'活动ID',
			'num'=>'购买数量',
			'price'=>'商品单价',
			'ordersn'=>'订单号',
			'order_id'=>'订单ID',
		);
	*/
	public function order_create($params){
		$plugin_name=$params['active_plugin'];
		unset($params['active_plugin']);
		$this->get_active_class($plugin_name)->order_create($params);
	}
	public function order_task(){
		$activitys=$this->private_activitys;
		foreach($activitys as $item){
			$this->get_active_class($item)->task();
		}
		$install = check_permission('jy_seckill');
		if($install){
			$this->get_active_class('jy_seckill')->task();
		}
		$install = check_permission('jy_yushou');
		if($install){
			$this->get_active_class('jy_yushou')->task();
		}
	}
	public function get_upgoods($goods){
		if(!$goods['total']){
			$goods['total']=pdo_getcolumn('jy_weishop_goods',array('id'=>$goods['id'],'uniacid'=>$_SESSION['uniacid']),'total');
		}
		//获取门店独立价格/库存
		$goods['storeid']=$goods['storeid']?:$_SESSION['store_id'];
		if($goods['storeid']){
				$storeset=$this->plugin_setting('storeset');
				if($storeset['no_goods']!=1){//没开启商品统一
					$getinfo=model('jy_weishop/store')->getinfo($goods['id'],$goods['storeid']);
					$goods['total']=$getinfo['id']?$getinfo['total']:$goods['total'];
					$goods['price']=$getinfo['price']>0?$getinfo['price']:$goods['price'];
					if($goods['optionid']){
						$options=model('jy_weishop/store')->getoption($goods['id'],$goods['storeid'],'',$goods['optionid']);
					}
				}
		}
		if(!$options['id'] && $goods['optionid']){
			$options = pdo_get('jy_weishop_goods_option',array('goodsid'=>$goods['id'],'id'=>$goods['optionid']));
		}
		
		if($options['id']){
			$goods['options']=$options;
			$goods['price']=$options['price']?:$goods['price'];
		}
		//获取会员独立价格
		if($goods['id'] && !$goods['diyprice']){			
			$goods['isdiyprice']=pdo_getcolumn('jy_weishop_goods',array('id'=>$goods['id'],'uniacid'=>$_SESSION['uniacid']),'isdiyprice');
			$goods['diyprice']=pdo_getcolumn('jy_weishop_goods',array('id'=>$goods['id'],'uniacid'=>$_SESSION['uniacid']),'diyprice');
		}
		if($goods['isdiyprice']==1){
			$goods['diyprice']=json_decode($goods['diyprice'],true);
			if($goods['diyprice']){
				$levelinfo = $this->model('member')->get_level();
				foreach($goods['diyprice'] as $dv){
					if($levelinfo['id']==$dv['levelid']){
						$goods['price']=price($dv['price'],true);
						break;
					}
				}
			}
		}
		if($goods['active_plugin'] && $goods['active_plugin']!='jy_friends_shop'){
				$goods['active']=$this->get_active($goods['id'],$goods['active_id'],$goods['active_plugin'],$goods['optionid']);
				//如果传过了的值是免费的
				if($goods['active']['price'] || $goods['active']['isfree']){
					$goods['oldprice']=$goods['price'];
					$goods['price']=$goods['active']['price'];
				}
				//重置规格价格
				if($goods['active']['optionprice']){
					$goods['options']['oldprice']=$goods['options']['price'];
					$goods['options']['price']=$goods['active']['optionprice'];
				}
		}
		if($goods['pluginname']){
				$goods['plugininfo']=$this->get_plugin($goods['id'],$goods['pluginname']);
		}
		if(!$goods['active']){
				$goods['active']=$this->get_sales($goods['id']);
				if($goods['active']['discount']>10){
					$goods['oldprice']=$goods['price'];
					$goods['price']=$goods['active']['price']=$goods['oldprice']*$goods['active']['discount']/100;
					$goods['options']['oldprice']=$goods['options']['price'];
					$goods['options']['price']=$goods['options']['oldprice']*$goods['active']['discount']/100;
				}
				if($goods['active']['cant_buy']==1){
					$goods['cant_buy']=1;
				}
		}
		//重置规格价格
		if($goods['options']['price']){
				$goods['oldprice']=$goods['options']['oldprice']?:$goods['oldprice'];
				$goods['price']=$goods['options']['price']?:$goods['price'];
		}
		//获取分销佣金；
		$install = check_account_permission('jy_commission');
		if($install){
			$commission=$this->plugin('jy_commission')->get_active($goods['id'],$goods['optionid']);
			$goods['commission_money']=$commission['commission_money'];
			$goods['commission_title']=$commission['commission_title'];
		}
		//直播价
		if($goods['roomid'] && !$goods['optionid']){
			$goodsid=pdo_getcolumn('jy_weishop_live_room',array('id'=>$goods['roomid'],'uniacid'=>$_SESSION['uniacid']),'goodsid');
			$goodsid=json_decode($goodsid,true);
			foreach($goodsid as &$gv){		
				$goods['price']=$goods['active']['price']=$gv['price'];
				$goods['active']['title']='直播价';
			}
		}
		//买家秀
		$goods['buyxiu_de_price']=$this->get_buyxiu_de_price($goods);
		//获取礼卡折扣
		$libaoactive=$this->model('libao')->get_active($goods);
		if($libaoactive){
			$goods['price']=$libaoactive['price'];
			$goods['active']=$libaoactive;
		}
		return $goods;
	}
	public function get_uporder($order){
		//获取门店独立价格/库存
		if($order['storeid']){
				$getinfo=model('jy_weishop/store')->getinfo($order['goodsid'],$order['storeid']);
				$order['total']=$getinfo['id']?$getinfo['total']:$order['total'];
				$order['price']=$getinfo['id']?$getinfo['price']:$order['price'];
				if($order['optionid']){
					$options=model('jy_weishop/store')->getoption($order['goodsid'],$order['storeid'],'',$order['optionid']);
				}
		}
		if(!$options['id'] && $order['optionid']){
			$options = pdo_get('jy_weishop_goods_option',array('goodsid'=>$order['goodsid'],'id'=>$order['optionid']));
		}
		if($options['id']){
			$options['stock']=$return['options']['id']?$options['stock']:$options['stock'];
			$order['options']=$options;
			$order['price']=$options['price']?:$order['price'];
		}
		//获取会员独立价格
		if($order['goodsid'] && !$order['diyprice']){			
			$order['isdiyprice']=pdo_getcolumn('jy_weishop_goods',array('id'=>$order['goodsid'],'uniacid'=>$_SESSION['uniacid']),'isdiyprice');
			$order['diyprice']=pdo_getcolumn('jy_weishop_goods',array('id'=>$order['goodsid'],'uniacid'=>$_SESSION['uniacid']),'diyprice');
		}
		if($order['isdiyprice']==1){
			$order['diyprice']=json_decode($order['diyprice'],true);
			if($order['diyprice']){
				$levelinfo = $this->model('member')->get_level();
				foreach($order['diyprice'] as $dv){
					if($levelinfo['id']==$dv['levelid']){
						$order['price']=price($dv['price'],true);
						break;
					}
				}
			}
		}
		if($order['active_plugin']){
			//商品在做活动，检查下库存是否不足
			$check_stock=$this->check_stock($order['goodsid'],$order['active_plugin'],$order['active_id'],$order['total']);
			$active=$this->get_active($order['goodsid'],$order['active_id'],$order['active_plugin']);
			$active['check_stock']=$check_stock;
			if($active['price']){
				$order['price']=$active['price']?:$order['price'];
				$order['active']=$active;
			}
		}
		if(empty($order['active'])){
				$order['active']=$this->get_sales($order['goodsid']);
				if($order['active']['maxnum']>0 && $order['total']>$order['active']['maxnum']){
					$order['canbuy']=0;
				}
				if($order['active']['discount']>10){
					$order['oldprice']=$order['price'];
					$order['price']=$order['oldprice']*$order['active']['discount']/100;
				}
		}
		return $order;
	}
	private function get_active_class($active_name){
		if(!$active_name){
			return false;
		}
		if(in_array($active_name,$this->private_activitys)){
			$active_class=$this->model('activity/'.$active_name);
		}elseif($active_name!='core'){
			$active_class=$this->plugin($active_name);
		}
		return $active_class;
	}
	//获取积分，余额抵扣
	public function get_deduct_credit($goods,$saleset='',$member=''){
		$saleset=$saleset?:$this->plugin_setting('saleset');
		$member=$member?:pdo_get('core_members',array('uniacid'=>$_SESSION['uniacid'],'id'=>$_SESSION['uid']),array('avatar','nickname','credit1','credit2'));
		$deduct_credit=0;
		if($goods['isdiscount']==1){
			if($goods['deductset']){
				$goods['deductset']=json_decode($goods['deductset'],true);
				if($goods['deductset']['deduct_credit1']==1){
					$deduct_credit=$member['credit1']/$goods['deductset']['deduct_bili'];
					$goods['deductset']['deduct_maxfeebili']=$goods['deductset']['deduct_maxfeebili']>0?$goods['deductset']['deduct_maxfeebili']:50;
					$maxcredit1=$goods['price']*$goods['deductset']['deduct_maxfeebili']/100;
					if($deduct_credit>$maxcredit1){
						$deduct_credit=price($maxcredit1,true);
					}
				}
			}	
		}elseif($saleset['deduct_credit1']==1){
			$deduct_credit=$member['credit1']/$saleset['deduct_bili'];
			$saleset['deduct_maxfeebili']=intval($saleset['deduct_maxfeebili'])?:50;
			$maxcredit1=$goods['price']*$saleset['deduct_maxfeebili']/100;
			if($deduct_credit>$maxcredit1){
				$deduct_credit=price($maxcredit1,true);
			}
		}
		return $deduct_credit;
	}
	//订单获取积分，余额抵扣
	public function get_deduct_credit_order($order,$saleset='',$member=''){
		$saleset=$saleset?:$this->plugin_setting('saleset');
		$member=$member?:pdo_get('core_members',array('uniacid'=>$_SESSION['uniacid'],'id'=>$_SESSION['uid']),array('avatar','nickname','credit1','credit2'));
		$alldeduct_credit=0;
		foreach($order['list'] as $item){
			$goods=pdo_get('jy_weishop_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$item['goodsid']));
			if($item['optionid']){
				$goods['price']=pdo_getcolumn('jy_weishop_goods_option',array('id'=>$item['optionid']),'price');
			}
			if($goods['isdiscount']==1){
				if($goods['deductset']){
					$goods['deductset']=json_decode($goods['deductset'],true);
					if($goods['deductset']['deduct_credit1']==1){
						$deduct_credit=$member['credit1']/$goods['deductset']['deduct_bili'];
						$goods['deductset']['deduct_maxfeebili']=$goods['deductset']['deduct_maxfeebili']>0?$goods['deductset']['deduct_maxfeebili']:50;
						$maxcredit1=$goods['price']*$goods['deductset']['deduct_maxfeebili']/100;
						if($deduct_credit>$maxcredit1){
							$deduct_credit=$maxcredit1;
						}
						//扣除积分
						$delcredit1=intval($deduct_credit*$goods['deductset']['deduct_bili']);
					}
				}	
			}elseif($saleset['deduct_credit1']==1){
				$deduct_credit=$member['credit1']/$saleset['deduct_bili'];
				$saleset['deduct_maxfeebili']=intval($saleset['deduct_maxfeebili'])?:50;
				$maxcredit1=$goods['price']*$saleset['deduct_maxfeebili']/100;
				if($deduct_credit>$maxcredit1){
					$deduct_credit=$maxcredit1;
				}
				//扣除积分
				$delcredit1=intval($deduct_credit*$saleset['deduct_bili']);
			}
			$deduct_credit=$deduct_credit*$item['total'];
			$alldeduct_credit +=$deduct_credit;
			$alldelcredit1 +=$delcredit1;
		}
		return array('delcredit1'=>$alldelcredit1,'deduct_credit'=>$alldeduct_credit);
	}
	//商品送积分
	public function get_buy_credit($goods,$buy_credit=''){
		$buy_credit=$buy_credit?:$this->plugin_setting('buy_credit');
		$goods['credit']=0;
		if($buy_credit['open']){
			if($buy_credit['type']==1){
				foreach($buy_credit['options'] as $buyv){
					if($buyv['start']<$goods['price']){
						$credit=$buyv['credit']*$goods['price'];
						$goods['credit']=$goods['credit']<$credit?$credit:$goods['credit'];
					}
				}
			}else{
				$goods['credit']=pdo_getcolumn('jy_weishop_goods_credit',array('goods_id'=>$goods['id'],'uniacid'=>$_SESSION['uniacid']),'credit');
			}
		}
		return $goods['credit'];
	}
	//订单送积分
	public function get_buy_credit_order($order,$buy_credit=''){
		$buy_credit=$buy_credit?:$this->plugin_setting('buy_credit');
		$order['credit']=0;
		if($buy_credit['open']){
			if($buy_credit['type']==1){
				foreach($buy_credit['options'] as $buyv){
					if($buyv['start']<$order['total_price']){
						$credit=$buyv['credit']*$order['total_price'];
						$order['credit']=$order['credit']<$credit?$credit:$order['credit'];
					}
				}
			}else{
				foreach($order['list'] as $cv){
					$credit=pdo_getcolumn('jy_weishop_goods_credit',array('goods_id'=>$cv['goodsid'],'uniacid'=>$_SESSION['uniacid']),'credit');
					$credit=$credit?:0;
					$order['credit'] +=$credit;
				}
			}
		}
		return $order['credit'];
	}
	//运势折扣
	public function get_luck_de_price($order){
		$order['luck_de_price']=0.00;
		$sale_luck=$this->plugin_setting('sale_luck');
		$myluckkey=pdo_getcolumn('core_members',array('id'=>$_SESSION['uid']),'luckkey');
		if($myluckkey && $sale_luck['isopen']){
			$discount=$sale_luck['lucklist'][$myluckkey]['discount'];
			$discount=($discount>10&&$discount<=100)?$discount:100;
			$order['luck_de_price']=$order['total_price']-($order['total_price']*$discount/100);
		}
		return $order['luck_de_price'];
	}
	//买家秀扣价
	public function get_buyxiu_de_price($goods){
		$isin=$this->plugin_exists('jy_vote');
		if(empty($isin)){
			return 0;
		}
		$buyxiu_price=$goods['price'];
		$buyxiu_de_price=0;
		$buyxiu=$this->plugin_setting('buyxiu');
		$item=pdo_get('jy_vote_opus',array('mid'=>$_SESSION['uid'],'uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goods['id']));
		if($item['likes'] && $item['likes'] >= $buyxiu['likes']){
			if($buyxiu['cuxiao']==1){
				$buyxiu_de_price=$buyxiu['jianmian'];
			}elseif($buyxiu['cuxiao']==2){
				$buyxiu_de_price=$buyxiu_price-$buyxiu_price*($buyxiu['dazhe']/10);
			}elseif($buyxiu['cuxiao']==3){
				$buyxiu_de_price=$buyxiu['dixian'];
			}else{
				$buyxiu_de_price=$buyxiu_price;
			}
		}
		return $buyxiu_de_price;
	}
	//买家秀清零
	public function get_buyxiu_up0($goodsid){
		$isin=$this->plugin_exists('jy_vote');
		if(empty($isin)){
			return false;
		}
		pdo_update('jy_vote_opus',array('likes'=>0),array('mid'=>$_SESSION['uid'],'uniacid'=>$_SESSION['uniacid'],'goodsid'=>$goodsid));
		return true;
	}
	/*
		赠品
		先根据订单金额找赠品，再根据商品找赠品
	*/
	public function get_goods_gifts($goods){
		$gifts=array();
		$goods_gifts=$this->pdo_getall('goods_gift',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'activity'=>0));
		//$current_gift=array();
		if($goods_gifts){
			foreach($goods_gifts as $gift){
				$gift['onlinetime']=json_decode($gift['onlinetime'],true);
				if($gift['onlinetime']['tstart']<time() && $gift['onlinetime']['tend']>time() && $gift['orderprice'] && $gift['orderprice']<$goods['price']){
					if(!$current_gift || $current_gift['orderprice']<$gift['orderprice']){
						$current_gift=$gift;
					}
				}
			}
		}
		if(!$current_gift){
			$goods_gifts=$this->pdo_getall('goods_gift',array('uniacid'=>$_SESSION['uniacid'],'status'=>1,'activity'=>1));
		}
		if($goods_gifts){
			foreach($goods_gifts as $gift){
				$gift['onlinetime']=json_decode($gift['onlinetime'],true);
				if($gift['onlinetime']['tstart']<time() && $gift['onlinetime']['tend']>time() && $gift['goodsid']){
						if($goods['id']==$gift['goodsid']){
							$current_gift=$gift;
							break;
						}
				}
			}
		}
		if($current_gift){
			$goods['gift_id']=$current_gift['id'];
			$gifts=json_decode($current_gift['gifts'],true);
			foreach($gifts as &$gv){
				$gv['price']=pdo_getcolumn('jy_weishop_goods',array('id'=>$gv['id'],'uniacid'=>$_SESSION['uniacid']),'price');
			}
		}
		return $gifts;
	}
	/*
		全返
	*/
	public function get_fullback($goods){
		if ($goods['isfullback']) {
			
		}
		return $fullbackfee;
	}
}