<?php
namespace jy_tour;
defined('BY_JYA') or exit('error');
/*
	分销佣金
	分销插件所有金额字段均保存整形，精确到分。显示时，除以100然后保留两位小数即可
	佣金比例字段保存整形，值为万分数，相当于百分数的精确到小数点后2位。即展示到前端时，需要除以100，换算成百分数显示
*/
class refund extends \plugin{

	public $status=array(
		'0'=>'待审核',
		'1'=>'审核通过',
		'2'=>'待打款',
		'4'=>'已退款',
		'5'=>'被拒绝',
	);
	/*
		检查订单是否支持退款
		订单支持退款的条件
			订单商品支持退款
			订单状态为已完成
			订单完成时间不超过七天
	*/
	public function check_order_rerefund($order_id=0,$iserror=''){//$iserror 报错
		$basic=$this->plugin_setting('basic');
		if(!$basic['refund_open']){
			if($iserror){
				exi('本系统暂不支持退款！','error');
			}else{
				return false;
			}
		}
		if($order_id){
			$order=$this->pdo_get('order',array('id'=>$order_id));
			if(!$order){
				if($iserror){
					exi('订单不存在，退款失败！','error');
				}else{
					return false;
				}
			}
			if($order['status']==0 || $order['status']>=3){
				if($iserror){
					exi('该订单状态，不支持退款！','error');
				}else{
					return false;
				}
			}
			/*$goods=$this->pdo_get('spot',array('id'=>$['spot_id']),array('isrefund'));
			if(!$goods['isrefund']){
					if($iserror){
						exi('该门票不支持退款！','error');
					}else{
						return false;
					}
			}*/
			if(!$basic['refundgo_time']){
				$order['go_time']=strtotime($order['go_time']);
				if($order['go_time']<TIMESTAMP){
					if($iserror){
						exi('不能退款了，已超过退款时间！','error');
					}else{
							return false;
					}	
				}
			}	
			//多少天内
			$basic['refund_days']=intval($basic['refund_days'])?:0;
			if($order['go_time']-TIMESTAMP<$basic['refund_days']*24*3600){
				$refundfee=$order['price']*(100-intval($basic['refund_kou0']))/100;
			}else{
				$refundfee=$order['price']*(100-intval($basic['refund_kou1']))/100;
			}
			return $refundfee;
		}
		return 0;
	}
	/*
		发起退款
	*/
	public function refund_create($params){
		$order=$this->pdo_get('order',array('id'=>$params['orderid']));
		if(!$order){
			exi('指定订单不存在，发起退款失败！','error');
		}
		$isrefund=$this->pdo_get('order_refund',array('orderid'=>$params['orderid']));
		if($isrefund['id']){
			exi('该订单已经发起退款，不能再发起','error');
		}
		$insert=array(
			'uniacid'=>$_SESSION['uniacid'],
			'refundsn'=>get_ordersn($this->tablename('order_refund'),'refundsn','REFUND'),
			'orderid'=>$order['id'],
			'merchid'=>$order['merchid'],
			'ordersn'=>$order['ordersn'],
			'mid'=>$order['mid'],
			'price'=>$params['price'],
			'images'=>$params['images'],
			'content'=>$params['content'],
			'createtime'=>TIMESTAMP,
			'paytype'=>$order['paytype'],
		);
		$this->pdo_insert('order_refund',$insert);
		$refund_id=pdo_insertid();
		$this->pdo_update('order',array('status'=>5,'oldstatus'=>$order['status']),array('id'=>$order['id']));
		return $refund_id;
	}
	/*
		审核退款
		将结果通知顾客
	*/
	public function refund_check($refund_id,$status,$reason=''){
		$update=array(
			'status'=>$status,
			'reason'=>$reason,
			'checktime'=>TIMESTAMP,
		);
		$this->pdo_update('order_refund',$update,array('id'=>$refund_id));
		return true;
	}
	/*
		发货
	*/
	public function refund_send($refund_id,$params){
		$update=array(
			'status'=>2,
			'express'=>ijson_encode($params),
			'sendtime'=>TIMESTAMP,
		);
		$this->pdo_update('order_refund',$update,array('id'=>$refund_id));
	}
	/*
		收货
	*/
	public function refund_receive($refund_id){
		$update=array(
			'status'=>3,
		);
		$this->pdo_update('order_refund',$update,array('id'=>$refund_id));
	}
	/*
		退款打款
	*/
	public function refund_pay($refund_id){
		//执行退款操作
		$refund=$this->pdo_get('order_refund',array('id'=>$refund_id));
		if(!$refund){
			return false;
		}
		if($refund['status']!=1){
			exi('退款单不符合打款要求！','error');
		}
		if($refund['paytype']=='credit'){
			//支付方式为余额支付，退款至余额
			$pay_out_id=model('core/member')->add_credit2($refund['mid'],$refund['price'],'订单退款');
		}else{
			$params=array(
				'money'=>$refund['price'],
				'remark'=>'订单退款',
			);
			$pay_out_id=model('core/member')->pay_out($refund['mid'],$params);
		}
		
		
		$update=array(
			'status'=>4,
			'paytime'=>TIMESTAMP,
			'pay_out_id'=>$pay_out_id,
		);
		$this->pdo_update('order_refund',$update,array('id'=>$refund_id));
		$this->pdo_update('order',array('status'=>6,'ismrefund'=>1),array('id'=>$refund['orderid']));
	}
}