//
//  Speed
//  Engine remake of the game "Speed Haste" based on the DelphiDoom engine
//
//  Copyright (C) 1995 by Noriaworks
//  Copyright (C) 1993-1996 by id Software, Inc.
//  Copyright (C) 2004-2022 by Jim Valavanis
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.
//
//------------------------------------------------------------------------------
//  Site  : https://sourceforge.net/projects/speed-game/
//------------------------------------------------------------------------------

{$I speed.inc}

(*
 *  File:     $RCSfile: SubBand2.pas,v $
 *  Revision: $Revision: 1.1.1.1 $
 *  Version : $Id: SubBand2.pas,v 1.1.1.1 2002/04/21 12:57:23 fobmagog Exp $
 *  Author:   $Author: fobmagog $
//  Site  : https://sourceforge.net/projects/speed-game/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)
unit mp3_SubBand2;

interface
uses
  Windows, SysUtils, mp3_Shared, mp3_BitStream, mp3_SubBand, mp3_Header, mp3_CRC, mp3_SynthFilter;

type
  // class for layer II subbands in single channel mode:
  TSubBandLayer2 = class(TSubBand)
  protected
    FSubBandNumber: Cardinal;
    FAllocation: Cardinal;
    FSCFSI: Cardinal;
    FScaleFactor1, FScaleFactor2, FScaleFactor3: Single;
    FCodeLength: Cardinal;
    FGroupingTable: PSingleArray;
    FFactor: Single;
    FGroupNumber: Cardinal;
    FSampleNumber: Cardinal;
    FSamples: array[0..2] of Single;
    FC, FD: Single;

    function GetAllocationLength(Header: THeader): Cardinal; virtual;
    procedure PrepareSampleReading(Header: THeader; Allocation: Cardinal;
      var GroupingTable: PSingleArray; var Factor: Single; var CodeLength: Cardinal;
      var C, D: Single); virtual;

  public
    constructor Create(SubBandNumber: Cardinal); virtual;

    procedure ReadAllocation(Stream: TBitStream; Header: THeader; CRC: TCRC16); override;
    procedure ReadScaleFactorSelection(Stream: TBitStream; CRC: TCRC16); virtual;
    procedure ReadScaleFactor(Stream: TBitStream; Header: THeader); override;
    function ReadSampleData(Stream: TBitStream): boolean; override;
    function PutNextSample(Channels: TChannels; Filter1, Filter2: TSynthesisFilter): boolean; override;
  end;

  // class for layer II subbands in joint stereo mode:
  TSubbandLayer2IntensityStereo = class(TSubbandLayer2)
  protected
    FChannel2SCFSI: Cardinal;
    FChannel2ScaleFactor1: Single;
    FChannel2ScaleFactor2: Single;
    FChannel2ScaleFactor3: Single;

  public
    procedure ReadScaleFactorSelection(Stream: TBitStream; CRC: TCRC16); override;
    procedure ReadScaleFactor(Stream: TBitStream; Header: THeader); override;
    function PutNextSample(Channels: TChannels; Filter1, Filter2: TSynthesisFilter): boolean; override;
  end;

  // class for layer II subbands in stereo mode:
  TSubbandLayer2Stereo = class(TSubbandLayer2)
  protected
    FChannel2Allocation: Cardinal;
    FChannel2SCFSI: Cardinal;
    FChannel2ScaleFactor1: Single;
    FChannel2ScaleFactor2: Single;
    FChannel2ScaleFactor3: Single;
    FChannel2Grouping: Boolean;
    FChannel2CodeLength: Cardinal;
    FChannel2GroupingTable: PSingleArray;
    FChannel2Factor: Single;
    FChannel2Samples: array[0..2] of Single;
    FChannel2C, FChannel2D: Single;

  public
    procedure ReadAllocation(Stream: TBitStream; Header: THeader; CRC: TCRC16); override;
    procedure ReadScaleFactorSelection(Stream: TBitStream; CRC: TCRC16); override;
    procedure ReadScaleFactor(Stream: TBitStream; Header: THeader); override;
    function ReadSampleData(Stream: TBitStream): boolean; override;
    function PutNextSample(Channels: TChannels; Filter1, Filter2: TSynthesisFilter): boolean; override;
  end;

implementation
uses
  mp3_ScaleFac;

const
  // this table contains 3 requantized samples for each legal codeword
  // when grouped in 5 bits, i.e. 3 quantizationsteps per sample
  Grouping5Bits: array[0..27 * 3 - 1] of Single = (
    -2.0/3.0, -2.0/3.0, -2.0/3.0,
     0.0,     -2.0/3.0, -2.0/3.0,
     2.0/3.0, -2.0/3.0, -2.0/3.0,
    -2.0/3.0,  0.0,     -2.0/3.0,
     0.0,      0.0,     -2.0/3.0,
     2.0/3.0,  0.0,     -2.0/3.0,
    -2.0/3.0,  2.0/3.0, -2.0/3.0,
     0.0,      2.0/3.0, -2.0/3.0,
     2.0/3.0,  2.0/3.0, -2.0/3.0,
    -2.0/3.0, -2.0/3.0,  0.0,
     0.0,     -2.0/3.0,  0.0,
     2.0/3.0, -2.0/3.0,  0.0,
    -2.0/3.0,  0.0,      0.0,
     0.0,      0.0,      0.0,
     2.0/3.0,  0.0,      0.0,
    -2.0/3.0,  2.0/3.0,  0.0,
     0.0,      2.0/3.0,  0.0,
     2.0/3.0,  2.0/3.0,  0.0,
    -2.0/3.0, -2.0/3.0,  2.0/3.0,
     0.0,     -2.0/3.0,  2.0/3.0,
     2.0/3.0, -2.0/3.0,  2.0/3.0,
    -2.0/3.0,  0.0,      2.0/3.0,
     0.0,      0.0,      2.0/3.0,
     2.0/3.0,  0.0,      2.0/3.0,
    -2.0/3.0,  2.0/3.0,  2.0/3.0,
     0.0,      2.0/3.0,  2.0/3.0,
     2.0/3.0,  2.0/3.0,  2.0/3.0);

  // this table contains 3 requantized samples for each legal codeword
  // when grouped in 7 bits, i.e. 5 quantizationsteps per sample
  Grouping7Bits: array[0..125 * 3 - 1] of Single = (
      -0.8, -0.8, -0.8,   -0.4, -0.8, -0.8,    0.0, -0.8, -0.8,    0.4, -0.8, -0.8,    0.8, -0.8, -0.8,
      -0.8, -0.4, -0.8,   -0.4, -0.4, -0.8,    0.0, -0.4, -0.8,    0.4, -0.4, -0.8,    0.8, -0.4, -0.8,
      -0.8,  0.0, -0.8,   -0.4,  0.0, -0.8,    0.0,  0.0, -0.8,    0.4,  0.0, -0.8,    0.8,  0.0, -0.8,
      -0.8,  0.4, -0.8,   -0.4,  0.4, -0.8,    0.0,  0.4, -0.8,    0.4,  0.4, -0.8,    0.8,  0.4, -0.8,
      -0.8,  0.8, -0.8,   -0.4,  0.8, -0.8,    0.0,  0.8, -0.8,    0.4,  0.8, -0.8,    0.8,  0.8, -0.8,
      -0.8, -0.8, -0.4,   -0.4, -0.8, -0.4,    0.0, -0.8, -0.4,    0.4, -0.8, -0.4,    0.8, -0.8, -0.4,
      -0.8, -0.4, -0.4,   -0.4, -0.4, -0.4,    0.0, -0.4, -0.4,    0.4, -0.4, -0.4,    0.8, -0.4, -0.4,
      -0.8,  0.0, -0.4,   -0.4,  0.0, -0.4,    0.0,  0.0, -0.4,    0.4,  0.0, -0.4,    0.8,  0.0, -0.4,
      -0.8,  0.4, -0.4,   -0.4,  0.4, -0.4,    0.0,  0.4, -0.4,    0.4,  0.4, -0.4,    0.8,  0.4, -0.4,
      -0.8,  0.8, -0.4,   -0.4,  0.8, -0.4,    0.0,  0.8, -0.4,    0.4,  0.8, -0.4,    0.8,  0.8, -0.4,
      -0.8, -0.8,  0.0,   -0.4, -0.8,  0.0,    0.0, -0.8,  0.0,    0.4, -0.8,  0.0,    0.8, -0.8,  0.0,
      -0.8, -0.4,  0.0,   -0.4, -0.4,  0.0,    0.0, -0.4,  0.0,    0.4, -0.4,  0.0,    0.8, -0.4,  0.0,
      -0.8,  0.0,  0.0,   -0.4,  0.0,  0.0,    0.0,  0.0,  0.0,    0.4,  0.0,  0.0,    0.8,  0.0,  0.0,
      -0.8,  0.4,  0.0,   -0.4,  0.4,  0.0,    0.0,  0.4,  0.0,    0.4,  0.4,  0.0,    0.8,  0.4,  0.0,
      -0.8,  0.8,  0.0,   -0.4,  0.8,  0.0,    0.0,  0.8,  0.0,    0.4,  0.8,  0.0,    0.8,  0.8,  0.0,
      -0.8, -0.8,  0.4,   -0.4, -0.8,  0.4,    0.0, -0.8,  0.4,    0.4, -0.8,  0.4,    0.8, -0.8,  0.4,
      -0.8, -0.4,  0.4,   -0.4, -0.4,  0.4,    0.0, -0.4,  0.4,    0.4, -0.4,  0.4,    0.8, -0.4,  0.4,
      -0.8,  0.0,  0.4,   -0.4,  0.0,  0.4,    0.0,  0.0,  0.4,    0.4,  0.0,  0.4,    0.8,  0.0,  0.4,
      -0.8,  0.4,  0.4,   -0.4,  0.4,  0.4,    0.0,  0.4,  0.4,    0.4,  0.4,  0.4,    0.8,  0.4,  0.4,
      -0.8,  0.8,  0.4,   -0.4,  0.8,  0.4,    0.0,  0.8,  0.4,    0.4,  0.8,  0.4,    0.8,  0.8,  0.4,
      -0.8, -0.8,  0.8,   -0.4, -0.8,  0.8,    0.0, -0.8,  0.8,    0.4, -0.8,  0.8,    0.8, -0.8,  0.8,
      -0.8, -0.4,  0.8,   -0.4, -0.4,  0.8,    0.0, -0.4,  0.8,    0.4, -0.4,  0.8,    0.8, -0.4,  0.8,
      -0.8,  0.0,  0.8,   -0.4,  0.0,  0.8,    0.0,  0.0,  0.8,    0.4,  0.0,  0.8,    0.8,  0.0,  0.8,
      -0.8,  0.4,  0.8,   -0.4,  0.4,  0.8,    0.0,  0.4,  0.8,    0.4,  0.4,  0.8,    0.8,  0.4,  0.8,
      -0.8,  0.8,  0.8,   -0.4,  0.8,  0.8,    0.0,  0.8,  0.8,    0.4,  0.8,  0.8,    0.8,  0.8,  0.8);

  // this table contains 3 requantized samples for each legal codeword
  // when grouped in 10 bits, i.e. 9 quantizationsteps per sample
  Grouping10Bits: array[0..729 * 3 - 1] of Single = (
    -8.0/9.0, -8.0/9.0, -8.0/9.0,   -6.0/9.0, -8.0/9.0, -8.0/9.0,   -4.0/9.0, -8.0/9.0, -8.0/9.0,
    -2.0/9.0, -8.0/9.0, -8.0/9.0,        0.0, -8.0/9.0, -8.0/9.0,    2.0/9.0, -8.0/9.0, -8.0/9.0,
     4.0/9.0, -8.0/9.0, -8.0/9.0,    6.0/9.0, -8.0/9.0, -8.0/9.0,    8.0/9.0, -8.0/9.0, -8.0/9.0,
    -8.0/9.0, -6.0/9.0, -8.0/9.0,   -6.0/9.0, -6.0/9.0, -8.0/9.0,   -4.0/9.0, -6.0/9.0, -8.0/9.0,
    -2.0/9.0, -6.0/9.0, -8.0/9.0,        0.0, -6.0/9.0, -8.0/9.0,    2.0/9.0, -6.0/9.0, -8.0/9.0,
     4.0/9.0, -6.0/9.0, -8.0/9.0,    6.0/9.0, -6.0/9.0, -8.0/9.0,    8.0/9.0, -6.0/9.0, -8.0/9.0,
    -8.0/9.0, -4.0/9.0, -8.0/9.0,   -6.0/9.0, -4.0/9.0, -8.0/9.0,   -4.0/9.0, -4.0/9.0, -8.0/9.0,
    -2.0/9.0, -4.0/9.0, -8.0/9.0,        0.0, -4.0/9.0, -8.0/9.0,    2.0/9.0, -4.0/9.0, -8.0/9.0,
     4.0/9.0, -4.0/9.0, -8.0/9.0,    6.0/9.0, -4.0/9.0, -8.0/9.0,    8.0/9.0, -4.0/9.0, -8.0/9.0,
    -8.0/9.0, -2.0/9.0, -8.0/9.0,   -6.0/9.0, -2.0/9.0, -8.0/9.0,   -4.0/9.0, -2.0/9.0, -8.0/9.0,
    -2.0/9.0, -2.0/9.0, -8.0/9.0,        0.0, -2.0/9.0, -8.0/9.0,    2.0/9.0, -2.0/9.0, -8.0/9.0,
     4.0/9.0, -2.0/9.0, -8.0/9.0,    6.0/9.0, -2.0/9.0, -8.0/9.0,    8.0/9.0, -2.0/9.0, -8.0/9.0,
    -8.0/9.0,      0.0, -8.0/9.0,   -6.0/9.0,      0.0, -8.0/9.0,   -4.0/9.0,      0.0, -8.0/9.0,
    -2.0/9.0,      0.0, -8.0/9.0,        0.0,      0.0, -8.0/9.0,    2.0/9.0,      0.0, -8.0/9.0,
     4.0/9.0,      0.0, -8.0/9.0,    6.0/9.0,      0.0, -8.0/9.0,    8.0/9.0,      0.0, -8.0/9.0,
    -8.0/9.0,  2.0/9.0, -8.0/9.0,   -6.0/9.0,  2.0/9.0, -8.0/9.0,   -4.0/9.0,  2.0/9.0, -8.0/9.0,
    -2.0/9.0,  2.0/9.0, -8.0/9.0,        0.0,  2.0/9.0, -8.0/9.0,    2.0/9.0,  2.0/9.0, -8.0/9.0,
     4.0/9.0,  2.0/9.0, -8.0/9.0,    6.0/9.0,  2.0/9.0, -8.0/9.0,    8.0/9.0,  2.0/9.0, -8.0/9.0,
    -8.0/9.0,  4.0/9.0, -8.0/9.0,   -6.0/9.0,  4.0/9.0, -8.0/9.0,   -4.0/9.0,  4.0/9.0, -8.0/9.0,
    -2.0/9.0,  4.0/9.0, -8.0/9.0,        0.0,  4.0/9.0, -8.0/9.0,    2.0/9.0,  4.0/9.0, -8.0/9.0,
     4.0/9.0,  4.0/9.0, -8.0/9.0,    6.0/9.0,  4.0/9.0, -8.0/9.0,    8.0/9.0,  4.0/9.0, -8.0/9.0,
    -8.0/9.0,  6.0/9.0, -8.0/9.0,   -6.0/9.0,  6.0/9.0, -8.0/9.0,   -4.0/9.0,  6.0/9.0, -8.0/9.0,
    -2.0/9.0,  6.0/9.0, -8.0/9.0,        0.0,  6.0/9.0, -8.0/9.0,    2.0/9.0,  6.0/9.0, -8.0/9.0,
     4.0/9.0,  6.0/9.0, -8.0/9.0,    6.0/9.0,  6.0/9.0, -8.0/9.0,    8.0/9.0,  6.0/9.0, -8.0/9.0,
    -8.0/9.0,  8.0/9.0, -8.0/9.0,   -6.0/9.0,  8.0/9.0, -8.0/9.0,   -4.0/9.0,  8.0/9.0, -8.0/9.0,
    -2.0/9.0,  8.0/9.0, -8.0/9.0,        0.0,  8.0/9.0, -8.0/9.0,    2.0/9.0,  8.0/9.0, -8.0/9.0,
     4.0/9.0,  8.0/9.0, -8.0/9.0,    6.0/9.0,  8.0/9.0, -8.0/9.0,    8.0/9.0,  8.0/9.0, -8.0/9.0,
    -8.0/9.0, -8.0/9.0, -6.0/9.0,   -6.0/9.0, -8.0/9.0, -6.0/9.0,   -4.0/9.0, -8.0/9.0, -6.0/9.0,
    -2.0/9.0, -8.0/9.0, -6.0/9.0,        0.0, -8.0/9.0, -6.0/9.0,    2.0/9.0, -8.0/9.0, -6.0/9.0,
     4.0/9.0, -8.0/9.0, -6.0/9.0,    6.0/9.0, -8.0/9.0, -6.0/9.0,    8.0/9.0, -8.0/9.0, -6.0/9.0,
    -8.0/9.0, -6.0/9.0, -6.0/9.0,   -6.0/9.0, -6.0/9.0, -6.0/9.0,   -4.0/9.0, -6.0/9.0, -6.0/9.0,
    -2.0/9.0, -6.0/9.0, -6.0/9.0,        0.0, -6.0/9.0, -6.0/9.0,    2.0/9.0, -6.0/9.0, -6.0/9.0,
     4.0/9.0, -6.0/9.0, -6.0/9.0,    6.0/9.0, -6.0/9.0, -6.0/9.0,    8.0/9.0, -6.0/9.0, -6.0/9.0,
    -8.0/9.0, -4.0/9.0, -6.0/9.0,   -6.0/9.0, -4.0/9.0, -6.0/9.0,   -4.0/9.0, -4.0/9.0, -6.0/9.0,
    -2.0/9.0, -4.0/9.0, -6.0/9.0,        0.0, -4.0/9.0, -6.0/9.0,    2.0/9.0, -4.0/9.0, -6.0/9.0,
     4.0/9.0, -4.0/9.0, -6.0/9.0,    6.0/9.0, -4.0/9.0, -6.0/9.0,    8.0/9.0, -4.0/9.0, -6.0/9.0,
    -8.0/9.0, -2.0/9.0, -6.0/9.0,   -6.0/9.0, -2.0/9.0, -6.0/9.0,   -4.0/9.0, -2.0/9.0, -6.0/9.0,
    -2.0/9.0, -2.0/9.0, -6.0/9.0,        0.0, -2.0/9.0, -6.0/9.0,    2.0/9.0, -2.0/9.0, -6.0/9.0,
     4.0/9.0, -2.0/9.0, -6.0/9.0,    6.0/9.0, -2.0/9.0, -6.0/9.0,    8.0/9.0, -2.0/9.0, -6.0/9.0,
    -8.0/9.0,      0.0, -6.0/9.0,   -6.0/9.0,      0.0, -6.0/9.0,   -4.0/9.0,      0.0, -6.0/9.0,
    -2.0/9.0,      0.0, -6.0/9.0,        0.0,      0.0, -6.0/9.0,    2.0/9.0,      0.0, -6.0/9.0,
     4.0/9.0,      0.0, -6.0/9.0,    6.0/9.0,      0.0, -6.0/9.0,    8.0/9.0,      0.0, -6.0/9.0,
    -8.0/9.0,  2.0/9.0, -6.0/9.0,   -6.0/9.0,  2.0/9.0, -6.0/9.0,   -4.0/9.0,  2.0/9.0, -6.0/9.0,
    -2.0/9.0,  2.0/9.0, -6.0/9.0,        0.0,  2.0/9.0, -6.0/9.0,    2.0/9.0,  2.0/9.0, -6.0/9.0,
     4.0/9.0,  2.0/9.0, -6.0/9.0,    6.0/9.0,  2.0/9.0, -6.0/9.0,    8.0/9.0,  2.0/9.0, -6.0/9.0,
    -8.0/9.0,  4.0/9.0, -6.0/9.0,   -6.0/9.0,  4.0/9.0, -6.0/9.0,   -4.0/9.0,  4.0/9.0, -6.0/9.0,
    -2.0/9.0,  4.0/9.0, -6.0/9.0,        0.0,  4.0/9.0, -6.0/9.0,    2.0/9.0,  4.0/9.0, -6.0/9.0,
     4.0/9.0,  4.0/9.0, -6.0/9.0,    6.0/9.0,  4.0/9.0, -6.0/9.0,    8.0/9.0,  4.0/9.0, -6.0/9.0,
    -8.0/9.0,  6.0/9.0, -6.0/9.0,   -6.0/9.0,  6.0/9.0, -6.0/9.0,   -4.0/9.0,  6.0/9.0, -6.0/9.0,
    -2.0/9.0,  6.0/9.0, -6.0/9.0,        0.0,  6.0/9.0, -6.0/9.0,    2.0/9.0,  6.0/9.0, -6.0/9.0,
     4.0/9.0,  6.0/9.0, -6.0/9.0,    6.0/9.0,  6.0/9.0, -6.0/9.0,    8.0/9.0,  6.0/9.0, -6.0/9.0,
    -8.0/9.0,  8.0/9.0, -6.0/9.0,   -6.0/9.0,  8.0/9.0, -6.0/9.0,   -4.0/9.0,  8.0/9.0, -6.0/9.0,
    -2.0/9.0,  8.0/9.0, -6.0/9.0,        0.0,  8.0/9.0, -6.0/9.0,    2.0/9.0,  8.0/9.0, -6.0/9.0,
     4.0/9.0,  8.0/9.0, -6.0/9.0,    6.0/9.0,  8.0/9.0, -6.0/9.0,    8.0/9.0,  8.0/9.0, -6.0/9.0,
    -8.0/9.0, -8.0/9.0, -4.0/9.0,   -6.0/9.0, -8.0/9.0, -4.0/9.0,   -4.0/9.0, -8.0/9.0, -4.0/9.0,
    -2.0/9.0, -8.0/9.0, -4.0/9.0,        0.0, -8.0/9.0, -4.0/9.0,    2.0/9.0, -8.0/9.0, -4.0/9.0,
     4.0/9.0, -8.0/9.0, -4.0/9.0,    6.0/9.0, -8.0/9.0, -4.0/9.0,    8.0/9.0, -8.0/9.0, -4.0/9.0,
    -8.0/9.0, -6.0/9.0, -4.0/9.0,   -6.0/9.0, -6.0/9.0, -4.0/9.0,   -4.0/9.0, -6.0/9.0, -4.0/9.0,
    -2.0/9.0, -6.0/9.0, -4.0/9.0,        0.0, -6.0/9.0, -4.0/9.0,    2.0/9.0, -6.0/9.0, -4.0/9.0,
     4.0/9.0, -6.0/9.0, -4.0/9.0,    6.0/9.0, -6.0/9.0, -4.0/9.0,    8.0/9.0, -6.0/9.0, -4.0/9.0,
    -8.0/9.0, -4.0/9.0, -4.0/9.0,   -6.0/9.0, -4.0/9.0, -4.0/9.0,   -4.0/9.0, -4.0/9.0, -4.0/9.0,
    -2.0/9.0, -4.0/9.0, -4.0/9.0,        0.0, -4.0/9.0, -4.0/9.0,    2.0/9.0, -4.0/9.0, -4.0/9.0,
     4.0/9.0, -4.0/9.0, -4.0/9.0,    6.0/9.0, -4.0/9.0, -4.0/9.0,    8.0/9.0, -4.0/9.0, -4.0/9.0,
    -8.0/9.0, -2.0/9.0, -4.0/9.0,   -6.0/9.0, -2.0/9.0, -4.0/9.0,   -4.0/9.0, -2.0/9.0, -4.0/9.0,
    -2.0/9.0, -2.0/9.0, -4.0/9.0,        0.0, -2.0/9.0, -4.0/9.0,    2.0/9.0, -2.0/9.0, -4.0/9.0,
     4.0/9.0, -2.0/9.0, -4.0/9.0,    6.0/9.0, -2.0/9.0, -4.0/9.0,    8.0/9.0, -2.0/9.0, -4.0/9.0,
    -8.0/9.0,      0.0, -4.0/9.0,   -6.0/9.0,      0.0, -4.0/9.0,   -4.0/9.0,      0.0, -4.0/9.0,
    -2.0/9.0,      0.0, -4.0/9.0,        0.0,      0.0, -4.0/9.0,    2.0/9.0,      0.0, -4.0/9.0,
     4.0/9.0,      0.0, -4.0/9.0,    6.0/9.0,      0.0, -4.0/9.0,    8.0/9.0,      0.0, -4.0/9.0,
    -8.0/9.0,  2.0/9.0, -4.0/9.0,   -6.0/9.0,  2.0/9.0, -4.0/9.0,   -4.0/9.0,  2.0/9.0, -4.0/9.0,
    -2.0/9.0,  2.0/9.0, -4.0/9.0,        0.0,  2.0/9.0, -4.0/9.0,    2.0/9.0,  2.0/9.0, -4.0/9.0,
     4.0/9.0,  2.0/9.0, -4.0/9.0,    6.0/9.0,  2.0/9.0, -4.0/9.0,    8.0/9.0,  2.0/9.0, -4.0/9.0,
    -8.0/9.0,  4.0/9.0, -4.0/9.0,   -6.0/9.0,  4.0/9.0, -4.0/9.0,   -4.0/9.0,  4.0/9.0, -4.0/9.0,
    -2.0/9.0,  4.0/9.0, -4.0/9.0,        0.0,  4.0/9.0, -4.0/9.0,    2.0/9.0,  4.0/9.0, -4.0/9.0,
     4.0/9.0,  4.0/9.0, -4.0/9.0,    6.0/9.0,  4.0/9.0, -4.0/9.0,    8.0/9.0,  4.0/9.0, -4.0/9.0,
    -8.0/9.0,  6.0/9.0, -4.0/9.0,   -6.0/9.0,  6.0/9.0, -4.0/9.0,   -4.0/9.0,  6.0/9.0, -4.0/9.0,
    -2.0/9.0,  6.0/9.0, -4.0/9.0,        0.0,  6.0/9.0, -4.0/9.0,    2.0/9.0,  6.0/9.0, -4.0/9.0,
     4.0/9.0,  6.0/9.0, -4.0/9.0,    6.0/9.0,  6.0/9.0, -4.0/9.0,    8.0/9.0,  6.0/9.0, -4.0/9.0,
    -8.0/9.0,  8.0/9.0, -4.0/9.0,   -6.0/9.0,  8.0/9.0, -4.0/9.0,   -4.0/9.0,  8.0/9.0, -4.0/9.0,
    -2.0/9.0,  8.0/9.0, -4.0/9.0,        0.0,  8.0/9.0, -4.0/9.0,    2.0/9.0,  8.0/9.0, -4.0/9.0,
     4.0/9.0,  8.0/9.0, -4.0/9.0,    6.0/9.0,  8.0/9.0, -4.0/9.0,    8.0/9.0,  8.0/9.0, -4.0/9.0,
    -8.0/9.0, -8.0/9.0, -2.0/9.0,   -6.0/9.0, -8.0/9.0, -2.0/9.0,   -4.0/9.0, -8.0/9.0, -2.0/9.0,
    -2.0/9.0, -8.0/9.0, -2.0/9.0,        0.0, -8.0/9.0, -2.0/9.0,    2.0/9.0, -8.0/9.0, -2.0/9.0,
     4.0/9.0, -8.0/9.0, -2.0/9.0,    6.0/9.0, -8.0/9.0, -2.0/9.0,    8.0/9.0, -8.0/9.0, -2.0/9.0,
    -8.0/9.0, -6.0/9.0, -2.0/9.0,   -6.0/9.0, -6.0/9.0, -2.0/9.0,   -4.0/9.0, -6.0/9.0, -2.0/9.0,
    -2.0/9.0, -6.0/9.0, -2.0/9.0,        0.0, -6.0/9.0, -2.0/9.0,    2.0/9.0, -6.0/9.0, -2.0/9.0,
     4.0/9.0, -6.0/9.0, -2.0/9.0,    6.0/9.0, -6.0/9.0, -2.0/9.0,    8.0/9.0, -6.0/9.0, -2.0/9.0,
    -8.0/9.0, -4.0/9.0, -2.0/9.0,   -6.0/9.0, -4.0/9.0, -2.0/9.0,   -4.0/9.0, -4.0/9.0, -2.0/9.0,
    -2.0/9.0, -4.0/9.0, -2.0/9.0,        0.0, -4.0/9.0, -2.0/9.0,    2.0/9.0, -4.0/9.0, -2.0/9.0,
     4.0/9.0, -4.0/9.0, -2.0/9.0,    6.0/9.0, -4.0/9.0, -2.0/9.0,    8.0/9.0, -4.0/9.0, -2.0/9.0,
    -8.0/9.0, -2.0/9.0, -2.0/9.0,   -6.0/9.0, -2.0/9.0, -2.0/9.0,   -4.0/9.0, -2.0/9.0, -2.0/9.0,
    -2.0/9.0, -2.0/9.0, -2.0/9.0,        0.0, -2.0/9.0, -2.0/9.0,    2.0/9.0, -2.0/9.0, -2.0/9.0,
     4.0/9.0, -2.0/9.0, -2.0/9.0,    6.0/9.0, -2.0/9.0, -2.0/9.0,    8.0/9.0, -2.0/9.0, -2.0/9.0,
    -8.0/9.0,      0.0, -2.0/9.0,   -6.0/9.0,      0.0, -2.0/9.0,   -4.0/9.0,      0.0, -2.0/9.0,
    -2.0/9.0,      0.0, -2.0/9.0,        0.0,      0.0, -2.0/9.0,    2.0/9.0,      0.0, -2.0/9.0,
     4.0/9.0,      0.0, -2.0/9.0,    6.0/9.0,      0.0, -2.0/9.0,    8.0/9.0,      0.0, -2.0/9.0,
    -8.0/9.0,  2.0/9.0, -2.0/9.0,   -6.0/9.0,  2.0/9.0, -2.0/9.0,   -4.0/9.0,  2.0/9.0, -2.0/9.0,
    -2.0/9.0,  2.0/9.0, -2.0/9.0,        0.0,  2.0/9.0, -2.0/9.0,    2.0/9.0,  2.0/9.0, -2.0/9.0,
     4.0/9.0,  2.0/9.0, -2.0/9.0,    6.0/9.0,  2.0/9.0, -2.0/9.0,    8.0/9.0,  2.0/9.0, -2.0/9.0,
    -8.0/9.0,  4.0/9.0, -2.0/9.0,   -6.0/9.0,  4.0/9.0, -2.0/9.0,   -4.0/9.0,  4.0/9.0, -2.0/9.0,
    -2.0/9.0,  4.0/9.0, -2.0/9.0,        0.0,  4.0/9.0, -2.0/9.0,    2.0/9.0,  4.0/9.0, -2.0/9.0,
     4.0/9.0,  4.0/9.0, -2.0/9.0,    6.0/9.0,  4.0/9.0, -2.0/9.0,    8.0/9.0,  4.0/9.0, -2.0/9.0,
    -8.0/9.0,  6.0/9.0, -2.0/9.0,   -6.0/9.0,  6.0/9.0, -2.0/9.0,   -4.0/9.0,  6.0/9.0, -2.0/9.0,
    -2.0/9.0,  6.0/9.0, -2.0/9.0,        0.0,  6.0/9.0, -2.0/9.0,    2.0/9.0,  6.0/9.0, -2.0/9.0,
     4.0/9.0,  6.0/9.0, -2.0/9.0,    6.0/9.0,  6.0/9.0, -2.0/9.0,    8.0/9.0,  6.0/9.0, -2.0/9.0,
    -8.0/9.0,  8.0/9.0, -2.0/9.0,   -6.0/9.0,  8.0/9.0, -2.0/9.0,   -4.0/9.0,  8.0/9.0, -2.0/9.0,
    -2.0/9.0,  8.0/9.0, -2.0/9.0,        0.0,  8.0/9.0, -2.0/9.0,    2.0/9.0,  8.0/9.0, -2.0/9.0,
     4.0/9.0,  8.0/9.0, -2.0/9.0,    6.0/9.0,  8.0/9.0, -2.0/9.0,    8.0/9.0,  8.0/9.0, -2.0/9.0,
    -8.0/9.0, -8.0/9.0,      0.0,   -6.0/9.0, -8.0/9.0,      0.0,   -4.0/9.0, -8.0/9.0,      0.0,
    -2.0/9.0, -8.0/9.0,      0.0,        0.0, -8.0/9.0,      0.0,    2.0/9.0, -8.0/9.0,      0.0,
     4.0/9.0, -8.0/9.0,      0.0,    6.0/9.0, -8.0/9.0,      0.0,    8.0/9.0, -8.0/9.0,      0.0,
    -8.0/9.0, -6.0/9.0,      0.0,   -6.0/9.0, -6.0/9.0,      0.0,   -4.0/9.0, -6.0/9.0,      0.0,
    -2.0/9.0, -6.0/9.0,      0.0,        0.0, -6.0/9.0,      0.0,    2.0/9.0, -6.0/9.0,      0.0,
     4.0/9.0, -6.0/9.0,      0.0,    6.0/9.0, -6.0/9.0,      0.0,    8.0/9.0, -6.0/9.0,      0.0,
    -8.0/9.0, -4.0/9.0,      0.0,   -6.0/9.0, -4.0/9.0,      0.0,   -4.0/9.0, -4.0/9.0,      0.0,
    -2.0/9.0, -4.0/9.0,      0.0,        0.0, -4.0/9.0,      0.0,    2.0/9.0, -4.0/9.0,      0.0,
     4.0/9.0, -4.0/9.0,      0.0,    6.0/9.0, -4.0/9.0,      0.0,    8.0/9.0, -4.0/9.0,      0.0,
    -8.0/9.0, -2.0/9.0,      0.0,   -6.0/9.0, -2.0/9.0,      0.0,   -4.0/9.0, -2.0/9.0,      0.0,
    -2.0/9.0, -2.0/9.0,      0.0,        0.0, -2.0/9.0,      0.0,    2.0/9.0, -2.0/9.0,      0.0,
     4.0/9.0, -2.0/9.0,      0.0,    6.0/9.0, -2.0/9.0,      0.0,    8.0/9.0, -2.0/9.0,      0.0,
    -8.0/9.0,      0.0,      0.0,   -6.0/9.0,      0.0,      0.0,   -4.0/9.0,      0.0,      0.0,
    -2.0/9.0,      0.0,      0.0,        0.0,      0.0,      0.0,    2.0/9.0,      0.0,      0.0,
     4.0/9.0,      0.0,      0.0,    6.0/9.0,      0.0,      0.0,    8.0/9.0,      0.0,      0.0,
    -8.0/9.0,  2.0/9.0,      0.0,   -6.0/9.0,  2.0/9.0,      0.0,   -4.0/9.0,  2.0/9.0,      0.0,
    -2.0/9.0,  2.0/9.0,      0.0,        0.0,  2.0/9.0,      0.0,    2.0/9.0,  2.0/9.0,      0.0,
     4.0/9.0,  2.0/9.0,      0.0,    6.0/9.0,  2.0/9.0,      0.0,    8.0/9.0,  2.0/9.0,      0.0,
    -8.0/9.0,  4.0/9.0,      0.0,   -6.0/9.0,  4.0/9.0,      0.0,   -4.0/9.0,  4.0/9.0,      0.0,
    -2.0/9.0,  4.0/9.0,      0.0,        0.0,  4.0/9.0,      0.0,    2.0/9.0,  4.0/9.0,      0.0,
     4.0/9.0,  4.0/9.0,      0.0,    6.0/9.0,  4.0/9.0,      0.0,    8.0/9.0,  4.0/9.0,      0.0,
    -8.0/9.0,  6.0/9.0,      0.0,   -6.0/9.0,  6.0/9.0,      0.0,   -4.0/9.0,  6.0/9.0,      0.0,
    -2.0/9.0,  6.0/9.0,      0.0,        0.0,  6.0/9.0,      0.0,    2.0/9.0,  6.0/9.0,      0.0,
     4.0/9.0,  6.0/9.0,      0.0,    6.0/9.0,  6.0/9.0,      0.0,    8.0/9.0,  6.0/9.0,      0.0,
    -8.0/9.0,  8.0/9.0,      0.0,   -6.0/9.0,  8.0/9.0,      0.0,   -4.0/9.0,  8.0/9.0,      0.0,
    -2.0/9.0,  8.0/9.0,      0.0,        0.0,  8.0/9.0,      0.0,    2.0/9.0,  8.0/9.0,      0.0,
     4.0/9.0,  8.0/9.0,      0.0,    6.0/9.0,  8.0/9.0,      0.0,    8.0/9.0,  8.0/9.0,      0.0,
    -8.0/9.0, -8.0/9.0,  2.0/9.0,   -6.0/9.0, -8.0/9.0,  2.0/9.0,   -4.0/9.0, -8.0/9.0,  2.0/9.0,
    -2.0/9.0, -8.0/9.0,  2.0/9.0,        0.0, -8.0/9.0,  2.0/9.0,    2.0/9.0, -8.0/9.0,  2.0/9.0,
     4.0/9.0, -8.0/9.0,  2.0/9.0,    6.0/9.0, -8.0/9.0,  2.0/9.0,    8.0/9.0, -8.0/9.0,  2.0/9.0,
    -8.0/9.0, -6.0/9.0,  2.0/9.0,   -6.0/9.0, -6.0/9.0,  2.0/9.0,   -4.0/9.0, -6.0/9.0,  2.0/9.0,
    -2.0/9.0, -6.0/9.0,  2.0/9.0,        0.0, -6.0/9.0,  2.0/9.0,    2.0/9.0, -6.0/9.0,  2.0/9.0,
     4.0/9.0, -6.0/9.0,  2.0/9.0,    6.0/9.0, -6.0/9.0,  2.0/9.0,    8.0/9.0, -6.0/9.0,  2.0/9.0,
    -8.0/9.0, -4.0/9.0,  2.0/9.0,   -6.0/9.0, -4.0/9.0,  2.0/9.0,   -4.0/9.0, -4.0/9.0,  2.0/9.0,
    -2.0/9.0, -4.0/9.0,  2.0/9.0,        0.0, -4.0/9.0,  2.0/9.0,    2.0/9.0, -4.0/9.0,  2.0/9.0,
     4.0/9.0, -4.0/9.0,  2.0/9.0,    6.0/9.0, -4.0/9.0,  2.0/9.0,    8.0/9.0, -4.0/9.0,  2.0/9.0,
    -8.0/9.0, -2.0/9.0,  2.0/9.0,   -6.0/9.0, -2.0/9.0,  2.0/9.0,   -4.0/9.0, -2.0/9.0,  2.0/9.0,
    -2.0/9.0, -2.0/9.0,  2.0/9.0,        0.0, -2.0/9.0,  2.0/9.0,    2.0/9.0, -2.0/9.0,  2.0/9.0,
     4.0/9.0, -2.0/9.0,  2.0/9.0,    6.0/9.0, -2.0/9.0,  2.0/9.0,    8.0/9.0, -2.0/9.0,  2.0/9.0,
    -8.0/9.0,      0.0,  2.0/9.0,   -6.0/9.0,      0.0,  2.0/9.0,   -4.0/9.0,      0.0,  2.0/9.0,
    -2.0/9.0,      0.0,  2.0/9.0,        0.0,      0.0,  2.0/9.0,    2.0/9.0,      0.0,  2.0/9.0,
     4.0/9.0,      0.0,  2.0/9.0,    6.0/9.0,      0.0,  2.0/9.0,    8.0/9.0,      0.0,  2.0/9.0,
    -8.0/9.0,  2.0/9.0,  2.0/9.0,   -6.0/9.0,  2.0/9.0,  2.0/9.0,   -4.0/9.0,  2.0/9.0,  2.0/9.0,
    -2.0/9.0,  2.0/9.0,  2.0/9.0,        0.0,  2.0/9.0,  2.0/9.0,    2.0/9.0,  2.0/9.0,  2.0/9.0,
     4.0/9.0,  2.0/9.0,  2.0/9.0,    6.0/9.0,  2.0/9.0,  2.0/9.0,    8.0/9.0,  2.0/9.0,  2.0/9.0,
    -8.0/9.0,  4.0/9.0,  2.0/9.0,   -6.0/9.0,  4.0/9.0,  2.0/9.0,   -4.0/9.0,  4.0/9.0,  2.0/9.0,
    -2.0/9.0,  4.0/9.0,  2.0/9.0,        0.0,  4.0/9.0,  2.0/9.0,    2.0/9.0,  4.0/9.0,  2.0/9.0,
     4.0/9.0,  4.0/9.0,  2.0/9.0,    6.0/9.0,  4.0/9.0,  2.0/9.0,    8.0/9.0,  4.0/9.0,  2.0/9.0,
    -8.0/9.0,  6.0/9.0,  2.0/9.0,   -6.0/9.0,  6.0/9.0,  2.0/9.0,   -4.0/9.0,  6.0/9.0,  2.0/9.0,
    -2.0/9.0,  6.0/9.0,  2.0/9.0,        0.0,  6.0/9.0,  2.0/9.0,    2.0/9.0,  6.0/9.0,  2.0/9.0,
     4.0/9.0,  6.0/9.0,  2.0/9.0,    6.0/9.0,  6.0/9.0,  2.0/9.0,    8.0/9.0,  6.0/9.0,  2.0/9.0,
    -8.0/9.0,  8.0/9.0,  2.0/9.0,   -6.0/9.0,  8.0/9.0,  2.0/9.0,   -4.0/9.0,  8.0/9.0,  2.0/9.0,
    -2.0/9.0,  8.0/9.0,  2.0/9.0,        0.0,  8.0/9.0,  2.0/9.0,    2.0/9.0,  8.0/9.0,  2.0/9.0,
     4.0/9.0,  8.0/9.0,  2.0/9.0,    6.0/9.0,  8.0/9.0,  2.0/9.0,    8.0/9.0,  8.0/9.0,  2.0/9.0,
    -8.0/9.0, -8.0/9.0,  4.0/9.0,   -6.0/9.0, -8.0/9.0,  4.0/9.0,   -4.0/9.0, -8.0/9.0,  4.0/9.0,
    -2.0/9.0, -8.0/9.0,  4.0/9.0,        0.0, -8.0/9.0,  4.0/9.0,    2.0/9.0, -8.0/9.0,  4.0/9.0,
     4.0/9.0, -8.0/9.0,  4.0/9.0,    6.0/9.0, -8.0/9.0,  4.0/9.0,    8.0/9.0, -8.0/9.0,  4.0/9.0,
    -8.0/9.0, -6.0/9.0,  4.0/9.0,   -6.0/9.0, -6.0/9.0,  4.0/9.0,   -4.0/9.0, -6.0/9.0,  4.0/9.0,
    -2.0/9.0, -6.0/9.0,  4.0/9.0,        0.0, -6.0/9.0,  4.0/9.0,    2.0/9.0, -6.0/9.0,  4.0/9.0,
     4.0/9.0, -6.0/9.0,  4.0/9.0,    6.0/9.0, -6.0/9.0,  4.0/9.0,    8.0/9.0, -6.0/9.0,  4.0/9.0,
    -8.0/9.0, -4.0/9.0,  4.0/9.0,   -6.0/9.0, -4.0/9.0,  4.0/9.0,   -4.0/9.0, -4.0/9.0,  4.0/9.0,
    -2.0/9.0, -4.0/9.0,  4.0/9.0,        0.0, -4.0/9.0,  4.0/9.0,    2.0/9.0, -4.0/9.0,  4.0/9.0,
     4.0/9.0, -4.0/9.0,  4.0/9.0,    6.0/9.0, -4.0/9.0,  4.0/9.0,    8.0/9.0, -4.0/9.0,  4.0/9.0,
    -8.0/9.0, -2.0/9.0,  4.0/9.0,   -6.0/9.0, -2.0/9.0,  4.0/9.0,   -4.0/9.0, -2.0/9.0,  4.0/9.0,
    -2.0/9.0, -2.0/9.0,  4.0/9.0,        0.0, -2.0/9.0,  4.0/9.0,    2.0/9.0, -2.0/9.0,  4.0/9.0,
     4.0/9.0, -2.0/9.0,  4.0/9.0,    6.0/9.0, -2.0/9.0,  4.0/9.0,    8.0/9.0, -2.0/9.0,  4.0/9.0,
    -8.0/9.0,      0.0,  4.0/9.0,   -6.0/9.0,      0.0,  4.0/9.0,   -4.0/9.0,      0.0,  4.0/9.0,
    -2.0/9.0,      0.0,  4.0/9.0,        0.0,      0.0,  4.0/9.0,    2.0/9.0,      0.0,  4.0/9.0,
     4.0/9.0,      0.0,  4.0/9.0,    6.0/9.0,      0.0,  4.0/9.0,    8.0/9.0,      0.0,  4.0/9.0,
    -8.0/9.0,  2.0/9.0,  4.0/9.0,   -6.0/9.0,  2.0/9.0,  4.0/9.0,   -4.0/9.0,  2.0/9.0,  4.0/9.0,
    -2.0/9.0,  2.0/9.0,  4.0/9.0,        0.0,  2.0/9.0,  4.0/9.0,    2.0/9.0,  2.0/9.0,  4.0/9.0,
     4.0/9.0,  2.0/9.0,  4.0/9.0,    6.0/9.0,  2.0/9.0,  4.0/9.0,    8.0/9.0,  2.0/9.0,  4.0/9.0,
    -8.0/9.0,  4.0/9.0,  4.0/9.0,   -6.0/9.0,  4.0/9.0,  4.0/9.0,   -4.0/9.0,  4.0/9.0,  4.0/9.0,
    -2.0/9.0,  4.0/9.0,  4.0/9.0,        0.0,  4.0/9.0,  4.0/9.0,    2.0/9.0,  4.0/9.0,  4.0/9.0,
     4.0/9.0,  4.0/9.0,  4.0/9.0,    6.0/9.0,  4.0/9.0,  4.0/9.0,    8.0/9.0,  4.0/9.0,  4.0/9.0,
    -8.0/9.0,  6.0/9.0,  4.0/9.0,   -6.0/9.0,  6.0/9.0,  4.0/9.0,   -4.0/9.0,  6.0/9.0,  4.0/9.0,
    -2.0/9.0,  6.0/9.0,  4.0/9.0,        0.0,  6.0/9.0,  4.0/9.0,    2.0/9.0,  6.0/9.0,  4.0/9.0,
     4.0/9.0,  6.0/9.0,  4.0/9.0,    6.0/9.0,  6.0/9.0,  4.0/9.0,    8.0/9.0,  6.0/9.0,  4.0/9.0,
    -8.0/9.0,  8.0/9.0,  4.0/9.0,   -6.0/9.0,  8.0/9.0,  4.0/9.0,   -4.0/9.0,  8.0/9.0,  4.0/9.0,
    -2.0/9.0,  8.0/9.0,  4.0/9.0,        0.0,  8.0/9.0,  4.0/9.0,    2.0/9.0,  8.0/9.0,  4.0/9.0,
     4.0/9.0,  8.0/9.0,  4.0/9.0,    6.0/9.0,  8.0/9.0,  4.0/9.0,    8.0/9.0,  8.0/9.0,  4.0/9.0,
    -8.0/9.0, -8.0/9.0,  6.0/9.0,   -6.0/9.0, -8.0/9.0,  6.0/9.0,   -4.0/9.0, -8.0/9.0,  6.0/9.0,
    -2.0/9.0, -8.0/9.0,  6.0/9.0,        0.0, -8.0/9.0,  6.0/9.0,    2.0/9.0, -8.0/9.0,  6.0/9.0,
     4.0/9.0, -8.0/9.0,  6.0/9.0,    6.0/9.0, -8.0/9.0,  6.0/9.0,    8.0/9.0, -8.0/9.0,  6.0/9.0,
    -8.0/9.0, -6.0/9.0,  6.0/9.0,   -6.0/9.0, -6.0/9.0,  6.0/9.0,   -4.0/9.0, -6.0/9.0,  6.0/9.0,
    -2.0/9.0, -6.0/9.0,  6.0/9.0,        0.0, -6.0/9.0,  6.0/9.0,    2.0/9.0, -6.0/9.0,  6.0/9.0,
     4.0/9.0, -6.0/9.0,  6.0/9.0,    6.0/9.0, -6.0/9.0,  6.0/9.0,    8.0/9.0, -6.0/9.0,  6.0/9.0,
    -8.0/9.0, -4.0/9.0,  6.0/9.0,   -6.0/9.0, -4.0/9.0,  6.0/9.0,   -4.0/9.0, -4.0/9.0,  6.0/9.0,
    -2.0/9.0, -4.0/9.0,  6.0/9.0,        0.0, -4.0/9.0,  6.0/9.0,    2.0/9.0, -4.0/9.0,  6.0/9.0,
     4.0/9.0, -4.0/9.0,  6.0/9.0,    6.0/9.0, -4.0/9.0,  6.0/9.0,    8.0/9.0, -4.0/9.0,  6.0/9.0,
    -8.0/9.0, -2.0/9.0,  6.0/9.0,   -6.0/9.0, -2.0/9.0,  6.0/9.0,   -4.0/9.0, -2.0/9.0,  6.0/9.0,
    -2.0/9.0, -2.0/9.0,  6.0/9.0,        0.0, -2.0/9.0,  6.0/9.0,    2.0/9.0, -2.0/9.0,  6.0/9.0,
     4.0/9.0, -2.0/9.0,  6.0/9.0,    6.0/9.0, -2.0/9.0,  6.0/9.0,    8.0/9.0, -2.0/9.0,  6.0/9.0,
    -8.0/9.0,      0.0,  6.0/9.0,   -6.0/9.0,      0.0,  6.0/9.0,   -4.0/9.0,      0.0,  6.0/9.0,
    -2.0/9.0,      0.0,  6.0/9.0,        0.0,      0.0,  6.0/9.0,    2.0/9.0,      0.0,  6.0/9.0,
     4.0/9.0,      0.0,  6.0/9.0,    6.0/9.0,      0.0,  6.0/9.0,    8.0/9.0,      0.0,  6.0/9.0,
    -8.0/9.0,  2.0/9.0,  6.0/9.0,   -6.0/9.0,  2.0/9.0,  6.0/9.0,   -4.0/9.0,  2.0/9.0,  6.0/9.0,
    -2.0/9.0,  2.0/9.0,  6.0/9.0,        0.0,  2.0/9.0,  6.0/9.0,    2.0/9.0,  2.0/9.0,  6.0/9.0,
     4.0/9.0,  2.0/9.0,  6.0/9.0,    6.0/9.0,  2.0/9.0,  6.0/9.0,    8.0/9.0,  2.0/9.0,  6.0/9.0,
    -8.0/9.0,  4.0/9.0,  6.0/9.0,   -6.0/9.0,  4.0/9.0,  6.0/9.0,   -4.0/9.0,  4.0/9.0,  6.0/9.0,
    -2.0/9.0,  4.0/9.0,  6.0/9.0,        0.0,  4.0/9.0,  6.0/9.0,    2.0/9.0,  4.0/9.0,  6.0/9.0,
     4.0/9.0,  4.0/9.0,  6.0/9.0,    6.0/9.0,  4.0/9.0,  6.0/9.0,    8.0/9.0,  4.0/9.0,  6.0/9.0,
    -8.0/9.0,  6.0/9.0,  6.0/9.0,   -6.0/9.0,  6.0/9.0,  6.0/9.0,   -4.0/9.0,  6.0/9.0,  6.0/9.0,
    -2.0/9.0,  6.0/9.0,  6.0/9.0,        0.0,  6.0/9.0,  6.0/9.0,    2.0/9.0,  6.0/9.0,  6.0/9.0,
     4.0/9.0,  6.0/9.0,  6.0/9.0,    6.0/9.0,  6.0/9.0,  6.0/9.0,    8.0/9.0,  6.0/9.0,  6.0/9.0,
    -8.0/9.0,  8.0/9.0,  6.0/9.0,   -6.0/9.0,  8.0/9.0,  6.0/9.0,   -4.0/9.0,  8.0/9.0,  6.0/9.0,
    -2.0/9.0,  8.0/9.0,  6.0/9.0,        0.0,  8.0/9.0,  6.0/9.0,    2.0/9.0,  8.0/9.0,  6.0/9.0,
     4.0/9.0,  8.0/9.0,  6.0/9.0,    6.0/9.0,  8.0/9.0,  6.0/9.0,    8.0/9.0,  8.0/9.0,  6.0/9.0,
    -8.0/9.0, -8.0/9.0,  8.0/9.0,   -6.0/9.0, -8.0/9.0,  8.0/9.0,   -4.0/9.0, -8.0/9.0,  8.0/9.0,
    -2.0/9.0, -8.0/9.0,  8.0/9.0,        0.0, -8.0/9.0,  8.0/9.0,    2.0/9.0, -8.0/9.0,  8.0/9.0,
     4.0/9.0, -8.0/9.0,  8.0/9.0,    6.0/9.0, -8.0/9.0,  8.0/9.0,    8.0/9.0, -8.0/9.0,  8.0/9.0,
    -8.0/9.0, -6.0/9.0,  8.0/9.0,   -6.0/9.0, -6.0/9.0,  8.0/9.0,   -4.0/9.0, -6.0/9.0,  8.0/9.0,
    -2.0/9.0, -6.0/9.0,  8.0/9.0,        0.0, -6.0/9.0,  8.0/9.0,    2.0/9.0, -6.0/9.0,  8.0/9.0,
     4.0/9.0, -6.0/9.0,  8.0/9.0,    6.0/9.0, -6.0/9.0,  8.0/9.0,    8.0/9.0, -6.0/9.0,  8.0/9.0,
    -8.0/9.0, -4.0/9.0,  8.0/9.0,   -6.0/9.0, -4.0/9.0,  8.0/9.0,   -4.0/9.0, -4.0/9.0,  8.0/9.0,
    -2.0/9.0, -4.0/9.0,  8.0/9.0,        0.0, -4.0/9.0,  8.0/9.0,    2.0/9.0, -4.0/9.0,  8.0/9.0,
     4.0/9.0, -4.0/9.0,  8.0/9.0,    6.0/9.0, -4.0/9.0,  8.0/9.0,    8.0/9.0, -4.0/9.0,  8.0/9.0,
    -8.0/9.0, -2.0/9.0,  8.0/9.0,   -6.0/9.0, -2.0/9.0,  8.0/9.0,   -4.0/9.0, -2.0/9.0,  8.0/9.0,
    -2.0/9.0, -2.0/9.0,  8.0/9.0,        0.0, -2.0/9.0,  8.0/9.0,    2.0/9.0, -2.0/9.0,  8.0/9.0,
     4.0/9.0, -2.0/9.0,  8.0/9.0,    6.0/9.0, -2.0/9.0,  8.0/9.0,    8.0/9.0, -2.0/9.0,  8.0/9.0,
    -8.0/9.0,      0.0,  8.0/9.0,   -6.0/9.0,      0.0,  8.0/9.0,   -4.0/9.0,      0.0,  8.0/9.0,
    -2.0/9.0,      0.0,  8.0/9.0,        0.0,      0.0,  8.0/9.0,    2.0/9.0,      0.0,  8.0/9.0,
     4.0/9.0,      0.0,  8.0/9.0,    6.0/9.0,      0.0,  8.0/9.0,    8.0/9.0,      0.0,  8.0/9.0,
    -8.0/9.0,  2.0/9.0,  8.0/9.0,   -6.0/9.0,  2.0/9.0,  8.0/9.0,   -4.0/9.0,  2.0/9.0,  8.0/9.0,
    -2.0/9.0,  2.0/9.0,  8.0/9.0,        0.0,  2.0/9.0,  8.0/9.0,    2.0/9.0,  2.0/9.0,  8.0/9.0,
     4.0/9.0,  2.0/9.0,  8.0/9.0,    6.0/9.0,  2.0/9.0,  8.0/9.0,    8.0/9.0,  2.0/9.0,  8.0/9.0,
    -8.0/9.0,  4.0/9.0,  8.0/9.0,   -6.0/9.0,  4.0/9.0,  8.0/9.0,   -4.0/9.0,  4.0/9.0,  8.0/9.0,
    -2.0/9.0,  4.0/9.0,  8.0/9.0,        0.0,  4.0/9.0,  8.0/9.0,    2.0/9.0,  4.0/9.0,  8.0/9.0,
     4.0/9.0,  4.0/9.0,  8.0/9.0,    6.0/9.0,  4.0/9.0,  8.0/9.0,    8.0/9.0,  4.0/9.0,  8.0/9.0,
    -8.0/9.0,  6.0/9.0,  8.0/9.0,   -6.0/9.0,  6.0/9.0,  8.0/9.0,   -4.0/9.0,  6.0/9.0,  8.0/9.0,
    -2.0/9.0,  6.0/9.0,  8.0/9.0,        0.0,  6.0/9.0,  8.0/9.0,    2.0/9.0,  6.0/9.0,  8.0/9.0,
     4.0/9.0,  6.0/9.0,  8.0/9.0,    6.0/9.0,  6.0/9.0,  8.0/9.0,    8.0/9.0,  6.0/9.0,  8.0/9.0,
    -8.0/9.0,  8.0/9.0,  8.0/9.0,   -6.0/9.0,  8.0/9.0,  8.0/9.0,   -4.0/9.0,  8.0/9.0,  8.0/9.0,
    -2.0/9.0,  8.0/9.0,  8.0/9.0,        0.0,  8.0/9.0,  8.0/9.0,    2.0/9.0,  8.0/9.0,  8.0/9.0,
     4.0/9.0,  8.0/9.0,  8.0/9.0,    6.0/9.0,  8.0/9.0,  8.0/9.0,    8.0/9.0,  8.0/9.0,  8.0/9.0);

  // data taken from ISO/IEC DIS 11172, Annexes 3-B.2[abcd] and 3-B.4:

  // subbands 0-2 in tables 3-B.2a and 2b: (index is allocation)
  // bits per codeword
  TableAB1CodeLength: array[0..15] of Cardinal = (
    0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);

  // pointer to sample grouping table, or NULL-pointer if ungrouped
  TableAB1GroupingTables: array[0..15] of PSingleArray = (
    nil, @Grouping5bits, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil);

  // factor for requantization: (real)sample * factor - 1.0 gives requantized sample
  TableAB1Factor: array[0..15] of Single = (
    0.0, 1.0/2.0, 1.0/4.0, 1.0/8.0, 1.0/16.0, 1.0/32.0, 1.0/64.0,
    1.0/128.0, 1.0/256.0, 1.0/512.0, 1.0/1024.0, 1.0/2048.0,
    1.0/4096.0, 1.0/8192.0, 1.0/16384.0, 1.0/32768.0);

  // factor c for requantization from table 3-B.4
  TableAB1C: array[0..15] of Single = (
    0.0,           1.33333333333, 1.14285714286, 1.06666666666, 1.03225806452,
    1.01587301587, 1.00787401575, 1.00392156863, 1.00195694716, 1.00097751711,
    1.00048851979, 1.00024420024, 1.00012208522, 1.00006103888, 1.00003051851,
    1.00001525902);

  // addend d for requantization from table 3-B.4
  TableAB1D: array[0..15] of Single = (
    0.0,           0.50000000000, 0.25000000000, 0.12500000000, 0.06250000000,
    0.03125000000, 0.01562500000, 0.00781250000, 0.00390625000, 0.00195312500,
    0.00097656250, 0.00048828125, 0.00024414063, 0.00012207031, 0.00006103516,
    0.00003051758);

  // subbands 3-... tables 3-B.2a and 2b:
  TableAB234GroupingTables: array[0..15] of PSingleArray = (
    nil, @Grouping5Bits, @Grouping7Bits, nil, @Grouping10Bits, nil, nil, nil,
    nil, nil, nil, nil, nil, nil, nil, nil);

  // subbands 3-10 in tables 3-B.2a and 2b:
  TableAB2CodeLength: array[0..15] of Cardinal = (
    0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16);

  TableAB2Factor: array[0..15] of Single = (
    0.0, 1.0/2.0, 1.0/4.0, 1.0/4.0, 1.0/8.0, 1.0/8.0, 1.0/16.0,
    1.0/32.0, 1.0/64.0, 1.0/128.0, 1.0/256.0, 1.0/512.0,
    1.0/1024.0, 1.0/2048.0, 1.0/4096.0, 1.0/32768.0);

  TableAB2C: array[0..15] of Single = (
    0.0,           1.33333333333, 1.60000000000, 1.14285714286, 1.77777777777,
    1.06666666666, 1.03225806452, 1.01587301587, 1.00787401575, 1.00392156863,
    1.00195694716, 1.00097751711, 1.00048851979, 1.00024420024, 1.00012208522,
    1.00001525902);

  TableAB2D: array[0..15] of Single = (
    0.0,           0.50000000000, 0.50000000000, 0.25000000000, 0.50000000000,
    0.12500000000, 0.06250000000, 0.03125000000, 0.01562500000, 0.00781250000,
    0.00390625000, 0.00195312500, 0.00097656250, 0.00048828125, 0.00024414063,
    0.00003051758);

  // subbands 11-22 in tables 3-B.2a and 2b:
  TableAB3CodeLength: array[0..7] of Cardinal = (
    0, 5, 7, 3, 10, 4, 5, 16);

  TableAB3Factor: array[0..7] of Single = (
    0.0, 1.0/2.0, 1.0/4.0, 1.0/4.0, 1.0/8.0, 1.0/8.0, 1.0/16.0, 1.0/32768.0);

  TableAB3C: array[0..7] of Single = (
    0.0,           1.33333333333, 1.60000000000, 1.14285714286, 1.77777777777,
    1.06666666666, 1.03225806452, 1.00001525902);

  TableAB3D: array[0..7] of Single = (
    0.0,           0.50000000000, 0.50000000000, 0.25000000000, 0.50000000000,
    0.12500000000, 0.06250000000, 0.00003051758);

  // subbands 23-... in tables 3-B.2a and 2b:
  TableAB4CodeLength: array[0..3] of Cardinal = (
    0, 5, 7, 16);

  TableAB4Factor: array[0..3] of Single = (
    0.0, 1.0/2.0, 1.0/4.0, 1.0/32768.0);

  TableAB4C: array[0..3] of Single = (
    0.0, 1.33333333333, 1.60000000000, 1.00001525902);

  TableAB4D: array[0..3] of Single = (
    0.0, 0.50000000000, 0.50000000000, 0.00003051758);

  // subbands in tables 3-B.2c and 2d:
  TableCDCodeLength: array[0..15] of Cardinal = (
    0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

  TableCDGroupingTables: array[0..15] of PSingleArray = (
    nil, @Grouping5Bits, @Grouping7Bits, @Grouping10Bits, nil, nil, nil, nil,
    nil, nil, nil, nil, nil, nil, nil, nil);

  TableCDFactor: array[0..15] of Single = (
    0.0, 1.0/2.0, 1.0/4.0, 1.0/8.0, 1.0/8.0, 1.0/16.0, 1.0/32.0, 1.0/64.0,
    1.0/128.0, 1.0/256.0, 1.0/512.0, 1.0/1024.0, 1.0/2048.0, 1.0/4096.0,
    1.0/8192.0, 1.0/16384.0);

  TableCDC: array[0..15] of Single = (
    0.0,           1.33333333333, 1.60000000000, 1.77777777777, 1.06666666666,
    1.03225806452, 1.01587301587, 1.00787401575, 1.00392156863, 1.00195694716,
    1.00097751711, 1.00048851979, 1.00024420024, 1.00012208522, 1.00006103888,
    1.00003051851);

  TableCDD: array[0..15] of Single = (
    0.0,           0.50000000000, 0.50000000000, 0.50000000000, 0.12500000000,
    0.06250000000, 0.03125000000, 0.01562500000, 0.00781250000, 0.00390625000,
    0.00195312500, 0.00097656250, 0.00048828125, 0.00024414063, 0.00012207031,
    0.00006103516);

{ TSubBandLayer2 }

//==============================================================================
//
// TSubBandLayer2.Create
//
//==============================================================================
constructor TSubBandLayer2.Create(SubBandNumber: Cardinal);
begin
  FSubBandNumber := SubBandNumber;
  FGroupNumber := 0;
  FSampleNumber := 0;
end;

//==============================================================================
//
// TSubBandLayer2.GetAllocationLength
//
//==============================================================================
function TSubBandLayer2.GetAllocationLength(Header: THeader): Cardinal;
var
  ChannelBitrate: Cardinal;
begin
  if Header.Version = MPEG1 then
  begin
    ChannelBitrate := Header.BitrateIndex;

    // calculate bitrate per channel:
    if Header.Mode <> SingleChannel then
      if ChannelBitrate = 4 then
        ChannelBitrate := 1
      else
        dec(ChannelBitrate, 4);

    if (ChannelBitrate = 1) or (ChannelBitrate = 2) then
    begin
      // table 3-B.2c or 3-B.2d
      if FSubBandNumber <= 1 then
        result := 4
      else
        result := 3;

      exit;
    end
    else
    begin
      // tables 3-B.2a or 3-B.2b
      if FSubBandNumber <= 10 then
        result := 4
      else if FSubBandNumber <= 22 then
        result := 3
      else
        result := 2;

      exit;
    end;
  end
  else
  begin  // MPEG-2 LSF -- Jeff
    // table B.1 of ISO/IEC 13818-3
    if FSubBandNumber <= 3 then
      result := 4
    else if FSubBandNumber <= 10 then
      result := 3
    else
      result := 2;

    exit;
  end;
end;

//==============================================================================
//
// TSubBandLayer2.PrepareSampleReading
//
//==============================================================================
procedure TSubBandLayer2.PrepareSampleReading(Header: THeader; Allocation: Cardinal;
  var GroupingTable: PSingleArray; var Factor: Single; var CodeLength: Cardinal; var C,
  D: Single);
var
  ChannelBitrate: Cardinal;
begin
  ChannelBitrate := Header.BitrateIndex;

  // calculate bitrate per channel:
  if Header.Mode <> SingleChannel then
    if ChannelBitrate = 4 then
      ChannelBitrate := 1
    else
      dec(ChannelBitrate, 4);

  if (ChannelBitrate = 1) or (ChannelBitrate = 2) then
  begin
    // table 3-B.2c or 3-B.2d
    GroupingTable := TableCDGroupingtables[Allocation];
    Factor := TableCDFactor[Allocation];
    CodeLength := TableCDCodelength[Allocation];
    C := TableCDC[Allocation];
    D := TableCDD[Allocation];
  end
  else
  begin
    // tables 3-B.2a or 3-B.2b
    if (FSubBandNumber <= 2) then
    begin
      Groupingtable := TableAB1GroupingTables[Allocation];
      Factor := TableAB1Factor[Allocation];
      CodeLength := TableAB1CodeLength[Allocation];
      C := TableAB1C[Allocation];
      D := TableAB1D[Allocation];
    end
    else
    begin
      GroupingTable := TableAB234GroupingTables[Allocation];
      if FSubBandNumber <= 10 then
      begin
        Factor := TableAB2Factor[Allocation];
        CodeLength := TableAB2CodeLength[Allocation];
        C := TableAB2C[Allocation];
        D := TableAB2D[Allocation];
      end
      else if (FSubBandNumber <= 22) then
      begin
        Factor := TableAB3Factor[Allocation];
        CodeLength := TableAB3CodeLength[Allocation];
        C := TableAB3C[Allocation];
        D := TableAB3D[Allocation];
      end
      else
      begin
        Factor := TableAB4Factor[Allocation];
        CodeLength := TableAB4CodeLength[Allocation];
        C := TableAB4C[Allocation];
        D := TableAB4D[Allocation];
      end;
    end;
  end;
end;

//==============================================================================
//
// TSubBandLayer2.PutNextSample
//
//==============================================================================
function TSubBandLayer2.PutNextSample(Channels: TChannels; Filter1,
  Filter2: TSynthesisFilter): boolean;
var Sample: Single;
begin
  if (FAllocation <> 0) and (Channels <> Right) then
  begin
    Sample := FSamples[FSampleNumber];

    if (FGroupingTable = nil) then
      Sample := (Sample + FD) * FC;

    if (FGroupNumber <= 4) then
      Sample := Sample * FScaleFactor1
    else if (FGroupNumber <= 8) then
      Sample := Sample * FScaleFactor2
    else
      Sample := Sample * FScaleFactor3;

    Filter1.InputSample(Sample, FSubBandNumber);
  end;

  inc(FSampleNumber);
  result := FSampleNumber = 3;
end;

//==============================================================================
//
// TSubBandLayer2.ReadAllocation
//
//==============================================================================
procedure TSubBandLayer2.ReadAllocation(Stream: TBitStream;
  Header: THeader; CRC: TCRC16);
var Length: Cardinal;
begin
  Length := GetAllocationLength(Header);
  FAllocation := Stream.GetBits(Length);
  if CRC <> nil then
    CRC.AddBits(FAllocation, Length);
end;

//==============================================================================
//
// TSubBandLayer2.ReadSampleData
//
//==============================================================================
function TSubBandLayer2.ReadSampleData(Stream: TBitStream): boolean;
var SampleCode: Cardinal;
begin
  if FAllocation <> 0 then
    if FGroupingTable <> nil then
    begin
      SampleCode := Stream.GetBits(FCodeLength);
      // create requantized samples:
      inc(SampleCode, SampleCode shl 1);
      FSamples[0] := FGroupingTable[SampleCode];
      FSamples[1] := FGroupingTable[SampleCode+1];
      FSamples[2] := FGroupingTable[SampleCode+2];
    end
    else
    begin
      FSamples[0] := Stream.GetBits(FCodeLength) * FFactor - 1.0;
      FSamples[1] := Stream.GetBits(FCodeLength) * FFactor - 1.0;
      FSamples[2] := Stream.GetBits(FCodeLength) * FFactor - 1.0;
    end;

  FSampleNumber := 0;
  inc(FGroupNumber);
  result := FGroupnumber = 12;
end;

//==============================================================================
//
// TSubBandLayer2.ReadScaleFactor
//
//==============================================================================
procedure TSubBandLayer2.ReadScaleFactor(Stream: TBitStream;
  Header: THeader);
begin
  if FAllocation <> 0 then
  begin
    case FSCFSI of
      0:
        begin
          FScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FScaleFactor2 := ScaleFactors[Stream.GetBits(6)];
          FScaleFactor3 := ScaleFactors[Stream.GetBits(6)];
        end;

      1:
        begin
          FScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FScaleFactor2 := FScaleFactor1;
          FScaleFactor3 := ScaleFactors[Stream.GetBits(6)];
        end;

      2:
        begin
          FScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FScaleFactor2 := FScaleFactor1;
          FScaleFactor3 := FScaleFactor1;
        end;

      3:
        begin
          FScaleFactor1 := Scalefactors[Stream.GetBits(6)];
          FScaleFactor2 := ScaleFactors[Stream.GetBits(6)];
          FScaleFactor3 := FScaleFactor2;
        end;
    end;

    PrepareSampleReading(Header, FAllocation, FGroupingtable, FFactor, FCodeLength, FC, FD);
  end;
end;

//==============================================================================
//
// TSubBandLayer2.ReadScaleFactorSelection
//
//==============================================================================
procedure TSubBandLayer2.ReadScaleFactorSelection(Stream: TBitStream; CRC: TCRC16);
begin
  if FAllocation <> 0 then
  begin
    FSCFSI := Stream.GetBits(2);
    if (CRC <> nil) then
      CRC.AddBits(FSCFSI, 2);
  end;
end;

{ TSubbandLayer2IntensityStereo }

//==============================================================================
//
// TSubbandLayer2IntensityStereo.PutNextSample
//
//==============================================================================
function TSubbandLayer2IntensityStereo.PutNextSample(Channels: TChannels;
  Filter1, Filter2: TSynthesisFilter): boolean;
var
  Sample, Sample2: Single;
begin
  if (FAllocation <> 0) then
  begin
    Sample := FSamples[FSampleNumber];

    if (FGroupingTable = nil) then
      Sample := (Sample + FD) * FC;

    if Channels = Both then
    begin
      Sample2 := Sample;
      if FGroupNumber <= 4 then
      begin
        Sample := Sample * FScaleFactor1;
        Sample2 := Sample2 * FChannel2ScaleFactor1;
      end
      else if (FGroupNumber <= 8) then
      begin
        Sample := Sample * FScaleFactor2;
        Sample2 := Sample2 * FChannel2ScaleFactor2;
      end
      else
      begin
        Sample := Sample * FScaleFactor3;
        Sample2 := Sample2 * FChannel2ScaleFactor3;
      end;

      Filter1.InputSample(Sample, FSubBandNumber);
      Filter2.InputSample(Sample2, FSubBandNumber);
    end
    else if Channels = Left then
    begin
      if FGroupNumber <= 4 then
        Sample := Sample * FScaleFactor1
      else if FGroupNumber <= 8 then
        Sample := Sample * FScaleFactor2
      else
        Sample := Sample * FScaleFactor3;

      Filter1.InputSample(Sample, FSubBandNumber);
    end
    else
    begin
      if FGroupNumber <= 4 then
        Sample := Sample * FChannel2ScaleFactor1
      else if FGroupNumber <= 8 then
        Sample := Sample * FChannel2ScaleFactor2
      else
        Sample := Sample * FChannel2ScaleFactor3;

      Filter1.InputSample(Sample, FSubBandNumber);
    end;
  end;

  inc(FSampleNumber);
  result := FSampleNumber = 3;
end;

//==============================================================================
//
// TSubbandLayer2IntensityStereo.ReadScaleFactor
//
//==============================================================================
procedure TSubbandLayer2IntensityStereo.ReadScaleFactor(Stream: TBitStream;
  Header: THeader);
begin
  if FAllocation <> 0 then
  begin
    inherited ReadScaleFactor(Stream, Header);

    case FChannel2SCFSI of
      0:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor3 := ScaleFactors[Stream.GetBits(6)];
        end;

      1:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := FChannel2ScaleFactor1;
          FChannel2ScaleFactor3 := ScaleFactors[Stream.GetBits(6)];
        end;

      2:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := FChannel2ScaleFactor1;
          FChannel2ScaleFactor3 := FChannel2ScaleFactor1;
        end;

      3:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor3 := FChannel2ScaleFactor2;
        end;
    end;
  end;
end;

procedure TSubbandLayer2IntensityStereo.ReadScaleFactorSelection(
  Stream: TBitStream; CRC: TCRC16);
begin
  if FAllocation <> 0 then
  begin
    FSCFSI := Stream.GetBits(2);
    FChannel2SCFSI := Stream.GetBits(2);
    if (CRC <> nil) then
    begin
      CRC.AddBits(FSCFSI, 2);
      CRC.AddBits(FChannel2SCFSI, 2);
    end;
  end;
end;

{ TSubbandLayer2Stereo }

//==============================================================================
//
// TSubbandLayer2Stereo.PutNextSample
//
//==============================================================================
function TSubbandLayer2Stereo.PutNextSample(Channels: TChannels; Filter1,
  Filter2: TSynthesisFilter): boolean;
var
  Sample: Single;
begin
  result := inherited PutNextSample(Channels, Filter1, Filter2);

  if (FChannel2Allocation <> 0) and (Channels <> Left) then
  begin
    Sample := FChannel2Samples[FSampleNumber - 1];

    if (FChannel2GroupingTable = nil) then
      Sample := (Sample + FChannel2D) * FChannel2C;

    if (FGroupNumber <= 4) then
      Sample := Sample * FChannel2ScaleFactor1
    else if (FGroupNumber <= 8) then
      Sample := Sample * FChannel2ScaleFactor2
    else
      Sample := Sample * FChannel2ScaleFactor3;

    if (Channels = Both) then
      Filter2.InputSample(Sample, FSubBandNumber)
    else
      Filter1.InputSample(Sample, FSubBandNumber);
  end;
end;

//==============================================================================
//
// TSubbandLayer2Stereo.ReadAllocation
//
//==============================================================================
procedure TSubbandLayer2Stereo.ReadAllocation(Stream: TBitStream;
  Header: THeader; CRC: TCRC16);
var
  Length: Cardinal;
begin
  Length := GetAllocationLength(Header);
  FAllocation := Stream.GetBits(Length);
  FChannel2Allocation := Stream.GetBits(Length);
  if (CRC <> nil) then
  begin
    CRC.AddBits(FAllocation, Length);
    CRC.AddBits(FChannel2Allocation, Length);
  end;
end;

//==============================================================================
//
// TSubbandLayer2Stereo.ReadSampleData
//
//==============================================================================
function TSubbandLayer2Stereo.ReadSampleData(Stream: TBitStream): boolean;
var
  SampleCode: Cardinal;
begin
  result := inherited ReadSampleData(Stream);

  if (FChannel2Allocation <> 0) then
    if (FChannel2GroupingTable <> nil) then
    begin
      SampleCode := Stream.GetBits(FChannel2CodeLength);
      // create requantized samples:
      inc(SampleCode, SampleCode shl 1);
      FChannel2Samples[0] := FChannel2GroupingTable[SampleCode];
      FChannel2Samples[1] := FChannel2GroupingTable[SampleCode+1];
      FChannel2Samples[2] := FChannel2GroupingTable[SampleCode+2];
    end
    else
    begin
      FChannel2Samples[0] := Stream.GetBits(FChannel2CodeLength) * FChannel2Factor - 1.0;
      FChannel2Samples[1] := Stream.GetBits(FChannel2CodeLength) * FChannel2Factor - 1.0;
      FChannel2Samples[2] := Stream.GetBits(FChannel2CodeLength) * FChannel2Factor - 1.0;
    end;
end;

//==============================================================================
//
// TSubbandLayer2Stereo.ReadScaleFactor
//
//==============================================================================
procedure TSubbandLayer2Stereo.ReadScaleFactor(Stream: TBitStream;
  Header: THeader);
begin
  inherited ReadScaleFactor(Stream, Header);

  if FChannel2Allocation <> 0 then
  begin
    case FChannel2SCFSI of
      0:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor3 := ScaleFactors[Stream.GetBits(6)];
        end;

      1:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := FChannel2ScaleFactor1;
          FChannel2ScaleFactor3 := ScaleFactors[Stream.GetBits(6)];
        end;

      2:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := FChannel2ScaleFactor1;
          FChannel2ScaleFactor3 := FChannel2ScaleFactor1;
        end;

      3:
        begin
          FChannel2ScaleFactor1 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor2 := ScaleFactors[Stream.GetBits(6)];
          FChannel2ScaleFactor3 := FChannel2ScaleFactor2;
        end;
    end;

    PrepareSampleReading(Header, FChannel2Allocation, FChannel2GroupingTable,
                         FChannel2Factor, FChannel2CodeLength, FChannel2C, FChannel2D);
  end;
end;

//==============================================================================
//
// TSubbandLayer2Stereo.ReadScaleFactorSelection
//
//==============================================================================
procedure TSubbandLayer2Stereo.ReadScaleFactorSelection(Stream: TBitStream;
  CRC: TCRC16);
begin
  if FAllocation <> 0 then
  begin
    FSCFSI := Stream.GetBits(2);
    if CRC <> nil then
      CRC.AddBits(FSCFSI, 2);
  end;

  if FChannel2Allocation <> 0 then
  begin
    FChannel2SCFSI := Stream.GetBits(2);
    if CRC <> nil then
      CRC.AddBits(FChannel2SCFSI, 2);
  end;
end;

end.
