//
//  Speed
//  Engine remake of the game "Speed Haste" based on the DelphiDoom engine
//
//  Copyright (C) 1995 by Noriaworks
//  Copyright (C) 1993-1996 by id Software, Inc.
//  Copyright (C) 2004-2021 by Jim Valavanis
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, inc., 59 Temple Place - Suite 330, Boston, MA
//  02111-1307, USA.
//
//------------------------------------------------------------------------------
//  Site  : https://sourceforge.net/projects/speed-game/
//------------------------------------------------------------------------------

{$I speed.inc}

(*
 *  File:     $RCSfile: SubBand.pas,v $
 *  Revision: $Revision: 1.1.1.1 $
 *  Version : $Id: SubBand.pas,v 1.1.1.1 2002/04/21 12:57:22 fobmagog Exp $
 *  Author:   $Author: fobmagog $
//  Site  : https://sourceforge.net/projects/speed-game/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)
unit mp3_SubBand;

interface
uses
  Windows, mp3_BitStream, mp3_Header, mp3_CRC, mp3_SynthFilter, mp3_Shared;

type
  TSubBand = class
  public
    procedure ReadAllocation(Stream: TBitStream; Header: THeader; CRC: TCRC16); virtual; abstract;
    procedure ReadScaleFactor(Stream: TBitStream; Header: THeader); virtual; abstract;
    function ReadSampleData(Stream: TBitStream): Boolean; virtual; abstract;
    function PutNextSample(Channels: TChannels; Filter1, Filter2: TSynthesisFilter): Boolean; virtual; abstract;
  end;

implementation

end.
