'use strict'
const path = require('path')
const utils = require('./utils')
const config = require('../config')
const vueLoaderConfig = require('./vue-loader.conf')
const fs = require('fs')

function resolve (dir) {
  return path.join(__dirname, '..', dir)
}

// 纠正favicon路径
function correctFaviconDir(spa) {
  let html = fs.readFileSync(resolve('index.html')).toString()
  let correctHtml = html.replace(/\/([a-zA-Z]+)\/favicon.ico/, `/${spa}/favicon.ico`)
  fs.writeFileSync(resolve('index.html'), correctHtml)
}

let currentSpa = 'fed';
//配置prod编译产出的SPA页面根目录
config.build.assetsSubDirectory = currentSpa;
//配置prod编译产出的SPA页面的html
config.build.index = path.resolve(__dirname, `../dist/${currentSpa}/index.html`)
correctFaviconDir(currentSpa)


module.exports = {
  context: path.resolve(__dirname, '../'),
  entry: {
    app: `./src/${currentSpa}`
  },
  output: {
    path: config.build.assetsRoot,
    filename: '[name].js',
    publicPath: process.env.NODE_ENV === 'production'
      ? config.build.assetsPublicPath
      : config.dev.assetsPublicPath
  },
  resolve: {
    extensions: ['.js', '.vue', '.json'],
    alias: {
      'vue$': 'vue/dist/vue.esm.js',
      '@': resolve('src'),
    }
  },
  module: {
    rules: [
      {
        test: /\.vue$/,
        loader: 'vue-loader',
        options: vueLoaderConfig
      },
      {
        test: /\.js$/,
        loader: 'babel-loader',
        include: [resolve('src'), resolve('test')]
      },
      {
        test: /\.(png|jpe?g|gif|svg)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: utils.assetsPath('img/[name].[hash:7].[ext]')
        }
      },
      {
        test: /\.(mp4|webm|ogg|mp3|wav|flac|aac)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: utils.assetsPath('media/[name].[hash:7].[ext]')
        }
      },
      {
        test: /\.(woff2?|eot|ttf|otf)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: utils.assetsPath('fonts/[name].[hash:7].[ext]')
        }
      }
    ]
  },
  node: {
    // prevent webpack from injecting useless setImmediate polyfill because Vue
    // source contains it (although only uses it if it's native).
    setImmediate: false,
    // prevent webpack from injecting mocks to Node native modules
    // that does not make sense for the client
    dgram: 'empty',
    fs: 'empty',
    net: 'empty',
    tls: 'empty',
    child_process: 'empty'
  }
}
