clear all
clc
close all
I = imread('catalunya_no_coords.jpg');

%u_phi = ([3657,82]-[966,1745]); u_phi = u_phi/norm(u_phi);
u_phi = ([3656,81]-[966,1745]); u_phi = u_phi/norm(u_phi);
%u_theta = ([3018,2062]-[1833,145]); u_theta = u_theta/norm(u_theta);
u_theta = ([3018,2062]-[1833,145]); u_theta = u_theta/norm(u_theta);
% Let's take the average of both and make them exactly normal
u_phi = (u_phi + [u_theta(2),-u_theta(1)]); u_phi = u_phi/norm(u_phi);
u_theta = [-u_phi(2), u_phi(1)];

% The vectors need magnitude, get some points
theta0 = 2.2572;
theta1 = 2.2608;
phi0 = 41.5692;
phi1 = 41.5728;

ij0 = [2309,915];
ij_theta1 = [2850, 1791];
ij_phi1 = [3480,191];

norm_theta = norm(ij0-ij_theta1)/(theta1-theta0);
norm_phi = norm(ij0-ij_phi1)/(phi1-phi0);

p = ij0 + norm_theta*u_theta*(theta1-theta0) + norm_phi*u_phi*(phi1-phi0);

A = [norm_theta*u_theta', norm_phi*u_phi'];
M = inv(A);

theta_phi = @(i,j)([theta0;phi0] + M*[i-ij0(2);j-ij0(1)]);
f_ij = @(theta,phi)(ij0' + A*[theta-theta0;phi-phi0]);
% Sanity: for every (i,j), compute its (x,y) using the projection
R_earth = 400/deg2rad(phi1-phi0);
phi_ref = acosd(3/4);

pos = zeros(2,size(I,1),size(I,2));
for i = 1 : size(I,1)
    for j = 1 : size(I,2)
        theta_phi_p = theta_phi(i,j);
        pos(:,i,j) = u_theta*R_earth*cosd(phi_ref)*deg2rad(theta_phi_p(1)-theta0) + u_phi*R_earth*deg2rad(theta_phi_p(2)-phi0);
    end
end

x_range = [min(min(pos(1,:,:))), max(max(pos(1,:,:)))];
y_range = [min(min(pos(2,:,:))), max(max(pos(2,:,:)))];


RI = imref2d(size(I)); RI.XWorldLimits = y_range; RI.YWorldLimits = x_range;
h = figure;
imshow(I,RI)
h.CurrentAxes.Visible='on';


r_left_raw = [2.263191084528997,41.57226534463398,0 2.261858682095013,41.57067785590088,0 2.261280040451652,41.56998979678787,0 2.26115243552063,41.56983828053116,0 2.260641410248212,41.56922907647799,0 2.259968291386663,41.56842970357956,0 2.259206955737258,41.56752292148887,0 2.258366952847413,41.56652473970811,0 2.258299952818328,41.5664314493111,0 2.258255834445473,41.56637807246146,0 2.258209636462014,41.56632297448112,0 2.25812464071995,41.56622000604911,0 2.258049811203307,41.56613069796899,0 2.257908896366567,41.56596370123918,0 2.257802288139561,41.56583636981468,0 2.257163638838617,41.56507888424174,0 2.256943051006037,41.56481661119523,0 2.25689363881368,41.56476660439295,0 2.256830359841817,41.56470842593133,0 2.256763424138637,41.56466362452408,0 2.256681143152952,41.56462339822687,0 2.256630154634065,41.56460558509735,0 2.256497529031924,41.56457836725838,0 2.256371847800802,41.56457561522576,0 2.256236861445029,41.56459743035763,0 2.25617293275117,41.56461605494053,0 2.256043902790235,41.56467173510961,0 2.255930801472223,41.56472634818926,0 2.255865554674599,41.56475594901539,0 2.255816254591883,41.56477747498064,0 2.255743019116678,41.56480449080685,0 2.255653549956398,41.56482667051866,0 2.255599773703307,41.56483392257497,0 2.255530538791963,41.56483900606408,0 2.255487303591663,41.56483925037629,0 2.255486793741182,41.56483980282717,0 2.255437326774319,41.56483793249048,0 2.255381139497707,41.56483278433223,0 2.255330252378509,41.56482435978143,0 2.255274607093909,41.56481110956565,0 2.255231188932443,41.56479842632228,0 2.255178868204732,41.56477802573372,0 2.255121852655251,41.56475159385561,0 2.255051944800566,41.56471693616822,0 2.254979525989298,41.56468051817723,0 2.254750768541474,41.56455533167388,0 2.254354747514222,41.56433902112442,0 2.254227389210699,41.56427745471959,0 2.254067890616027,41.56421948914046,0 2.25395021805699,41.56418608450277,0 2.253820736321357,41.56416090016388,0 2.253712640548224,41.56414755978206,0 2.253558267250639,41.56413813778771,0 2.25342749583832,41.56414284070789,0 2.25332102850601,41.5641525768332,0 2.253196811999909,41.56417113037814,0 2.253101379084019,41.56419284056748,0 2.253015041599298,41.56421686783428,0 2.252929019224255,41.56424530732235,0 2.252855411731214,41.56427422880086,0 2.252778563429472,41.56430968623476,0 2.252706051031625,41.56434605401589,0 2.252619444770223,41.56439837752247,0 2.252547690856213,41.56444949167369,0 2.252505451461571,41.56448222626784,0 2.252457542044757,41.56452427828935,0 2.252412627290181,41.56456751819752,0 2.25237875848562,41.56460355791901,0 2.252346081554499,41.56464109309464,0 2.252313869172258,41.564681003701,0 2.252274544363628,41.56473626131098,0 2.252238022070998,41.56479203096889,0 2.252200883348141,41.56485609540982,0 2.252166500342618,41.56492722327798,0 2.252127866487164,41.56502668650016,0 2.252102845830717,41.56511501474237,0 2.252092181291345,41.56516977446594,0 2.252082902760821,41.56523323353418,0 2.252076322696368,41.5653345884209,0 2.252079226079922,41.5654720437656,0 2.252088408727844,41.56556586840701,0 2.252103039352855,41.56565936729349,0 2.252102586949001,41.56565944701614,0 2.252125756101917,41.56576415093079,0 2.252147065038173,41.56584414107481,0 2.252177819714858,41.56593353059321,0 2.252215340603134,41.56602822200969,0 2.252276437115603,41.56615988402449,0 2.252325511213269,41.56624955474567,0 2.252377482845866,41.56633230228006,0 2.252438593362074,41.56641824498974,0 2.252535992545832,41.56654241930927,0 2.252614321222217,41.56664215848981,0 2.252667349652544,41.56671298772855,0 2.252717344990334,41.5667728301929,0 2.253097650878455,41.56722599750143,0 2.253770846824583,41.56802649109315,0 2.253842164132462,41.56811072211566,0 2.25392237342477,41.56819351419883,0 2.25398032756148,41.56826065265797,0 2.254041948669876,41.5683169990378,0 2.254089580068621,41.56835363397352,0 2.254153910430099,41.56839205125399,0 2.254213488992902,41.56842019299405,0 2.254278099425147,41.56844382676115,0 2.254359268632442,41.56846502579794,0 2.254433234939821,41.56847817240903,0 2.254525998099954,41.56848784741052,0 2.254613813205502,41.56848869460422,0 2.254684159842038,41.5684842888639,0 2.254743364849174,41.56847466696878,0 2.254799912568062,41.56846234491834,0 2.254850583644497,41.56844722775471,0 2.254893275453804,41.56843233424949,0 2.254959517317359,41.56840526323727,0 2.255023091332611,41.56837291275421,0 2.2550672899466,41.56834684775468,0 2.255114714526403,41.5683152558226,0 2.255167546360211,41.56827612217566,0 2.255200975926526,41.56824833504396,0 2.255242986104462,41.56820753735988,0 2.255287989443477,41.56815806761303,0 2.255323845754278,41.56811091631604,0 2.255362068702964,41.56805172538249,0 2.255394410937595,41.56798573227126,0 2.255419364282765,41.567917128389,0 2.255434786842974,41.56785428818612,0 2.255445535628675,41.56778289191389,0 2.25545278638569,41.5677057643674,0 2.25545257926445,41.56765233421015,0 2.25544887794404,41.56758294151838,0 2.25543562112178,41.56750650059848,0 2.255415191223267,41.56743207267934,0 2.255389689400733,41.56735847536323,0 2.255349193673262,41.56726481921423,0 2.255312109015017,41.56719268299187,0 2.255285005950245,41.56714983323589,0 2.255194351262488,41.56703733679498,0 2.254916758019656,41.56670747530515,0 2.254824651561336,41.566613443953,0 2.254746485174732,41.56652162366883,0 2.254417529281108,41.566131519212,0 2.254312557529576,41.56600497879486,0 2.254198945383765,41.56587282107311,0 2.254167053450551,41.56583562738152,0 2.254142357926185,41.56580368626997,0 2.254121380480485,41.56577602375372,0 2.254099595115093,41.56574590735503,0 2.254081663222822,41.56571641171127,0 2.254072577344313,41.56569622458681,0 2.254065815675947,41.5656752684181,0 2.254059352695337,41.5656427187959,0 2.254059413676737,41.56561654315418,0 2.254063850665933,41.56558345426032,0 2.254072498184774,41.56555196878697,0 2.25408426690809,41.56552870328382,0 2.25409647657193,41.56550876797517,0 2.25411385008192,41.56548682514054,0 2.254134680910822,41.56546499927833,0 2.254164115050548,41.56544292333014,0 2.254202502123168,41.56541896880204,0 2.254235140033622,41.56540254819837,0 2.2542684036544,41.56538925734137,0 2.254299983164247,41.56538070723991,0 2.254342153151649,41.56537310198642,0 2.254382855267627,41.56536974978142,0 2.254433666156344,41.56536946329006,0 2.254495036417736,41.56537604974429,0 2.254544929519127,41.56538915422668,0 2.25460769216103,41.56540195817746,0 2.25468547316215,41.56542781699908,0 2.254905585185238,41.56550091793949,0 2.255080141961991,41.56555923861231,0 2.256041646775759,41.56588114334102,0 2.256164268895817,41.56593121589824,0 2.25621855181148,41.56595429779618,0 2.256357794231953,41.56601931701685,0 2.256462521285962,41.56607297667876,0 2.256624700009873,41.56617108992574,0 2.256743450960166,41.5662548116717,0 2.2568771697086,41.56636177249777,0 2.256974707598705,41.56645015784037,0 2.257050895876871,41.56652574953814,0 2.257175625098762,41.56666818481113,0 2.257571232104176,41.56712697365676,0 2.257617894344248,41.5671954023286,0 2.257667378696564,41.56726015781741,0 2.257693309771851,41.56730392765134,0 2.257708778488818,41.56734999848812,0 2.257715648799559,41.56738962543418,0 2.257714071040655,41.56742967389746,0 2.257703822320503,41.56747166978421,0 2.257689880575005,41.56750815078953,0 2.257667298995878,41.56754489307555,0 2.257636997596268,41.56758198276485,0 2.257604411274368,41.56761160787531,0 2.257576629092153,41.56763103029544,0 2.257544295550769,41.56765071443451,0 2.257514015460793,41.56766568164151,0 2.257474862264408,41.56768793736867,0 2.257439762018558,41.56770820663152,0 2.257392073108917,41.56772967023971,0 2.257249823466332,41.567794354403,0 2.257154067710827,41.56784546260144,0 2.257091337225801,41.56788550623376,0 2.25699083642414,41.56796472151803,0 2.256923221757074,41.56803006882599,0 2.256870320754896,41.56809102165456,0 2.256827030075175,41.56815421952723,0 2.256795613987843,41.56820598632058,0 2.256750312186613,41.56828414076333,0 2.256699998064184,41.56835721930209,0 2.256669428098745,41.56841323242931,0 2.256472746842064,41.56876245832389,0 2.25613863813904,41.56935298592366,0 2.256089177776115,41.56945852678744,0 2.256022573906655,41.56957185889652,0 2.255966173353368,41.56966599458778,0 2.255934845854033,41.56974223242568,0 2.255912881055053,41.56982014656896,0 2.25590453668258,41.56987352825276,0 2.255900560073858,41.56992924074247,0 2.255902622811958,41.56999213630315,0 2.255907296008108,41.57004487835406,0 2.255918378551851,41.57010254800338,0 2.255935427066831,41.57016279551923,0 2.255961571494274,41.57022897487838,0 2.255990416406672,41.57028426301709,0 2.256022567186731,41.57033614498167,0 2.256062866098938,41.57039018085938,0 2.256099583605233,41.5704330954889,0 2.256138003689987,41.57047391708264,0 2.256177315557748,41.57051047186213,0 2.25620952322654,41.57053803234224,0 2.25624520488181,41.5705650872469,0 2.256297942876582,41.57060240230941,0 2.25635198157262,41.57064015897702,0 2.256388921989825,41.57066623837248,0 2.256468729128642,41.57070707387068,0 2.256541621809613,41.5707400613075,0 2.256623344467594,41.57077275638257,0 2.256790624905476,41.57083766528914,0 2.256956445481966,41.57090112070557,0 2.257324325289323,41.57104370446633,0 2.257672419309491,41.57117720209422,0 2.2578783581642,41.57125616587359,0 2.258072071595336,41.57132065905547,0 2.258547398505308,41.57150158680566,0 2.259103914133829,41.57171295626421,0 2.260480297652647,41.57223939120485,0 2.261672191253783,41.57272969909032,0 2.261730036400635,41.57275399889689,0 2.261756631183092,41.57277008783795,0 2.261783551385999,41.57278800843928,0 2.261804600938639,41.57280578996397,0 2.26181937966788,41.57282579286565,0 2.26182771811809,41.57284492916573,0 2.261831907642937,41.57286757935073,0 2.261829887407578,41.57288816833582,0 2.261823657042554,41.5729050956654,0 2.261809934826851,41.57292545754088,0 2.261791457613591,41.57294397136508,0 2.261768602367695,41.57295769408044,0 2.261750670548746,41.57296642236838,0 2.261731445558406,41.57297139148707,0 2.261711548149126,41.57297721956996,0 2.261659275646699,41.57299156049103,0 2.261525607215875,41.57301350468831,0 2.260781412601203,41.57313846090571,0 2.260651055910341,41.57315520297942,0 2.260584257189526,41.57316529656848,0 2.260548281254315,41.57316695524913,0 2.26051002677663,41.57316697895383,0 2.260464280763472,41.57316140016166,0 2.260420959489904,41.5731516805412,0 2.260385494227477,41.57313989068585,0 2.260347833054996,41.57312308556093,0 2.260315794043792,41.57310444800062,0 2.260291130096328,41.57308866413725,0 2.260263716916622,41.57307115037271,0 2.26023185887128,41.57305160916693,0 2.260175077447617,41.57302045293895,0 2.260135958104412,41.57299817959017,0 2.260066633239204,41.57295588857914,0 2.260008719092506,41.57292295367814,0 2.259952649891444,41.57289581830896,0 2.259889428041288,41.57286953068941,0 2.25981950552715,41.57284762083856,0 2.259768175461792,41.57283562393972,0 2.259715306181378,41.57282603433262,0 2.259648214079943,41.57281860659787,0 2.259589351156248,41.57281661831026,0 2.259523036874163,41.57281753424819,0 2.259448913938613,41.57282287491926,0 2.259360841830507,41.57283722317753,0 2.259291697126984,41.57285359717026,0 2.259182464391027,41.57289302533788,0 2.259103431950116,41.57293246409071,0 2.259033558323251,41.57297748955387,0 2.258977690582258,41.5730223178818,0 2.258925449643583,41.57307553202705,0 2.258894238351532,41.57311601498292,0 2.258863971105862,41.57316255227646,0 2.258839209799497,41.57321397587687,0 2.25882131536804,41.5732649866533,0 2.258812023741272,41.57330490116967,0 2.258806990658162,41.57333746571621,0 2.258804303184718,41.57338321290272,0 2.258805419587249,41.57342672413571,0 2.258811237541327,41.57346682612926,0 2.258820591297557,41.57350878120207,0 2.258834208914651,41.57354744994686,0 2.258843012877809,41.57356827373642,0 2.258863670758955,41.57361000263706,0 2.25889159774262,41.57365557004581,0 2.258921830486569,41.57369513546752,0 2.258952563856897,41.5737349955076,0 2.258964597819464,41.57374933683649,0 2.25901189334434,41.57378627742104,0 2.259064961977348,41.57382123616981,0 2.259147021724646,41.57387332773174,0 2.259605129866666,41.57415586281472,0 2.260187865499854,41.57451664361825,0 2.260347874496866,41.5746050498383,0 2.260443142925692,41.57466134665471,0 2.260523641056953,41.57469989623406,0 2.260570696216022,41.5747146243316,0 2.260619515006572,41.57472433989651,0 2.260675488891,41.57472768983407,0 2.260717704987159,41.57472410530784,0 2.260764255442469,41.5747127982463,0 2.260797252898696,41.57469856824173,0 2.260837238737217,41.57468086744979,0 2.260875127259496,41.57466677762294,0 2.260911410314397,41.57464785273716,0 2.26097319475568,41.57461301776425,0 2.261048853348411,41.57457179246691,0 2.261119111789096,41.57453159799164,0 2.261412124555946,41.57436616534282,0 2.261439373235139,41.57434978193993,0 2.261565021021734,41.57427876680165,0 2.261617597934218,41.57423829345757,0 2.26178609988543,41.5741440088572,0 2.261841869556551,41.5741127470053,0 2.26186563413078,41.57410398187706,0 2.261892496482003,41.5740910067909,0 2.261911758932358,41.57408068726457,0 2.261922444036319,41.57407615071761,0 2.261932537775984,41.57407331849242,0 2.261943305165983,41.57407271385736,0 2.261956510201728,41.57407332575557,0 2.261966779752498,41.57407695735502,0 2.261978269953449,41.57408206899714,0 2.261991685950822,41.57409189048924,0 2.262005424298201,41.57410275017393,0 2.262020027827987,41.57411329070455,0 2.262045453451333,41.57412694133843,0 2.262072109759554,41.57414531046066,0 2.262127845155972,41.57419033492216,0 2.262226373005471,41.57426952050202,0 2.262253430188605,41.5742890665462,0 2.262282243247604,41.57430507646777,0 2.262322769004035,41.57431344946005,0 2.262355639578717,41.57431281878999,0 2.262394920155988,41.5743096784734,0 2.262433173094045,41.57430464679179,0 2.262481454827037,41.5742816834972,0 2.262512865607393,41.57426686822681,0 2.263179134716637,41.5739495459549,0 2.263270674512461,41.57389561566387,0 2.263352354851753,41.57384452922361,0 2.263416147829034,41.57380242595532,0 2.263478146873172,41.57375115345025,0 2.263527841297828,41.57370415515889,0 2.263588369329914,41.5736352350058,0 2.263632873097865,41.57357260520379,0 2.263683391363815,41.57348498356635,0 2.263722791447651,41.57339242854161,0 2.263743893775556,41.57330718434613,0 2.263754107325202,41.57319335718302,0 2.263743853371856,41.57306893562937,0 2.263723639775659,41.57298401736987,0 2.26370443996132,41.57292902217578,0 2.263669006661366,41.5728478793188,0 2.263642711305973,41.57279331481801,0 2.263593896653313,41.57272768179023,0 2.263341932981247,41.57242952761396,0 ];
r_right_raw = [2.263062883247047,41.57232332622944,0 2.261760024012349,41.57077451973223,0 2.260260392167366,41.568992168049,0 2.258687222656965,41.5671201155515,0 2.257994536368357,41.56629929599917,0 2.257301135681629,41.56547297183045,0 2.256786425061064,41.56485721458825,0 2.256764115111916,41.56483189696293,0 2.256728895521112,41.5648031530264,0 2.256697687250444,41.56477933286384,0 2.256668330895417,41.56475892839861,0 2.256631518735157,41.56473867212383,0 2.256605000532763,41.56472686111979,0 2.256575252604782,41.5647160680539,0 2.256545459289967,41.56470793081807,0 2.256515158164458,41.56470076487032,0 2.256474792763596,41.56469429412797,0 2.25642497006493,41.56469050834436,0 2.256365803295246,41.56469164132808,0 2.256330493614567,41.56469620972324,0 2.256286719839942,41.56470440731891,0 2.256263758941579,41.56470981592358,0 2.256227291392898,41.56472116561039,0 2.2561982764127,41.56473167653295,0 2.25616786956538,41.5647438899849,0 2.256131628549731,41.56475996292202,0 2.256079179317914,41.56478089213627,0 2.256005668949301,41.56481745899188,0 2.255961899544561,41.56483835043515,0 2.255928566765784,41.56485500003193,0 2.255898864323338,41.56486907480809,0 2.255861588646833,41.56488494149497,0 2.25583157136741,41.56489663503793,0 2.255793604314968,41.56490904309385,0 2.255743192390953,41.56492264467416,0 2.255684025950926,41.56493507971395,0 2.255640113911122,41.56494474816305,0 2.255593370954516,41.56495044807502,0 2.255512394957508,41.56495498975159,0 2.255445754874876,41.56495394521495,0 2.255380065373458,41.56494860767393,0 2.255314538957385,41.56493912834436,0 2.255241129004109,41.56492328980423,0 2.255191679877555,41.56490962652721,0 2.255141964894485,41.56489153725501,0 2.255086916008435,41.56486787468642,0 2.255030814271,41.56484062078177,0 2.255001674125843,41.56482578155585,0 2.254953371889792,41.56480021972963,0 2.254822849761366,41.56472878514046,0 2.25460483690398,41.56460802266867,0 2.254418118485013,41.56450810604569,0 2.254333012960086,41.56446281768529,0 2.254293209804574,41.56444220483338,0 2.254208244868607,41.56439872913207,0 2.254161005683104,41.56437650963574,0 2.254113084101921,41.56435720254574,0 2.254072212588707,41.56434185049753,0 2.254036249473281,41.56432937592207,0 2.253996240628564,41.56431601283563,0 2.253963684375071,41.56430699899453,0 2.253904942009659,41.56429155656656,0 2.253858509228779,41.5642813987777,0 2.253816385163783,41.56427346812748,0 2.253785763054954,41.56426867882023,0 2.253752237563111,41.56426367269187,0 2.253716545012756,41.56425955592645,0 2.253649570971903,41.56425351884788,0 2.25360505841866,41.56425108590835,0 2.253566511358196,41.56424972069796,0 2.253527836185212,41.56424943662762,0 2.25349909088671,41.56424978574442,0 2.253477372420845,41.56425021152118,0 2.253442118213311,41.56425149588147,0 2.253418348863163,41.56425339545979,0 2.253388657605351,41.56425595077688,0 2.253321538166124,41.56426321257167,0 2.253273086284118,41.56427028280071,0 2.253242035490062,41.56427560552743,0 2.253181438311747,41.56428791118407,0 2.253116984174379,41.56430304769094,0 2.253067034482796,41.56431798891555,0 2.253016440694118,41.56433498332927,0 2.25295293055439,41.56435822527972,0 2.252905375717162,41.56437812735189,0 2.252874901834525,41.56439205620925,0 2.252841715646068,41.56440838686071,0 2.252796836567375,41.5644318571651,0 2.252758541335549,41.56445319078876,0 2.252724439034426,41.5644749603566,0 2.252691456071085,41.5644969764265,0 2.252666288762308,41.56451453137836,0 2.252632330298987,41.56454003605405,0 2.252600322564444,41.56456643199998,0 2.252574332848005,41.56458975184106,0 2.252554094452106,41.564608555532,0 2.252539184151792,41.56462414385947,0 2.252513417300179,41.56465000556552,0 2.252490654400734,41.56467552318458,0 2.252469238225581,41.56470204912019,0 2.25244894658819,41.56472701798333,0 2.252431930141598,41.564749127308,0 2.252418611024949,41.56476681142332,0 2.25240927140631,41.56478001305472,0 2.252393820365703,41.56480292252531,0 2.252368963385549,41.56484408424473,0 2.252343853501177,41.56488592745666,0 2.252318316834836,41.56493394883525,0 2.252300867252637,41.56497146469282,0 2.252287279253771,41.5650063744244,0 2.252274464202011,41.56504325923456,0 2.252260518851936,41.56508344155045,0 2.252247194220078,41.56513064797346,0 2.252238874477244,41.5651717241045,0 2.252231641021869,41.56520851258154,0 2.252227676342085,41.56524034112962,0 2.252224096109554,41.56528039734507,0 2.252222063065901,41.56535337965986,0 2.252222822010328,41.56541089450414,0 2.252225985615806,41.5654626820012,0 2.252232067482915,41.56553153682595,0 2.252241177679752,41.56559986074436,0 2.252256940321724,41.56568427153791,0 2.252277285458699,41.56576963330843,0 2.252293653575641,41.5658241859659,0 2.252314833133009,41.56588489651515,0 2.252350883553278,41.56597256408963,0 2.252384692935852,41.5660528405725,0 2.252439796877761,41.56615933185701,0 2.252508923275767,41.5662789371875,0 2.25259365167962,41.56639777300821,0 2.252696115348529,41.5665261253377,0 2.252881632178307,41.56674359301122,0 2.253910227929081,41.56797412737623,0 2.253980039217451,41.56805974132388,0 2.254023238296126,41.56811523775913,0 2.254067802692439,41.56816181285338,0 2.254106409595433,41.56820277744399,0 2.254144285201545,41.56823751527408,0 2.254193234895783,41.56827277276995,0 2.254247440856723,41.56830413822609,0 2.254295712277263,41.56832663457013,0 2.254347596734194,41.568345220287,0 2.254396902544828,41.56835931720016,0 2.254430807259364,41.56836664602658,0 2.254469394955843,41.56837252721883,0 2.254501534194953,41.56837605663427,0 2.254542607223091,41.56837899275108,0 2.254581028343596,41.56837991281239,0 2.254626785740828,41.56837756696507,0 2.254665118116761,41.56837423466496,0 2.254698710684728,41.56836916263745,0 2.254731414441891,41.5683626122802,0 2.254764895576016,41.56835464099339,0 2.254825183934521,41.56833555233846,0 2.254900627309848,41.56830437657893,0 2.25495377398423,41.5682756370138,0 2.255011384892793,41.5682385446493,0 2.255052060098877,41.56820856987291,0 2.255094701214775,41.56817293620402,0 2.25512428623307,41.5681432449352,0 2.255161730175776,41.5681030532525,0 2.255183415983586,41.56807395879643,0 2.255201923263375,41.56804877009602,0 2.255218330536775,41.56802345410545,0 2.255236443994808,41.56799085574826,0 2.255251774021796,41.56795746518094,0 2.255268849731302,41.56791088831991,0 2.25528089888112,41.56787256802442,0 2.255286356661008,41.567846441272,0 2.255294807087547,41.56781059404401,0 2.255302613424464,41.56775594585006,0 2.255305447308671,41.56769972548616,0 2.255304816920729,41.5676351926578,0 2.255293898713651,41.56754867209528,0 2.255274399832821,41.56747271405154,0 2.255253516775078,41.56741995623864,0 2.25522726971725,41.56735894878857,0 2.255201914677822,41.56730937150032,0 2.255172202712055,41.56725943399903,0 2.25514164140401,41.56721406896796,0 2.255094392457475,41.5671493402758,0 2.255055814964655,41.56709974543852,0 2.25503094067107,41.56706430357622,0 2.254880733180984,41.56688645471043,0 2.254733016810688,41.56671231368565,0 2.254619704850673,41.56659489685854,0 2.254490531381712,41.56644036225686,0 2.254316795998332,41.5662337522961,0 2.254013078483215,41.56586915339591,0 2.253948001304709,41.5657776441229,0 2.253914430275352,41.56568229355278,0 2.253912114258014,41.56558337710927,0 2.2539349479398,41.56550811787516,0 2.253958389993578,41.56546013215412,0 2.254001244331876,41.56540872541104,0 2.254034132827363,41.56538080151923,0 2.254075361843484,41.56534976017925,0 2.254122762412694,41.56532157686631,0 2.254191277530673,41.56529190145142,0 2.254249976743243,41.56527362314931,0 2.254310779885405,41.5652616862397,0 2.254397857795947,41.56525524511893,0 2.254491630132442,41.56525916428338,0 2.254604181406383,41.56527675049301,0 2.254774953744054,41.56533358611812,0 2.25552008598952,41.56558189893386,0 2.255657987594455,41.56562890803141,0 2.256017547924105,41.56575460288729,0 2.256265986521899,41.56584800828267,0 2.256441607107733,41.56593003927343,0 2.256593664101749,41.5660157070732,0 2.256764418114379,41.56612076762767,0 2.256929438720179,41.56624377860012,0 2.257159088607665,41.56645693114184,0 2.257307098532941,41.56662636917033,0 2.257403984452269,41.56673833128219,0 2.25754337941646,41.56689424466067,0 2.257733525795782,41.56711814314352,0 2.257825280752834,41.56725071248376,0 2.257855354269251,41.56732100624879,0 2.257865860029673,41.5674046143599,0 2.257855874183743,41.56748059448465,0 2.257829343564342,41.56755063946695,0 2.257789795282952,41.56761466309749,0 2.257724920596729,41.56768122076547,0 2.257681340397819,41.5677157651433,0 2.257566943375544,41.56778130394311,0 2.257439994776631,41.56784167847248,0 2.257329974283235,41.56789175105237,0 2.257263562486873,41.56792671231715,0 2.257206366030922,41.56796273622071,0 2.257172528050664,41.56798626862754,0 2.257145575124733,41.56800802057889,0 2.25709742753246,41.56804901056346,0 2.257053443739332,41.56809058305925,0 2.257014639121413,41.56813194164632,0 2.256966872553472,41.56819598803366,0 2.256928708788823,41.56825408799367,0 2.256845717323164,41.56839462946592,0 2.25674351233619,41.56857258273748,0 2.256537144628548,41.56893626791375,0 2.256267648662504,41.56941316633296,0 2.256187297344465,41.5695606643179,0 2.256139626940561,41.56964420094165,0 2.256100908976866,41.56972497254546,0 2.256075260602461,41.5697946676688,0 2.256060820930164,41.56985745850299,0 2.256053066230501,41.56992584764072,0 2.256053002905696,41.56999658650152,0 2.25606184991596,41.5700593062785,0 2.256074634492358,41.57010951082275,0 2.256102005560909,41.57018376437567,0 2.256101327905857,41.57018384676954,0 2.256135937016674,41.57025348691734,0 2.256176558850491,41.5703133761607,0 2.256232980970727,41.57037970419057,0 2.256294365818212,41.57044260018412,0 2.256336194715778,41.57048307978425,0 2.256413961103347,41.57053482930872,0 2.256503487318708,41.57058513976236,0 2.256573195855611,41.57062229395293,0 2.256676761901411,41.57066576341787,0 2.259063910334296,41.57158172692174,0 2.259338562142532,41.57167800409937,0 2.260453785155629,41.57210184472218,0 2.260810839906295,41.57224185635548,0 2.261275227834847,41.57242204163727,0 2.261643426208957,41.57256220128066,0 2.26183831809075,41.57263983382715,0 2.261939469502756,41.57268492968163,0 2.262026912972501,41.57274155934331,0 2.262082339027787,41.57281310770731,0 2.262080773267485,41.57290645220922,0 2.262033355874333,41.5729774377519,0 2.262000124357055,41.57302374068002,0 2.261944248637664,41.57305554251234,0 2.261862016657759,41.57307747124914,0 2.261770758882722,41.57309282753324,0 2.261690667476455,41.57310437655256,0 2.261470187216426,41.57314023459,0 2.261351585781373,41.57316031020214,0 2.260925895774168,41.57322690755989,0 2.260695003677546,41.57326203356907,0 2.260601017227304,41.57326929106274,0 2.260507403088663,41.57327575606644,0 2.260412738145618,41.57326912458605,0 2.26034642022906,41.57325325107437,0 2.260295952774125,41.57323668242951,0 2.260247142044507,41.5732079922865,0 2.26016493909418,41.57315730957863,0 2.260088835541421,41.57311613926851,0 2.259999337890151,41.57306136234568,0 2.259960961900285,41.57303858200103,0 2.259907877219753,41.57301179492984,0 2.259865761016688,41.57299136238944,0 2.259815537007037,41.57296946342018,0 2.259761970961358,41.57295467989758,0 2.259691732098212,41.57294027244724,0 2.259642234230348,41.57293243861548,0 2.259551188157847,41.57292923225931,0 2.259440388909251,41.57293949275574,0 2.259361691117847,41.57295553833318,0 2.259279059475898,41.57298172868119,0 2.259217301501664,41.57301046353583,0 2.25915366060701,41.57304777618815,0 2.259086013963363,41.57310289960445,0 2.259038154411361,41.57315519056424,0 2.259004123939801,41.57320685881721,0 2.258980899522391,41.5732578865402,0 2.258963629904316,41.57330673968634,0 2.258954866939402,41.57336287989074,0 2.258959593970948,41.57344733611765,0 2.258986433573309,41.57353482631471,0 2.259021368302399,41.57359694347356,0 2.259061034303502,41.57364471436023,0 2.259108449934004,41.57369197045025,0 2.259139187231751,41.57371842167021,0 2.25920744274891,41.57376170914147,0 2.259318267793211,41.5738320406987,0 2.260338223464673,41.57446212281938,0 2.260398253072937,41.57449774213725,0 2.260489436797608,41.57454582138736,0 2.26052516561791,41.57456406445581,0 2.260554370993368,41.57457737843464,0 2.260594173275698,41.57458860693926,0 2.260634390638778,41.57459320328276,0 2.260680863031272,41.57459275184401,0 2.260723718518092,41.57458554549283,0 2.260771174125435,41.57456796013435,0 2.260820213479913,41.57454134719048,0 2.260882785799798,41.57451107413952,0 2.260996014091361,41.57444892864106,0 2.26124153738162,41.5743117305706,0 2.261417577675122,41.57421209681577,0 2.261462321674068,41.57417577966243,0 2.261533654756169,41.57413349436919,0 2.261659455605907,41.5740634513382,0 2.261752831633297,41.5740104472592,0 2.261798040363916,41.57398646092271,0 2.261826974326662,41.57397520924673,0 2.261896351277366,41.57395921645522,0 2.261948563540059,41.57395394661366,0 2.261991981702904,41.57395803688774,0 2.262048886554175,41.5739735426159,0 2.262095796481718,41.57400239524026,0 2.262149131764548,41.57404559268934,0 2.262190466360834,41.57407834956408,0 2.262237264313367,41.57411255946803,0 2.262275095509743,41.57414072336625,0 2.262308690199792,41.57416412805014,0 2.262326870867244,41.57417738837246,0 2.262343680227628,41.57418870221462,0 2.262368336457645,41.57419052017525,0 2.262392932307002,41.5741820922067,0 2.262421777343762,41.57416888713522,0 2.262498826574317,41.57413474798128,0 2.262622052478678,41.57407870675395,0 2.262975824088025,41.57390732501182,0 2.26305097969888,41.57387080185401,0 2.263120162056542,41.57383600777644,0 2.263170703326332,41.57381010088586,0 2.263214296323683,41.57378738596773,0 2.263282370490267,41.57374108184764,0 2.2633327517144,41.57370394823056,0 2.263375991554988,41.57366780582782,0 2.263406660979068,41.57363470736501,0 2.263439838574139,41.57359963778862,0 2.263475611701939,41.57355280564949,0 2.263510233089037,41.57349865303412,0 2.2635415380752,41.57343929490482,0 2.263563557439032,41.57338776071813,0 2.263580578994757,41.57332629486168,0 2.263590299343483,41.57327464488737,0 2.263596480722152,41.57321403627393,0 2.263596817257132,41.57314389884162,0 2.263590945833445,41.57310439793572,0 2.263580865962187,41.57305041652334,0 2.263565308083142,41.57300447559661,0 2.263545899424801,41.57295022978924,0 2.263520605264495,41.57290019947283,0 2.263496684611777,41.57286243777501,0 2.263473015468072,41.57282733182961,0 2.2634540106903,41.57279541237821,0 2.263416953064052,41.57274541416932,0 2.263360831402694,41.57267442525318,0 2.263204475788239,41.57249071919362,0 ];

lon_left = r_left_raw(1:3:length(r_left_raw));
lat_left = r_left_raw(2:3:length(r_left_raw));
lon_right = r_right_raw(1:3:length(r_right_raw));
lat_right = r_right_raw(2:3:length(r_right_raw));

lon_left = [lon_left,lon_left(1)];
lat_left = [lat_left,lat_left(1)];

lon_right = [lon_right,lon_right(1)];
lat_right = [lat_right,lat_right(1)];
R_earth = R_earth*1.001;
xy_left = zeros(2,length(lon_left));
for i = 1 : length(lon_left)
    xy_left(:,i) = u_theta*R_earth*cosd(phi_ref)*deg2rad(lon_left(i)-theta0) + u_phi*R_earth*deg2rad(lat_left(i)-phi0);
end

xy_right = zeros(2,length(lon_right));
for i = 1 : length(lon_right)
    xy_right(:,i) = u_theta*R_earth*cosd(phi_ref)*deg2rad(lon_right(i)-theta0) + u_phi*R_earth*deg2rad(lat_right(i)-phi0);
end

hold on
plot(xy_left(1,:),xy_left(2,:),'LineWidth',2)
plot(xy_right(1,:),xy_right(2,:),'LineWidth',2)


R_earth_fl = 6378388.0;
phi0_fl = lat_right(1);
x0 = deg2rad(lon_right(1))*R_earth_fl*cosd(phi0_fl);
y0 = deg2rad(lat_right(1))*R_earth_fl;
lon_fl = zeros(1,size(aa,1));
lat_fl = zeros(1,size(aa,1));
for i = 1 : size(aa,1)
    lon_fl(i) = rad2deg((x0+aa(i,1))/(R_earth_fl*cosd(phi0_fl)));
    lat_fl(i) = rad2deg((y0+aa(i,2))/(R_earth_fl));
end

xy_fl = zeros(2,length(lon_fl));
for i = 1 : length(lon_fl)
    xy_fl(:,i) = u_theta*R_earth*cosd(phi_ref)*deg2rad(lon_fl(i)-theta0) + u_phi*R_earth*deg2rad(lat_fl(i)-phi0);
end
plot(xy_fl(1,:),xy_fl(2,:));