/**
 * 自定义字段 - 商品品牌字段
 */
Ext.define("PSI.Goods.GoodsBrandField", {
	extend : "Ext.form.field.Trigger",
	alias : "widget.PSI_goods_brand_field",

	config : {
		showModal : false
	},

	initComponent : function() {
		var me = this;
		me.__idValue = null;

		me.enableKeyEvents = true;

		me.callParent(arguments);

		me.on("keydown", function(field, e) {
					if (e.getKey() === e.BACKSPACE) {
						field.setValue(null);
						me.setIdValue(null);
						e.preventDefault();
						return false;
					}

					if (e.getKey() !== e.ENTER) {
						this.onTriggerClick(e);
					}
				});
		me.on({
					render : function(p) {
						p.getEl().on("dblclick", function() {
									me.onTriggerClick();
								});
					},
					single : true
				});
	},

	onTriggerClick : function(e) {
		var me = this;

		var modelName = "PSIGoodsBrandField";
		Ext.define(modelName, {
					extend : "Ext.data.Model",
					fields : ["id", "name"]
				});

		var store = Ext.create("Ext.data.Store", {
					model : modelName,
					autoLoad : false,
					data : []
				});
		var lookupGrid = Ext.create("Ext.grid.Panel", {
					cls : "PSI",
					columnLines : true,
					border : 0,
					store : store,
					columns : [{
								header : "品牌",
								dataIndex : "name",
								menuDisabled : true,
								flex : 1
							}]
				});
		me.lookupGrid = lookupGrid;
		me.lookupGrid.on("itemdblclick", me.onOK, me);

		var wnd = Ext.create("Ext.window.Window", {
					title : "选择 - 商品品牌",
					modal : me.getShowModal(),
					width : 400,
					height : 300,
					layout : "border",
					items : [{
								region : "center",
								xtype : "panel",
								layout : "fit",
								border : 0,
								items : [lookupGrid]
							}, {
								xtype : "panel",
								region : "south",
								height : 40,
								layout : "fit",
								border : 0,
								items : [{
											xtype : "form",
											layout : "form",
											bodyPadding : 5,
											items : [{
														id : "__editGoodsBrand",
														xtype : "textfield",
														fieldLabel : "商品品牌",
														labelWidth : 70,
														labelAlign : "right",
														labelSeparator : ""
													}]
										}]
							}],
					buttons : [{
								text : "确定",
								handler : me.onOK,
								scope : me
							}, {
								text : "取消",
								handler : function() {
									wnd.close();
								}
							}]
				});

		wnd.on("close", function() {
					me.focus();
				});
		if (!me.getShowModal()) {
			wnd.on("deactivate", function() {
						wnd.close();
					});
		}
		me.wnd = wnd;

		var editName = Ext.getCmp("__editGoodsBrand");
		editName.on("change", function() {
			var store = me.lookupGrid.getStore();
			Ext.Ajax.request({
						url : PSI.Const.BASE_URL
								+ "Home/Goods/queryGoodsBrandData",
						params : {
							queryKey : editName.getValue()
						},
						method : "POST",
						callback : function(opt, success, response) {
							store.removeAll();
							if (success) {
								var data = Ext.JSON
										.decode(response.responseText);
								store.add(data);
								if (data.length > 0) {
									me.lookupGrid.getSelectionModel().select(0);
									editName.focus();
								}
							} else {
								PSI.MsgBox.showInfo("网络错误");
							}
						},
						scope : this
					});

		}, me);

		editName.on("specialkey", function(field, e) {
					if (e.getKey() == e.ENTER) {
						me.onOK();
					} else if (e.getKey() == e.UP) {
						var m = me.lookupGrid.getSelectionModel();
						var store = me.lookupGrid.getStore();
						var index = 0;
						for (var i = 0; i < store.getCount(); i++) {
							if (m.isSelected(i)) {
								index = i;
							}
						}
						index--;
						if (index < 0) {
							index = 0;
						}
						m.select(index);
						e.preventDefault();
						editName.focus();
					} else if (e.getKey() == e.DOWN) {
						var m = me.lookupGrid.getSelectionModel();
						var store = me.lookupGrid.getStore();
						var index = 0;
						for (var i = 0; i < store.getCount(); i++) {
							if (m.isSelected(i)) {
								index = i;
							}
						}
						index++;
						if (index > store.getCount() - 1) {
							index = store.getCount() - 1;
						}
						m.select(index);
						e.preventDefault();
						editName.focus();
					}
				}, me);

		me.wnd.on("show", function() {
					editName.focus();
					editName.fireEvent("change");
				}, me);
		wnd.showBy(me);
	},

	onOK : function() {
		var me = this;
		var grid = me.lookupGrid;
		var item = grid.getSelectionModel().getSelection();
		if (item == null || item.length != 1) {
			PSI.MsgBox.showInfo("没有选择品牌");
			return;
		}

		var data = item[0].data;
		me.setValue(Ext.String.htmlDecode(data.name));
		me.setIdValue(data.id);
		me.wnd.close();
		me.focus();
	},

	setIdValue : function(id) {
		this.__idValue = id;
	},

	getIdValue : function() {
		return this.__idValue;
	},

	clearIdValue : function() {
		this.setValue(null);
		this.__idValue = null;
	}
});