<p align="center">
  <br />
  <img width="100" src="./open ai.png" alt="OpenAI logo">
  <br />
  <br />
</p>

<h1 align="center">ChatGPT Resources</h1>

<p align="center">
  Curated list of awesome libraries, extensions, tools, apps for ChatGPT.
</p>

## Table Of Contents

- [API](#api)
- [Browser Extensions](#browser-extensions)
- [Other Extensions](#other-extensions)
- [Bots](#bots)
- [Agents](#agents)
- [Libraries](#libraries)
- [Apps](#apps)
- [Integration](#integration)
- [CLI](#cli)
- [Prompts](#prompts)
- [Misc](#misc)


## API

- [Official OpenAI API](https://platform.openai.com/api-keys) - Get your own OpenAI API Key from OpenAI.
- [FreeGPT35](https://github.com/missuo/FreeGPT35) - Utilize the unlimited free GPT-3.5-Turbo API service provided by the login-free ChatGPT Web.
- [Free ChatGPT API](https://github.com/skzhengkai/free-chatgpt-api) - Access ChatGPT (GPT-3.5) API for absolutely free, hosted from your own computer! No API key required.
- [ChatGPT](https://github.com/PawanOsman/ChatGPT) - OpenAI API Free Reverse Proxy
- [ChatGPTSwift](https://github.com/alfianlosari/ChatGPTSwift) - Access ChatGPT API using Swift.
- [OpenAI-DotNet](https://github.com/RageAgainstThePixel/OpenAI-DotNet) - A fast lightweight DotNet library for OpenAI API.
- [Whetstone.ChatGPT](https://github.com/johniwasz/whetstone.chatgpt) - A simple light-weight library that 
- [ruby-openai](https://github.com/alexrudall/ruby-openai) - OpenAI API + Ruby! 🤖❤️ Now with ChatGPT and Whisper.
- [openai-kotlin](https://github.com/aallam/openai-kotlin) - OpenAI API client for Kotlin with multiplatform and coroutines capabilities.
- [slickgpt](https://github.com/ShipBit/slickgpt) - A light-weight "use-your-own-API-key" web client for the OpenAI API written in Svelte. It offers GPT-4 integration, a userless share feature and other superpowers.

## Browser Extensions
- [Best ChatGPT Browser Extensions](https://www.scriptbyai.com/best-chatgpt-browser-extensions/) - 10 best and free ChatGPT browser extensions that will take your browsing game to the next level!
- [AI-Prompt-Genius](https://github.com/benf2004/AI-Prompt-Genius) - Curate a custom library of AI Prompts
- [chatgpt-to-notion](https://github.com/L-a-r-t/chatgpt-to-notion) - ChatGPT to Notion brings the cleverness of ChatGPT right into your Notion workspace!
- [ChatGPT-History-Downloader](https://github.com/Luo-Yihang/ChatGPT-History-Downloader) - A Google chrome extension to help download chat history with OpenAI ChatGPT
- [openai](https://github.com/anasfik/openai) - Dart/Flutter SDK for ChatGPT and all OpenAI APIs (GPT, Dall-e..).

## Other Extensions.
- [chatgpt-vscode](https://github.com/mpociot/chatgpt-vscode) - A VSCode extension that allows you to use ChatGPT.
- [chatgpt.nvim](https://github.com/terror/chatgpt.nvim) - A Neovim plugin that lets you query ChatGPT inside a Neovim buffer.
- [chatgpt-raycast](https://github.com/abielzulio/chatgpt-raycast) - Unofficial ChatGPT raycast extension.
- [docGPT](https://github.com/cesarhuret/docGPT) - ChatGPT directly within Google Docs as an Editor Add-on.
- [vscode-chatgpt](https://github.com/gencay/vscode-chatgpt) - A Visual Studio Code extension to support ChatGPT. The extension is pair-programmed with ChatGPT.
- [chatgpt-vscode-plugin](https://github.com/barnesoir/chatgpt-vscode-plugin) - A VS code plugin for ChatGPT built by ChatGPT.
- [ChatGPT.nvim](https://github.com/jackMort/ChatGPT.nvim) - Neovim plugin for interacting with OpenAI GPT-3 chatbot, providing an easy interface for exploring GPT-3 and NLP.
- [vim-chatgpt](https://github.com/mattn/vim-chatgpt) - Vim plugin for ChatGPT
- [MenuChatGPT](https://github.com/ericlewis/MenuChatGPT) - ChatGPT as a status bar item for macOS
- [ExplainThisCode](https://github.com/evyatar9/ExplainThisCode) - A VSCode extension that uses the ChatGPT API to provide explanations for selected code.
- [ChatGPT-Gnome-Desktop-Extension](https://github.com/HorrorPills/ChatGPT-Gnome-Desktop-Extension) - ChatGPT Gnome Desktop Extension | Talk with ChatGPT from your menubar!
- [ScribeAI](https://github.com/ajikan/ScribeAI) - ChatGPT extension for VSCode.
- [chatgpt-helper](https://github.com/kiranvshah/chatgpt-helper) - A VS Code extension to quickly query OpenAI's ChatGPT from inside your editor.

## Bots
- [Best ChatGPT Bots For Telegram](https://www.scriptbyai.com/best-chatgpt-bots-telegram/) - 7 Best ChatGPT Bots For Telegram: Unleashing the Future of AI-Powered Messaging.
- [chatgpt-telegram](https://github.com/m1guelpf/chatgpt-telegram) - Run your own GPTChat Telegram bot, with a single command!
- [chatGPT-telegram-bot](https://github.com/altryne/chatGPT-telegram-bot) - This is a very early attempt at having chatGPT work within a telegram bot
- [wechat-chatgpt](https://github.com/fuergaosi233/wechat-chatgpt) - Use ChatGPT On Wechat via wechaty.
- [ChatGPT-wechat-bot](https://github.com/AutumnWhj/ChatGPT-wechat-bot) - A WeChat assistant based on NodeJS and webchaty
- [chatgpt-twitter-bot](https://github.com/transitive-bullshit/chatgpt-twitter-bot) - Twitter bot powered by OpenAI's ChatGPT.
- [chatGPT-discord-bot](https://github.com/Zero6992/chatGPT-discord-bot) - OpenAI chatGPT discord bot.
- [ChatGPT-ProBot](https://github.com/oceanlvr/ChatGPT-ProBot) - A GPTChat based GitHub robot. dialogue/CR/etc.
- [chatGPTLineBot](https://github.com/isdaviddong/chatGPTLineBot) - A GPTChat based Line robot.
- [ChatGPTSlackBot](https://github.com/pedrorito/ChatGPTSlackBot) - ChatGPT for Slack Bot.
- [chatgpt-speech-to-text](https://github.com/dylanbud/chatgpt-speech-to-text) - A simple voice-based chatbot that uses the ChatGPT model to generate responses to a users voice input.
- [Discord-ChatGPT-Bot](https://github.com/onury5506/Discord-ChatGPT-Bot) - Discord ChatGPT bot.
- [chatgpt-telegram](https://github.com/Klingefjord/chatgpt-telegram) - A telegram bot for ChatGPT.
- [ChatGPT-macOS](https://github.com/sourcelocation/ChatGPT-macOS) - Interact with ChatGPT from your macOS Menu Bar.
- [ChatGPT-Telegram-Bot](https://github.com/yym68686/ChatGPT-Telegram-Bot) - An AI chat Telegram Bot with ChatGPT in fly.io.
- [ChatGPTDiscord](https://github.com/ausbitbank/ChatGPTDiscord) - Discord bot for interacting with ChatGPT's API by OpenAI.
- [ChatGPT Teams Bot app](https://github.com/formulahendry/chatgpt-teams-bot) - A ChatGPT Teams Bot app to let you chat with ChatGPT in Microsoft Teams.
- [chatgpt-bot](https://github.com/MrlolDev/chatgpt-discord-bot) - A discord bot for interact with ChatGPT.
- [GPT3Discord](https://github.com/Kav-K/GPT3Discord) - A robust, but simple GPT3 interface with Discord. Chat just like ChatGPT right inside Discord!
- [matrix-chatgpt-bot](https://github.com/jakecoppinger/matrix-chatgpt-bot) - Talk to ChatGPT via your favourite Matrix client!
- [whatsgpt](https://github.com/pascalroget/whatsgpt) - WhatsApp Bot for ChatGPT with multiple user support.
- [chatgpt-discord](https://github.com/m1guelpf/chatgpt-discord) - Run your own GPTChat Discord bot, with a single command!
- [slack-chat-gpt](https://github.com/halilylm/slack-chat-gpt) - Slack bot assisted with ChatGPT.
- [LINE-Bot-ChatSummarizer](https://github.com/kkdai/LINE-Bot-ChatSummarizer) - Use ChatGPT to summarize your group chat as a chat summarizer with the LINE Bot Chat Summarizer.
- [chatgpt_telegram_bot](https://github.com/karfly/chatgpt_telegram_bot) - ChatGPT Telegram Bot (fast and no limits).
- [chatgpt-whatsapp](https://github.com/noelzappy/chatgpt-whatsapp) - A simple WhatsApp bot that uses OpenAI's ChatGPT to respond to user inputs. Includes a cron to enable ChatGPT to send messages to recipients at periodic intervals.
- [GPT-Linebot-python-flask-on-vercel](https://github.com/howarder3/GPT-Linebot-python-flask-on-vercel) - GPT-Linebot using python flask for vercel.
- [wpp-chatgpt](https://github.com/Santosl2/wpp-chatgpt) - Make your whatsapp BOT talk like a human using ChatGPT!
- [chatgpt-whatsapp](https://github.com/theazran/chatgpt-whatsapp) - ChatGPT OpenAI WhatsApp
- [matrix-chatgpt-bot](https://github.com/matrixgpt/matrix-chatgpt-bot) - Talk to ChatGPT via your favourite Matrix client!
- [BotWhatsapp](https://github.com/try-catch-dev/BotWhatsapp) - Bot Whatsapp
- [ChatGPT-Binance-Trading](https://github.com/JoeKaram78/ChatGPT-Binance-Trading) - Simple trading bot which use ChatGPT algorithm trading.
- [chatgpt-telegram-bot](https://github.com/RainEggplant/chatgpt-telegram-bot) - A ChatGPT bot for Telegram based on Node.js. Works with Cloudflare protection.
- [text-surfer](https://github.com/not-poma/text-surfer) - An example GPT bot that can quickly read a lot of text or documentation and then answers questions about it.
- [Hephaestus](https://github.com/Suyash-Purwar/Hephaestus) - An AI powered telegram bot developed using OpenAI's ChatGPT & Dall-E API.
- [Telegram Chatbot using OpenAI](https://github.com/Eloise1988/OPENAI) - This is a python script for a Telegram chatbot that uses the OpenAI API to generate responses to user input.
- [chatbot-telegram](https://github.com/Ciyou/chatbot-telegram) - Yet another telegram ChatGPT bot which allows you to setup and run your bot with one simple command. 
- [GPT-Telegramus](https://github.com/F33RNI/GPT-Telegramus) - ChatGPT and DALLE implementation as a telegram bot.
- [chatgpt-bot-nodejs](https://github.com/monokaijs/chatgpt-bot-nodejs) - ChatGPT Bot with NodeJs.
- [GPT-Discord-Bot](https://github.com/iTzArshia/GPT-Discord-Bot) - Example Discord bot written in JavaScript that uses `text-davinci-003`, `Dall.E 2`, and `text-moderation-004` models with many features!
- [chatgpt-bot](https://github.com/Swothh/chatgpt-bot) - Discord bot that interacts with the unofficial ChatGPT API.
- [ChatGPT-DiscordBot](https://github.com/JasonInd/ChatGPT-DiscordBot) - An up to date Discord Bot that generates replies using chatGPT.
- [askrella](https://github.com/askrella/whatsapp-chatgpt) - Whatsapp bot that uses OpenAI's GPT & DALLE to respond to user inputs.
- [Whatsapp_Instagram_Messanger_ChatGPT_OpenAI](https://github.com/JoseHenriqueSiqueira/Whatsapp_Instagram_Messanger_ChatGPT_OpenAI) - This repository showcases a ChatBot integrated with WhatsApp, using OpenAI API (such as ChatGPT).
- [openai-whatsapp-chatbot](https://github.com/simonsanvil/openai-whatsapp-chatbot) - A chatbot app that uses OpenAI's GPT3 and DALL-E to reply to incoming messages from WhatsApp and generate images.
- [ChatGPT-Line-Bot](https://github.com/TheExplainthis/ChatGPT-Line-Bot) - This is a repository that allows you to integrate ChatGPT into Line.
- [TelegramGPT](https://github.com/zhuorantan/TelegramGPT) - A minimum ChatGPT Telegram Bot with conversation history.
- [slack-chatgpt](https://github.com/shapehq/slack-chatgpt) - Integrate ChatGPT into Slack using Cloudflare Workers.
- [chatgpt-telegram-bot](https://github.com/flynnoct/chatgpt-telegram-bot) - Telegram bot implemented by OFFICIAL OpenAI ChatGPT API (gpt-3.5-turbo-0301, released on 2023-03-01).
- [chatgpt-telegram-bot](https://github.com/shinyypig/chatgpt-telegram-bot) - OpenAI chatbot for Telegram using GPT-3.5.
- [chatgpt-telegram-bot](https://github.com/leafduo/chatgpt-telegram-bot) - Run your own ChatGPT Telegram bot!
- [chatGPT-discord-bot](https://github.com/Zero6992/chatGPT-discord-bot) - Integrate ChatGPT into your own discord bot.
- [SirChatalot](https://github.com/sazonovanton/SirChatalot) - A Telegram bot powered by new OpenAI API for ChatGPT and Whisper.
- [discourse-chatbot](https://github.com/merefield/discourse-chatbot) - A cloud chatbot adaptor for Discourse, currently supporting OpenAI.
- [TeleGPT](https://github.com/Helixform/TeleGPT) - An out-of-box ChatGPT bot for Telegram.
- [pokitoki](https://github.com/nalgeon/pokitoki) - Humble ChatGPT Telegram Bot.
- [whatbot](https://github.com/theshanergy/whatbot) - GPT based chat bot for WhatsApp which uses the OpenAI API.
- [slack-gpt-bot](https://github.com/alex000kim/slack-gpt-bot) - GPT4-powered Slack bot that can scrape URL contents.
- [ChatGPT-Discord-BOT](https://github.com/itskdhere/ChatGPT-Discord-BOT) - A Discord BOT Powered By OpenAI's ChatGPT.
- [telegram-chatgpt-concierge-bot](https://github.com/RafalWilinski/telegram-chatgpt-concierge-bot) - Telegram ChatGPT Concierge Bot.
- [Dibbr](https://github.com/thehemi/Dibbr) - Smart, context-aware GPT-4/Custom LLM bot for discord.
- [GPTDiscord](https://github.com/Kav-K/GPTDiscord) - A robust, all-in-one GPT3 interface for Discord. ChatGPT-style conversations, image generation, AI-moderation, custom indexes/knowledgebase, youtube summarizer, and more!
- [gptbot](https://github.com/go-aie/gptbot) - Question Answering Bot powered by OpenAI GPT models.
- [insights-bot](https://github.com/nekomeowww/insights-bot) - A bot works with OpenAI GPT models to provide insights for your Telegram info flows.
- [Discord-AI-Chatbot](https://github.com/mishalhossin/Discord-AI-Chatbot) - This is a Discord Chatbot with image detection for free.
- [ChatGPT-Telegram-Bot](https://github.com/V-know/ChatGPT-Telegram-Bot) - A Telegram bot with a smooth AI experience.

## Agents
- [Auto-GPT](https://github.com/Torantulino/Auto-GPT) - An experimental open-source attempt to make GPT-4 fully autonomous.
- [AgentGPT](https://github.com/reworkd/AgentGPT) - Assemble, configure, and deploy autonomous AI Agents in your browser.
- [gptagent.js](https://github.com/lgrammel/gptagent.js) - Build AI Agents with TS/JS.
- [gpt-assistant](https://github.com/BuilderIO/gpt-assistant) - An experiment to give an autonomous GPT agent access to a browser and have it accomplish tasks.
- [darwin-gpt](https://github.com/muellerberndt/darwin-gpt) - A minimal self-replicating agent based on GPT-3.5/4.
- [micro-gpt](https://github.com/muellerberndt/micro-gpt) - A minimal generic autonomous agent.
- [agentx](https://github.com/slavakurilyak/agentx) - An experiment to extend Auto-GPT, babyagi, and other agents using LangChain.
- [js-agent](https://github.com/lgrammel/js-agent) - A composable and extensible framework for creating GPT agents with JavaScript and TypeScript.
- [loopgpt](https://github.com/farizrahman4u/loopgpt) - Modular Auto-GPT Framework.
- [e2b](https://github.com/e2b-dev/e2b) - Your own virtual developer. e2b lets you build & deploy specialized AI agents that build software for you based on your instructions.
- [LordGPT](https://github.com/Cytranics/LordGPT) - An AI Autonomous Agent that can complete a wide range of tasks unassisted. Built using python and OpenAI / Azure GPT Models.
- [Free-AUTO-GPT-with-NO-API](https://github.com/IntelligenzaArtificiale/Free-AUTO-GPT-with-NO-API) - A repository that offers a simple version of Autogpt, an autonomous AI agent capable of performing tasks independently. 
- [mini-agi](https://github.com/muellerberndt/mini-agi) - A minimal general-purpose autonomous agent based on GPT-3.5 / GPT-4. Can analyze stock prices, perform network security tests, create art, and order pizza.
- [Chrome-GPT](https://github.com/richardyc/Chrome-GPT) - An AutoGPT agent that controls Chrome on your desktop.
- [GPTeam](https://github.com/101dotxyz/GPTeam) - GPTeam uses GPT-4 to create multiple agents who collaborate to achieve predefined goals.
- [Free-Auto-GPT](https://github.com/IntelligenzaArtificiale/Free-Auto-GPT) - Free Auto GPT with NO paids API is a repository that offers a simple version of Auto GPT, an autonomous AI agent capable of performing tasks independently.
- [gpt-engineer](https://github.com/AntonOsika/gpt-engineer) - Specify what you want it to build, the AI asks for clarification, and then builds it.
- [molly](https://github.com/marmelab/molly) - A GPT-powered conversational agent with an inner monologue, demonstrating artificial consciousness. 
- [gpt-autopilot](https://github.com/unconv/gpt-autopilot) - A GPT-4 powered AI agent that can create full projects with iterative prompting.
- [gpt-researcher](https://github.com/assafelovic/gpt-researcher) - An autonomous agent designed for comprehensive online research on a variety of tasks.
- [MetaGPT](https://github.com/geekan/MetaGPT) - The Multi-Agent Framework: Given one line Requirement, return PRD, Design, Tasks, Repo.

## Libraries

- [summarize.site](https://github.com/clmnin/summarize.site) - Summarize web pages using OpenAI ChatGPT
- [sharegpt](https://github.com/domeccleston/sharegpt) - Easily share permanent links to ChatGPT conversations with your friends
- [OpenAIAuth](https://github.com/acheong08/OpenAIAuth) - OpenAI Authentication Library for ChatGPT
- [talk-to-chatgpt](https://github.com/C-Nedelcu/talk-to-chatgpt) - A new javascript program that allows users to interact with the ChatGPT AI using their voice, rather than just by typing. 
- [liboai](https://github.com/D7EAD/liboai) - A C++17 library to access the entire OpenAI API.
- [TalkGPT](https://github.com/ShadovvBeast/TalkGPT) - TalkGPT allows you to easily interact with ChatGPT, the state-of-the-art language model developed by OpenAI. With TalkGPT, you can talk to ChatGPT naturally, with your voice, and it will answer with a voice as well!
- [ChatGPT-Official](https://github.com/PawanOsman/ChatGPT-Official) - A simple Node.js module for creating ChatGPT using OpenAI official API.
- [Sekiryu](https://github.com/20urc3/Sekiryu) - A python script that performs automatic decompilation and analysis of binary files with your prefered Decompiler and ChatGPT
- [Smarty-GPT](https://github.com/citiususc/Smarty-GPT) - Library of prompts/contexts that allows to enhance GPT models responses without the involvement of the user.
- [WebGPT](https://github.com/0hq/WebGPT) - Run GPT model on the browser with WebGPU. An implementation of GPT inference in less than ~2000 lines of vanilla Javascript.

## Apps

- [chatgpt-mac](https://github.com/vincelwt/chatgpt-mac) - ChatGPT for Mac, living in your menubar.
- [chatgpt-desktop](https://github.com/sonnylazuardi/chatgpt-desktop) - Unofficial open source OpenAI ChatGPT desktop app for mac, windows, and linux menubar using tauri & rust.
- [ChatGPT](https://github.com/lencx/ChatGPT) - ChatGPT Desktop Application.
- [ChatGPT-Mac-MenuBar](https://github.com/KittenYang/ChatGPT-Mac-MenuBar) - Chat with OpenAI's ChatGPT in mac menu bar like a pro.
- [ChatGPT_production](https://github.com/sorrge/ChatGPT_production) - Minesweeper game made with ChatGPT.
- [chatgpt-clone](https://github.com/afizs/chatgpt-clone) - Build Your own ChatGPT with OpenAI API and Streamlit.
- [ChatGPT-macOS](https://github.com/sourcelocation/ChatGPT-macOS) - Interact with ChatGPT from your macOS Menu Bar.
- [AskAI](https://github.com/bodhichristian/AskAI) - AskAI provides an approachable, native to iOS experience for interfacing with ChatGPT, and saving chats for later. It's written with almost entirely SwiftUI, and uses MVVM architecture. Chat engine images generated with Midjourney.
- [chatgpt-resume-builder](https://github.com/ofikodar/chatgpt-resume-builder) - A Resume Builder with OpenAI ChatGPT
- [ChatGPT-Flutter-AIChatBot](https://github.com/iampawan/ChatGPT-Flutter-AIChatBot) - A Chatbot chat app built using the Flutter framework and OpenAI's GPT-3 language model.
- [ChatGPT](https://github.com/wieslawsoltes/ChatGPT) - A ChatGPT C# client for graphical user interface.
- [widget](https://github.com/askclippyai/widget) - An AI assistant for your company's docs.
- [ChatGPTAndroid](https://github.com/nohjunh/ChatGPTAndroid) - OpenAI ChatGPT for Android.
- [chatgpt-voice-assistant](https://github.com/fabioo29/chatgpt-voice-assistant) - A voice assistant powered by OpenAI's ChatGPT language model, currently available in six languages.
- [CoverGPT](https://github.com/mahfoozm/CoverGPT) - Generate a personalized & formatted cover letter for a given job position utilizing your resume.
- [chatgpt-mobile](https://github.com/nezort11/chatgpt-mobile) - ChatGPT mobile application bulit using React Native, Expo & Webview.
- [chat-gpt-enhanced](https://github.com/JesseKartabani/chat-gpt-enhanced) - ChatGPT but with more features.
- [HeyChatGPT](https://github.com/ynagatomo/HeyChatGPT) - A minimal iOS app that interacts with ChatGPT by your voice.
- [ChatGPT](https://github.com/orhanerday/ChatGPT) - ChatGPT clone is a simple web application powered by the OpenAI library and built with PHP. It allows users to chat with an AI language model that responds in real-time. Chat history is saved using cookies, and the project requires the use of an API key and enabled SQLite3.
- [ChatGPT](https://github.com/nisabmohd/ChatGPT) - ChatGPT clone using openAI API.
- [TrippingLettuce](https://github.com/TrippingLettuce/ChatGPT-Generated-Articles-to-WordPress) - AI generated WordPress articles, with images
- [chatgpt_please_improve_my_paper_writing](https://github.com/ashawkey/chatgpt_please_improve_my_paper_writing) - A thin wrapper of chatgpt with a gradio interface for improving academic writing.
- [ChatGPTFreeApp](https://github.com/ztjhz/ChatGPTFreeApp) - An amazing open-source web app that allows you to play with OpenAI's ChatGPT API for free!
- [chatgpt-raycast](https://github.com/abielzulio/chatgpt-raycast) - Interact with OpenAI's ChatGPT right from your command bar.
- [AIShader](https://github.com/keijiro/AIShader) - ChatGPT-powered shader generator for Unity.
- [ChatGPT](https://github.com/chenxi92/ChatGPT) - A macOS and iOS App to communicate with ChatGPT.
- [chatty](https://github.com/huntabyte/chatty) - A chatbot application build with OpenAI's ChatGPT API.
- [chatbox](https://github.com/Bin-Huang/chatbox) - A cross-platform desktop client for OpenAI API, also a prompt debugging and management tool.
- [chatgpt-i18n](https://github.com/ObservedObserver/chatgpt-i18n) - Translate your locale json files with AI assistance.
- [ChatPaper](https://github.com/kaixindelele/ChatPaper) - Use ChatGPT to summary the Arxiv papers.
- [ohmygpt](https://github.com/noobnooc/ohmygpt) - Deploy your ChatGPT-based web app in minutes.
- [ChatGPT-Paper-Reader](https://github.com/talkingwallace/ChatGPT-Paper-Reader) - This repository provides a simple interface that utilizes the gpt-3.5-turbo model to read academic papers in PDF format locally. You can use it to help you summarize papers, create presentation slides, or simply fulfill tasks assigned by your supervisor.
- [FreeChatGPT](https://github.com/ztjhz/FreeChatGPT) - An amazing open-source web app that allows you to play with OpenAI's ChatGPT API for free!
- [GPT-google-sheets](https://github.com/MoritzLaurer/GPT-google-sheets) - Code and documentation for running ChatGPT in google sheets without any coding knowledge. Transform unstructured text to structured data.
- [Chatgpt-document-pdf-based-chatbot-pdf-summarizer](https://github.com/muratali016/Chatgpt-document-pdf-based-chatbot-pdf-summarizer) - This is a text summarization app that uses OpenAI's GPT-3 language model to generate a summary of a given text.
- [gerev](https://github.com/GerevAI/gerev) - ChatGPT search engine for workplaces.
- [ChatGPTify](https://github.com/idilsulo/ChatGPTify) - Spotify playlist generator via ChatGPT.
- [PlaticaBot](https://github.com/migueldeicaza/PlaticaBot) - A ChatGPT app for MacOS, iPhone and WatchOS.
- [gpt4-pdf-chatbot-langchain](https://github.com/mayooear/gpt4-pdf-chatbot-langchain) - GPT4 & LangChain Chatbot for large PDF docs.
- [jasper-alternative-gpt](https://github.com/yuvalsuede/jasper-alternative-gpt) - A Jasper alternative open source with ChatGPT
- [BingGPT](https://github.com/dice2o/BingGPT) - Desktop application of new Bing's AI-powered chat (Windows, macOS and Linux).
- [nextjs-chatgpt-app](https://github.com/enricoros/nextjs-chatgpt-app) - Responsive chat application powered by OpenAI's GPT-4, with response streaming, code highlighting, various presets for developers. Using Next.js, React, Joy.
- [chatgpt-web](https://github.com/Niek/chatgpt-web) - ChatGPT web interface using the OpenAI API.
- [BetterChatGPT](https://github.com/ztjhz/BetterChatGPT) - Play and chat smarter with BetterChatGPT - an amazing open-source web app with a better UI for exploring OpenAI's ChatGPT API!
- [storyteller](https://github.com/jaketae/storyteller) - Multimodal AI Story Teller, built with Stable Diffusion, GPT, and neural text-to-speech.
- [generative-manim](https://github.com/360macky/generative-manim) - GPT-4 for video generation.
- [summ](https://github.com/yasyf/summ) - GPT-based Conversation Summarizer.
- [roomGPT](https://github.com/Nutlope/roomGPT) - Upload a photo of your room to generate your dream room with AI.
- [scrapeghost](https://github.com/jamesturk/scrapeghost) - Experimental library for scraping websites using OpenAI's GPT API.
- [browser-agent](https://github.com/m1guelpf/browser-agent) - A browser AI agent, using GPT-4.
- [TimeGPT](https://github.com/Spiderpig86/TimeGPT) - AI-powered time and dates.
- [HealthGPT](https://github.com/StanfordBDHG/HealthGPT) - Query your Apple Health data with natural language.

## Integration
- [nuxt-chatgpt](https://github.com/SchnapsterDog/nuxt-chatgpt) - ChatGPT integration for Nuxt 3.
- [ChatGptNet](https://github.com/marcominerva/ChatGptNet) - A ChatGPT integration library for .NET.
- [react-native-chatgpt](https://github.com/rgommezz/react-native-chatgpt) - A React Native wrapper around ChatGPT to seamlessly integrate it with your applications. It handles authentication, streamed responses, and keeping track of conversations. 100% client-side.
- [Quest](https://github.com/farrael004/Quest) - This is a web app that integrates GPT-3 with google searches.
- [gptel](https://github.com/karthink/gptel) - A no-frills ChatGPT client for Emacs.
- [ChatGPT-Xcode](https://github.com/fitomad/ChatGPT-Xcode) - Integrate ChatGPT in Xcode using a Xcode Source Editor Extension.
- [VisualChatGPTStudio](https://github.com/jeffdapaz/VisualChatGPTStudio) - Add chatGPT functionalities directly on Visual Studio.
- [chatgpt-md](https://github.com/bramses/chatgpt-md) - A (nearly) seamless integration of ChatGPT into Obsidian.
- [AICommand](https://github.com/keijiro/AICommand) - ChatGPT integration with Unity Editor.
- [gpt-anywhere](https://github.com/JinayJain/gpt-anywhere) - Use GPT anywhere with just one shortcut. Available for Mac, Windows, and Linux.
- [vim-ai](https://github.com/madox2/vim-ai) - Complete text, generate code and chat with GPT in Vim/Neovim using OpenAI.
- [filippofinke](https://github.com/filippofinke/WordGPT) - Bring the power of ChatGPT to Microsoft Word.
- [CodeGPT.nvim](https://github.com/dpayne/CodeGPT.nvim) - A plugin for neovim that provides commands to interact with ChatGPT.
- [backseat.nvim](https://github.com/james1236/backseat.nvim) - A neovim plugin that uses GPT to highlight and explain code readability issues.
- [MatGPT](https://github.com/toshiakit/MatGPT) - MATLAB app and class to access ChatGPT API from OpenAI.
- [Integrate-ChatGPT-in-Excel-using-VBA](https://github.com/Sven-Bo/Integrate-ChatGPT-in-Excel-using-VBA) - Revolutionize your spreadsheet game with OpenAI's ChatGPT in Microsoft Excel using my custom VBA code.
- [word-GPT-Plus](https://github.com/Kuingsmile/word-GPT-Plus) - A word add-in which integrates the chatGPT model into Microsoft Word. Both official and web api is supported.
- [BlenderGPT](https://github.com/gd3kr/BlenderGPT) - Use commands in English to control Blender with OpenAI's GPT-4.
- [JavaGPT](https://github.com/FrankCYB/JavaGPT) - A Java GUI that interfaces ChatGPT API.
- [DelphiOpenAI](https://github.com/HemulGM/DelphiOpenAI) - OpenAI API client for Delphi. Use ChatGPT, DALL-E and other products.

## CLI
- [Best Tools To Interact With ChatGPT In CLI](https://www.scriptbyai.com/best-chatgpt-cli-tools/) - 10 best and free CLI tools for ChatGPT: streamline your workflow, enhance your conversational AI experience, and unlock new opportunities with these powerful resources.
- [askai](https://github.com/yudax42/askai) - A command-line interface for OpenAI ChatGPT.
- [chatgpt-api](https://github.com/mbroton/chatgpt-api) - ChatGPT HTTP API Client and CLI.
- [chatgpt](https://github.com/kkdai/chatgpt) - ChatGPT Console client in Golang.
- [search](https://github.com/visualbasic6/search) - A cli google client written by ai (chatgpt) that bypasses captcha and rate limiting by using the google alerts "preview" feature.
- [StackExplain](https://github.com/shobrook/stackexplain) - Explain your error message in plain English using ChatGPT. 
- [assistant-cli](https://github.com/diciaup/assistant-cli) - A comfortable CLI tool to use ChatGPT service.
- [cligpt](https://github.com/paij0se/cligpt) - chat-gpt but in the terminal.
- [go-assistant](https://github.com/halilylm/go-assistant) - CLI App interacting with ChatGPT.
- [terminalGPT](https://github.com/jucasoliveira/terminalGPT) - Get GPT like chatGPT on your terminal.
- [chatGPT-shell-cli](https://github.com/0xacx/chatGPT-shell-cli) - Simple shell script to use OpenAI's chatGPT and DALL-E from the terminal.
- [chatgpt_cli](https://github.com/zawawiAI/chatgpt_cli) - This script allows you to use OpenAI in your CLIs tested on Linux terminal, Mac Terminal and Windows Command Prompt.
- [shellgpt](https://github.com/kpatronas/shellgpt) - Query chatgpt from your shell.
- [Houston](https://github.com/npgrosser/Houston) - An AI Assistant and Script Generator for your Terminal, which enables you to accomplish a wide range of tasks with simple, natural language instructions.
- [gpt_cli](https://github.com/zawawiAI/gpt_cli) - This script allows you to use OpenAI in your CLIs tested on Linux terminal, Mac Terminal and Windows Command Prompt.
- [AiShell](https://github.com/code-yeongyu/AiShell) - A simple Python code that connects to OpenAI's ChatGPT and executes the returned results.
- [gpt-chatbot-cli](https://github.com/slithery0/gpt-chatbot-cli) - It's a very minimal cli prompt, where you can chat and keeping the conversation session momoriable by chatgpt.
- [mindflow-cli](https://github.com/nollied/mindflow-cli) - Conversate with your code directly from the command line or Visual Studio Code. Powered by ChatGPT!
- [ata](https://github.com/rikhuijzer/ata) - Ask the Terminal Anything (ATA): OpenAI GPT in the terminal.
- [openai-chatgpt](https://github.com/gmpetrov/openai-chatgpt) - Use ChatGPT from the terminal.
- [chatgpt](https://github.com/verdverm/chatgpt) - CLI application for working with ChatGPT. Interactive or file based session with context and moods.
- [DirectAI](https://github.com/ustayready/DirectAI) - ChatGPT queries via OpenAI API in your terminal.
- [aicommits](https://github.com/Nutlope/aicommits) - A CLI that writes your git commit messages for you with AI.
- [command_line_chatgpt](https://github.com/atomic14/command_line_chatgpt) - A command line chat bot using the ChatGPT API from OpenAI.
- [gptcli](https://github.com/evilpan/gptcli) - ChatGPT in command line with gpt-3.5-turbo api.
- [chatgpt](https://github.com/j178/chatgpt) - Cli for ChatGPT.
- [shell_gpt](https://github.com/TheR1D/shell_gpt) - A command-line productivity tool powered by ChatGPT, will help you accomplish your tasks faster and more efficiently.
- [aichat](https://github.com/sigoden/aichat) - Chat with ChatGPT-3.5 in the terminal.
- [command-ai](https://github.com/amachino/command-ai) - AI chatbot in your terminal, powered by OpenAI API.
- [loz](https://github.com/joone/loz) - A command-line interface tool based on ChatGPT that allows Unix pipes to be used with other Unix tools.
- [chatgpt_cli](https://github.com/mansimov/chatgpt_cli) - Lightweight wrapper of the official ChatGPT API in your terminal
- [gogpt](https://github.com/Nemoden/gogpt) - ChatGPT. In your terminal!
- [PowerGPT](https://github.com/ouromoros/PowerGPT) - Do anything in Windows PowerShell using natural language
- [ai.py](https://github.com/reorx/ai.py) - Single-file Python script that helps you get answers from ChatGPT API in the command line.
- [heygpt](https://github.com/fuyufjh/heygpt) - A simple common-line interface for ChatGPT API.
- [linux-command-gpt](https://github.com/asrul10/linux-command-gpt) - Get Linux commands in natural language with the power of ChatGPT.
- [CodeGPT](https://github.com/appleboy/CodeGPT) - A CLI written in Go language that writes git commit messages for you using ChatGPT AI (gpt-3.5-turbo model) and automatically installs a git prepare-commit-msg hook.
- [ChatGPTerminator](https://github.com/AineeJames/ChatGPTerminator) - ChatGPT in the terminal!
- [AskGPT](https://github.com/praeclarum/AskGPT) - Ask ChatGPT questions from the command line.
- [gpt-cli](https://github.com/CristiVlad25/gpt-cli) - Access GPT3, ChatGPT, and GPT4 straight from your terminal.
- [gpt-cli](https://github.com/kharvd/gpt-cli) - Command-line interface for ChatGPT.
- [search-gpt](https://github.com/tobiasbueschel/search-gpt) - Connecting ChatGPT with the Internet.
- [gptc](https://github.com/junyu-w/gptc) - Supercharge your CLI with the power of OpenAI's GPT model (and other models too!)
- [clevercli](https://github.com/clevercli/clevercli) - ChatGPT powered CLI utilities. Easily add new prompt types in ~/.clevercli/
- [opencommit](https://github.com/di-sukharev/opencommit) - GPT CLI to auto-generate impressive commits in 1 second.
- [cligpt](https://github.com/Luanf/cligpt) - Terminal autocomplete integation with GPT.
- [gptchat](https://github.com/ian-kent/gptchat) - A GPT-4 client which gives your favourite AI a memory and tools for self-improvement.
- [promptr](https://github.com/ferrislucas/promptr) - A CLI tool for operating on your codebase using GPT. Promptr dynamically includes one or more files into your GPT prompts, and it can optionally parse and apply the changes that GPT suggests to your codebase. Several prompt templates are included for various purposes, and users can create their own templates.
- [fjrdomingues](https://github.com/fjrdomingues/autopilot) - Autopilot is an AI tool that utilizes GPT to read a codebase, create context, and solve tasks that you request.
- [gpt-4-search](https://github.com/andylokandy/gpt-4-search) - A command line GPT-4 REPL with Google search in 200 lines of code.
- [ShellGPT](https://github.com/mattvr/ShellGPT) - A command-line tool that allows you to interact with GPT-4 directly from your terminal.
- [ai-shell](https://github.com/BuilderIO/ai-shell) - A CLI that converts natural language to shell commands.
- [aider](https://github.com/paul-gauthier/aider) - GPT-4 powered coding in your terminal.
- [gpt-cli](https://github.com/TheLime1/gpt-cli) - A command-line interface chatbot. It allows you to have interactive conversations with different bots, including GPT4 FOR FREE.
- [cli](https://github.com/promptops/cli) - A GPT-powered CLI assistant. Ask questions in plain English, get the perfect shell command.
- [aicmd](https://github.com/atinylittleshell/aicmd) - A CLI program that allows you to run shell commands using nautral language.
- [Houston](https://github.com/npgrosser/Houston) - An GPT-based Terminal Assistant. It allows you to accomplish a wide range of tasks by giving simple, natural language instructions. It supports providing context information to help it complete tasks in a more meaningful way.

## Prompts
- [20 Best ChatGPT Prompts For SEO](https://www.scriptbyai.com/best-chatgpt-prompts-seo/) - Harness the power of AI: 20 must-use ChatGPT prompts for mastering SEO.
- [awesome-chatgpt-prompts](https://github.com/f/awesome-chatgpt-prompts) - Some ChatGPT prompts that works well.
- [ChatGPT-Prompts](https://github.com/yokoffing/ChatGPT-Prompts) - ChatGPT prompt curation to use ChatGPT better.
- [awesome-chatgpt-suggestions](https://github.com/aminblm/awesome-chatgpt-suggestions) - List of prompts for chatGPT for various assistances with tasks.
- [ChatGPT-Prompts-In-50Languages](https://github.com/TarrySingh/ChatGPT-Prompts-In-50Languages) - Awesome ChatGPT Prompt in 50 Languages.
- [ChatGPT-Prompts](https://github.com/PrathamKumar14/ChatGPT-Prompts) - AI is taking over slowly. Here are some use ChatGPT/API prompts that help you unlock 100% of your productivity.
- [chatgpt-prompts](https://github.com/pacholoamit/chatgpt-prompts) - A collection of 140+ amazing and useful prompts for GPT-3
- [ChatGPT3-Free-Prompt-List](https://github.com/mattnigh/ChatGPT3-Free-Prompt-List) - Guide and framework for creating ChatGPT3 Prompts.
- [gpt-jailbreaks](https://github.com/malaya-zemlya/gpt-jailbreaks) - A repository of methods of bypassing GPT and ChatGPT content filters.
- [ChatGPT-Data-Science-Prompts](https://github.com/travistangvh/ChatGPT-Data-Science-Prompts) - A repository of 60 useful data science prompts for ChatGPT
- [Instructgpt-prompts](https://github.com/kevinamiri/Instructgpt-prompts) - A collection of ChatGPT and GPT-3.5 instruction-based prompts for generating and classifying text.
- [promptlib](https://github.com/jmpaz/promptlib) - A collection of prompts and wrappers for ChatGPT & GPT-3.
- [ChatGPT-MidJourney-prompt](https://github.com/awekrx/ChatGPT-MidJourney-prompt) - A ChatGPT based prompt generation model for MidJorney. 
- [click-prompt](https://github.com/prompt-engineering/click-prompt) - Streamline your prompt design, with ClickPrompt, you can easily view, share, and run these prompts with just one click. 
- [markprompt](https://github.com/motifland/markprompt) - Open-source GPT-4 platform for Markdown, Markdoc and MDX with built-in analytics
- [prompt-layer-library](https://github.com/MagnivOrg/prompt-layer-library) - Maintain a log of your prompts and OpenAI API requests. Track, debug, and replay old completions. 
- [ora-sh](https://github.com/ora-sh/Awesome-GPT4-Prompts) - A collection of awesome GPT4 prompts.
- [SourceGPT](https://github.com/NightmareLab/SourceGPT) - Prompt manager and source code analyzer built on top of ChatGPT as the oracle
- [ChatGPT 500 Prompts](https://www.linkedin.com/pulse/chatgpt-500-prompts-make-you-top-1-copywriter-alexis-khvatov-) - ChatGPT 500 Prompts To Make You a Top 1% Copywriter
- [gpt-prompt-engineer](https://github.com/mshumer/gpt-prompt-engineer) - Simply input a description of your task and some test cases, and the system will generate, test, and rank a multitude of prompts to find the ones that perform the best.

## Misc
- [chatgpt-python](https://github.com/labteral/chatgpt-python) - Unofficial Python SDK for OpenAI's ChatGPT.
- [DAILA](https://github.com/mahaloz/DAILA) - Decompiler Artifical Intelligence Language Assistant: Use ChatGPT for a improved Decompilation Experience.
- [chatgpt-conversation](https://github.com/platelminto/chatgpt-conversation) - Have a conversation with ChatGPT using your voice, and have it talk back.Decompilation Experience.
- [chat-gpt-ppt](https://github.com/williamfzc/chat-gpt-ppt) - use ChatGPT to generate PPT automatically.
- [gptlang](https://github.com/forrestchang/gptlang) - A new programming language running in ChatGPT.
- [chatgpt-exporter](https://github.com/pionxzh/chatgpt-exporter) - Export and Share your ChatGPT conversation history.
- [Alice](https://github.com/greshake/Alice) - Giving ChatGPT access to a real terminal.
- [chatgpt-action](https://github.com/kxxt/chatgpt-action) - Let ChatGPT review PRs for you.
- [ChatGPT Matrix Style](https://github.com/lvwzhen/ChatGPT-Matrix-Style) - Make ChatGPT like the Matrix.
- [ChatARKit](https://github.com/trzy/ChatARKit) - Using ChatGPT to Create AR Experiences with Natural Language
- [chat-gpt](https://github.com/jcubic/chat-gpt) - ChatGPT conversation saving bookmark.
- [chatgpt-clone](https://github.com/EyuCoder/chatgpt-clone) - A ChatGPT Clone with DALL.E using OpenAIs text-davinci-003 and image generation Model.
- [chatgpt-go](https://github.com/chatgp/chatgpt-go) - Chatgpt sdk writen by golang.
- [chatgpt-github-actions](https://github.com/cirolini/chatgpt-github-actions) - This project aims to automate code review using the ChatGPT language model. It integrates with Github Actions, and upon receiving a Pull Request, it automatically sends each code review to ChatGPT for an explanation.
- [voice_chatgpt](https://github.com/nickbild/voice_chatgpt) - VoiceGPT is a voice assistant that leverages the powerful ChatGPT chatbot to answer your questions. You speak the requests, and VoiceGPT responds with realistic, synthesized speech.
- [OpenAI-Checker](https://github.com/missuo/OpenAI-Checker) - Used to check if your IP can access OpenAI services.
- [ChatGPT-Proxy](https://github.com/acheong08/ChatGPT-Proxy) - Forward requests and inject CloudFlare cookies
- [chatpad](https://github.com/deiucanta/chatpad) - Premium quality UI for ChatGPT
- [chatgpt-backup](https://github.com/abacaj/chatgpt-backup) - Single client side script to backup your entire ChatGPT conversation history.
- [openai-gpt4](https://github.com/xtekky/openai-gpt4) - Free gpt4 / gpt3.5 access through several reverse engineered api's (nat.dev, poe.com, t3nsor.com etc...)
- [toolkit-ai](https://github.com/hey-pal/toolkit-ai) - AI-agents that automatically generate and use Langchain Tools and ChatGPT plugins
- [GPTCache](https://github.com/zilliztech/GPTCache) - A library for creating semantic cache to store responses from LLM queries.
- [infiniteGPT](https://github.com/emmethalm/infiniteGPT) - A Python script that lets you input an unlimited size text into the OpenAI API. No more tedious copy & pasting. Long live multithreading!
- [Best And Free AI Content Detector Tools](https://www.scriptbyai.com/best-free-ai-content-detectors/) - 5 best and free AI content detection tools to verify the authenticity of online content.
- [Timeline Of ChatGPT](https://github.com/jqueryscript/chatgpt-timeline) - A timeline of ChatGPT: major events, milestones, controversies, etc.
- [awesome-chatgpt-plugins](https://github.com/jqueryscript/awesome-chatgpt-plugins) - An awesome & curated list of best plugins for ChatGPT.
