import fs from "node:fs/promises";

async function generateFixture() {
	const fixture = await fs.readFile( "./test/data/qunit-fixture.html", "utf8" );
	await fs.writeFile(
		"./test/data/qunit-fixture.js",
		"// Generated by build/tasks/qunit-fixture.js\n" +
		"QUnit.config.fixture = " +
			JSON.stringify( fixture.replace( /\r\n/g, "\n" ) ) +
		";\n"
	);
	console.log( "Updated ./test/data/qunit-fixture.js" );
}

generateFixture();
