<?php
/**
 * 作用：接口处理程序
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

final class cms_api
{
    private $db;
    function __construct()
    {
        $this->db=cms::$db;
    }

    #后台日志记录
    function log($msg='')
    {
        if(getint(config('admin_log_admin'))==0)
        {
            return;
        }
        $arr=[];
        $url=str_replace(WEB_URL,'',THIS_LOCAL);
        $url=rawurldecode($url);
        $encode=mb_detect_encoding($url,['UTF-8','GBK','GB2312']);
        if($encode!='UTF-8')
        {
            $url=mb_convert_encoding($url,'utf-8',$encode);   
        }
        $arr['ip']=getip();
        $arr['title']=get_admin_info('adminname');
        $arr['msg']=cut(enhtml($msg),255);
        $arr['createdate']=time();
        $arr['url']=cut(enhtml($url),255);
        $this->db->add('cms_admin_log',$arr);
    }

    function encode($a,$b='nicemb.com')
    {
        if($a=='')
        {
            return '';
        }
        $pre=($b!='')?$b:config('prefix');
        return authcode(E($a),'E',$pre);
    }
    
    function decode($a,$b='nicemb.com')
    {
        if($a=='')
        {
            return '';
        }
        $pre=($b!='')?$b:config('prefix');
        $a=D(authcode($a,'D',$pre));
        $a=$a?$a:[];
        return $a;
    }

    #微信访问自动获取Openid
    function get_openid()
    {
        if(isweixin() && getint(config('weixin_openid'))==1)
        {
            #自定义加密解密key，可以留空
            $key=md5($_SERVER['HTTP_HOST']);
            if(S('openid')=='')
            {
                if(F('get.openid')=='')
                {
                    $backurl=THIS_LOCAL;
                    if(F('get.backurl')!='')
                    {
                        $backurl=F('get.backurl');
                    }
                    $backkey=F('get.backkey');
                    S('backurl',$backurl);
                    S('backkey',$backkey);
                    $openid_url=config('weixin_openid_url');
                    if($openid_url=='')
                    {
                        $openid_url=U('pay/index/openid');
                    }
                    else
                    {
                        $openid_url=trim($openid_url,"/")."/?backkey=".$key."&backurl=".WEB_URL.THIS_LOCAL;
                    }
                    G($openid_url);
                    return;
                }
                else
                {
                    $backkey=F('get.backkey');
                    if($backkey=='')
                    {
                        $openid=F('get.openid');
                        $unionid=F('get.unionid');
                    }
                    else
                    {
                        $str=F('get.openid');
                        if($backkey==$key)
                        {
                            $str=$this->decode(base64_decode($str),$key);
                            list($openid,$unionid)=explode("||",$str,2);
                        }
                    }
                    S('openid',$openid);
                    S('unionid',$unionid);
                }
            }
            else
            {
                if(F('get.backurl')!='')
                {
                    $backurl=F('get.backurl');
                    S('backurl',$backurl);
                }
            }
            $backurl=S('backurl');
            if($backurl!='' && strpos($backurl,'://'))
            {
                S('backurl','[del]');
                $backurl=$backurl.'?openid='.S('openid').'&unionid='.S('unionid');
                G($backurl);
            }
        }
    }

    #支付业务处理
    function paycall($orderid,$type,$trade_no)
    {
        $rs=$this->db->row("select order_id,ispay,goods_id,goods_num,issales,order_total,mobile from cms_order where order_no='$orderid' and ispay=0 limit 1");
        if($rs)
        {
            $order_id=$rs['order_id'];
            $order_total=$rs['order_total'];
            $mobile=$rs['mobile'];
            if($rs['issales']==0)
            {
                $goods_id=$rs['goods_id'];
                $goods_num=$rs['goods_num'];
                $rg=$this->db->row("select tsales from cms_goods where id=$goods_id limit 1");
                if($rg)
                {
                    $this->db->update("cms_goods","id=$goods_id",['tsales'=>($rg['tsales']+$goods_num)]);
                }
            }
            $this->db->update("cms_order","order_id=$order_id",['ispay'=>1,'paydate'=>time(),'payway'=>$type,'trade_no'=>$trade_no]);

            #通知客户付款成功
            if(getint(config('sms_ispay'))==1 && config('sms_state')!='')
            {
                cms_app::init('sms');
                cms_app::send($mobile,'order_pay_user',['orderid'=>$orderid,'money'=>$order_total]);
            }
            
            #提醒管理员发货
            if(getint(config('sms_ispost'))==1 && config('sms_state')!='')
            {
                cms_app::init('sms');
                cms_app::send(config('sms_admin'),'order_pay',['orderid'=>$orderid,'money'=>$order_total]);
            }
            
        }
    }
     
}