<?php defined('IN_CMS') or die();?><!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="renderer" content="webkit">
<meta http-equiv="Cache-Control" content="no-siteapp"/>
<title>在线安装程序_参数配置</title>
<link rel="stylesheet" href="public/css/ui.css">
<link rel="stylesheet" href="app/install/view/css/app.css">
<script src="public/js/jq.js"></script>
<script src="public/js/ui.js"></script>
</head>

<body>

    <form class="ui-form" method="post">
    <div id="step" class="width ui-mt-50"></div>
    
    <div class="width inner_container">
        <div class="install">
            <div class="ui-menu blue ui-mb-30">
                <div class="ui-menu-name ui-bold">数据库配置</div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">数据库地址：</label>
                <div class="ui-col-6">
                	<div class="ui-input-group">
                        <input type="text" name="t0" id="t0" class="ui-form-ip radius-right-none" maxlength="50" data-rule="数据库地址:required;">
                        <span class="after blue"><input type="text" name="t1" maxlength="8" value="3306" data-rule="端口:required;"></span>
                    </div>
                    <div class="ui-mt">同一服务器请填写：127.0.0.1，<a href="javascript:;" class="ui-text-red" onClick="$('#t0').val('127.0.0.1')">一键填写</a></div>
                </div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">数据库名：</label>
                <div class="ui-col-6"><input type="text" name="t2" class="ui-form-ip" maxlength="50" data-rule="数据库名:required;"></div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">数据库账号：</label>
                <div class="ui-col-6"><input type="text" name="t3" class="ui-form-ip" maxlength="50" data-rule="数据库账号:required;"></div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">数据库密码：</label>
                <div class="ui-col-6"><input type="text" name="t4" class="ui-form-ip" maxlength="50" data-rule="数据库密码:required;"></div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">表前缀：</label>
                <div class="ui-col-6">
                	<div class="ui-input-group">
                        <input type="text" name="t5" class="ui-form-ip radius-right-none" value="cms_" maxlength="50" data-rule="表前缀:required;">
                        <span class="after">通常无需修改</span>
                    </div>
                </div>
            </div>
            
            <div class="ui-menu blue ui-mt-30 ui-mb-30">
                <div class="ui-menu-name ui-bold">管理员配置</div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">用户名：</label>
                <div class="ui-col-6"><input type="text" name="t6" class="ui-form-ip" maxlength="20" placeholder="请输入用户名" data-rule="用户名:required;username;"></div>
            </div>
            <div class="ui-form-group ui-row">
                <label class="ui-col-2 ui-pt ui-pr ui-text-right ui-text-gray">密码：</label>
                <div class="ui-col-6"><input type="text" name="t7" class="ui-form-ip" maxlength="20" placeholder="请输入密码（5-20位字符）" data-rule="密码:required;password"></div>
            </div>
            <input type="hidden" name="token" value="{$token}">
            <div class="ui-text-center ui-mt-20"><button type="button" class="ui-btn ui-mr" onClick="location.href='{U("check")}'">上一步</button><button type="submit" id="ui-submit" class="ui-btn blue">下一步</button></div>
        </div>
        
    </div>
    </form>

    <!--[if lt IE 9]>
    <div class="notsupport">
        <h1>:( 非常遗憾</h1>
        <h2>您的浏览器版本太低，请升级您的浏览器</h2>
    </div>
    <![endif]-->
    <script>
	$(function()
	{
		$("#step").step({data:['安装协议','环境检测','参数配置','安装结果'],index:3});
		$(".ui-form").form(
		{
			type:2,
			align:'center',
			result:function(form)
			{
				ui.loading("正在安装，请稍候");
				$("#ui-submit").attr("disabled",true);
				$.ajax(
				{
					type:'post',
					cache:false,
					dataType:'json',
					url:'{THIS_LOCAL}',
					data:$(form).serialize(),
					error:function(e)
					{
						$.progress('close');
						$("#ui-submit").attr("disabled",false);
						alert('数据库链接失败'+e.responseText);
					},
					success:function(d)
					{
						$.progress('close');
						$("#ui-submit").attr("disabled",false);
						if(d.state=='success')
						{
							setTimeout(function(){location.href='{U("result")}';},500);
						}
						else
						{
							ui.error(d.msg);
						}
					}
				});
			}
		});
	})
	</script>
</body>
</html>