SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for cms_ad
-- ----------------------------
DROP TABLE IF EXISTS `cms_ad`;
CREATE TABLE `cms_ad` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `isshow` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_ad
-- ----------------------------

-- ----------------------------
-- Table structure for cms_admin
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin`;
CREATE TABLE `cms_admin` (
  `adminid` int(10) NOT NULL AUTO_INCREMENT,
  `adminname` varchar(50) DEFAULT '',
  `adminpass` varchar(50) DEFAULT '',
  `penname` varchar(20) DEFAULT '',
  `pid` int(10) DEFAULT '0',
  `logintimes` int(10) DEFAULT '0',
  `lastlogindate` bigint(10) DEFAULT '0',
  `lastloginip` varchar(50) DEFAULT '',
  `readonly` smallint(1) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`adminid`),
  KEY `adminname` (`adminname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_admin
-- ----------------------------

-- ----------------------------
-- Table structure for cms_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_log`;
CREATE TABLE `cms_admin_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `msg` varchar(255) DEFAULT '',
  `ip` varchar(50) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_admin_log
-- ----------------------------

-- ----------------------------
-- Table structure for cms_admin_login_log
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_login_log`;
CREATE TABLE `cms_admin_login_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `loginname` varchar(50) DEFAULT '',
  `loginip` varchar(50) DEFAULT '',
  `logindate` bigint(10) DEFAULT '0',
  `loginmsg` varchar(255) DEFAULT '',
  `loginstate` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_admin_login_log
-- ----------------------------

-- ----------------------------
-- Table structure for cms_admin_menu
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_menu`;
CREATE TABLE `cms_admin_menu` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `cname` varchar(50) DEFAULT '',
  `aname` varchar(50) DEFAULT '',
  `dname` varchar(255) DEFAULT '',
  `icon` varchar(50) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_admin_menu
-- ----------------------------
INSERT INTO `cms_admin_menu` VALUES ('1', '网站', '', '', '', 'ui-icon-setting', '0', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('2', '商品', '', '', '', 'ui-icon-shopping', '0', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('3', '订单', '', '', '', 'ui-icon-filter', '0', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('4', '报表', '', '', '', 'ui-icon-barchart', '0', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('5', '应用', '', '', '', 'ui-icon-appstore', '0', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('6', '系统', '', '', '', 'ui-icon-windows', '0', '11', '1');
INSERT INTO `cms_admin_menu` VALUES ('7', '网站设置', 'config', 'index', '', '', '1', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('8', '接口设置', 'configapi', 'index', '', '', '1', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('9', '部门管理', 'adminpart', 'index', '', '', '1', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('10', '后台用户', 'admin', 'index', '', '', '1', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('11', '商品分类', 'goodsclass', 'index', '', '', '2', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('12', '商品管理', 'goods', 'index', '', '', '2', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('13', '回收站', 'goodsrecycle', 'index', '', '', '2', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('14', '订单管理', 'order', 'index', '', '', '3', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('15', '回收站', 'orderrecycle', 'index', '', '', '3', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('16', '收入统计', 'count', 'index', '', '', '4', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('17', '订单统计', 'countorder', 'index', '', '', '4', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('18', '渠道统计', 'countfrom', 'index', '', '', '4', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('19', '模板管理', 'theme', 'index', '', '', '5', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('20', '插件管理', 'plug', 'index', '', '', '5', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('21', '设置分组', 'configgroup', 'index', '', '', '6', '1', '1');
INSERT INTO `cms_admin_menu` VALUES ('22', '后台菜单', 'adminmenu', 'index', '', '', '6', '3', '1');
INSERT INTO `cms_admin_menu` VALUES ('23', '管理日志', 'log', 'index', '', '', '6', '5', '1');
INSERT INTO `cms_admin_menu` VALUES ('24', '错误日志', 'logerror', 'index', '', '', '6', '7', '1');
INSERT INTO `cms_admin_menu` VALUES ('25', '缓存管理', 'cache', 'index', '', '', '6', '9', '1');
INSERT INTO `cms_admin_menu` VALUES ('26', '轮播图片', 'ad', 'index', '', '', '1', '5', '1');

-- ----------------------------
-- Table structure for cms_admin_part
-- ----------------------------
DROP TABLE IF EXISTS `cms_admin_part`;
CREATE TABLE `cms_admin_part` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `page_list` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_admin_part
-- ----------------------------

-- ----------------------------
-- Table structure for cms_alias
-- ----------------------------
DROP TABLE IF EXISTS `cms_alias`;
CREATE TABLE `cms_alias` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `alias` varchar(50) DEFAULT '',
  `app` varchar(50) DEFAULT '',
  `sid` int(10) DEFAULT '0',
  `types` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_alias
-- ----------------------------

-- ----------------------------
-- Table structure for cms_auth
-- ----------------------------
DROP TABLE IF EXISTS `cms_auth`;
CREATE TABLE `cms_auth` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ckey` varchar(50) DEFAULT '',
  `cval` text,
  `cdate` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_auth
-- ----------------------------

-- ----------------------------
-- Table structure for cms_class
-- ----------------------------
DROP TABLE IF EXISTS `cms_class`;
CREATE TABLE `cms_class` (
  `cateid` int(10) NOT NULL AUTO_INCREMENT,
  `cate_name` varchar(255) DEFAULT '',
  `cate_pic` varchar(255) DEFAULT '',
  `cate_order` int(10) DEFAULT '0',
  `cate_show` smallint(1) DEFAULT '0',
  `cate_url` varchar(255) DEFAULT '',
  `cate_title` varchar(255) DEFAULT '',
  `cate_key` varchar(255) DEFAULT '',
  `cate_desc` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_class
-- ----------------------------

-- ----------------------------
-- Table structure for cms_config
-- ----------------------------
DROP TABLE IF EXISTS `cms_config`;
CREATE TABLE `cms_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gid` int(10) DEFAULT '0',
  `ckey` varchar(50) DEFAULT '',
  `ctitle` varchar(50) DEFAULT '',
  `cvalue` text,
  `ordnum` int(10) DEFAULT '0',
  `ctype` int(11) DEFAULT '0',
  `dvalue` text,
  `dtext` text,
  `rtype` smallint(1) DEFAULT '0',
  `utype` smallint(1) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  `issys` smallint(1) DEFAULT '0',
  `ishide` smallint(1) DEFAULT '0',
  `field_table` varchar(255) DEFAULT '',
  `field_join` varchar(255) DEFAULT '',
  `field_where` varchar(255) DEFAULT '',
  `field_order` varchar(255) DEFAULT '',
  `field_value` varchar(255) DEFAULT NULL,
  `field_label` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ckey` (`ckey`),
  KEY `gid` (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_config
-- ----------------------------
INSERT INTO `cms_config` VALUES ('1', '1', 'web_line', '网站设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('2', '1', 'web_open', '网站开关', '1', '3', '6', '开启|1,关闭|0', '关闭后前台无法访问，后台不影响使用', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('3', '1', 'web_close', '关闭原因', '临时维护，请稍候访问。', '5', '5', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('4', '1', 'web_name', '网站名称', '微商城订单系统', '7', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('5', '1', 'web_logo', '网站Logo', '/upfile/logo.png', '9', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('6', '1', 'web_count', '统计代码', '', '11', '10', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('7', '1', 'domain_line', '域名设置', '', '13', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('8', '1', 'domain_http', 'Http类型', 'http://', '15', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('9', '1', 'domain_main', '主域名', '', '17', '1', '', '例：www.baidu.com，可以为空', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('10', '1', 'domain_other', '副域名', '', '19', '5', '', '一行一条，格式：www.baidu.com 或 baidu.com，副域名会自动跳转到主域名', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('11', '1', 'beian_line', '备案设置', '', '21', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('12', '1', 'beian_icp', 'ICP备案号', '', '23', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('13', '1', 'ga_num', '公安备案号', '', '25', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('14', '1', 'ga_url', '公安备案链接', '', '27', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('15', '1', 'ct_line', '联系方式', '', '29', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('16', '1', 'ct_tel', '客服电话', '', '31', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('17', '1', 'ct_weixin', '微信二维码', '', '33', '4', '', '上传微信二维码，方便客户加好友', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('18', '2', 'url_mode_line', 'Url设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('19', '2', 'url_mode', 'Url模式', '1', '3', '6', '调试模式（例: /?m=home）|1,Path_Info模式（例: /index.php/news.html）|2,伪静态模式（例: /news.html）|3', '建议伪静态模式（需要上传或配置伪静态规则）', '2', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('20', '2', 'url_mid', 'Url间隔符', '/', '5', '8', '/|/,_|_', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('21', '2', 'url_ext', 'Url后缀', '.html', '7', '8', '无后缀|,/|/,.html|.html', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('22', '2', 'seo_line', 'SEO设置', '', '9', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('23', '2', 'web_title', '自定义标题', '', '11', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('24', '2', 'web_key', '关键字', '', '13', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('25', '2', 'web_desc', '描述', '', '15', '5', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('26', '2', 'seo_mid', '间隔符号', ' - ', '17', '1', '', '标题间隔符', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('27', '3', 'upload_way', '存储方式', 'local', '1', '11', '', '', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;upload&#039;', 'id desc', 'root', 'name');
INSERT INTO `cms_config` VALUES ('28', '3', 'upload_line', '上传设置', '', '3', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('29', '3', 'upload_max', '最大上传', '20', '5', '1', '', '单位：M', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('30', '3', 'upload_slice', '分片大小', '2', '7', '1', '', '单位：M，为0时不分片', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('31', '3', 'upload_file_folder', '存放路径', '2', '9', '8', '年/文件名|1,年/月/文件名|2,年/月/日/文件名|3', '', '2', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('32', '3', 'thumb_line', '图片压缩', '', '11', '0', '', '云存储分片时无效', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('33', '3', 'thumb_open', '压缩开关', '0', '13', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('34', '3', 'thumb_min', '压缩宽度', '800', '15', '1', '', '图片会被压缩成这个宽度', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('35', '3', 'thumb_piclist', '组图压缩', '0', '17', '6', '开始|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('36', '3', 'water_line', '图片水印', '', '19', '0', '', '云存储分片时无效', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('37', '3', 'water_open', '水印开关', '0', '21', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('38', '3', 'water_width', '最小宽度', '400', '23', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('39', '3', 'water_height', '最小高度', '300', '25', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('40', '3', 'water_opacity', '透明度', '60', '27', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('41', '3', 'water_position', '水印位置', '5', '29', '8', '随机显示|0,顶部居左|1,顶部居中|2,顶部居右|3,中部居左|4,中部居中|5,中部居右|6,底部居左|7,底部居中|8,底部居右|9', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('42', '3', 'water_logo', '水印Logo', '/upfile/logo.png', '31', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('43', '3', 'water_piclist', '组图水印', '1', '33', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('44', '4', 'order_line', '订单安全', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('45', '4', 'order_times', '订单时间限制', '0', '3', '1', '', '多少分钟内只允许提交一次，为0时不限制', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('46', '4', 'order_ip', '订单次数限制', '0', '5', '1', '', '同一IP一天内只能提交几次订单，为0时不限制', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('47', '4', 'order_mobile', '手机号下单限制', '0', '7', '1', '', '同一手机号一天内只能提交几次订单，为0时不限制', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('48', '4', 'order_tips', '订单提醒', '1', '9', '6', '开启|1,关闭|0', '后台新订单音乐提醒', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('49', '5', 'admin_line', '后台设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('50', '5', 'admin_logo', '后台Logo', '/public/admin/images/logo.png', '3', '4', '', '', '1', '1', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('51', '5', 'admin_code', '登录验证码', '1', '5', '6', '图形验证码|1,谷歌验证码|2,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('52', '5', 'admin_code_google', '谷歌密钥', 'PY6MZVI2ZMEZHELJ', '7', '1', '', '如果使用：谷歌验证码，请点击【生成】按钮生成密钥，然后通过【身份验证器】APP，扫描二维码', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('53', '5', 'admin_logintimes', '登录尝试次数', '5', '9', '1', '', '超过次数后禁止登录', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('54', '5', 'admin_log', '自动清理日志', '30', '11', '1', '', '单位：天，超过多少天的自动清理', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('55', '5', 'admin_log_login', '后台登录日志', '1', '13', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('56', '5', 'admin_log_admin', '后台管理日志', '1', '15', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('57', '5', 'admin_auth_state', '授权类型', '0', '19', '6', '开启|1,关闭|0', '授权类型显示开关', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('58', '5', 'sys_line', '接口授权', '', '17', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('59', '5', 'api_http', '接口Http', 'https://', '21', '6', 'Http://|http://,Https://|https://', '<p>建议https，用于后台升级、插件及模板下载</p>', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('60', '5', 'api_url', '接口资源', '1', '23', '6', '国内|1,境外|0', '如果使用香港或海外服务器，请选择境外', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('61', '6', 'pay_paycash_line', '货到付款', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('62', '6', 'pay_paycash_open', '是否开启', '0', '3', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('63', '6', 'shop_paycash_percent', '货到付款手续费', '0', '5', '1', '', '货到付款手续费比例，为0时关闭，假如为5%，则输入0.05', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('64', '6', 'pay_blank_line', '银行转账', '', '7', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('65', '6', 'pay_blank_open', '是否开启', '0', '9', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('66', '6', 'pay_blank_text', '银行收款', '<p><strong>中国工商银行</strong><br>\r\n户名：陆先生<br>\r\n卡号：123456 7890</p>', '11', '9', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('67', '6', 'weixin_line', '微信公众号', '', '13', '0', '', '微信支付必须设置以下参数：必须为服务号，且通过认证', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('68', '6', 'weixin_appid', '开发者ID', '', '15', '1', '', '在微信公众号官方平台中：【设置与开发菜】单下的【基本配置】', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('69', '6', 'weixin_secret', '开发者密码', '', '17', '1', '', '在微信公众号官方平台中：【设置与开发菜】单下的【基本配置】', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('70', '6', 'weixin_openid', '获取微信Openid', '0', '19', '6', '开启|1,关闭|0', '<p>微信APP里内访问自动获取OpenID</p>', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('71', '6', 'weixin_openid_type', '获取方式', '1', '21', '6', '授权获取|1,静默获取|0', '<p>外站获取时，本设置无效</p>', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('72', '6', 'weixin_openid_url', '获取链接', '', '23', '1', '', '本站获取请留空，外站获取格式：http://www.baidu.com（用于多个站使用同一个微信服务号）', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('73', '7', 'sys_biz_line', '系统授权', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('74', '7', 'sys_auth_type', '授权类型', 'network', '3', '6', '网络授权|network,本地授权|local', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('75', '7', 'biz_id', '授权码', '', '5', '5', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('76', '7', 'sys_bind_line', '账号绑定', '', '7', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('77', '7', 'sys_uname', '用户名', '', '9', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('78', '7', 'sys_upass', '密码', '', '11', '1', '', '', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('79', '7', 'sys_temp_line', '系统模板', '', '13', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('80', '7', 'theme_dir', '模板路径', 'default', '15', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('81', '7', 'sys_plug', '插件列表', '{\"attachment\":\"attachment\",\"backup\":\"backup\"}', '17', '1', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('82', '8', 'sms_line', '短信设置', '', '1', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('83', '8', 'sms_state', '短信接口', '', '3', '11', '', '', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;sms&#039;', 'id desc', 'root', 'name');
INSERT INTO `cms_config` VALUES ('84', '8', 'sms_admin', '管理员手机号', '', '5', '1', '', '用于接收发货提醒等操作', '1', '0', '1', '1', '1', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('85', '8', 'sms_shop_line', '短信开关', '', '7', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('86', '8', 'sms_ispay', '付款提醒', '0', '9', '6', '发短信|1,不发短信|0', '订单付款后提醒买家', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('87', '8', 'sms_ispost', '发货提醒', '0', '11', '6', '发短信|1,不发短信|0', '订单付款后通知卖家发货', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('88', '8', 'sms_haspost', '收货提醒', '0', '13', '6', '发短信|1,不发短信|0', '发货后提醒买家已发货', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('89', '8', 'express_line', '快递设置', '', '15', '0', '', '', '1', '0', '1', '1', '0', '', '', '', '', '', '');
INSERT INTO `cms_config` VALUES ('90', '8', 'express_state', '快递接口', '', '17', '11', '', '', '1', '0', '1', '1', '0', 'cms_plug', '', 'state=1 and type=&#039;express&#039;', 'id desc', 'root', 'name');

-- ----------------------------
-- Table structure for cms_config_group
-- ----------------------------
DROP TABLE IF EXISTS `cms_config_group`;
CREATE TABLE `cms_config_group` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `gkey` varchar(50) DEFAULT '',
  `islock` smallint(6) DEFAULT '0',
  `types` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_config_group
-- ----------------------------
INSERT INTO `cms_config_group` VALUES ('1', '基本设置', '1', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('2', 'SEO设置', '3', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('3', '附件设置', '5', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('4', '订单相关', '7', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('5', '后台相关', '9', '0', '1', '1');
INSERT INTO `cms_config_group` VALUES ('6', '支付设置', '11', '0', '1', '2');
INSERT INTO `cms_config_group` VALUES ('7', '内置设置', '0', 'sys', '1', '1');
INSERT INTO `cms_config_group` VALUES ('8', '短信快递', '13', '0', '1', '2');

-- ----------------------------
-- Table structure for cms_file
-- ----------------------------
DROP TABLE IF EXISTS `cms_file`;
CREATE TABLE `cms_file` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '1：图片，2：视频，3：其他文件',
  `gid` int(10) DEFAULT '0',
  `file_url` varchar(255) DEFAULT '',
  `file_name` varchar(255) DEFAULT '' COMMENT '文件名',
  `file_ext` varchar(50) DEFAULT '' COMMENT '后缀',
  `file_size` int(10) DEFAULT '0',
  `file_type` int(10) DEFAULT '0' COMMENT '1：图片，2：视频，3：其他',
  `file_local` varchar(50) DEFAULT '',
  `file_update` bigint(10) DEFAULT '0' COMMENT '上传的日期',
  `file_adminid` int(11) DEFAULT '0',
  `file_ip` varchar(50) DEFAULT '' COMMENT '传者上IP',
  PRIMARY KEY (`id`),
  KEY `type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_file
-- ----------------------------

-- ----------------------------
-- Table structure for cms_file_group
-- ----------------------------
DROP TABLE IF EXISTS `cms_file_group`;
CREATE TABLE `cms_file_group` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_file_group
-- ----------------------------

-- ----------------------------
-- Table structure for cms_goods
-- ----------------------------
DROP TABLE IF EXISTS `cms_goods`;
CREATE TABLE `cms_goods` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(510) DEFAULT '',
  `classid` int(11) DEFAULT '0',
  `intro` varchar(510) DEFAULT '',
  `pic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `no` varchar(50) DEFAULT '',
  `sprice` decimal(10,2) DEFAULT '0.00' COMMENT '市场价',
  `vprice` decimal(10,2) DEFAULT '0.00' COMMENT '销售价',
  `vsales` int(10) DEFAULT '0' COMMENT '虚拟销量',
  `tsales` int(10) DEFAULT '0' COMMENT '真实销量',
  `freight` decimal(10,2) DEFAULT '0.00' COMMENT '运费',
  `hits` int(11) DEFAULT '0',
  `isnice` smallint(1) DEFAULT '0',
  `isshow` smallint(1) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0' COMMENT '排序',
  `seo_title` varchar(510) DEFAULT '',
  `seo_key` varchar(510) DEFAULT '',
  `seo_desc` varchar(510) DEFAULT '',
  `alias` varchar(50) DEFAULT '' COMMENT '别名',
  `adminid` int(10) DEFAULT '0',
  `createdate` bigint(10) DEFAULT '0',
  `lastupdate` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `where1` (`isshow`),
  KEY `order` (`ordnum`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_goods
-- ----------------------------

-- ----------------------------
-- Table structure for cms_goods_data
-- ----------------------------
DROP TABLE IF EXISTS `cms_goods_data`;
CREATE TABLE `cms_goods_data` (
  `dataid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `sku` varchar(500) DEFAULT '',
  `color` varchar(50) DEFAULT '',
  `thumb` text,
  `piclist` text,
  `content` mediumtext,
  PRIMARY KEY (`dataid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_goods_data
-- ----------------------------

-- ----------------------------
-- Table structure for cms_goods_list
-- ----------------------------
DROP TABLE IF EXISTS `cms_goods_list`;
CREATE TABLE `cms_goods_list` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT '0' COMMENT '主产品ID',
  `sku` varchar(255) DEFAULT '',
  `no` varchar(50) DEFAULT '',
  `sprice` decimal(10,2) DEFAULT '0.00',
  `vprice` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`aid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_goods_list
-- ----------------------------

-- ----------------------------
-- Table structure for cms_mobile
-- ----------------------------
DROP TABLE IF EXISTS `cms_mobile`;
CREATE TABLE `cms_mobile` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `state` smallint(1) DEFAULT '1' COMMENT '是否接受群发优惠通知',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of cms_mobile
-- ----------------------------

-- ----------------------------
-- Table structure for cms_order
-- ----------------------------
DROP TABLE IF EXISTS `cms_order`;
CREATE TABLE `cms_order` (
  `order_id` int(10) NOT NULL AUTO_INCREMENT,
  `order_no` varchar(50) DEFAULT '' COMMENT '订单编号',
  `goods_total` decimal(10,2) DEFAULT '0.00' COMMENT '商品总计',
  `goods_freight` decimal(10,2) DEFAULT '0.00' COMMENT '运费',
  `goods_service` decimal(10,2) DEFAULT '0.00' COMMENT '货到付款手续费',
  `order_total` decimal(10,2) DEFAULT '0.00' COMMENT '订单应付总金额（商品金额+运费+货到付款手续费）',
  `order_state` smallint(1) DEFAULT '0' COMMENT '订单状态',
  `name` varchar(50) DEFAULT '' COMMENT '姓名',
  `mobile` varchar(20) DEFAULT '',
  `area` varchar(255) DEFAULT '' COMMENT '省市区',
  `address` varchar(510) DEFAULT '' COMMENT '街道门牌',
  `message` varchar(510) DEFAULT '' COMMENT '客户留言',
  `ispay` smallint(1) DEFAULT '0' COMMENT '是否付款',
  `paydate` bigint(10) DEFAULT '0' COMMENT '付款日期',
  `payway` varchar(50) DEFAULT '' COMMENT '付款方式',
  `trade_no` varchar(510) DEFAULT '' COMMENT '订单交易号',
  `ispost` smallint(1) DEFAULT '0' COMMENT '是否已发货',
  `postdate` bigint(10) DEFAULT '0' COMMENT '发货日期',
  `postsign` smallint(1) DEFAULT '0' COMMENT '是否已签收',
  `goods_id` int(11) DEFAULT '0' COMMENT '商品ID',
  `goods_skuid` int(11) DEFAULT '0' COMMENT '规格ID',
  `goods_name` varchar(510) CHARACTER SET utf8 DEFAULT '' COMMENT '商品名称',
  `goods_no` varchar(255) DEFAULT '' COMMENT '商品货号',
  `goods_sku` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '商品SKU',
  `goods_pic` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '商品图片',
  `goods_num` int(10) DEFAULT '0' COMMENT '购买数量',
  `goods_price` decimal(10,2) DEFAULT '0.00',
  `express_id` varchar(255) DEFAULT '' COMMENT '快递ID',
  `express_name` varchar(255) DEFAULT '' COMMENT '快递公司',
  `express_code` varchar(255) DEFAULT '' COMMENT '快递代码',
  `express_num` varchar(255) DEFAULT '' COMMENT '快递单号',
  `express_state` text,
  `postip` varchar(255) DEFAULT '',
  `openid` varchar(510) DEFAULT '',
  `createdate` bigint(10) DEFAULT '0',
  `order_from` varchar(255) DEFAULT '' COMMENT '订单推广渠道',
  `comefrom` smallint(1) DEFAULT '0' COMMENT '订单来源（1：PC，2：手机，3：微信）',
  `posturl` varchar(510) DEFAULT '',
  `postkey` varchar(255) DEFAULT '' COMMENT '搜索关键字',
  `issales` smallint(1) DEFAULT '0' COMMENT '是否增加过销量',
  `isdel` smallint(1) DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of cms_order
-- ----------------------------

-- ----------------------------
-- Table structure for cms_plug
-- ----------------------------
DROP TABLE IF EXISTS `cms_plug`;
CREATE TABLE `cms_plug` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '名称',
  `root` varchar(100) DEFAULT '' COMMENT '路径',
  `icon` varchar(255) DEFAULT '',
  `intro` varchar(510) DEFAULT '',
  `type` varchar(50) DEFAULT '' COMMENT '插件类型',
  `hook` smallint(1) DEFAULT '0' COMMENT '是否有hook',
  `version` varchar(50) DEFAULT '' COMMENT '当前版本',
  `author` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `config` text COMMENT '配置数据',
  `admin` smallint(1) unsigned DEFAULT '0',
  `state` smallint(1) DEFAULT '0' COMMENT '状态（1：启用，0：禁用）',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;