<?php
/**
 * 作用：前端相关程序
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Order extends HomeController
{
	function Index()
	{
		if(IS_POST)
		{
			$id=getint(F('id'));
			$sku_id=getint(F('sku_id'));
			$buynum=getint(F('buynum'));
			if($id<=0)
			{
				$this->error('商品ID错误');
				return;
			}
			if($sku_id<0)
			{
				$this->error('商品规格ID错误');
				return;
			}

			if($buynum<=0 || $buynum>1000)
			{
				$this->error('购买数量错误');
				return;
			}
			
			$name=left(F('name'),45);
			$mobile=left(F('mobile'),11);
			$area=left(F('area'),255);
			$address=left(F('address'),510);
			$message=left(F('message'),510);
			$payway=left(F('payway'),255);
			$order_from=left(F('from'),255);
			$openid=S('openid');
			$postkey=left(F('postkey'),255);
			$ispc=getint(F('ispc'));

			if(isweixin())
			{
				$comeform=3;
			}
			else if(ismobile())
			{
				$comeform=2;
			}
			else
			{
				$comeform=1;
			}

			$arr=explode("/",$area);
			if(count($arr)<2)
			{
				$this->error('省市选择不完整');
				return;
			}

			$data=[];
			$data=array_merge($data,[[$name,'null','姓名不能为空'],[$name,'cn','姓名只能为汉字']]);
			$data=array_merge($data,[[$mobile,'null','手机号不能为空'],[$mobile,'mobile','手机号格式不正确']]);
			$data=array_merge($data,[[$area,'null','省市不能为空']]);
			$data=array_merge($data,[[$address,'null','地址不能为空']]);
			$data=array_merge($data,[[$payway,'null','付款方式不能为空']]);

			if($payway=='')
			{
				$this->error('请选择付款方式');
				return;
			}
			if($payway=='post' && getint(config('pay_paycash_open'))==0)
			{
				$this->error('请选择付款方式');
				return;
			}

			if($payway=='blank' && getint(config('pay_blank_open'))==0)
			{
				$this->error('请选择付款方式');
				return;
			}
			
			if(ismobile())
			{
				$ispc=0;
			}

			$postip=getip();
			$order_times=getint(config('order_times'));
			$order_ip=getint(config('order_ip'));
			$order_mobile=getint(config('order_mobile'));
			if($order_times>0)
			{
				#获取IP用户上次提交时间
				$rs=$this->db->row("select createdate from cms_order where postip='$postip' and isdel=0 order by order_id desc limit 1");
				if($rs)
				{
					#默认1分钟
					if((time()-$rs['createdate'])/60<$order_times)
					{
						$this->error('提交太频繁');
						return;
					}
				}
			}

			if($order_ip>0)
			{
				$num=$this->db->count("select count(1) from cms_order where postip='$postip' and FROM_UNIXTIME(`createdate`,'%Y-%m-%d')='".date('Y-m-d')."'");
				if($num>=$order_ip)
				{
					$this->error('今日订单量已达到限制');
					return;
				}
			}

			if($order_mobile>0)
			{
				$num=$this->db->count("select count(1) from cms_order where mobile='$mobile' and FROM_UNIXTIME(`createdate`,'%Y-%m-%d')='".date('Y-m-d')."'");
				if($num>=$order_mobile)
				{
					$this->error('今日订单量已达到限制');
					return;
				}
			}

			$rs=$this->db->row("select title,pic,no,sku,vprice,freight from cms_goods a left join cms_goods_data b on a.id=b.cid where id=$id and isshow=1 limit 1");
			if(!$rs)
			{
				$this->error('商品ID错误');
				return;
			}
			else
			{
				$title=$rs['title'];
				$pic=$rs['pic'];
				$no=$rs['no'];
				$vprice=$rs['vprice'];
				$freight=$rs['freight'];
				$sku='';
				if($rs['sku']=='')
				{
					if($sku_id>0)
					{
						$this->error('商品规格ID错误');
						return;
					}
				}
				else
				{
					$rs=$this->db->row("select sku,vprice from cms_goods_list where cid=$id and aid=$sku_id limit 1");
					if(!$rs)
					{
						$this->error('商品规格ID错误');
						return;
					}
					else
					{
						$vprice=$rs['vprice'];
						$sku=$rs['sku'];
					}
				}
			}

			$goods_total=$vprice*$buynum;
			$goods_freight=$freight;
			$goods_service=getprice($goods_total*getint(config('shop_paycash_percent')));
			if($payway!='post')
			{
				$goods_service=0;
			}
			$order_total=getprice($goods_total+$goods_freight+$goods_service);

			$v=new cms_verify($data);
			if($v->result())
			{
				#检查是否存在当日同一订单
				$where="order_state=1 and ispay=0 and isdel=0";
				$where.=" and postip='$postip' and goods_id=$id and goods_skuid=$sku_id";
				$where.=" and goods_no='$no' and goods_num=$buynum and goods_price=$vprice";
				$where.=" and goods_total=$goods_total and goods_freight=$goods_freight and goods_service=$goods_service";
				$where.=" and order_total=$order_total and area='".str_replace('/',' ',$area)."' and address='$address'";
				$rs=$this->db->row("select order_no from cms_order where $where limit 1");
				if($rs)
				{
					$orderid=$rs['order_no'];
				}
				else
				{
					$orderid=date('YmdHis').mt_rand(1000,9999);
					$d=[];
					$d['order_no']=$orderid;
					$d['goods_total']=$goods_total;
					$d['goods_freight']=$goods_freight;
					$d['goods_service']=$goods_service;
					$d['order_total']=$order_total;
					$d['name']=$name;
					$d['mobile']=$mobile;
					$d['area']=str_replace('/',' ',$area);
					$d['address']=$address;
					$d['message']=$message;
					$d['postip']=$postip;
					$d['goods_id']=$id;
					$d['goods_skuid']=$sku_id;
					$d['goods_name']=$title;
					$d['goods_pic']=$pic;
					$d['goods_no']=$no;
					$d['goods_sku']=str_replace('|',' ',$sku);
					$d['goods_num']=$buynum;
					$d['goods_price']=$vprice;
					$d['createdate']=time();
					$d['order_from']=$order_from;
					$d['order_state']=1;
					$d['comefrom']=$comeform;
					$d['posturl']=cut(PRE_URL,510);
					$d['payway']=$payway;
					$d['openid']=$openid;
					$d['postkey']=$postkey;
					$this->db->add('cms_order',$d);
					$this->setsms($name,$mobile);
				}
				
				if($payway=='post' && getint(config('sms_ispost'))==1 && config('sms_state')!='')
				{
					#货到付款发货提醒
					cms_app::init('sms');
					cms_app::send(config('sms_admin'),'order_cash',['orderid'=>$orderid,'money'=>$order_total]);
				}

				if($payway=='post' || $payway=='blank')
				{
					$res=U("order/show","orderid=$orderid");
				}
				else
				{
					$res=U('pay/index/'.$payway.'','orderid='.$orderid.'');
					if($ispc==1)
					{
						$res=$res.'@@'.$orderid.'@@'.U("pay/index/index");
					}
				}
				$this->success($res);
			}
			else
			{
				$this->error($v->msg);
			}
		}
	}

	#收集手机号
	private function setsms($name,$mobile)
	{
		$rs=$this->db->row("select id from cms_mobile where mobile='$mobile' limit 1");
		if(!$rs)
		{
			$this->db->add('cms_mobile',['name'=>$name,'mobile'=>$mobile]);
		}
	}

	function show()
	{
		$orderid=F('orderid');
		if(empty($orderid))
		{
			echo '订单号不能为空';
			return;
		}
		$rs=$this->db->row("select * from cms_order where order_no='$orderid' limit 1");
		if($rs)
		{
			foreach($rs as $key=>$val)
			{
				$this->tp->add($key,$val);
			}
			$this->tp->add('userip',(bool)(getip()==$rs['postip']));
			$this->tdk('订单详情');
			$this->tp->show(T('order'));
		}
		else
		{
			echo '查不到订单号：'.$orderid;
		}
	}

	#根据选择的付款方式跳转对应付款处理页面(废弃)
	function cash()
	{
		$orderid=F('orderid');
		if(empty($orderid))
		{
			echo '订单号不能为空';
			return;
		}
		$rs=$this->db->row("select * from cms_order where order_no='$orderid' limit 1");
		if($rs)
		{
			if($rs['payway']=='alipay')
			{
				G(U('pay/index/alipay','orderid='.$rs['order_no'].''));
				return;
			}
			if($rs['payway']=='weixin')
			{
				G(U('pay/index/weixin','orderid='.$rs['order_no'].''));
				return;
			}
			G(U('order/show','orderid='.$rs['order_no'].''));
		}
		else
		{
			echo '查不到订单号：'.$orderid;
		}
	}

	#获取物流
	function getexpress()
	{
		if(IS_POST)
		{
			$id=getint(F('id'));
			$rs=$this->db->row("select * from cms_order where order_id=$id limit 1");
			if(!$rs)
			{
				$this->error('订单号错误');
			}
			else
			{
				if(config('express_state')=='')
				{
					$this->error('未开启快递接口');
					return;
				}
				if($rs['postsign']==0)
				{
					cms_app::init('express',$rs['express_id']);
					$data=cms_app::query($rs['express_code'],$rs['express_num'],$rs['mobile']);					
					if($data['state']=='success')
					{
						$result=$data['msg'];
						if(strlen($result)>strlen($rs['express_state']))
						{
							$arr=[];
							$arr['express_state']=$result;
							if(strpos($result,'签收'))
							{
								$arr['postsign']=1;
							}
							$this->db->update("cms_order","order_id=$id",$arr);
						}
						else
						{
							$result=$rs['express_state'];
						}
						$this->success($result);
					}
					else
					{
						$this->error($data['msg']);
					}
				}
				else
				{
					$this->success($rs['express_state']);
				}
			}
		}
	}

	function result()
	{
		$orderid=F('orderid');
		if(empty($orderid))
		{
			echo '订单号不能为空';
			return;
		}
		$rs=$this->db->row("select * from cms_order where order_no='$orderid' limit 1");
		if($rs)
		{
			foreach($rs as $key=>$val)
			{
				$this->tp->add($key,$val);
			}
			$this->tdk('支付结果');
			$this->tp->add('pagebar',false);
			$this->tp->show(T('res'));
		}
		else
		{
			echo '查不到订单号：'.$orderid;
		}
	}

}