<?php
/**
 * 作用：常用函数
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

#XSS过滤
define('XSS_LIST','FSCommand|onAbort|onActivate|onAfterPrint|onAfterUpdate|onBeforeActivate|onBeforeCopy|onBeforeCut|onBeforeDeactivate|onBeforeEditFocus|onBeforePaste|onBeforePrint|onBeforeUnload|onBeforeUpdate|onBegin|onBlur|onBounce|onCellChange|onChange|onClick|onContextMenu|onControlSelect|onCopy|onCut|onDataAvailable|onDataSetChanged|onDataSetComplete|onDblClick|onDeactivate|onDrag|onDragEnd|onDragLeave|onDragEnter|onDragOver|onDragDrop|onDragStart|onDrop|onEnd|onError|onErrorUpdate|onFilterChange|onFinish|onFocus|onFocusIn|onFocusOut|onHashChange|onHelp|onInput|onKeyDown|onKeyPress|onKeyUp|onLayoutComplete|onLoad|onLoseCapture|onMediaComplete|onMediaError|onMessage|onMouseDown|onMouseEnter|onMouseLeave|onMouseMove|onMouseOut|onMouseOver|onMouseUp|onMouseWheel|onMove|onMoveEnd|onMoveStart|onOffline|onOnline|onOutOfSync|onPaste|onPause|onPopState|onProgress|onPropertyChange|onReadyStateChange|onRedo|onRepeat|onReset|onResize|onResizeEnd|onResizeStart|onResume|onReverse|onRowsEnter|onRowExit|onRowDelete|onRowInserted|onScroll|onSeek|onSelect|onSelectionChange|onSelectStart|onStart|onStop|onStorage|onSyncRestored|onSubmit|onTimeError|onTrackChange|onUndo|onUnload|onURLFlip|seekSegmentTime');

#URL追加参数
function A($a,$b)
{
	if(is_string($b))
	{
		parse_str($b,$c);
	}
	elseif(is_array($b))
	{
		$c=$b;
	}
	else
	{
		$c=[];
	}
	$c=array_merge($_GET,$c);
	unset($c['m']);
	unset($c['c']);
	unset($c['a']);
	unset($c['page']);
	return str_replace("%2C",",",U($a,$c));
}

#去掉bom
function B($a)
{
	if(!is_file($a))
	{
		exit("无法读取文件：{$a}");
	}
	$b=file_get_contents($a);
	$c[1]=substr($b,0,1);
    $c[2]=substr($b,1,1);
    $c[3]=substr($b,2,1);
	if(ord($c[1])==239 && ord($c[2])==187 && ord($c[3])==191)
	{
		$d=substr($b,3);
        file_put_contents($a,$d);
	}
	unset($b);
	unset($c);
	return (array)require_once($a);
}

#cookie
function C($a,$b='')
{
	$prefix=config('prefix').$a;
	if($b=='')
	{
		return enhtml(isset($_COOKIE[$prefix])?$_COOKIE[$prefix]:null);
	}
	elseif($b=='[del]')
	{
		setcookie($prefix,'',time()-1,'/','','');
	}
	else
	{
		setcookie($prefix,$b,time()+86400,'/','','');
	}
}

#Json转Array
function D($a,$b=0)
{
	if(empty($a))
	{
		return false;
	}
	if($b==1)
	{
		$a=str_replace("\r","\\r",$a);
		$a=str_replace("\n","\\n",$a);
	}
	return json_decode($a,true);
}

#Array转json
function E($a)
{
	return str_replace('\t','',json_encode($a,320));
}

#F函数（get和post）
function F($a,$b='',$c=0)
{
	#$a=strtolower($a);
	$d='';
	if(strpos($a,'.'))
	{
		list($d,$a)=explode('.',$a,2);
	}
	switch($d)
	{
		case 'get':
			$d=$_GET;
			break;
		case 'post':
			$d=$_POST;
			break;
		default:
			$d=(REQUEST_METHOD=='GET')?$_GET:$_POST;
			break;
	}
	$e=isset($d[$a])?$d[$a]:$b;
	if(defined('M_NAME'))
	{
		if(S('admindir')!='' && M_NAME!=S('admindir'))
		{
			$e=filter_html($e);
		}
	}
	if($a=="web_count")
	{
		$c=2;
	}
	if(is_string($e))
	{
		$e=enhtml($e,$c);
	}
	return $e;
}

#跳转
function G($a,$b=0)
{
	if($b==301)
	{
		Header("HTTP/1.1 301 Moved Permanently");
	}
	header('Location:'.$a);
	exit();
}

function H()
{
	$a=config('domain_main');
	$b=enhtml($_SERVER['HTTP_HOST']);
	if($a=='')
	{
		return $b;
	}
	return ($a!=$b)?$b:$a;
}

#别名url组合
function N($a,$b=0)
{
	if($b==0)
	{
		$b=config('URL_MODE');
	}
	$pre=(M_NAME!='pay')?'':WEB_URL;
	switch($b)
	{
		case '1':
			return $pre.WEB_ROOT.'?m='.$a;
			break;
		case '2':
			$pathinfo=config('pathinfo');
			if(empty($pathinfo))
			{
				$last='/';
			}
			else
			{
				$last='?'.config('pathinfo').'=';
			}
			return $pre.WEB_ROOT.'index.php'.$last.$a;
			break;
		case '3':
			return $pre.WEB_ROOT.$a.config('url_ext');
			break;
	}
}

#session
function S($a,$b='')
{
	$prefix=config('PREFIX').$a;
	if($b=='')
	{
		return isset($_SESSION[$prefix])?$_SESSION[$prefix]:'';
	}
	elseif($b=='[del]')#删除单个变量
	{
		unset($_SESSION[$prefix]);
	}
	elseif($b=='[delete]')#删除全部
	{
		session_unset();
        session_destroy();
	}
	else
	{
		$_SESSION[$prefix]=$b;
	}
}

#模板资源
function T($a)
{
	$b=isset($GLOBALS['sys_theme_config'][$a])?$GLOBALS['sys_theme_config'][$a]:'';
	if($b=='')
	{
		exit('【'.$a.'】模板配置不存在');
	}
	return $b;
}

#Url组装
function U($a='',$b='',$c=1)
{
	return geturl($a,$b,$c);
}

#Version转number
function V($a)
{
    $b=explode(".",$a);
    if(count($b)<=2)
    {
    	return $a;
    }
    else
    {
    	$c=$b[0];
    	unset($b[0]);
    	$d=implode('',$b);
    	return (float)($c.".".$d);
    }
}

#系统资源
function config($a='')
{
	static $b=[];
	if(empty($a))
	{
		return $b;
	}
	if(is_string($a))
	{
		if(!strpos($a,'.'))
		{
			$a=strtoupper($a);
			return isset($b[$a])?$b[$a]:'';
		}
		else
		{
			$a=explode('.',$a);
			$a[0]=strtoupper($a[0]);
			return isset($b[$a[0]][$a[1]])?$b[$a[0]][$a[1]]:'';
		}
	}
	if(is_array($a))
	{
		$b=array_merge($b,array_change_key_case($a,CASE_UPPER));
		return '';
	}
	return '';
}

#字符串加密解密
function authcode($string,$type='D',$key='',$expiry=0)
{
	$ckey_length=4;
	$key=md5($key);
	$keya=md5(substr($key,0,16));
	$keyb=md5(substr($key,16,16));
	$keyc=$ckey_length?($type=='D'?substr($string,0,$ckey_length):substr(md5(microtime()),-$ckey_length)):'';
	$cryptkey=$keya.md5($keya.$keyc);
	$key_length=strlen($cryptkey);
	$string=$type=='D'?base64_decode(substr($string,$ckey_length)):sprintf('%010d',$expiry?$expiry+time():0).substr(md5($string.$keyb),0,16).$string;
	$string_length=strlen($string);
	$result='';
	$box=range(0,255);
	$rndkey=array();
	for($i=0;$i<=255;$i++)
	{
		$rndkey[$i]=ord($cryptkey[$i%$key_length]);
	}
	for($j=$i=0;$i<256;$i++)
	{
		$j=($j+$box[$i]+$rndkey[$i])%256;
		$tmp=$box[$i];
		$box[$i]=$box[$j];
		$box[$j]=$tmp;
	}
	for($a=$j=$i=0;$i<$string_length;$i++)
	{
		$a=($a+1)%256;
		$j=($j+$box[$a])%256;
		$tmp=$box[$a];
		$box[$a]=$box[$j];
		$box[$j]=$tmp;
		$result.=chr(ord($string[$i])^($box[($box[$a]+$box[$j])%256]));
	}
	if($type=='D')
	{
		if((substr($result,0,10)==0 || substr($result,0,10)-time()>0) && substr($result,10,16)==substr(md5(substr($result,26).$keyb),0,16))
		{
			return substr($result,26);
		}
		else
		{ 
			return '';
		}
	}
	else
	{  
		return $keyc.str_replace('=','',base64_encode($result));
	}
}

#解决部分服务器获取不到：REQUEST_URI
function getlocal()
{
	if(isset($_SERVER['REQUEST_URI']))
	{ 
		$_SERVER['REQUEST_URI']=$_SERVER['REQUEST_URI'];
	}
	elseif(isset($_SERVER['HTTP_X_REWRITE_URL']))
	{
		$_SERVER['REQUEST_URI']=$_SERVER['HTTP_X_REWRITE_URL'];
	}
	elseif(isset($_SERVER['REDIRECT_URL']))
	{ 
		$_SERVER['REQUEST_URI']=$_SERVER['REDIRECT_URL'];
	}
	elseif(isset($_SERVER['ORIG_PATH_INFO']))
	{
		$_SERVER['REQUEST_URI']=$_SERVER['ORIG_PATH_INFO'];
		if(!empty($_SERVER['QUERY_STRING']))
		{
			$_SERVER['REQUEST_URI'].='?'.$_SERVER['QUERY_STRING'];
		}
	}
	return enhtml(mb_convert_encoding($_SERVER['REQUEST_URI'],'utf-8','gbk'));
}

function filter_html($a)
{
	if(is_array($a))
	{
		foreach($a as $key=>$val)
		{
			$a[$key]=filter_html($val);
		}
		return $a;
	}
	else
	{
		$a=preg_replace(["/<(\/?)(script|iframe|applet|meta|xml|blink|link|style|embed|object|layer|title|bgsound|base|\?|\%)([^>]*?)>/isU"],'',$a);
		return $a;
	}
}

function filter_query($var)
{
	filter_even($var);
	return $var;
}

function deal_str($a)
{
	if(is_array($a))
	{
		foreach($a as $key=>$val)
		{
			$a[$key]=deal_str($val);
		}
	}
	else
	{
		$a=addslashes($a);
	}
	return $a;
}

function filter_even($a)
{
	if(is_array($a))
	{
		if(count($a)==0)
		{
			return '';
		}
		foreach($a as $key=>$val)
		{
			$a[$key]=filter_even($val);
		}
	}
	else
	{
		$a=addslashes($a);
		$a=urldecode($a);
		$html=rawurldecode(htmlspecialchars_decode($a));
		$html=preg_replace('/&#([0-9]{1,3})/','',$html);
		$html=rawurldecode(htmlspecialchars_decode($html));
		$num=preg_match_all("/\<([\w.]+)(.*?)\>/s",$html,$match);
		$res='';
		if($num)
		{
			for($i=0;$i<$num;$i++)
			{
				$param=$match[2][$i];
				$n=preg_match_all('/('.XSS_LIST.')=(.*?)/i',$param,$m);
				if($n>0)
				{
					$res=($m[1][0]);
					break;
				}
				$n=preg_match_all('/(alert\(|eval\(|expression\(|prompt\(|base64\(|vbscript\(|msgbox\(|unescape\()/i',$param,$m);
				if($n>0)
				{
					$res=($m[1][0]);
					break;
				}
			}
		}
		if($res!='')
		{
			echo E(['state'=>'error','msg'=>'请勿提交非法参数：'.$res]);
			exit();
		}
		$res=check_bad($html);
		if($res!='')
		{
			echo E(['state'=>'error','msg'=>'请勿提交非法参数'.$res]);
			exit();
		}
	}
}

function check_bad($str)
{
	$num=preg_match_all("/(phpinfo\(|getcwd\(|=\`ls\`|error_reporting\(|\)goto|chr\(|enctype\=|proc_close\(|proc_nice\(|proc_terminate\(|escapeshellarg\(|escapeshellcmd\(|set_time_limit\(|base64_decode\(|json_decode\(|require\(|include\(|include_once\(|require_once\(|pack\(|str_rot13\(|system\(|eval\(|request\[|execute\(|savefile\(|file_put_contents\(|file_get_contents\(|highlight_file\(|exec\(|chroot\(|scandir\(|chgrp\(|chown\(|shell_exec\(|pcntl_exec\(|proc_open\(|popen\(|fget\(|putenv\(|proc_get_status\(|error_log\(|pfsockopen\(|syslog\(|readlink\(|fscanf\(|symlink\(|stream_socket_server\(|preg_replace\(|delfolder\(|unlink\(|mkdir\(|file\(|fopen\(|fread\(|fwrite\(|fputs\(|fgetss\(|fgets\(|tmpfile\(|flock\(|load_file\(|outfile\(|chmod\(|fflush\(|fputcsv\(|delete\(|payload\(|fclose\(|copy\(|feof\(|fgetc\(|fgets\(|assert\(|cmdshell\(|wshshell\(|show_source\(|parse_ini_file\(|_post\[|_get\[|_file\(|create_function\(|call_user_func\(|call_user_func_array\(|passthru\(|array_walk|getenv\(|register_|escapeshellcmd\(|rmdir\(|rename\(|readfile\(|usort\(|uasort\(|array_filter\(|array_flip\(|var_dump\(|array_merge\(|parse_str\(|extract\(|get_defined_vars\(|get_defined_constants\(|get_include_files\(|glob\(|array_map\(|ob_start\(|is_numeric\(|ini_get\(|ini_set\(|ini_alter\(|ini_restore\(|move_uploaded_file\(|get_included_files\(|SplFileObject\(|SplFileInfo)/Ui",str_replace(["'.'","\".\""],"",$str),$match);
	if($num>0)
	{
		return $match[0][0];
	}
	$num=preg_match_all('/\\$([\w])\.\\$([\w])/',$str,$match);
	if($num>0)
	{
		return $match[0][0];
	}
	return '';
}

#副域名处理，使用301重定向
function domain()
{
	if(config('domain_main')!='' && config('domain_other')!='')
	{
		if(in_array($_SERVER['HTTP_HOST'],explode("\r\n",config('domain_other'))))
		{
			if($_SERVER['HTTP_HOST']!=config('domain_main'))
			{
				$url=WEB_HTTP.config('domain_main').THIS_LOCAL;
				G($url,301);
				exit();
			}
		}
	}
}

function is_really_writable($a)
{
    if(is_dir($a))
    {
        $a=rtrim($a,'/').'/'.'test.html';
        if(($fp=@fopen($a,'ab'))===false)
        {
            return false;
        }
        fclose($fp);
        @chmod($a,0777);
        unlink($a);
        return true;
    }
    elseif(($fp=@fopen($a,'ab'))===false)
    {
        return false;
    }
    fclose($fp);
    return true;
}

function savefile($a,$b)
{
	if(!is_really_writable($a))
	{
		return false;
	}
	else
	{
		if(file_put_contents($a,$b)==false)
		{
			return false;
		}
		else
		{
			return true;
		}
	}
}

function left($a,$b)
{
	return mb_substr(trim($a),0,$b,"utf-8");
}

function enhtml($a,$b=0)
{
	if(is_array($a))
	{
		foreach($a as $key=>$val)
		{
			$a[$key]=enhtml($val,$b);
		}
	}
	else
	{
		$a=($a!='')?$a:'';
		$a=str_replace(["+","/"],["jiaplus","slantingbar"],$a);
		$a=urldecode($a);
		$a=preg_replace('/^\\\\|\.\.\/|\.\/|&colon;|base64_______/i','',$a);
		$a=preg_replace('/&#([0-9]{1,3})/','',$a);
		$a=htmlspecialchars(stripslashes($a),ENT_QUOTES,'UTF-8');
		if($b>=1)
		{
			$a=str_replace(["&lt;","&gt;","&quot;"],["<",">","\""],$a);
		}
		if(defined('C_NAME'))
		{
			if((C_NAME."-".A_NAME)!='theme-edit')
			{
				if($b!=2)
				{
					$a=preg_replace('/<script[\s\S]*?/i','',$a);
				}
			}
		}
		$a=preg_replace('/('.XSS_LIST.')=/i','',$a);
		$a=str_replace(["jiaplus","slantingbar","&amp;"],["+","/","&"],$a);
		return $a;
	}
}

function dehtml($a)
{
	return htmlspecialchars_decode($a);
}

function nohtml($a)
{
	if(is_string($a))
	{
		$a=dehtml($a);
		$a=str_replace(['&amp;nbsp;','　',"\r\n"],'',$a);
		$a=preg_replace("@<style(.*?)</style>@is",'',$a);
		$a=trim(strip_tags($a));
	}
	return $a;
}

function getint($a,$b=0)
{
	if(is_array($a))
	{
		$a=implode($a);
	}
	$c=($a!='')?(!preg_match("/^[-0-9.]+$/",$a))?$b:substr($a,0,11):$b;
	return floatval($c);
}

#格式化小数
function getprice($a,$b=2)
{
	return floatval(number_format($a,$b,'.',''));
}

#cut函数
function cut($a,$b,$c=0)
{
	$d=mb_strcut($a,0,$b,'UTF8');
	if(strlen($a)>$b && $c==1)
	{
		$d.='…';
	}
	return $d;
}

#getip函数
function getip()
{
	$ip='';
	if(isset($_SERVER['HTTP_X_REAL_IP'])) 
	{
        $ip=$_SERVER['HTTP_X_REAL_IP'];
    }
    elseif(isset($_SERVER['HTTP_CLIENT_IP']))
    {
        $ip=$_SERVER['HTTP_CLIENT_IP'];
    }
    elseif(isset($_SERVER['HTTP_ALI_CDN_REAL_IP']))
    {
        $ip=$_SERVER['HTTP_ALI_CDN_REAL_IP'];
    }
    elseif(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
    {
        $arr=explode(',',$_SERVER['HTTP_X_FORWARDED_FOR']);
        return $arr[0];
    }
    if($ip=='' || strpos($ip,":"))
    {
    	$ip=$_SERVER['REMOTE_ADDR'];
    }
    return filter_var($ip,FILTER_VALIDATE_IP)?enhtml(trim($ip)):'0.0.0.0';
}

function ismobile()
{
    if(isset($_SERVER['HTTP_X_WAP_PROFILE']))
    {
        return true;
    }
    if(isset($_SERVER['HTTP_VIA']))
    {
    	if(strpos($_SERVER['HTTP_VIA'],"wap"))
        {
        	return true;
        }
    }
    if(isset($_SERVER['HTTP_USER_AGENT']))
    {
        $clientkeywords = array ("android","phone","ipod","mqqbrowser","blackberry","nokia","windowsce","symbian","lg","ucweb","skyfire","webos","incognito","blackberry","mobile","bada"); 
        if(preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT'])))
        {
            return true;
        }
	}
    if(isset($_SERVER['HTTP_ACCEPT']))
    { 
        if((strpos($_SERVER['HTTP_ACCEPT'],'vnd.wap.wml')!==false) && (strpos($_SERVER['HTTP_ACCEPT'],'text/html')===false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml')<strpos($_SERVER['HTTP_ACCEPT'],'text/html'))))
        {
            return true;
        }
    }
    return false;
}

#是否微信浏览器
function isweixin()
{
	return (bool)(strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'micromessenger'));	
}

function ispc()
{
	return (ismobile() || isweixin())?false:true;
}

#文件单位
function formatBytes($a)
{ 
	$units=['B','K','M','G','TB']; 
	for($i=0;$a>=1024 && $i<4;$i++)
	{
		$a/=1024;
	}
	return round($a,2).' '.$units[$i]; 
}

#创建文件夹(无限级)
function mkfolder($a)
{
	if(!is_dir($a))
	{
		return mkdir($a,0777,true);
	}
}

#删除文件夹(包含子目录)
function delfolder($a)
{
    $a=str_replace('','/',$a);
    $a=substr($a,-1)=='/'?$a:$a.'/';
    if(!is_dir($a))
    {
        return false;
    }
    $b=opendir($a);
    while(false!==($file=readdir($b)))
    {
        if($file=='.' || $file=='..')
        {
            continue;
        }
        if(!is_dir($a.$file))
        {
            unlink($a.$file);
        }
        else
        {
            delfolder($a.$file);
        }
    }
    closedir($b);
    return rmdir($a);
}

#栏目url
function cateurl($classid,$alias)
{
	if(!empty($alias))
	{
		return N($alias);
	}
	return U('home/index/cate','classid='.$classid.'');
}

#内容URL
function link_url($a,$b)
{
	return (empty($b))?U("home/goods/show","id=$a"):N($b);
}

function geturl($url='',$vars='',$type=1)
{
	$strs=cms_route::url($url,$vars);
	$arr=parse_url($url);	
	if(!empty($arr['path']))
	{
		$url=$arr['path'];
	}
	else
	{
		$url=A_NAME;
	}
	if(is_string($vars))
	{
		parse_str($vars,$vars);
	}
	elseif(!is_array($vars))
	{
		$vars=[];
	}
	$umid=config('url_mid');
	if($url)
	{
		$url=trim(str_replace($umid,'/',$url),'/');
		$path=explode('/',$url);
		$a=A_NAME;
		if(!empty($path))
		{
			$a=end($path);
			array_pop($path);
		}
		$c=C_NAME;
		if(!empty($path))
		{
			$c=end($path);
			array_pop($path);
		}
		$m=M_NAME;
		if(!empty($path))
		{
			$m=end($path);
			array_pop($path);
		}
		$p='';
		if(!P_NAME && $m=='plug')
		{
			$p=$c;
			$c=$a;
			$a='index';
		}
		else
		{
			$p=P_NAME;
		}
	}
	$str='';
	if(config('url_mode')==1)
	{
		$str.="c=$c&a=$a";
		if($m!='home')
		{
			$str="m=$m&".$str;
		}
		if($p && $m!=S('admindir'))
		{
			$str.="&p=$p";
		}
		$str="?".$str;
		$param=http_build_query($vars);
		if($param!='')
		{
			$str.='&'.$param;
		}
	}
	else
	{
		if($strs)
		{
			$str=str_replace('/',config('url_mid'),$strs);
		}
		else
		{
			$param=http_build_query($vars);
			$param=str_replace(['=','&'],$umid,$param);
			$str="$c$umid$a$umid";
			$str=($param!='')?("$c$umid$a$umid".$param):(trim(trim($str,'/'),$umid));
			$str=($p && $type==1)?("$m$umid$p$umid".$str):("$m$umid".$str);
		}
		$str=$str.config('url_ext');
	}
	if(config('url_mode')==2)
	{
		$pathinfo=config('pathinfo');
		if(empty($pathinfo))
		{
			$last='/';
		}
		else
		{
			$last='?'.config('pathinfo').'=';
		}
		$str='index.php'.$last.$str;
	}
	$pre=(M_NAME!='pay')?'':WEB_URL;
	return $pre.WEB_ROOT.$str;
}

#密码是否同时包含字母和数字
function check_pass($a)
{
    return ( (preg_match('/\d/',$a) || preg_match('/[.*?&^%$#@!~_\-+=|()]/',$a)) && preg_match('/[a-zA-Z]/',$a));
}

function get_payway($a,$b=0)
{
	$c=$a;
	switch($a)
	{
		case 'post':
			$c='货到付款';
			break;
		case 'blank':
			$c='银行转账';
			break;
	}
	return ($b==0)?$c:"　【{$c}　<span class=\"gray\">".date('Y-m-d H:i:s',$b)."</span>】";
}

#后台相关
function is_admin()
{
	$info=S('admin_info');
	if(empty($info))
	{
		return 0;
	}
	else
	{
		return $info['adminid'];
	}
}

function get_admin_info($a)
{  
	$info=S('admin_info');
	if(empty($info))
	{
		return '';
	}
	else
	{
		return $info[$a];
	}
}

#运行时间
function runtime()
{
	$GLOBALS['end']=['0'=>microtime(true),'1'=>memory_get_usage()];
	return 'Processed in '.getprice(($GLOBALS['end'][0]-$GLOBALS['begin'][0]),6).' s , Memory '.formatBytes(($GLOBALS['end'][1]-$GLOBALS['begin'][1])).' , '.$GLOBALS['query'].' queries';
}