<?php if(!defined('IN_CMS')) exit;?><!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="renderer" content="webkit">
<title>插件管理</title>
<link rel="stylesheet" href="{WEB_ROOT}public/css/ui.css">
<link rel="stylesheet" href="{WEB_ROOT}public/admin/css/cms.css">
<script src="{WEB_ROOT}public/js/jq.js"></script>
<script src="{WEB_ROOT}public/js/ui.js"></script>
<script src="{WEB_ROOT}public/admin/js/cms.js"></script>
</head>

<body>
    <div class="position">当前位置：应用管理 > <a href="{U('index')}">插件管理</a></div>
    <div class="ui-borders">
        <!---->
        <div class="ui-tabs ui-tabs-white" data-href="1">
        	<div class="ui-tabs-header-nav">
                <ul class="ui-tabs-nav">
                  <li class="active"><a href="{U('index','type=0')}">本地插件</a></li>
                  <li><a href="{U('index','type=1')}">插件市场</a></li>
                  <li><a href="javascript:;" class="import">导入插件</a></li>
                </ul>
                <div class="ui-tabs-header-more">
                    <select class="ui-form-ip ui-w-auto" onChange="location.href=this.value">
                        <option value="{A('index','mode=all')}" {if $mode=='all'} selected{/if}>全部插件</option>
                        <option value="{A('index','mode=pay')}" {if $mode=='pay'} selected{/if}>支付接口</option>
                        <option value="{A('index','mode=sms')}" {if $mode=='sms'} selected{/if}>短信接口</option>
                        <option value="{A('index','mode=upload')}" {if $mode=='upload'} selected{/if}>上传接口</option>
                        <option value="{A('index','mode=express')}" {if $mode=='express'} selected{/if}>快递接口</option>
                        <option value="{A('index','mode=safe')}" {if $mode=='safe'} selected{/if}>网站安全</option>
                        <option value="{A('index','mode=tool')}" {if $mode=='tool'} selected{/if}>系统工具</option>
                        <option value="{A('index','mode=other')}" {if $mode=='other'} selected{/if}>其他插件</option>
                    </select>
                </div>
            </div>
            <div class="ui-tabs-content">
                <div class="ui-tabs-pane active">
                    <!--loop-->
                    <div class="plug_list">
                    	{cms:rs pagesize="10" from="cms_plug" where="$where" order="id desc"}
                    	<div class="plug_list_item">
                        	{if $rs.state==1}<div class="ui-ring small green"><span>已安装</span></div>{/if}
                        	<div class="plug_list_item_body">
                            	<a class="plug_list_wrap"{if $rs.state==1 && $rs.admin} href="{U("plug/".$rs.root."/admin")}"{/if}>
                                	<div class="plug_list_icon">
                                    	<img src="{WEB_ROOT}plug/{$rs.root}/{$rs.icon}">
                                    </div>
                                    <div class="plug_list_body">
                                    	<div class="name">{$rs.name}</div>
                                        <div class="intro ui-text-hide">{$rs.intro}</div>
                                    </div>
                                </a>
                                <div class="plug_list_foot">
                                	<div class="action">{if $rs.state==1}<a href="{U('uninstall','name='.$rs.root.'')}" class="ui-btn small ui-action outline red" data-type="uninstall" data-data="token={$token}">卸载</a>{else}<a href="{U('install','type='.$type.'&name='.$rs.root.'')}" class="ui-btn blue outline small ui-action" data-type="install" data-tips="正在安装，请稍等" data-data="token={$token}">安装</a>{/if}{if $rs.state==1 && $rs.admin} <a href="{U("plug/".$rs.root."/admin")}" class="ui-btn small outline blue ui-ml-sm">管理</a>{/if}</div>
                                    <div class="version">版本：{$rs.version}</div>
                                </div>
                            </div>
                        </div>
                        {/cms:rs}
                    </div>
                    <!--loop-->
                </div>
            </div>
        </div>
        
        {if $total_rs!=0}
        <div class="ui-page center blue mid ui-mt-20">
            <div class="ui-page-list"><ul>{$showpage}</ul></div>
        </div>
        <div class="ui-block" style="height:20px;"></div>
        {/if}
        <!---->
    </div>
    <script>
	$(function()
	{
		$(".import").click(function()
		{
			$.dialogbox(
			{
				title:"导入插件",
				inputholder:"请输入插件文件夹名称",
				maxlength:30,
				type:1,
				ok:function(e)
				{
					var val=e.inputval();
					if(val=='')
					{
						ui.error("请输入插件文件夹名称")
						return;
					}
					$.ajax(
					{
						type:'post',
						cache:false,
						dataType:'json',
						url:'{U("import")}',
						data:'token={$token}&name='+encodeURIComponent(val),
						error:function(e){alert(e.responseText);},
						success:function(d)
						{
							if(d.state=='success')
							{
								e.close();
								ui.success('安装成功');
								setTimeout(function(){location.href='{THIS_LOCAL}';},1000);
							}
							else
							{
								ui.error(d.msg);
							}
						}
					});
				}
			});
		});
	});
	</script>
</body>
</html>