<?php if(!defined('IN_CMS')) exit;?><!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="renderer" content="webkit">
<title>订单管理</title>
<link rel="stylesheet" href="{WEB_ROOT}public/css/ui.css">
<link rel="stylesheet" href="{WEB_ROOT}public/admin/css/cms.css">
<link rel="stylesheet" href="{WEB_ROOT}public/table/table.css">
<script src="{WEB_ROOT}public/js/jq.js"></script>
<script src="{WEB_ROOT}public/js/ui.js"></script>
<script src="{WEB_ROOT}public/admin/js/cms.js"></script>
<script>
function tips()
{
	ui.loading('正在处理，请注意下载栏提示');
	setTimeout(function()
	{
		$.progress('close');
	},3000);
}
</script>
</head>

<body>

<div class="position">当前位置：<a href="{U('index')}">订单管理</a> > {$position}</div>
<div class="ui-border">
    <form action="{THIS_LOCAL}" method="get">
        {if cms[url_mode]==1}
            {php $pathinfo=cms[pathinfo]}
			{if !empty($pathinfo) && cms[url_mode]>1}<input type="hidden" name="s" value="{PATH_URL}" />{/if}
            {if cms[url_mode]==1}
                <input type="hidden" name="m" value="{M_NAME}" />
                <input type="hidden" name="c" value="{C_NAME}" />
                <input type="hidden" name="a" value="{A_NAME}" />
            {/if}
        {/if}
        <div class="ui-form-group ui-row ui-select">
            <label class="ui-text-gray">订单搜索：</label>
            <div class="ui-w-auto ui-mr">
                <select name="stype" class="ui-form-ip">
                    <option value="1"{if $stype==1} selected{/if}>订单编号</option>
                    <option value="2"{if $stype==2} selected{/if}>客户姓名</option>
                    <option value="3"{if $stype==3} selected{/if}>客户手机</option>
                    <option value="4"{if $stype==4} selected{/if}>推广渠道</option>
                    <option value="5"{if $stype==5} selected{/if}>商品ID</option>
                </select>
            </div>
            <div class="ui-w-auto">
                <input type="text" name="keyword" class="ui-form-ip" value="{$keyword}" placeholder="请输入订单编号">
            </div>
        </div>
        
        <div class="ui-form-group ui-row ui-select">
            <label class="ui-text-gray">下单时间：</label>
            <div class="ui-w-auto ui-mr">
                <input type="text" name="begindate" id="begindate" class="ui-form-ip datepick" value="{$begindate}" placeholder="开始时间">
            </div>
            <div class="ui-w-auto ui-mr">
                <input type="text" name="overdate" id="overdate" class="ui-form-ip datepick" value="{$overdate}" placeholder="结束时间">
            </div>
            <div class="ui-w-auto ui-pt ui-ml">
                <a href="javascript:;" data-type="1" class="date_c ui-mr ui-text-blue">昨天</a>
                <a href="javascript:;" data-type="2" class="date_c ui-mr ui-text-blue">今天</a>
                <a href="javascript:;" data-type="3" class="date_c ui-mr ui-text-blue">最近7天</a>
                <a href="javascript:;" data-type="4" class="date_c ui-mr ui-text-blue">最近30天</a>
                <a href="javascript:;" data-type="5" class="date_c ui-mr ui-text-blue">全部</a>
            </div>
        </div>
        <div class="ui-form-group ui-row ui-select">
        	 <label class="ui-text-gray">来源状态：</label>
            <div class="ui-w-auto ui-mr">
                <select name="ctype" class="ui-form-ip">
                    <option value="0">订单来源</option>
                    <option value="1"{if $ctype==1} selected{/if}>Pc订单</option>
                    <option value="2"{if $ctype==2} selected{/if}>手机订单</option>
                    <option value="3"{if $ctype==3} selected{/if}>公众号订单</option>
                </select>
            </div>
            <div class="ui-w-auto ui-mr">
                <select name="type" class="ui-form-ip">
                    <option value="0">订单状态</option>
                    <option value="1"{if $type==1} selected{/if}>未付款</option>
                    <option value="2"{if $type==2} selected{/if}>已付款</option>
                    <option value="3"{if $type==3} selected{/if}>未发货</option>
                    <option value="4"{if $type==4} selected{/if}>已发货</option>
                </select>
            </div>
            <div class="ui-w-auto ui-mr">
                <select name="otype" class="ui-form-ip">
                    <option value="0">订单备注</option>
                    <option value="1"{if $otype==1} selected{/if}>未处理</option>
                    <option value="2"{if $otype==2} selected{/if}>无人接听</option>
                    <option value="3"{if $otype==3} selected{/if}>不要了</option>
                    <option value="4"{if $otype==4} selected{/if}>考虑中</option>
                    <option value="5"{if $otype==5} selected{/if}>已发货</option>
                    <option value="6"{if $otype==6} selected{/if}>拒签单</option>
                    <option value="7"{if $otype==7} selected{/if}>已退货</option>
                	<option value="8"{if $otype==8} selected{/if}>已退款</option>
                    <option value="99"{if $otype==99} selected{/if}>已完成</option>
                </select>
            </div>
        </div>
        <div class="ui-form-group ui-row ui-mb-0 ui-select">
            <label></label>
            <div class="ui-w-auto">
                <button type="submit" class="ui-btn blue ui-mr">搜索订单</button>
                <button type="submit" formaction="{U('exports')}" onClick="tips()" class="ui-btn yellow ui-mr">导出</button>
            </div>
        </div>
    </form>
</div>

<div class="ui-borders">
    <div class="ui-tabs ui-tabs-white" data-href="1">
    	<div class="ui-tabs-header-nav">
            <ul class="ui-tabs-nav">
                <li{if $type==0} class="active"{/if}><a href="{U('index','type=0')}">全部订单</a></li>
                <li{if $type==1} class="active"{/if}><a href="{U('index','type=1')}">未付款</a></li>
                <li{if $type==2} class="active"{/if}><a href="{U('index','type=2')}">已付款</a></li>
                <li{if $type==3} class="active"{/if}><a href="{U('index','type=3')}">待发货</a></li>
                <li{if $type==4} class="active"{/if}><a href="{U('index','type=4')}">已发货</a></li>
            </ul>
            <div class="ui-tabs-header-more">
                <select class="ui-form-ip ui-w-auto" onChange="location.href=this.value">
                    <option value="{A('index','pagenum=10')}" {if $pagenum==10} selected{/if}>10/页</option>
                    <option value="{A('index','pagenum=20')}" {if $pagenum==20} selected{/if}>20/页</option>
                    <option value="{A('index','pagenum=30')}" {if $pagenum==30} selected{/if}>30/页</option>
                    <option value="{A('index','pagenum=40')}" {if $pagenum==40} selected{/if}>40/页</option>
                    <option value="{A('index','pagenum=50')}" {if $pagenum==50} selected{/if}>50/页</option>
                </select>
            </div>
        </div>
        
    	<div class="ui-tabs-content">
    		<div class="ui-tabs-pane active">
    
            <form method="post" class="ui-form">
			<div class="ui-btn-group blue bgcolor ui-mb">
                <a class="ui-btn-group-item btach active" type="print">批量打印</a>
                <a class="ui-btn-group-item btach" type="post">批量发货</a>
                <a class="ui-btn-group-item btach" type="export">批量导出</a>
                <a class="ui-btn-group-item btach" type="del">批量删除</a>
            </div>

            <div class="ui-table-wrap">
                <table class="ui-table hover blue ui-mb{if !ismobile()} ui-hide{/if}" table-rule="ui-table">
                    <thead class="ui-thead-gray">
                        <tr>
                            <th tb-rule="{width:50,fixed:'left'}"><label class="ui-checkbox ui-tips" data-align="right-top" data-title="全选/取消"><input type="checkbox" class="checkall" value=""><i></i></label></th>
                            <th tb-rule="{width:70,fixed:'left'}">订单号</th>
                            <th tb-rule="{minWidth:260,align:'left'}">商品</th>
                            <th tb-rule="{width:60}">数量</th>
                            <th tb-rule="{width:120}">收件人</th>
                            <th tb-rule="{width:140,align:'left'}">收货地址</th>
                            <th tb-rule="{width:80}">推广渠道</th>
                            <th tb-rule="{width:90}">总金额</th>
                            <th tb-rule="{width:50}">明细</th>
                            <th tb-rule="{width:50}">日期</th>
                            <th tb-rule="{width:60}">付款</th>
                            <th tb-rule="{width:60}">发货</th>
                            <th tb-rule="{width:70}">备注</th>
                            <th tb-rule="{width:50,fixed:'right'}">操作</th>
                        </tr>
                    </thead>
                    <tbody>
                    {cms:rs pagesize="$pagenum" from="cms_order" where="$where" order="order_id desc" key="order_id"}
                    <tr>
                        <td><label class="ui-checkbox"><input type="checkbox" name="id" value="{$rs.order_id}"><i></i></label></td>
                        <td style="min-width:70px;"><i class="ui-icon-info-circle ui-tips" data-title="{redkey($rs.order_no,$keyword)}"></i>{if $rs.payway=='post'}<div class="ui-text-red">货到付款</div>{/if}</td>
                        <td class="ui-font-14" style="min-width:300px;"><a href="{$rs.goods_pic}" class="ui-lightbox" title="{$rs.goods_name}"><img src="{$rs.goods_pic}" width="60" height="60" class="ui-bd ui-mr" align="left"></a><a href="{U('home/goods/show','id='.$rs.goods_id.'')}" class="ui-text-hide-2 ui-height-20" target="_blank" title="查看">{redkey($rs.goods_name,$keyword)}</a><div><em>{$rs.goods_sku}</em></div></td>
                        <td style="min-width:60px;">×{$rs.goods_num}</td>
                        <td class="ui-font-12" style="min-width:120px;">{redkey($rs.name,$keyword)}<br>{redkey($rs.mobile,$keyword)}</td>
                        <td class="ui-font-12" style="min-width:180px;">{str_replace(" ","",$rs.area)}<br>{$rs.address}</td>
                        <td class="ui-font-14" style="min-width:80px;">{redkey($rs.order_from,$keyword)}</td>
                        <td class="ui-font-14" style="min-width:90px;">￥{getprice($rs.order_total)}{if $rs.ispay==0 && $rs.ispost==0}<br><a href="{U('change','id='.$rs.order_id.'')}" class="ui-iframe blue" data-title="订单改价" data-size="500px:290px">[改价]</a>{/if}</td>
                        <td class="ui-font-14"><i class="ui-icon-flag ui-tips" data-title="商品：{getprice($rs.goods_total)}<br>运费：{getprice($rs.goods_freight)}<br>手续费：{getprice($rs.goods_service)}"></i></td>
                        <td><i class="ui-icon-time-circle ui-tips" data-title="{date('Y-m-d',$rs.createdate)}<br>{date('H:i:s',$rs.createdate)}"></i></td>
                        <td class="ui-font-14" style="min-width:75px;">{if $rs.ispay==0}未付款<br><a href="{U('pay','id='.$rs.order_id.'')}" class="ui-iframe blue" data-title="订单收款" data-size="400px:120px">[收款]</a>{else}已付款{/if}</td>
                        <td class="ui-font-14" style="min-width:75px;">{if $rs.ispost==0}未发货{if $rs.payway=='post' || $rs.ispay==1}<br><a href="{U('post','id='.$rs.order_id.'')}" class="ui-iframe blue" data-title="订单发货" data-size="400px:160px">[发货]</a>{/if}{else}已发货{/if}</td>
                        <td class="ui-font-14" style="min-width:80px;">{get_state($rs.order_state)}{if $rs.order_state<99}<br><a href="{U('state','id='.$rs.order_id.'')}" class="ui-iframe blue" data-title="订单备注" data-size="300px:92px">[备注]</a>{/if}</td>
                        <td class="link" style="min-width:50px;"><a href="{U('show','id='.$rs.order_id.'')}" class="blue">查看</a><br><a href="{U('prints','id='.$rs.order_id.'')}" class="gray" target="_blank">打印</a><br><a href="{U('del','id='.$rs.order_id.'')}" class="ui-action gray" data-type="recycle">删除</a></td>
                    </tr>
                    {/cms:rs}
                    </tbody>
                </table>
                </div>
                {if $total_rs!=0}
                <div class="ui-page center blue mid">
                    <div class="ui-page-list"><ul>{$showpage}</ul></div>
                </div>
                {/if}
            </form>
        <!---->
    		</div>
        </div>
    </div>
</div>
<div class="ui-hide"><a href="javascript:;" target="_blank" id="gourl"></a></div>
<script src="{WEB_ROOT}public/datepick/laydate.js"></script>
<script src="{WEB_ROOT}public/table/table.js"></script>
<script>
{if !ismobile()}
layui.table.init('ui-table',
{
	{php $auto=(isset($auto))?$auto:0;}
	{if $auto>5}height:'full-260',{/if}
	text:{none:'暂无记录'}
});
{/if}
$(function()
{
	lay('.datepick').each(function()
	{
		laydate.render(
		{
			elem:this,
			type:'datetime',
			trigger:'click'
		});
	});
	$("select[name=stype]").change(function()
	{
		var a=$(this).find("option:selected").val();
		var str='';
		switch(a)
		{
			case "1":
				str='请输入订单编号';
				break;
			case "2":
				str='请输入客户姓名';
				break;
			case "3":
				str='请输入客户手机号';
				break;
			case "4":
				str='请输入推广渠道';
				break;
			case "5":
				str='请输入商品ID';
				break;
		}
		$("input[name=keyword]").attr("placeholder",str);
	});
    $(".date_c").click(function()
	{
		$("#begindate").val('');
		$("#overdate").val('');
		var type=$(this).data("type");
		var b='';
		var o='';
		switch(type)
		{
			case 1:
				b="{date('Y-m-d',strtotime('-1 day'))} 00:00:00";
				o="{date('Y-m-d',strtotime('-1 day'))} 23:59:59";
				break;
			case 2:
				b="{date('Y-m-d')} 00:00:00";
				o="{date('Y-m-d')} 23:59:59";
				break;
			case 3:
				b="{date('Y-m-d',strtotime('-6 day'))} 00:00:00";
				o="{date('Y-m-d')} 23:59:59";
				break;
			case 4:
				b="{date('Y-m-d',strtotime('-29 day'))} 00:00:00";
				o="{date('Y-m-d')} 23:59:59";
				break;
		}
		setTimeout(function()
		{
			$("#begindate").val(b);
			$("#overdate").val(o);	
		},200)
	});
	$(".btach").click(function()
	{
		event.preventDefault();
		var type=$(this).attr("type");
		var data=[];
		$(".ui-form").find("input[type=checkbox]:checked").each(function()
		{
			if($(this).attr("class")!='checkall' && !$(this).closest("label").hasClass("ui-switch"))
			{
				data.push($(this).val());
			}
		});
        if(data.length==0)
        {
            ui.error('至少选择一条订单');
        }
        else
        {
			data=unique(data);
            if(type=='del')
			{
				$.dialog(
				{
					title:"操作提示",
					text:"确定要放入回收站？",
					ok:function(e)
					{
						$.ajax(
						{
							type:'post',
							cache:false,
							dataType:'json',
							url:'{U("btach")}',
							data:'id='+data.join(","),
							error:function(e){alert(e.responseText);},
							success:function(d)
							{
								e.close();
								if(d.state=='success')
								{
									ui.success(d.msg);
									setTimeout(function(){location.href='{THIS_LOCAL}';},1500);
								}
								else
								{
									ui.error(d.msg);
								}
							}
						});
					}
				});
			}
			else
			{
				if(type=='print')
				{
					var url="{U('prints',"id=printid")}";
					url=url.replace('printid',data.join(","));
					$("#gourl").attr("target",'_blank');
				}
				else
				{
					if(type=='post')
					{
						var url="{U('posts',"id=printid")}";
					}
					else
					{
						var url="{U('export',"id=printid")}";
					}
					url=url.replace('printid',data.join(","));
					$("#gourl").attr("target",'');
				}
				$("#gourl").attr("href",url);
				$("#gourl")[0].click(function(){});
			}
        }
    });
})
</script>
</body>
</html>