<?php
/**
 * 作用：后台上传
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Upload extends AdminsController
{
	function __construct()
	{
		parent::__construct();
		#关掉日志
		define('SYS_LOG',false);
	}

	function index()
	{
		$result='';
		switch(F('get.action')) 
		{
			case 'image':
				$result=self::editor(1);
				break;
			case 'music':
				$result=self::editor(2);
				break;
			case 'video':
				$result=self::editor(3);
				break;
			default:
				$result=self::editor(4);
				break;
		}
		echo $result;
	}

	function editor($type)
	{
		$size=getint(F('size'));
		$total=getint(F('total'));
		$index=getint(F('index'));
		$totalsize=getint(F('totalsize'));
		$up=new cms_upload(['type'=>$type,'thumb'=>1,'water'=>1,'size'=>$size,'total'=>$total,'totalsize'=>$totalsize,'index'=>$index]);
		if($up->state=='success')
		{
			$isover=0;
			if($size==0 && $total==0)
			{
				$isover=1;
			}
			else
			{
				if(($index+1)==$total)
				{
					$isover=1;
				}
			}
			if($isover==1)
			{
				self::record($up->fileinfo,0);
			}
		}
		return $up->showmsg();
	}

	function saveRemote($url)
	{
		$info=['state'=>'错误','url'=>'','file'=>[]];
		#演示站原样返回
		if(APP_DEMO) return $info;
		$url=str_replace('&amp;','&',$url);
		if(strpos($url,'http')!==0)
		{
			$info['state']='链接不是http链接';
			return $info;
		}
		preg_match('/(^https*:\/\/[^:\/]+)/', $url, $matches);
        $host_with_protocol=count($matches)>1? $matches[1]:'';

        #判断是否是合法 url
        if(!filter_var($host_with_protocol, FILTER_VALIDATE_URL))
        {
            $info['state']='非法URL';
			return $info;
        }

        preg_match('/^https*:\/\/(.+)/',$host_with_protocol,$matches);
        $host_without_protocol=count($matches)>1?$matches[1]:'';

        #此时提取出来的可能是 ip 也有可能是域名，先获取 ip
        $ip=gethostbyname($host_without_protocol);
        #判断是否是私有 ip
        if(!filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE))
        {
            $info['state']='非法IP';
			return $info;
        }
        #获取请求头并检测死链
        $heads=get_headers($url, 1);
        if (!(stristr($heads[0], "200") && stristr($heads[0], "OK")))
        {
            $info['state']='链接不可用';
			return $info;
        }
        #格式验证(扩展名验证和Content-Type验证)
        if(isset($heads['Content-Type']))
        {
        	$heads['Content-Type']=str_replace(';charset=UTF-8','',$heads['Content-Type']);
        	switch($heads['Content-Type'])
        	{
        	 	case 'image/gif':
        	 		$ext='.gif';
        	 		break;
        	 	case 'image/jpeg':
        	 		$ext='.jpg';
        	 		break;
        	 	case 'image/png':
        	 		$ext='.png';
        	 		break;
        	 	case 'image/bmp':
        	 		$ext='.bmp';
        	 		break;
        	 	case 'image/webp':
        	 		$ext='.webp';
        	 		break;
        	 	default:
        	 		$info['state']='非法图片'.$heads['Content-Type'];
        	 		return $info;
        	 		break;
        	 }
        }
        if(!in_array($ext,[".png",".jpg",".jpeg",".gif",".webp"]) || !isset($heads['Content-Type']) || !stristr($heads['Content-Type'], "image"))
        {
            $info['state']='链接contentType不正确';
			return $info;
        }
        #打开输出缓冲区并获取远程图片
        ob_start();
        $context=stream_context_create(array('http'=>array('follow_location'=>false)));
        readfile($url,false,$context);
        $img=ob_get_contents();
        ob_end_clean();
        preg_match("/[\/]([^\/]*)[\.]?[^\.\/]*$/",$url,$m);
        if(check_bad($img)!='')
		{
			$info['state']='非法图像文件';
			return $info;
		}
		$size=strlen($img);
        if($size>config('upload_max')*1024*1024)
        {
        	$info['state']='文件大小超出网站限制';
			return $info;
        }
        switch(config('upload_file_folder'))
		{
			case '1':
				$filepath='upfile/'.date("Y").'/';
				break;
			case '2':
				$filepath='upfile/'.date("Y").'/'.date("m").'/';
				break;
			case '3':
				$filepath='upfile/'.date("Y").'/'.date("m").'/'.date("d").'/';
				break;
			default:
				$filepath='upfile/'.date("Ym").'/';
		}
		if(!is_dir($filepath))
		{
			if(!mkfolder($filepath))
			{
				$info['state']='文件夹创建失败';
				return $info;
			}
		}
		$newname=time().mt_rand(100,999).$ext;
		if(!(file_put_contents($filepath.$newname,$img) && file_exists($filepath.$newname)))
		{
            $info['state']='移动失败';
        }
        else
        {
	        $fileway=config('upload_way');
			if($fileway=='local')
			{
				$info['state']='SUCCESS';
            	$info['url']=WEB_ROOT.$filepath.$newname;
            }
            else
            {
            	$data['tmp_name']=$filepath.$newname;
	        	$data['type']='image/'.$ext;
	        	$data['size']=$size;
	        	$class='upload_'.$fileway;
	        	cms::load($fileway,'plug');
				$up=new $class();
				$result=$up->upload($data,$filepath.$newname,($size/1024/1024),0,0,$filepath,$filepath,$ext,'',1,0,0);
				if($result)
				{
					$info['url']=$up->backurl;
					$info['state']='SUCCESS';
					#删除本地文件
					@unlink($filepath.$newname);
				}
				else
				{
					$info['state']=$up->msg;
				}
			}
			if($info['state']=='SUCCESS')
			{
				$old=explode('/',$url);
				$old=end($old);
				list($name)=explode('?',$old);
				$info['file']=['file_url'=>$info['url'],'file_name'=>enhtml($name),'file_ext'=>strtolower($ext),'file_size'=>$size,'file_type'=>1,'file_update'=>time(),'file_ip'=>getip()];
			}
        }
        return $info;
	}

	function outimage()
	{
		$a=F('content','',1);
		if(empty($a))
		{
			echo '';
			exit;
		}
		#去掉反斜杠
		$a=stripslashes($a);
		list($host)=explode(':',$_SERVER['HTTP_HOST']);
		$d=get_all_picurl($a,$host);
		if(is_array($d))
		{
			foreach($d as $key=>$val)
			{
				$info=self::saveRemote($val);
				if($info['state']=='SUCCESS')
				{
					$a=str_replace($val,$info['url'],$a);
					self::record($info['file']);
				}
				/*
				else
				{
					$a=$info['state'];
				}
				*/
			}
		}
		echo $a;
	}

	function upfile()
	{
		$water=getint(F('get.water'));
		$thumb=getint(F('get.thumb'));
		$type=getint(F('get.type'),1);
		$iseditor=getint(F('get.iseditor'));
		$islocal=getint(F('get.islocal'));
		$gid=getint(F('gid'));
		$size=getint(F('size'));
		$total=getint(F('total'));
		$index=getint(F('index'));
		$totalsize=getint(F('totalsize'));
		if($iseditor==1)
		{
			$thumb=1;
			$water=1;
		}
		$up=new cms_upload(['type'=>$type,'thumb'=>$thumb,'water'=>$water,'size'=>$size,'total'=>$total,'totalsize'=>$totalsize,'index'=>$index,'islocal'=>$islocal]);
		if($up->state=='success')
		{
			$isover=0;
			if($size==0 && $total==0)
			{
				$isover=1;
			}
			else
			{
				if(($index+1)==$total)
				{
					$isover=1;
				}
			}
			if($isover==1)
			{
				self::record($up->fileinfo,$gid);
			}
		}
		echo $up->showmsg();
	}

	function imagelist()
	{
		$type=getint(F('get.type'));
		$multiple=getint(F('get.multiple'));
		$thumb=getint(F('get.thumb'),1);
		$water=getint(F('get.water'),1);
		$iseditor=getint(F('get.iseditor'));
		$gid=F('get.gid');
		$where="1=1";
		$order="id desc";
		$where_query='';
		if(in_array($type,[1,2,3,4]))
		{
			$where="file_type=$type";
			$where_query=" and file_type=$type";
		}
		if($type==4 && $iseditor==0)
		{
			$where="file_type>=1";
			$where_query=" and file_type>=1";
		}
		if($gid=='')
		{
			$gid='a';
		}
		if($gid!='a')
		{
			$where.=" and gid=".getint($gid)."";
		}
		$total=$this->db->count("select count(1) from cms_file where gid=0 $where_query");
		$this->tp->add('type',$type);
		$this->tp->add('multiple',$multiple);
		$this->tp->add('thumb',$thumb);
		$this->tp->add('water',$water);
		$this->tp->add('iseditor',$iseditor);
		$this->tp->add('gid',$gid);
		$this->tp->add('where',$where);
		$this->tp->add('where_query',$where_query);
		$this->tp->add('order',$order);
		$this->tp->add('total',$total);
		$this->tp->show('other/image.php');
	}

	function imageupload()
	{
		$type=getint(F('get.type'));
		$multiple=getint(F('get.multiple'));
		$iseditor=getint(F('get.iseditor'));
		$gid=getint(F('get.gid'));
		$thumb=getint(F('get.thumb'));
		$water=getint(F('get.water'));
		$this->tp->add('type',$type);
		$this->tp->add('multiple',$multiple);
		$this->tp->add('iseditor',$iseditor);
		$this->tp->add('thumb',$thumb);
		$this->tp->add('water',$water);
		$this->tp->add('gid',$gid);
		$this->tp->show('other/upload.php');
	}
	
	function addgroup()
	{
		if(IS_POST)
		{
			$name=left(trim(F('name')),50);
			$data=[[$name,'null','分组名称不能为空']];
			$v=new cms_verify($data);
			if($v->result())
			{
				$rs=$this->db->row("select * from cms_file_group where gname='$name' limit 1");
				if($rs)
				{
					$this->error('分组名称已存在');
				}
				else
				{
					$d=[];
					$d['gname']=$name;
					$d['ordnum']=0;
					$d['islock']=1;
					$this->db->add('cms_file_group',$d);
					$this->success($this->db->newid);
				}
			}
			else
			{
				$this->error($v->msg);
			}
		}
	}

	private function record($data,$gid=0)
	{
		if(!APP_DEMO && is_array($data))
		{
			$data['file_adminid']=ADMIN_ID;
			$data['file_local']='local';
			$data['gid']=$gid;
			$this->db->add("cms_file",$data);
		}
	}

}