<?php
class Upgrade extends AdminsController
{
	function __construct()
	{
		parent::__construct();
		if(get_admin_info('pid')>0)
		{
			$this->error('普通管理员没有操作权限');
			exit();
		}
	}

	private function getnew()
	{
		$uname=config('sys_uname');
		$upass=config('sys_upass');
		if($uname=='' || $upass=='')
		{
			return ['state'=>'error','msg'=>'未绑定官网账号'];
		}
		$upass=$this->decode($upass);
		$domain=cms_parse::getHost();
		if(is_array($upass))
		{
			return ['state'=>'error','msg'=>'密码解密失败，请重新绑定'];
		}
		$version=config('version_number');
		return cms_http::post(['url'=>SYS_API_URL.'/check','data'=>"uname={$uname}&upass={$upass}&domain={$domain}&version={$version}&type=order",'type'=>1]);
	}

	function version()
	{
		if(IS_POST)
		{
			$res=$this->getnew();
			if($res['state']=='200' || $res['state']=='301')
			{
				$arr=D($res['msg']);
				$msg=$arr['msg'];
				if($arr['state']=='error')
				{
					$this->error($msg);
					return;
				}
				$last=V($msg['version']);
				$url=$msg['url'];
				$content=$msg['content'];
				$version=V(config('version_number'));
				if($last>$version)
				{
					$this->success(E(['version'=>$last,'content'=>$content,'url'=>$url]));
					exit();
				}
				else
				{
					$this->error("暂无新版可升级");
				}
			}
			else
			{
				if($res['state']=='error')
				{
					$this->error($res['msg']);
				}
				else
				{
					$this->error("无法连接升级服务器");
				}
			}
		}
	}

	function zip()
	{
		if(IS_POST)
		{
			$res=$this->getnew();
			if($res['state']=='200' || $res['state']=='301')
			{
				$arr=D($res['msg']);
				$msg=$arr['msg'];
				if($arr['state']=='error')
				{
					$this->error($msg);
					return;
				}
				$last=$msg['version'];
				$url=$msg['url'];
				$version=V(config('version_number'));
				if($last==$version)
				{
					$this->error("暂无新版可升级");
					return;
				}
			}
			else
			{
				if($res['state']=='error')
				{
					$this->error($res['msg']);
				}
				else
				{
					$this->error("无法连接升级服务器");
				}
				return;
			}
			if($url=='' || $url=='#')
			{
				$this->error('暂无可用升级包');
				return;
			}
			#下载文件
			$url=get_api_url($url);
			$res=cms_http::get(['url'=>$url,'type'=>1]);
			if(!($res['state']=='200' || $res['state']=='301'))
			{
				$this->error('升级包下载失败');
				return;
			}
			$root='cache/temp/update';
			delfolder($root);
			$filename=$root.'/update.zip';
			if(!is_dir($root))
			{
				mkfolder($root);
			}
			$res=savefile($filename,$res['msg']);
			if(!$res)
			{
				$this->error('【'.$root.'】读写权限不足');
				return;
			}
			$result=cms_zip::unzip($filename,$root);
	    	if(!$result)
	    	{
	    		$this->error("解压失败：$result");
	    		return;
	    	}
			#解压成功后删除压缩包
			@unlink($filename);

			#当前站点后台路径
			$admindir=M_NAME;

			#检查当前网站后台路径是否为admin，如果不是，重命名解压后的后台文件夹名称
			if($admindir!='admin')
			{
				if(is_dir($root."/app/admin"))
				{
					rename($root."/app/admin",$root."/app/{$admindir}");
				}
			}
			#执行update.php
			if(is_file($root."/update.php"))
			{
				require $root."/update.php";
				@unlink($root."/update.php");
				#删除此文件
			}
			#将文件夹打包
			$result=cms_zip::zip('cache/temp/update/',"cache/update.zip");
			if($result!=1)
			{
				$this->error('打包失败');
				return;
			}
			#解压到根目录
			$result=cms_zip::unzip("cache/update.zip",SYS_PATH);
			if(!$result)
	    	{
	    		$this->error("解压失败：$result");
	    		return;
	    	}
			#删除临时文件
			delfolder($root);
			$this->success('升级成功');
		}
	}

}