<?php
/**
 * 作用：模板管理
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Theme extends AdminsController
{
	private $root;
	public function __construct()
	{
		parent::__construct();
		$this->root='store/';
	}

	function index()
	{
		$folder=scandir('theme');
		if(!$folder)
		{
			die('【scandir】函数不支持，请在Php.ini中去掉限制');
		}
		unset($folder[0]);
		unset($folder[1]);
		$type=getint(F('type'));
		foreach($folder as $key=>$val)
		{
			if(!is_dir('theme/'.$val))
			{
				unset($folder[$key]);
			}
			else
			{
				unset($folder[$key]);
				if(is_file('theme/'.$val.'/_theme.php'))
				{
					$info=require('theme/'.$val.'/_theme.php');
					$folder[$val]=['app'=>$val,'key'=>$this->encode($val),'title'=>$info['title'],'intro'=>$info['intro'],'image'=>$info['image'],'author'=>$info['author'],'url'=>$info['url'],'isstall'=>(config('theme_dir')==$val)?1:0];
				}
			}
		}
		if($type==1)
		{
			$page=getint(F('page'),1);
			$data=self::applist($page);

			#总记录数
			$totalnum=$data['totalnum'];

			#总页数
			$totalpage=$data['totalpage'];

			#插件数据
			$list=$data['list'];

			foreach($list as $key=>$val)
			{
				if(config('theme_dir')==$val['root'])
				{
					$val['isstall']=1;
				}
				else
				{
					$val['isstall']=0;
				}
				$val['key']=$this->encode($val['root']);
				$list[$key]=$val;
			}
			$this->tp->add('list',$list);
			$this->tp->add('totalnum',$totalnum);
			$this->tp->add('totalpage',$totalpage);
			$this->tp->add('page',$page);
		}
		$this->tp->add('folder',$folder);
		$this->tp->add('type',$type);
		if($type==0)
		{
			$this->tp->show($this->root."local.php");
		}
		else
		{
			$this->tp->show($this->root."net.php");
		}
	}

	function geturl()
	{
		if(IS_POST)
		{
			#关掉管理日志
			define('SYS_LOG',false);
			$page=getint(F('page'),1);
			$this->success(U('index','type=1&page='.$page.''));
		}
	}

	function applist($page)
	{
		$res=cms_http::post(['url'=>SYS_API_URL."/templist",'data'=>"type=order&page=$page",'type'=>1]);
		if($res['state']=='200' || $res['state']=='301')
		{
			$arr=D($res['msg']);
			if($arr['state']=='success')
			{
				return $arr['msg'];
			}
			else
			{
				exit($arr['msg']);
			}
		}
		else
		{
			cms_log::log('无法获取模板服务器列表','sys_');
		}
		return ['totalnum'=>0,'totalpage'=>1,'list'=>[]];
	}

	function down()
	{
		if(IS_POST)
		{
			$id=getint(F('get.id'));
			if($id<=0)
			{
				$this->error('ID参数错误');
				return;
			}
			$uname=config('sys_uname');
			$upass=config('sys_upass');
			if($uname=='' || $upass=='')
			{
				$this->error("未绑定官网账号");
				return;
			}
			$upass=$this->decode($upass);
			if(is_array($upass))
			{
				$this->error("绑定的密码解密失败，请重新绑定");
				return;
			}
			#连接插件服务器，获取文件
			$res=cms_http::post(['url'=>SYS_API_URL.'/tempshow','data'=>"uname={$uname}&upass={$upass}&id={$id}&type=pay",'type'=>1]);
			if($res['state']=='200' || $res['state']=='301')
			{
				$arr=D($res['msg']);
				$msg=$arr['msg'];
				if($arr['state']=='error')
				{
					$this->error($msg);
					return;
				}
				$name=$msg['name'];
				$url=$msg['url'];
			}
			else
			{
				$this->error('无法连接模板服务器');
				return;
			}
			#下载文件
			$url=get_api_url($url);
			$res=cms_http::get(['url'=>$url,'type'=>1]);
			if(!($res['state']=='200' || $res['state']=='301'))
			{
				$this->error($url.'获取失败');
				return;
			}
			$root='cache/temp';
			$filename=$root.'/'.$name.'.zip';
			mkfolder($root);
			mkfolder("theme/$name");
			$res=savefile($filename,$res['msg']);
			if(!$res)
			{
				$this->error('【'.$root.'】读写权限不足');
				return;
			}
			$result=cms_zip::unzip($filename,"theme/$name");
	    	if(!$result)
	    	{
	    		$this->error("解压失败：$result");
	    		return;
	    	}
			#删除临时文件
			@unlink($filename);
			$this->success('下载成功');
		}
	}

	function config()
	{
		if(IS_POST)
		{
			$config=F('config');
			if(!is_file('theme/'.$config.'/_theme.php'))
			{
				$this->error('模板配置错误');
			}
			else
			{
				$this->db->update("cms_config","ckey='theme_dir'",['cvalue'=>$config]);
				#删除缓存
				cms_cache::del();
				$this->success('应用成功');
			}
		}
	}

	function delete()
	{
		if(IS_POST)
		{
			$config=F('config');
			$config=str_replace('..','',$config);
			if(!is_dir('theme/'.$config))
			{
				$this->error('模板路径错误');
			}
			else
			{
				if($config==config('theme_dir'))
				{
					$this->error('模板正在使用，无法删除!');
					return;
				}
				delfolder('theme/'.$config);
				$this->success('删除成功');
			}
		}
	}

	function lists()
	{
		$dir=$this->decode(F('root'));
		$dir=str_replace('..','',$dir);
		$root='theme/'.$dir;
		if(!is_dir($root))
		{
			die('非法路径');
		}
		list($theme)=explode('/',$dir);
		self::check_note($theme);
		$name=require('theme/'.$theme.'/_note.php');
		$data=self::deal_arr(scandir($root),$root,$dir);
		$folder=$data[0];
		$file=$data[1];
		$arr=explode('/',$dir);
		$str='';
		$position='';
		foreach($arr as $key=>$val)
		{
			if($key==0)
			{
				$str=$val;
			}
			else
			{
				$str.='/'.$val;
			}
			$position.=' > <a href="'.U('lists','root='.$this->encode($str).'').'">'.$val.'</a>';
		}
		$arr=explode('/',$dir);
		array_shift($arr);
		$note=implode('/',$arr);
		if($note){$note.='/';}

		$this->tp->add('dir',$dir);
		$this->tp->add('note',$note);
		$this->tp->add('position',$position);
		$this->tp->add('folder',$folder);
		$this->tp->add('file',$file);
		$this->tp->add('name',$name);
		$this->tp->show($this->root.'list.php');
	}

	function edit()
	{
		if(IS_POST)
		{
			$dir=$this->decode(F('t0'));
			$dir=str_replace('..','',$dir);
			$root='theme/'.$dir;
			if(!is_file($root))
			{
				$this->error('非法文件');
				return;
			}
			$data=explode("/",$dir);
			if(count($data)>2 && $data[1]=='block')
			{
				$this->error('非法文件');
				return;
			}
			list($theme)=explode('/',$dir);
			self::check_note($theme);
			$name=require('theme/'.$theme.'/_note.php');
			$db=explode('/',$dir);
			unset($db[0]);
			$note=implode('/',$db);
			$t1=F('t1');
			if(empty($t1))
			{
				unset($name[$note]);
			}
			else
			{
				$name[$note]=F('t1');
			}
			$text=self::deal_text(F('t2','',1),$dir);
			$data=[[$text,'null','内容不能为空']];
			if(check_bad($text)>0)
			{
				$data=array_merge($data,[[true,'other','请勿提交非法内容']]);
			}
			$num=preg_match_all('/\\$([\w])\.\\$([\w])/',$text,$match);
			if($num>0)
			{
				$data=array_merge($data,[[true,'other','请勿提交非法内容'.$match[0][0]]]);
			}
			$text=str_replace(['?php','?>',"< if(!defined('IN_CMS')) exit;"],'',str_replace("&#039;","'",$text));
			
			$v=new cms_verify($data);
			if($v->result())
			{
				if(strpos($root,'.php'))
				{
					$text="<?php if(!defined('IN_CMS')) exit;?>".$text;
				}
				if(savefile($root,$text))
				{
					$this->success('保存成功');
					$data="<?php\nif(!defined('IN_CMS')) exit;\nreturn ".var_export($name, true).";\n?>";
					savefile('theme/'.$theme.'/_note.php', $data);
				}
			}
			else
			{
				$this->error($v->msg);
			}
		}
		else
		{
			$dir=$this->decode(F('get.root'));
			$dir=str_replace('..','',$dir);
			$root='theme/'.$dir;
			if(!is_file($root))
			{
				die('非法文件');
			}
			$data=explode("/",$dir);
			if(count($data)>2 && $data[1]=='block')
			{
				die('非法文件');
			}
			if(self::isImage($root))
			{
				die('图像文件不可编辑');
			}
			$arr=explode('/',$dir);
			array_pop($arr);
			list($theme)=explode('/',$dir);
			self::check_note($theme);
			$name=require('theme/'.$theme.'/_note.php');
			$remark='';
			$db=explode('/',$dir);
			unset($db[0]);
			$note=implode('/',$db);
			if(isset($name[$note]))
			{
				$remark=$name[$note];
			}
			$arr=explode('/',$dir);
			array_pop($arr);
			$str='';
			$position='';
			foreach($arr as $key=>$val)
			{
				if($key==0)
				{
					$str=$val;
				}
				elseif($key!=count($arr))
				{
					$str.='/'.$val;
				}
				$position.=' > <a href="'.U('lists','root='.$this->encode($str).'').'">'.$val.'</a>';
			}
			$data=file_get_contents($root);
			if(APP_DEMO) $data='您的账户没有查看模板代码权限';
			$this->tp->add('file',$dir);
			$this->tp->add('file_code',$this->encode($dir));
			$this->tp->add('remark',$remark);
			$this->tp->add('data',str_replace("<?php if(!defined('IN_CMS')) exit;?>",'',$data));
			$this->tp->add('old',$this->encode(implode('/',$arr)));
			$this->tp->add('position',$position);
			$this->tp->show($this->root.'edit.php');
		}
	}

	function isImage($filename)
	{
		$res=false;
	    if(file_exists($filename))
	    {
	    	$info=pathinfo($filename);
	        $ext=$info['extension'];
	        if(in_array($ext,['gif','jpg','jpeg','png']))
	        {
	        	$res=true;
	        }
	    }
	    return $res;
	}

	function deal_arr($data,$root,$dir='')
	{
		unset($data[0]);unset($data[1]);
		$a=[];
		$b=[];
		foreach($data as $key=>$val)
		{
			if(is_dir($root.'/'.$val))
			{
				$a[$key]=['0'=>$val,'1'=>filemtime($root.'/'.$val)];
				$dir=rtrim($dir,"/");
				$a[$key][2]=$this->encode($dir.'/'.$a[$key][0]);
			}
			elseif(is_file($root.'/'.$val))
			{
				$b[$key]=['0'=>$val,'1'=>filemtime($root.'/'.$val),'2'=>formatBytes(filesize($root.'/'.$val))];
				$b[$key][3]=$this->encode($dir.'/'.$b[$key][0]);
				$b[$key][4]=self::isImage($root.'/'.$val);
			}
			else
			{
				unset($data[$key]);
			}
		}
		return ['0'=>$a,'1'=>$b];
	}

	function check_note($theme)
	{
		if(!file_exists('theme/'.$theme.'/_note.php'))
		{
			$d="<?php\nif(!defined('IN_CMS')) exit;\nreturn ".var_export([], true).";\n?>";
			savefile('theme/'.$theme.'/_note.php', $d);
		}
	}

	function deal_text($str,$dir)
	{
		$arr=pathinfo($dir);
		if($arr['extension']!='css')
		{
			$str=str_replace('../','',$str);
		}
		return stripslashes($str);
	}

	function template()
	{
		$root=$this->decode(F('root'));
		$root=str_replace('..','',$root);
		if($root=='')
		{
			$root='theme/'.config('theme_dir').'/';
		}
		else
		{
			$root='theme/'.config('theme_dir').'/'.$root.'/';
		}

		$dir=str_replace('theme/'.config('theme_dir').'/','',$root);
		if(!is_dir($root))
		{
			die($root.'文件夹不存在');
		}
		$arr=explode('/',ltrim($dir,"/"));
		$str='';
		$position='';
		$default='theme/'.config('theme_dir').'/';
		foreach($arr as $key=>$val)
		{
			if($key==0)
			{
				$str=$val;
			}
			else
			{
				$str.='/'.$val;
			}
			$position.=' > <a href="'.U('template','root='.$this->encode($str).'').'">'.$val.'</a>';
		}
		$data=self::deal_arr(scandir($root),$root,$dir);
		$folder=$data[0];
		$file=$data[1];
		self::check_note(config('theme_dir'));
		$name=require('theme/'.config('theme_dir').'/_note.php');
		$this->tp->add('folder',$folder);
		$this->tp->add('file',$file);
		$this->tp->add('name',$name);
		$this->tp->add('root',$root);
		$this->tp->add('dir',$dir);
		$this->tp->add('position',$position);
		$this->tp->show($this->root."template.php");
	}

}