<?php
/**
 * 作用：插件列表
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Plug extends AdminsController
{
	private $root;
	public function __construct()
	{
		parent::__construct();
		$this->root='store/plug/';
	}

	function index()
	{
		$type=getint(F('type'));
		$mode=F('mode');
		if(!in_array($mode,['pay','sms','upload','express','safe','tool','other']))
		{
			$mode='all';
		}

		$this->tp->add('type',$type);
		$this->tp->add('mode',$mode);

		if($type==0)
		{
			$where=($mode=='all')?'1=1':"type='$mode'";
			$this->tp->add('where',$where);
			$this->tp->show($this->root."local.php");
		}
		else
		{
			$page=getint(F('page'),1);
			#获取接口数据
			$data=self::applist($page,$mode);

			$plug=config('plug');

			#总记录数
			$totalnum=$data['totalnum'];

			#总页数
			$totalpage=$data['totalpage'];

			#插件数据
			$list=$data['list'];

			foreach($list as $key=>$val)
			{
				if(isset($plug[$val['root']]))
				{
					$val['state']=1;
					$val['upgrade']=(V($val['version']))>V($plug[$val['root']]['version'])?1:0;
				}
				else
				{
					$val['state']=0;
					$val['upgrade']=0;
				}
				$list[$key]=$val;
			}

			$this->tp->add('data',$list);
			$this->tp->add('totalnum',$totalnum);
			$this->tp->add('totalpage',$totalpage);
			$this->tp->add('page',$page);
			$this->tp->show($this->root."net.php");
		}
	}

	function geturl()
	{
		if(IS_POST)
		{
			#关掉管理日志
			define('SYS_LOG',false);
			$page=getint(F('page'),1);
			$this->success(U('index','type=1&page='.$page.''));
		}
	}

	function applist($page,$mode)
	{
		$res=cms_http::post(['url'=>SYS_API_URL."/pluglist",'data'=>"type=order&mode=$mode&page=$page",'type'=>1]);
		#print_r($res);
		if($res['state']=='200' || $res['state']=='301')
		{
			$arr=D($res['msg']);
			if($arr['state']=='success')
			{
				return $arr['msg'];
			}
			else
			{
				exit($arr['msg']);
			}
		}
		else
		{
			cms_log::log('无法获取插件服务器列表','sys_');
		}
		return ['totalnum'=>0,'totalpage'=>1,'list'=>[]];
	}

	function import()
	{
		if(IS_POST)
		{
			$name=strtolower(trim(F('name')));
			if($name=='')
			{
				$this->error('插件文件夹不能为空');
				return;
			}
			if(!preg_match('/^[a-zA-Z0-9-_]+$/',$name))
			{
				$this->error('只能为字母或数字的组合');
				return;
			}
			if(!is_dir('plug/'.$name))
			{
				$this->error('插件文件夹不存在，请检查');
				return;
			}
			if(!is_file('plug/'.$name.'/_config.php'))
			{
				$this->error('插件配置文件不存在');
				return;
			}
			$config=require('plug/'.$name.'/_config.php');
			if($config['install'] && $way==0)
			{
				$split=explode('@@@@',$config['install']);
				foreach($split as $key=>$val)
				{
					$this->db->query($val);
				}
			}
			$rs=$this->db->row("select id from cms_plug where root='$name' limit 1");
			if($rs)
			{
				$this->error('插件已安装过');
				return;
			}
			else
			{
				$d=[];
				$d['name']=$config['title'];
				$d['root']=$name;
				$d['icon']=$config['icon'];
				$d['intro']=$config['intro'];
				$d['hook']=getint($config['hook']);
				$d['version']=$config['version'];
				$d['config']=($config['config']=='')?E([]):$config['config'];
				$d['type']=$config['type'];
				$d['admin']=getint($config['admin']);
				$d['state']=1;
				$this->db->add('cms_plug',$d);
			}
			
			#清理缓存
			cms_cache::del('plug');
			$this->success('安装成功');
		}
	}

	function install()
	{
		if(IS_POST)
		{
			$id=getint(F('get.id'));
			$name=F('get.name');
			$way=getint(F('get.way'));
			if($id<=0 && $name=='')
			{
				$this->error('参数错误');
				return;
			}
			if($id>0)
			{
				$uname=config('sys_uname');
				$upass=config('sys_upass');
				if($uname=='' || $upass=='')
				{
					$this->error("未绑定官网账号");
					return;
				}
				$upass=$this->decode($upass);
				if(is_array($upass))
				{
					$this->error("绑定的密码解密失败，请重新绑定");
					return;
				}
				#连接插件服务器，获取文件
				$res=cms_http::post(['url'=>SYS_API_URL.'/plugshow','data'=>"uname={$uname}&upass={$upass}&id={$id}&type=pay",'type'=>1]);
				if($res['state']=='200' || $res['state']=='301')
				{
					$arr=D($res['msg']);
					$msg=$arr['msg'];
					if($arr['state']=='error')
					{
						$this->error($msg);
						return;
					}
					$name=$msg['name'];
					$url=$msg['url'];
				}
				else
				{
					$this->error('无法连接插件服务器');
					return;
				}
				#下载文件
				$url=get_api_url($url);
				$res=cms_http::get(['url'=>$url,'type'=>1]);
				if(!($res['state']=='200' || $res['state']=='301'))
				{
					$this->error($url.'获取失败');
					return;
				}
				$root='cache/temp';
				$filename=$root.'/'.$name.'.zip';
				mkfolder($root);
				mkfolder("plug/$name");
				$res=savefile($filename,$res['msg']);
				if(!$res)
				{
					$this->error('【'.$root.'】读写权限不足');
					return;
				}
				$result=cms_zip::unzip($filename,"plug/$name");
		    	if(!$result)
		    	{
		    		$this->error("解压失败：$result");
		    		return;
		    	}
				#删除临时文件
				@unlink($filename);
				if(!is_dir('plug/'.$name))
				{
					$this->error('插件路径错误');
					return;
				}
			}
			
			if(!is_file('plug/'.$name.'/_config.php'))
			{
				$this->error('插件配置错误');
				return;
			}
			$config=require('plug/'.$name.'/_config.php');
			if($config['install'] && $way==0)
			{
				$split=explode('@@@@',$config['install']);
				foreach($split as $key=>$val)
				{
					$this->db->query($val);
				}
			}
			$rs=$this->db->row("select id from cms_plug where root='$name' limit 1");
			if($rs)
			{
				$version=$config['version'];
				$intro=$config['intro'];
				$this->db->update('cms_plug',"root='$name'",['state'=>1,'intro'=>$intro,'version'=>$version]);
			}
			else
			{
				$d=[];
				$d['name']=$config['title'];
				$d['root']=$name;
				$d['icon']=$config['icon'];
				$d['intro']=$config['intro'];
				$d['hook']=getint($config['hook']);
				$d['version']=$config['version'];
				$d['config']=($config['config']=='')?E([]):$config['config'];
				$d['type']=$config['type'];
				$d['admin']=getint($config['admin']);
				$d['state']=1;
				$this->db->add('cms_plug',$d);
			}
			
			#清理缓存
			cms_cache::del('plug');
			$this->success('安装成功');
		}
	}

	function uninstall()
	{
		if(IS_POST)
		{
			$name=F('get.name');
			if(!is_dir('plug/'.$name))
			{
				$this->error('插件路径错误');
			}
			else
			{
				if(!is_file('plug/'.$name.'/_config.php'))
				{
					$this->error('插件配置错误');
				}
				else
				{
					$rs=$this->db->row("select id from cms_plug where root='$name' limit 1");
					if($rs)
					{
						$config=require('plug/'.$name.'/_config.php');
						if($config['delete'])
						{
							$split=explode('@@@@',$config['delete']);
							foreach ($split as $key=>$val)
							{
								$this->db->query($val);
							}
						}
						delfolder('plug/'.$name);
						delfolder('cache/plug/'.$name);
						$this->db->del('cms_plug',"root='$name'");
					}
					#清理缓存
					cms_cache::del('plug');
					$this->success('卸载成功');
				}
			}
		}
	}
}