<?php
/**
 * 作用：订单管理
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Order extends AdminsController
{
	private $tbname,$root;
	function __construct()
	{
		parent::__construct();
		$this->tbname='cms_order';
		$this->root='order/';
	}

	function index()
	{
		$where='isdel=0 ';
		$pagenum=getint(F('pagenum'),20);
		$pagenum=($pagenum>100 || $pagenum<=0)?20:$pagenum;
		$stype=getint(F('stype'));
		$keyword=F('keyword');
		$begindate=F('begindate');
		$overdate=F('overdate');
		$ctype=getint(F('ctype'));
		$otype=getint(F('otype'));
		$type=getint(F('type'));
		
		if(!empty($keyword) && $stype>0)
		{
			switch($stype)
			{
				case '1':
					$where.=" and order_no like '%".$keyword."%' ";
					break;
				case '2':
					$where.=" and name like '%".$keyword."%' ";
					break;
				case '3':
					$where.=" and mobile like '%".$keyword."%' ";
					break;
				case '4':
					$where.=" and (order_from like '%".$keyword."%' or order_from='$keyword')";
					break;
				case '5':
					$where.=" and goods_id like ".getint($keyword)." ";
					break;
			}
		}
		if(!empty($begindate) && !empty($overdate))
		{
			$begin=strtotime($begindate);
			$over=strtotime($overdate);
			$where.=" and createdate>=$begin and createdate<=$over ";
		}
		if($ctype>0)
		{
			$where.=" and comefrom=$ctype ";
		}
		if($otype>0)
		{
			$where.=" and order_state=$otype ";
		}
		$position='全部订单';
		switch($type)
		{
			case '1':
				$where.=" and ispay=0";
				$position='未付款';
				break;
			case '2':
				$where.=" and ispay=1";
				$position='已付款';
				break;
			case '3':
				$where.=" and ((ispay=1 and ispost=0) or (ispay=0 and payway='post' and ispost=0))";
				$position='未发货';
				break;
			case '4':
				$where.=" and ispost=1";
				$position='已发货';
				break;
		}
		$this->tp->add("position","<a href=\"".U('index','type='.$type.'')."\">{$position}</a>");
		$this->tp->add("pagenum",$pagenum);
		$this->tp->add("stype",$stype);
		$this->tp->add("keyword",$keyword);
		$this->tp->add("begindate",$begindate);
		$this->tp->add("overdate",$overdate);
		$this->tp->add("type",$type);
		$this->tp->add("ctype",$ctype);
		$this->tp->add("otype",$otype);
		$this->tp->add("where",$where);
		$this->tp->show($this->root."index.php");
	}

	#订单详情
	function show()
	{
		$id=getint(F('get.id'));
		$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id limit 1");
		if($rs)
		{
			foreach($rs as $key=>$val)
			{
				$this->tp->add($key,$val);
			}
			$this->tp->add('id',$id);
			$this->tp->show($this->root."show.php");
		}
	}

	#订单批量发货
	function posts()
	{
		if(IS_POST)
		{
			$t0=F('t0');
			$t1=F('t1');
			$t2=F('t2');
			if($t0=='' || $t1=='')
			{
				$this->error('快递公司不能为空');
				return;
			}
			if(!is_array($t2))
			{
				$this->error('快递单号不能为空');
				return;
			}
			$step=0;
			foreach($t2 as $key=>$val)
			{
				$id=getint($key);
				$num=enhtml($val);
				$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id limit 1");
				if($rs)
				{
					$mobile=$rs['mobile'];
					$orderid=$rs['order_no'];
					if($rs['ispay']==0 && $rs['payway']!='post')
					{
						#未付款的不发货
					}
					else
					{
						if($rs['issales']==0)
						{
							$goods_id=$rs['goods_id'];
							$goods_num=$rs['goods_num'];
							$rg=$this->db->row("select tsales from cms_goods where id=$goods_id limit 1");
							if($rs)
							{
								$this->db->update("cms_goods","id=$goods_id",['tsales'=>($rg['tsales']+$goods_num)]);
							}
						}
						$step++;
						#更新订单发货状态
						$d=[];
						$d['ispost']=1;
						$d['postdate']=time();
						$d['express_id']=config('express_state');
						$d['express_name']=$t0;
						$d['express_code']=$t1;
						$d['express_num']=$num;
						$this->db->update($this->tbname,"order_id=$id",$d);
						#提醒客户
						if(getint(config('sms_ispost'))==1 && config('sms_state')!='')
						{
							cms_app::init('sms');
							cms_app::send($mobile,'order_post',['orderid'=>$orderid]);
						}
					}
				}
			}
			$this->success('本次发货：'.$step.'个');
		}
		else
		{
			$id=F('id');
			$this->tp->add('id',$id);
			$company=[];
			$express=config('express_state');
			if($express!='')
			{
				$plug=config('plug');
		        if(isset($plug[$express]))
		        {
		            $data=$plug[$express]['config'];
			        $code=$data['code'];
			        $company=explode("\r\n",$code);
		        }
			}
			$this->tp->add('company',$company);
			$this->tp->show($this->root."posts.php");
		}
	}

	#按条件导出
	function exports()
	{
		$where='isdel=0 ';
		$stype=getint(F('stype'));
		$keyword=F('keyword');
		$begindate=F('begindate');
		$overdate=F('overdate');
		$overdate=F('overdate');
		$ctype=getint(F('ctype'));
		$otype=getint(F('otype'));
		$type=getint(F('type'));
		if(!empty($keyword) && $stype>0)
		{
			switch($stype)
			{
				case '1':
					$where.=" and order_no like '%".$keyword."%' ";
					break;
				case '2':
					$where.=" and name like '%".$keyword."%' ";
					break;
				case '3':
					$where.=" and mobile like '%".$keyword."%' ";
					break;
				case '4':
					$where.=" and (order_from like '%".$keyword."%' or order_from='$keyword')";
					break;
				case '5':
					$where.=" and goods_id like ".getint($keyword)." ";
					break;
			}
		}
		if(!empty($begindate) && !empty($overdate))
		{
			$begin=strtotime($begindate);
			$over=strtotime($overdate);
			$where.=" and createdate>=$begin and createdate<=$over ";
		}
		if($ctype>0)
		{
			$where.=" and comefrom=$ctype ";
		}
		if($otype>0)
		{
			$where.=" and order_state=$otype ";
		}
		switch($type)
		{
			case '1':
				$where.="and ispay=0";
				break;
			case '2':
				$where.="and ispay=1";
				break;
			case '3':
				$where.="and ispost=0";
				break;
			case '4':
				$where.="and ispost=1";
				break;
		}
		self::excel("select * from cms_order where $where order by order_id desc");
	}

	#批量导出
	function export()
	{
		$id=F('id');
		$data=explode(',',$id);
		foreach($data as $key=>$val)
		{
			$val=getint($val);
			if($val<=0)
			{
				unset($data[$key]);
			}
			else
			{
				$data[$key]=$val;
			}
		}
		if(count($data)>0)
		{
			$id=implode(',',$data);
			self::excel("select * from cms_order where order_id in($id) order by order_id desc");
		}
		else
		{
			echo '没有数据可导出';
		}
	}

	private function excel($sql)
	{
		$rs=$this->db->load($sql);
		if($rs)
		{
			foreach($rs as $key=>$val)
			{
				$d=[];
				$d['order_no']='="'.$val['order_no'].'"';
				$d['goods_name']=$val['goods_name'];
				$d['goods_sku']=$val['goods_sku'];
				$d['goods_num']=$val['goods_num'];
				$d['order_total']=$val['order_total'];
				$d['goods_freight']=$val['goods_freight'];
				$d['goods_service']=$val['goods_service'];
				$d['name']=$val['name'];
				$d['mobile']='="'.$val['mobile'].'"';
				$d['address']=str_replace(' ','',$val['area']).$val['address'];
				$d['ispay']=($val['ispay']==0)?'未付款':'已付款';
				$d['ispost']=($val['ispost']==0)?'未发货':'已发货';
				$d['order_from']=$val['order_from'];
				$d['comefrom']=get_from($val['comefrom']);
				$d['createdate']='="'.date('Y-m-d H:i:s',$val['createdate']).'"';
				$d['postip']=$val['postip'];
				$rs[$key]=$d;
			}
			self::exportExcel(['订单号','商品','规格','数量','订单金额','运费','手续费','姓名','手机','地址','是否付款','是否发货','推广渠道','订单来源','下单日期','下单IP'],$rs,date('YmdHis'));
		}
		else
		{
			cms::error('没有订单可导出');
		}
	}

	private function exportExcel($title=[],$data=[],$file='')
	{
		header("Content-type:application/octet-stream");
		header("Accept-Ranges:bytes");
		header("Content-type:application/vnd.ms-excel");  
		header("Content-Disposition:attachment;filename=".$file.".xls");
		header("Pragma:no-cache");
		header("Expires:0");

		if(!empty($title))
		{
			foreach($title as $k=>$v)
			{
				$title[$k]=iconv("UTF-8","GB2312",$v);
			}
			$title=implode("\t", $title);
			echo "$title\n";
		}
		foreach($data as $key=>$val)
		{
			foreach($val as $ck=>$cv)
			{
				$data[$key][$ck]=iconv("UTF-8","GB2312",$cv);
			}
		 	$data[$key]=implode("\t",$data[$key]);
		}
		echo implode("\n",$data);
	}  

	#订单打印
	function prints()
	{
		$this->tp->add('data',explode(',',F('id')));
		$this->tp->show($this->root."print.php");
	}

	#获取物流
	function getexpress()
	{
		if(IS_POST)
		{
			#关掉日志
			define('SYS_LOG',false);
			$id=getint(F('id'));
			$rs=$this->db->row("select * from cms_order where order_id=$id limit 1");
			if(!$rs)
			{
				$this->error('订单号错误');
			}
			else
			{
				if(config('express_state')=='')
				{
					$this->error('未开启快递接口');
					return;
				}
				if($rs['postsign']==0)
				{
					cms_app::init('express',$rs['express_id']);
					$data=cms_app::query($rs['express_code'],$rs['express_num'],$rs['mobile']);
					if($data['state']=='success')
					{
						$result=$data['msg'];
						if(strlen($result)>strlen($rs['express_state']))
						{
							$arr=[];
							$arr['express_state']=$result;
							if(strpos($result,'签收'))
							{
								$arr['postsign']=1;
							}
							$this->db->update("cms_order","order_id=$id",$arr);
						}
						else
						{
							$result=$rs['express_state'];
						}
						$this->success($result);
					}
					else
					{
						$this->error($data['msg']);
					}
				}
				else
				{
					$this->success($rs['express_state']);
				}
			}
		}
	}

	#删除订单
	function del()
	{
		$id=getint(F('get.id'));
		self::btach_del($id);
		$this->success('删除成功');
	}

	#批量操作
	function btach()
	{
		$id=F('id');
		self::btach_del($id);
		$this->success('操作成功');
	}

	#批量删除
	function btach_del($id)
	{
		if(APP_DEMO) return;
		$arr=explode(',',$id);
		foreach($arr as $key=>$val)
		{
			$val=getint($val);
			$rs=$this->db->row("select order_id from ".$this->tbname." where order_id=$val limit 1");
			if($rs)
			{
				$this->db->update($this->tbname,"order_id=$val",['isdel'=>1]);
			}
		}
	}

	#修改收货人资料
	function edit()
	{
		$id=getint(F('get.id'));
		if(IS_POST)
		{
			$data=[[F('name'),'null','姓名不能为空'],[F('mobile'),'null','手机不能为空'],[F('area'),'null','省市不能为空'],[F('address'),'null','街道不能为空']];
			$v=new cms_verify($data);
			if($v->result())
			{
				$rs=$this->db->row("select order_id from ".$this->tbname." where order_id=$id and ispost=0 limit 1");
				if(!$rs)
				{
					$this->error('订单已发货不能修改');
					return;
				}
				$d=[];
				$d['name']=F('name');
				$d['mobile']=F('mobile');
				$d['area']=str_replace('/',' ',F('area'));
				$d['address']=F('address');
				$this->db->update($this->tbname,"order_id=$id",$d);
				$this->success('修改成功');
			}
			else
			{
				$this->error($v->msg);
			}
		}
		else
		{
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id and ispost=0 limit 1");
			if($rs)
			{
				foreach($rs as $key=>$val)
				{
					$this->tp->add($key,$val);
				}
				$this->tp->show($this->root."edit.php");
			}
		}
	}

	#订单改价
	function change()
	{
		$id=F('get.id');
		if(IS_POST)
		{
			$goods_total=getint(F('goods_total'));
			$goods_freight=getint(F('goods_freight'));
			$goods_service=getint(F('goods_service'));
			$order_total=$goods_total+$goods_freight+$goods_service;
			if($order_total<=0)
			{
				$this->error('总价格不能小于等于0');
				return;
			}
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id limit 1");
			if($rs)
			{
				if($rs['ispay']==1)
				{
					$this->error('商品已付款，不能改价格');
					return;
				}
				if($rs['ispost']==1)
				{
					$this->error('商品已发货，不能改价格');
					return;
				}
				$this->db->update($this->tbname,"order_id=$id",['goods_total'=>$goods_total,'goods_freight'=>$goods_freight,'goods_service'=>$goods_service,'order_total'=>$order_total]);
			}
			$this->success('修改成功');
		}
		else
		{
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id limit 1");
			if($rs)
			{
				if($rs['ispay']==1)
				{
					echo '商品已付款，不能改价格';
					return;
				}
				if($rs['ispost']==1)
				{
					echo '商品已发货，不能改价格';
					return;
				}
				foreach($rs as $key=>$val)
				{
					$this->tp->add($key,$val);
				}
				$this->tp->show($this->root."change.php");
			}
		}
	}

	#订单收款
	function pay()
	{
		$id=getint(F('get.id'));
		if(IS_POST)
		{
			$payway=F('payway');
			$rs=$this->db->row("select order_id from ".$this->tbname." where order_id=$id and ispay=0 limit 1");
			if(!$rs)
			{
				$this->error('订单已付款或已关闭');
				return;
			}
			#更新付款状态
			$this->db->update($this->tbname,"order_id=$id",['payway'=>$payway,'ispay'=>1,'paydate'=>time()]);
			$this->success('收款成功');
		}
		else
		{
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id and ispay=0 limit 1");
			if($rs)
			{
				foreach($rs as $key=>$val)
				{
					$this->tp->add($key,$val);
				}
				$this->tp->show($this->root."pay.php");
			}
		}
	}

	#订单发货
	function post()
	{
		$id=getint(F('get.id'));
		if(IS_POST)
		{
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id and ispost=0 limit 1");
			if(!$rs)
			{
				$this->error('订单已发货');
				return;
			}
			$data=[[F('t0'),'null','快递公司不能为空'],[F('t1'),'null','快递公司代码不能为空'],[F('t2'),'null','运单号不能为空']];
			$v=new cms_verify($data);
			if($v->result())
			{
				$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id limit 1");
				if($rs)
				{
					$mobile=$rs['mobile'];
					$orderid=$rs['order_no'];
					if($rs['ispay']==0 && $rs['payway']!='post')
					{
						$this->error('未付款的不发货');
						return;
					}
					else
					{
						if($rs['issales']==0)
						{
							$goods_id=$rs['goods_id'];
							$goods_num=$rs['goods_num'];
							$rg=$this->db->row("select tsales from cms_goods where id=$goods_id limit 1");
							if($rs)
							{
								$this->db->update("cms_goods","id=$goods_id",['tsales'=>($rg['tsales']+$goods_num)]);
							}
						}
						#更新订单发货状态
						$d=[];
						$d['ispost']=1;
						$d['postdate']=time();
						$d['express_id']=config('express_state');
						$d['express_name']=F('t0');
						$d['express_code']=F('t1');
						$d['express_num']=F('t2');
						$d['order_state']=5;
						$this->db->update($this->tbname,"order_id=$id",$d);
						#提醒客户
						if(getint(config('sms_ispost'))==1 && config('sms_state')!='')
						{
							cms_app::init('sms');
							cms_app::send($mobile,'order_post',['orderid'=>$orderid]);
						}
					}
				}
                $this->success('发货成功');
			}
			else
			{
				$this->error($v->msg);
			}
		}
		else
		{
			$this->tp->add("id",$id);
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id and ispost=0 limit 1");
			if($rs)
			{
				if($rs['ispay']==0 && $rs['payway']!='post')
				{
					echo '订单未付款';
					exit;
				}
				foreach($rs as $key=>$val)
				{
					$this->tp->add($key,$val);
				}
				$company=[];
				$express=config('express_state');
				if($express!='')
				{
					$plug=config('plug');
			        if(isset($plug[$express]))
			        {
			            $data=$plug[$express]['config'];
				        $code=$data['code'];
				        $company=explode("\r\n",$code);
			        }
				}
				$this->tp->add('company',$company);
				$this->tp->show($this->root."post.php");
			}
		}
	}

	#修改订单状态
	function state()
	{
		$id=getint(F('get.id'));
		if(IS_POST)
		{
			$rs=$this->db->row("select * from ".$this->tbname." where order_id=$id and order_state<99 limit 1");
			if(!$rs)
			{
				$this->error('订单ID错误');
				return;
			}
			$state=getint(F('state'));
			$this->db->update($this->tbname,"order_id=$id",['order_state'=>$state]);
			$this->success('修改成功');
		}
		else
		{
			$rs=$this->db->row("select order_state from ".$this->tbname." where order_id=$id and order_state<99 limit 1");
			if(!$rs)
			{
				$this->error('订单ID错误');
				return;
			}
			foreach($rs as $key=>$val)
			{
				$this->tp->add($key,$val);
			}
			$this->tp->add("id",$id);
			$this->tp->show($this->root."state.php");
		}
	}

}