<?php
/**
 * 作用：错误日志
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class LogError extends AdminsController
{
	private $root;
	function __construct()
	{
		parent::__construct();
		$this->root='data/log';
	}

	private function check()
	{
		if(!is_dir($this->root))
		{
			mkfolder($this->root);
		}
	}

	function index()
	{
		self::check();
		$root=$this->root;
		$db=self::deal_arr(scandir($root),$root);
		$this->tp->add('db',$db[0]);
		$this->tp->show("system/log/error.php");
	}

	function view()
	{
		#关掉日志
		define('SYS_LOG',false);
		$key=$this->decode(F('key'));
		$key=str_replace('..','',$key);
		if(!is_file($this->root.'/'.$key))
		{
			echo '日志文件名错误';
		}
		else
		{
			echo file_get_contents($this->root.'/'.$key);
		}
	}

	function del()
	{
		if(IS_POST)
		{
			$key=$this->decode(F('get.key'));
			$key=str_replace('..','',$key);
			@unlink($this->root.'/'.$key);
		}
		$this->success('删除成功');
	}

	function clear()
	{
		if(IS_POST)
		{
			$root=$this->root;
			$db=self::deal_arr(scandir($root),$root);
			foreach ($db[0] as $rs)
			{
				@unlink($root.'/'.$rs['name']);
			}
		}
		$this->success('清理成功');
	}
	
	function deal_arr($data,$root)
	{
		if(!$data)
		{
			die('【scandir】函数不支持，请在Php.ini中找到去掉限制');
		}
		unset($data[0]);unset($data[1]);
		$a=[];
		foreach($data as $key=>$val)
		{
			if(is_file($root.'/'.$val))
			{
				$time=filemtime($root.'/'.$val);
				$a[$time]=['name'=>mb_convert_encoding($val,"utf-8",mb_detect_encoding($val,['UTF-8','GBK','GB2312'])),'time'=>$time,'size'=>formatBytes(filesize($root.'/'.$val))];
				$a[$time]['file']=$this->encode($a[$time]['name']);
			}
			else
			{
				unset($data[$key]);
			}
		}
		array_multisort(array_column($a,'time'),SORT_DESC,$a);
		return ['0'=>$a];
	}
}