<?php
/**
 * 作用：首页
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Index extends AdminsController
{
	function __construct()
	{
		parent::__construct();
	}
	
	function Index()
	{
		if(IS_POST)
		{
			$type=getint(F('type'));
			$code=str_replace(["\r\n","\n"],"",F('code'));
			$this->db->update("cms_config","ckey='biz_id'",['cvalue'=>$code]);
			$this->db->update("cms_config","ckey='sys_auth_type'",['cvalue'=>($type==1)?"network":"local"]);
			#删除缓存
			cms_cache::del();
			$this->db->del("cms_auth","");
			foreach($_SESSION as $key => $val)
			{
				if(strpos($key,"_auth_"))
				{
					unset($_SESSION[$key]);
				}
			}
			$this->success('保存成功');
		}
		else
		{
			$where='';
			if(ADMIN_ID==0)
			{
				$this->tp->show('login.php');
			}
			else
			{
				if(get_admin_info('pid')!=0)
				{
					$where=' and id in('.PAGE_LEVER.')';
				}
				$this->tp->add('domain',cms_parse::getHost());
				$this->tp->add('where',$where);
				$this->tp->show('index.php');
			}
		}
	}

	#修改后台路径
	function edit()
	{
		if(IS_POST)
		{
			if(get_admin_info('pid')>0)
			{
				$this->error('没有修改权限');
				return;
			}
			$root=strtolower(trim(F('root')));
			if($root=='' || $root==M_NAME)
			{
				$this->error('未修改');
				return;
			}
			if(!preg_match('/^[a-zA-Z0-9-]+$/',$root))
			{
				$this->error('只能为字母或数字的组合');
				return;
			}
			$folder=scandir('app');
			if(!$folder)
			{
				die('【scandir】函数不支持，请在Php.ini中去掉限制');
			}
			$data=[];
			foreach($folder as $key=>$val)
			{
				if(!is_dir('app/'.$val) || $val=='..' || $val=='.')
				{
					unset($folder[$key]);
				}
				else
				{
					$data[$val]=$val;
				}
			}
			if(in_array($root,$data))
			{
				$this->error('路径已存在，请更换');
				return;
			}
			
			if(strtolower(PHP_OS)!='linux' || strtolower(PHP_OS)=='winnt')
			{
				$old=APP_PATH.'\\'.M_NAME;
				$new=APP_PATH.'\\'.$root;
				$old=str_replace('\\',"\\\\",$old);
				$new=str_replace('\\',"\\\\",$new);
			}
			else
			{
				$old="app/".M_NAME;
				$new="app/".$root;
			}
			
			if(@rename($old,$new))
			{
				$this->success(N($root));
				S("admindir",$root);
				delfolder('cache');
			}
			else
			{
				$this->error('修改失败，请手工修改（请勿打开后台任何文件）');
			}
		}
	}

	function music()
	{
		$a=$this->db->count("select count(1) from cms_order where ispay=0");
		if(IS_POST)
		{
			#关掉管理日志
			define('SYS_LOG',false);
			echo $a;
		}
		else
		{
			$this->tp->add('num',$a);
			$this->tp->show("other/music.php");
		}
	}

	function right()
	{
		$count=[];
		$count['order']['total']=$this->db->count("select count(1) from cms_order where isdel=0");
		$count['order']['today']=$this->db->count("select count(1) from cms_order where isdel=0 and FROM_UNIXTIME(`createdate`,'%Y-%m-%d')='".date('Y-m-d')."'");
		$count['order']['post']=$this->db->count("select count(1) from cms_order where isdel=0 and ((ispay=1 and ispost=0) or (ispay=0 and payway='post' and ispost=0))");

		$count['sales']['total']=$this->db->count("select sum(order_total) from cms_order where isdel=0 and ispay=1");
		$count['sales']['today']=$this->db->count("select sum(order_total) from cms_order where isdel=0 and ispay=1 and FROM_UNIXTIME(`createdate`,'%Y-%m-%d')='".date('Y-m-d')."'");
		$count['sales']['yesterday']=$this->db->count("select sum(order_total) from cms_order where isdel=0 and ispay=1 and  FROM_UNIXTIME(`createdate`,'%Y-%m-%d')='".date('Y-m-d',strtotime('-1 day'))."'");

		$count['goods']['total']=$this->db->count("select count(1) from cms_goods");
		$count['goods']['show']=$this->db->count("select count(1) from cms_goods where isshow=1");
		$count['goods']['lock']=$this->db->count("select count(1) from cms_goods where isshow=0");
		
		$this->tp->add('count',$count);

		$services=[
             '操作系统'=>PHP_OS,
             '运行环境'=>enhtml($_SERVER["SERVER_SOFTWARE"]),
             'Php版本'=>PHP_VERSION,
             '服务器Ip'=>enhtml(gethostbyname($_SERVER['SERVER_NAME'])),
             '网站端口'=>enhtml($_SERVER['SERVER_PORT']),
             '运行内存'=>get_cfg_var("memory_limit")?get_cfg_var("memory_limit"):'',
             '上传限制'=>ini_get('upload_max_filesize'),
             '提交限制'=>get_cfg_var("post_max_size"),
             '脚本超时'=>ini_get('max_execution_time').'秒',
             'Gzip压缩'=>enhtml($_SERVER['HTTP_ACCEPT_ENCODING']),
        ];

		$this->tp->add('services',$services);
		$where='1=1';
		if(get_admin_info('pid')!=0)
		{
			$where=" loginname='".get_admin_info('adminname')."'";
		}
		$this->tp->add('where',$where);
		$this->tp->show('right.php');
	}

	function pass()
	{
		if(IS_POST)
		{
			$t0=left(trim(F('t0')),20);
			$t1=left(trim(F('t1')),20);
			$t2=left(trim(F('t2')),20);
			$data=[
				[$t0,'null','原密码不能为空'],
				[md5(md5($t0))!=get_admin_info('adminpass'),'other','原密码错误'],
				[$t1,'null','新密码不能为空'],
				[$t2,'null','确认密码不能为空'],
				[$t1!=$t2,'other','两次密码不一致']
			];
			if(!check_pass($t1))
			{
				$data=array_merge($data,[[true,'other','密码须包含：字母、数字或字符']]);
			}
			$v=new cms_verify($data);
			if($v->result())
			{
				$d=[];
				$d['adminpass']=md5(md5($t1));
				$this->db->update('cms_admin','adminid='.ADMIN_ID.'',$d);
				$a=S('admin_info');
				$a['adminpass']=$d['adminpass'];
				S('admin_info',$a);
				$this->success('修改成功');
			}
			else
			{
				$this->error($v->msg);
			}
		}
		else
		{
			$this->tp->show("config/admin/pass.php");
		}
	}
	
	function check()
	{
		$loginstate=0;
		if(IS_POST)
		{
			#关掉管理日志
			define('SYS_LOG',false);
			#获取今日登录失败次数
			if(getint(config('admin_logintimes'))>0)
			{
				$fail_times=$this->db->count("select count(1) from cms_admin_login_log where loginip='".getip()."' and loginstate=0 and FROM_UNIXTIME(`logindate`,'%Y-%m-%d')='".date('Y-m-d')."'");
				if($fail_times>=config('admin_logintimes'))
				{
					$this->error('系统已禁止您今日登录');
					return;
				}
			}
			$t0=left(trim(F('t0')),20);
			$t1=left(trim(F('t1')),20);
			$t3=S('scode');
			$data=[
				[$t0,'username','用户名为3-20位字符'],
				[$t1,'password','密码为5-20位字符']
			];
			$t1=md5(md5($t1));
			if(getint(config('admin_code'))==1)
			{
				$data=array_merge($data,[
					[F('t2'),'null','验证码不能为空'],
					[$t3,'null','无法获取系统验证码'],
					[$t3!=md5(strtolower(F('t2'))),'other','验证码不正确']
				]);
			}
			if(getint(config('admin_code'))==2)
			{
				require_once 'app/'.M_NAME.'/google.php';
				$ga=new PHPGangsta_GoogleAuthenticator();
				$secret=config('admin_code_google');

				#用户提交的谷歌验证码
				$gcode=F('t3');
				$data=array_merge($data,[[$gcode,'null','谷歌验证码为空']]);

				#最后一个参数为容差时间,这里是1 那么就是 1*30s 一分钟.
				$checkResult=$ga->verifyCode($secret,$gcode,1);
				if(!$checkResult)
				{
				   $data=array_merge($data,[[true,'other','谷歌验证码错误']]);
				}
				#谷歌验证码结束
			}
			$v=new cms_verify($data);
			if($v->result())
			{
				$rs=$this->db->row("select adminid,adminname,adminpass,penname,pid,islock,logintimes,page_list,readonly from cms_admin a left join cms_admin_part b on a.pid=b.id where adminname='$t0' and adminpass='$t1' limit 1");
				if(!$rs)
				{
					$this->error('用户名或密码错误');
				}
				else
				{
					if($rs['islock']==0)
					{
						$this->error('用户被锁定，不能登录');
					}
					else
					{
						$adminid=$rs['adminid'];
						$logintimes=$rs['logintimes'];
						S('admin_info',$rs);
						$this->db->update('cms_admin',"adminid=$adminid",['logintimes'=>$logintimes+1,'lastlogindate'=>time(),'lastloginip'=>getip()]);
						$loginstate=1;
						S("admindir",M_NAME);
						#清理日志
						if(config('admin_log')>0)
						{
							$this->db->del('cms_admin_login_log',"logindate<=".strtotime("-".config('admin_log')." day")."");
							$this->db->del('cms_admin_log',"createdate<=".strtotime("-".config('admin_log')." day")."");
						}
						$this->success('登录成功');
					}
				}
			}
			else
			{
				$this->error($v->msg);
			}
			
			#登陆日志开关
			if(config('admin_log_login')==1)
			{
				$d=[];
				$d['loginname']=enhtml($t0);
				$d['loginip']=getip();
				$d['logindate']=time();
				$d['loginmsg']=$this->msg;
				$d['loginstate']=$loginstate;
				$this->db->add('cms_admin_login_log',$d);
			}
		}
		else
		{
			$this->error('来源错误');
		}
	}

	function out()
	{
		S('admin_info','[del]');
		G(N(M_NAME));
	}

	function code()
	{
		$c=new cms_code();
        $c->doimg();
        $code=$c->getCode();
        S('scode',$code);
	}
}