<?php
/**
 * 作用：管理员
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class Admin extends AdminsController
{
	private $tbname,$root;
	function __construct()
	{
		parent::__construct();
		$this->tbname='cms_admin';
		$this->root='config/admin/';
	}

	function switchs()
	{
		if(IS_POST)
		{
			$id=getint(F('get.id'));
			$type=getint(F('get.type'));
			$state=getint(F('state'));
			switch($type)
			{
				case '1':
					$field='islock';
					break;
				case '2':
					$field='readonly';
					break;
			}
			$rs=$this->db->row("select adminid from ".$this->tbname." where adminid=$id limit 1");
			if($rs)
			{
				if($id!=ADMIN_ID)
				{
					$this->db->update($this->tbname,"adminid=$id",[$field=>$state]);
					$this->success('修改成功');
				}
				else
				{
					$this->error('修改失败');
				}
			}
		}
	}

	function index()
	{
		$this->tp->show($this->root."index.php");
	}

	function add()
	{
		if(IS_POST)
		{
			$t0=left(trim(F('t0')),20);
			$t1=left(trim(F('t1')),20);
			$t2=left(trim(F('t2')),20);
			$data=[[$t0,'username','用户名格式错误'],[$t1,'password','密码格式错误'],[$t2,'null','笔名不能为空']];
			if(!check_pass($t1))
			{
				$data=array_merge($data,[[true,'other','密码须包含：字母、数字或字符']]);
			}
			$v=new cms_verify($data);
			if($v->result())
			{
				$rs=$this->db->row("select * from ".$this->tbname." where adminname='$t0' limit 1");
				if($rs)
				{
					$this->error('用户名已存在');
				}
				else
				{
					$d=[];
					$d['adminname']=$t0;
					$d['adminpass']=md5(md5($t1));
					$d['penname']=$t2;
					$d['pid']=getint(F('t3'));
					$d['islock']=getint(F('t4'));
					$d['readonly']=getint(F('t5'));
					$d['logintimes']=0;
					$this->db->add($this->tbname,$d);
					$this->success('添加成功');
				}
			}
			else
			{
				$this->error($v->msg);
			}
		}
		else
		{
			$this->tp->show($this->root."add.php");
		}
	}

	function edit()
	{
		$id=getint(F('get.id'));
		if(IS_POST)
		{
			$rs=$this->db->row("select * from ".$this->tbname." where adminid=$id limit 1");
			if($rs)
			{
				$t1=left(trim(F('t1')),20);
				$t2=left(trim(F('t2')),20);
				$d=[];
				if(strlen($t1)!=0)
				{
					if(!check_pass($t1))
					{
						$this->error('密码须包含：字母、数字或字符');
						return;
					}
					$d['adminpass']=md5(md5($t1));
				}
				$d['penname']=$t2;
				$d['pid']=getint(F('t3'));
				$d['islock']=getint(F('t4'));
				$d['readonly']=getint(F('t5'));
				if($id==ADMIN_ID)
				{
					if($d['islock']==0)
					{
						$this->error('禁止锁定当前账户');
						return;
					}
					if($d['readonly']==1)
					{
						$this->error('禁止将当前账户设置为只读');
						return;
					}
				}
				$this->db->update($this->tbname,"adminid=$id",$d);
			}
			$this->success('保存成功');
		}
		else
		{
			$rs=$this->db->row("select * from ".$this->tbname." where adminid=$id limit 1");
			if($rs)
			{
				foreach($rs as $key=>$val)
				{
					$this->tp->add($key,$val);
				}
				$this->tp->show($this->root."edit.php");
			}
		}
	}

	function del()
	{
		if(IS_POST)
		{
			$id=getint(F('get.id'));
			if($id==ADMIN_ID)
			{
				$this->error('不能删除自己');
			}
			else
			{
				$this->db->del($this->tbname,"adminid=$id");
				$this->success('删除成功');
			}
		}
	}

}