<?php
/**
 * 作用：后台控制器
 * 官网：Https://www.nicemb.com
 * 作者：IT平民
 * ===========================================================================
 * 未经授权不允许对程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

class AdminsController extends Controller
{
	function _initialize()
	{
		$mname=M_NAME;
		$this->tp->themeRoot="app/$mname/view/";
		$this->tp->cacheRoot=config('cache_dir')."/$mname/";
		
		#是否后台只读模式
		$isready=(get_admin_info('readonly')==1?true:false);
		define('APP_DEMO',$isready);

		$api_url=(config('api_http'))?config('api_http'):'https://';
		define('SYS_API_URL',$api_url.'app.nicemb.com');
		
		if(IS_POST && C_NAME.'/'.A_NAME=='index/check')
		{
			if(config('app_admin_token'))
			{
				$token=F('token');
				if($token!=S("_token_".$mname."_"))
				{
					$this->error("Token检验失败，请刷新重试");
					exit();
				}
			}
		}
	}

	function _before_action()
	{
		$mname=M_NAME;
		if(!(C_NAME=='index' && (A_NAME=='login' || A_NAME=='check' || A_NAME=='code')))
		{
			if(ADMIN_ID==0 && C_NAME.A_NAME!='indexindex')
			{
				G(N($mname));
			}
		}

		if(getint(get_admin_info('pid'))!=0)
		{
			define('PAGE_LEVER',get_admin_info('page_list'));
			if(strlen(PAGE_LEVER)==0)
			{
				S('admin_info','[del]');
				die('没有页面管理权限，请检查部门权限设置，<a href="'.N($mname).'">退出登录</a>');
			}
			if(!(C_NAME=='index'))
			{
				$rs=$this->db->load("select cname from cms_admin_menu where followid>0 and id in(".PAGE_LEVER.")");
				if($rs)
				{
					foreach($rs as $key=>$value)
					{
						$rs[$key]=$mname.'/'.$value['cname'];
					}
					$rs[''.$mname.'/loglogin']=''.$mname.'/loglogin';
					if(in_array(''.$mname.'/configgroup',$rs))
					{
						$rs[''.$mname.'/configgroupfield']=''.$mname.'/configgroupfield';
					}
					$rs[''.$mname.'/upload']=$mname.'/upload';
					if(!(in_array(M_NAME.'/'.C_NAME,$rs)))
					{
						die('没有管理权限');
					}
				}
			}
		}

		if(IS_POST)
		{
			if(APP_DEMO && C_NAME!='upload')
			{
				$this->success('操作成功！！');
				exit();
			}
		}
	}

	function _after_action()
	{
		if(IS_POST && !defined('SYS_LOG'))
		{
			$this->api->log($this->msg);
		}
	}

	#删除缓存
	function cache_alias()
	{
		cms_cache::del('alias');
	}

	#检查别名是否存在
	function check_add_alias($alias,$data)
	{
		if($alias!='')
		{
			$msg=self::check_alias($alias);
			if($msg!='')
			{
				$data=array_merge($data,[[true,'other',$msg]]);
				return $data;
			}
			$rs=$this->db->row("select id from cms_alias where alias='$alias' limit 1");
			if($rs)
			{
				$data=array_merge($data,[[true,'other','别名已存在，请更换']]);
			}
		}
		return $data;
	}

	function check_edit_alias($alias,$id,$data)
	{
		if($alias!='')
		{
			$msg=self::check_alias($alias);
			if($msg!='')
			{
				$data=array_merge($data,[[true,'other',$msg]]);
				return $data;
			}
			
			$rs=$this->db->row("select id from cms_alias where alias='$alias' and sid<>$id limit 1");
			if($rs)
			{
				$data=array_merge($data,[[true,'other','别名已存在，请更换']]);
			}
		}
		return $data;
	}

	function check_alias($alias)
	{
		$admin=M_NAME;
		if($alias!='')
		{
			switch(config('url_mid'))
			{
				case "/":
					$preg='-_';
					break;
				case "_":
					$preg='-';
					break;
			}
			if(!preg_match('/^[a-zA-Z0-9'.$preg.']+$/',$alias))
			{
				return '别名只能为字母或字母和数字的组合';
			}
			if(in_array($alias,[$admin,'admin','app','type','switch','edit','add','btach','del','public','data','install','cache','theme','list','clear','move','tree','alipay','wxpay','weixin']))
			{
				return '别名为系统禁用关键字，请更换';
			}
			$route=D(CMS_ROUTE);
			if(isset($route[$alias]))
			{
				return '别名为内置，请更换';
			}
		}
	}

	#新增时候处理别名
	function add_alias($alias,$name,$id)
	{
		if($alias!='')
		{
			$this->db->add('cms_alias',['alias'=>$alias,'app'=>$name,'sid'=>$id,'types'=>1]);
		}
		$this->cache_alias();
	}

	#编辑时处理别名
	function edit_alias($alias,$name,$id)
	{
		#如果为空，则删除原来的别名，否则修改原来的别名
		if($alias=='')
		{
			$this->db->del('cms_alias',"sid=$id and app='".$name."'");
		}
		else
		{
			$rs=$this->db->row("select id from cms_alias where app='".$name."' and sid=$id limit 1");
			if($rs)
			{
				$this->db->update('cms_alias','id='.$rs['id'].'',['alias'=>$alias]);
			}
			else
			{
				$this->db->add('cms_alias',['alias'=>$alias,'app'=>$name,'sid'=>$id,'types'=>1]);
			}
		}
		$this->cache_alias();
	}

	#删除时处理别名
	function del_alias($id,$name)
	{
		$this->db->del('cms_alias',"sid=$id and app='$name'");
		$this->cache_alias();
	}

	function encode($a,$b='')
	{
		return base64_encode(authcode(E($a),'E',config('prefix').$b));
	}

	function decode($a,$b='')
	{
		if(empty($a))
		{
			return '';
		}
		$a=D(authcode(base64_decode($a),'D',config('prefix').$b));
		$a=$a?$a:[];
		return $a;
	}
	
}