import {
  Trigger,
  DropdownMenuTriggerProps,
} from "@radix-ui/react-dropdown-menu";
import { ForwardedRef, forwardRef } from "react";

export const DropdownMenuTrigger = forwardRef(function DropdownMenuTrigger(
  props: DropdownMenuTriggerProps,
  ref: ForwardedRef<HTMLButtonElement>,
) {
  return (
    <Trigger asChild {...props}>
      <button
        className="relative svg-outline w-[35px] h-[35px] translate-x-0.5 -translate-y-0.5 border-2 border-black inline-flex items-center justify-center text-black bg-white"
        aria-label="Customise options"
        data-anchor
        ref={ref}
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          fill="none"
          viewBox="0 0 24 24"
          strokeWidth="1.5"
          stroke="currentColor"
          className="w-6 h-6"
        >
          <path
            strokeLinecap="round"
            strokeLinejoin="round"
            d="M10.5 6h9.75M10.5 6a1.5 1.5 0 1 1-3 0m3 0a1.5 1.5 0 1 0-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 0 1-3 0m3 0a1.5 1.5 0 0 0-3 0m-9.75 0h9.75"
          />
        </svg>
      </button>
    </Trigger>
  );
});
