//simple service worker
//https://github.com/ibrahima92/pwa-with-vanilla-js
let staticDevCoffee = 'pwa-assets';
const assets = [
  "/",
  "/index.html",
  "/dist/index.js"
];

self.addEventListener("install", installEvent => {
  installEvent.waitUntil(
    caches.open(staticDevCoffee).then(cache => {
      cache.addAll(assets);
    })
  );
});

self.addEventListener("fetch", fetchEvent => {
  fetchEvent.respondWith(
    caches.match(fetchEvent.request).then(res => {
      return res || fetch(fetchEvent.request);
    })
  );
});