/* --------------------------------------------------------------------------
 * Copyrights
 *
 * Portions created by or assigned to Cursive Systems, Inc. are
 * Copyright (c) 2002-2008 Cursive Systems, Inc.  All Rights Reserved.  Contact
 * information for Cursive Systems, Inc. is available at
 * http://www.cursive.net/.
 *
 * License
 *
 * Jabber-Net is licensed under the LGPL.
 * See LICENSE.txt for details.
 * --------------------------------------------------------------------------*/
/* This file is automatically generated.  DO NOT EDIT! */

namespace StringPrep.Unicode
{
    /// <summary>
    /// Data for composition of characters.  The algorithms here are still black box to me.
    /// </summary>
    public class ComposeData
    {

        /// <summary>
        /// Where the first range of offsets from Data starts.
        /// These are used for checking the first character
        /// in a pair with a second character in Array.
        /// </summary>
        public const short FIRST_START = 1;
        /// <summary>
        /// Where the offsets of the range of characters where there is
        /// only one match for the second character, with a given first character.
        /// </summary>
        public const short FIRST_SINGLE_START = 147;
        /// <summary>
        /// Where the offsets of the range of second characters that match a given first
        /// character starts.
        /// </summary>
        public const short SECOND_START = 357;
        /// <summary>
        /// When there is only a single match to the left for these characters on the
        /// right, the offsets for that chunk of characters starts here.
        /// </summary>
        public const short SECOND_SINGLE_START = 388;

        /// <summary>
        /// The offset into Array for each character.  This array is compressed using
        /// the Table table, which provides page offsets for the pages that are non-zero.
        /// </summary>
        public static readonly short[,] Data = new short[,]
        {
            { /* page 0, index 0 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 147, 148, 149,   0,   0,   1,   2,   3,   4,   5,
                150,   6,   7,   8, 151,   9,  10,  11,  12,  13,  14,   0,  15,  16,  17,  18,  19,  20,  21,
                 22,  23,   0,   0,   0,   0,   0,   0,  24,  25,  26,  27,  28, 152,  29,  30,  31,  32,  33,
                 34,  35,  36,  37,  38,   0,  39,  40,  41,  42,  43,  44,  45,  46,  47,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  48,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  49,   0, 153, 154,
                 50, 155,   0,   0,  51,   0,   0,   0,   0, 156,   0,   0,   0,   0,  52,  53, 157,   0, 158,   0,
                  0,   0,  54,   0,   0,   0,   0,   0,  55,   0, 159, 160,  56, 161,   0,   0,  57,   0,   0,   0,   0,
                162,   0,   0,   0,   0,  58,  59, 163,   0, 164,   0,   0,   0,  60,   0,   0,   0
            },
            { /* page 1, index 1 */
                  0,   0,  61,  62,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  63,  64,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,  65,  66,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 165, 166,   0,
                  0,   0,   0, 167, 168,   0,   0,   0,   0,   0,   0, 169, 170, 171, 172,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  67,
                 68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  69,  70,   0,   0,   0,   0,   0,   0, 174,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0, 175, 176,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0
            },
            { /* page 2, index 2 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 177, 178, 179, 180,   0,   0,   0,   0,
                181, 182,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0, 183,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 3, index 3 */
                357, 358, 359, 360, 361,   0, 362, 363, 364, 365, 366, 367, 368,   0,   0, 369,
                  0, 370,   0, 371, 372,   0,   0,   0,   0,   0,   0, 373,   0,   0,   0,   0,   0,   0,   0, 374,
                375, 376, 377, 378, 379,   0,   0,   0,   0, 380, 381,   0, 382, 383,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 384,   0,   0, 385,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  71,   0,   0,   0,
                 72,   0,  73,   0,  74,   0,   0,   0,   0,   0,  75,   0, 184,   0,   0,   0,  76,   0,   0,   0,  77,   0,
                  0, 185,   0, 186,   0,   0,  78,   0,   0,   0,  79,   0,  80,   0,  81,   0,   0,   0,   0,   0,  82,
                  0,  83,   0,   0,   0,  84,   0,   0,   0,  85,  86,  87,   0,   0, 187,   0,   0,   0,  88,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 4, index 4 */
                  0,   0,   0,   0,   0,   0, 188,   0,   0,   0,   0,   0,   0,   0,   0,   0,  89,   0,   0, 189,   0,  90,
                 91, 190,  92,   0, 191,   0,   0,   0, 192,   0,   0,   0,   0,  93,   0,   0,   0, 193,   0,   0,   0,
                194,   0, 195,   0,   0,  94,   0,   0, 196,   0,  95,  96, 197,  97,   0, 198,   0,   0,   0,
                199,   0,   0,   0,   0,  98,   0,   0,   0, 200,   0,   0,   0, 201,   0, 202,   0,   0,   0,   0,   0,
                  0,   0,   0, 203,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 205,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 206, 207,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0, 208, 209,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 6, index 5 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  99,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                210,   0, 211,   0,   0,   0,   0,   0,   0,   0,   0, 388, 389, 390,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0, 212,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 213,   0,
                  0, 214,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 9, index 6 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 215,   0,   0,   0,   0,   0,   0,   0,
                216,   0,   0, 217,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 391,
                  0,   0,   0,   0,   0,   0,   0,   0, 100,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                392,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 11, index 7 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 393,   0,   0,   0,   0,   0,   0,   0,   0,
                101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 394, 395,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0, 218,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0, 396,   0,   0,   0,   0,   0,   0,   0, 102, 219,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0, 397,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 12, index 8 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 220,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 221,
                  0,   0, 398,   0,   0,   0, 103,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 399,
                400,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 13, index 9 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 401,   0,   0,   0,   0,   0,   0,   0, 104,
                223,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 402,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 403,   0,   0,   0,   0, 404,   0,   0,   0,   0,   0,
                  0,   0,   0,   0, 105,   0,   0, 224,   0,   0, 405,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 16, index 10 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 225,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 30, index 11 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0, 226, 227,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 228, 229,   0,   0,
                  0,   0,   0,   0, 230, 231,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 106, 107,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 232, 233,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 234, 235,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 31, index 12 */
                108, 109, 236, 237, 238, 239, 240, 241, 110, 111, 242, 243, 244, 245,
                246, 247, 112, 113,   0,   0,   0,   0,   0,   0, 114, 115,   0,   0,   0,   0,   0,   0, 116,
                117, 248, 249, 250, 251, 252, 253, 118, 119, 254, 255, 256, 257, 258,
                259, 120, 121,   0,   0,   0,   0,   0,   0, 122, 123,   0,   0,   0,   0,   0,   0, 124, 125,   0,
                  0,   0,   0,   0,   0, 126, 127,   0,   0,   0,   0,   0,   0, 128, 129,   0,   0,   0,   0,   0,   0,   0,
                130,   0,   0,   0,   0,   0,   0, 131, 132, 260, 261, 262, 263, 264, 265, 133, 134,
                266, 267, 268, 269, 270, 271, 272,   0,   0,   0, 273,   0,   0,   0,   0,   0,   0,   0,
                274,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 275,   0,   0,   0,   0,   0,   0,   0,   0, 135,   0,   0,   0,
                  0,   0,   0, 276,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0, 277,   0,   0,   0,   0,   0,   0,   0, 136,   0
            },
            { /* page 33, index 13 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                278,   0, 279,   0, 280,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 281,   0, 282,   0,
                283,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 34, index 14 */
                  0,   0,   0, 284,   0,   0,   0,   0, 285,   0,   0, 286,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 287,   0, 288,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 289,   0,   0,   0,   0,   0,   0, 290,
                  0, 291,   0,   0, 292,   0,   0,   0,   0, 293,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0, 294,   0,   0, 295, 296,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0, 297, 298,   0,   0, 299, 300,   0,   0, 301, 302, 303, 304,   0,   0,   0,   0,
                305, 306,   0,   0, 307, 308,   0,   0,   0,   0,   0,   0,   0,   0,   0, 309, 310,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 311,   0,   0,   0,   0,   0, 312, 313,   0, 314,
                  0,   0,   0,   0,   0,   0, 315, 316, 317, 318,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
            },
            { /* page 48, index 15 */
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 319,   0,
                  0,   0,   0, 320,   0, 321,   0, 322,   0, 323,   0, 324,   0, 325,   0, 326,   0, 327,   0,
                328,   0, 329,   0, 330,   0, 331,   0,   0, 332,   0, 333,   0, 334,   0,   0,   0,   0,   0,   0,
                137,   0,   0, 138,   0,   0, 139,   0,   0, 140,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 386, 387,
                  0,   0, 335,   0,   0,   0,   0,   0,   0,   0,   0, 336,   0,   0,   0,   0, 337,   0, 338,   0, 339,
                  0, 340,   0, 341,   0, 342,   0, 343,   0, 344,   0, 345,   0, 346,   0, 347,   0, 348,
                  0,   0, 349,   0, 350,   0, 351,   0,   0,   0,   0,   0,   0, 142,   0,   0, 143,   0,   0, 144,
                  0,   0, 145,   0,   0, 146,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                  0,   0, 352, 353, 354, 355,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 356,   0,   0
            }
        };

        /// <summary>
        /// Page offsets into Data for each page of characters.
        /// </summary>
        public static readonly byte[] Table = new byte[]
        {
            0 /* page 0 */,
            1 /* page 1 */,
            2 /* page 2 */,
            3 /* page 3 */,
            4 /* page 4 */,
            255,
            5 /* page 6 */,
            255,
            255,
            6 /* page 9 */,
            255,
            7 /* page 11 */,
            8 /* page 12 */,
            9 /* page 13 */,
            255,
            255,
            10 /* page 16 */,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            11 /* page 30 */,
            12 /* page 31 */,
            255,
            13 /* page 33 */,
            14 /* page 34 */,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            255,
            15 /* page 48 */
        };

        /// <summary>
        /// When the offset for the  first character is in the range
        /// [FIRST_SINGLE_START, SECOND_START), look up the corresponding
        /// character here with the offset from Data to see if it is
        /// the second character.  If not, there is no combination.
        /// </summary>
        public static readonly char[,] FirstSingle = new char[,]
        {
            {'\x0338', '\x226e'},
            {'\x0338', '\x2260'},
            {'\x0338', '\x226f'},
            {'\x0307', '\x1e1e'},
            {'\x0302', '\x0134'},
            {'\x0307', '\x1e1f'},
            {'\x0304', '\x01de'},
            {'\x0301', '\x01fa'},
            {'\x0301', '\x1e08'},
            {'\x0301', '\x1e2e'},
            {'\x0304', '\x022a'},
            {'\x0301', '\x01fe'},
            {'\x0304', '\x01df'},
            {'\x0301', '\x01fb'},
            {'\x0301', '\x1e09'},
            {'\x0301', '\x1e2f'},
            {'\x0304', '\x022b'},
            {'\x0301', '\x01ff'},
            {'\x0307', '\x1e64'},
            {'\x0307', '\x1e65'},
            {'\x0307', '\x1e66'},
            {'\x0307', '\x1e67'},
            {'\x0301', '\x1e78'},
            {'\x0301', '\x1e79'},
            {'\x0308', '\x1e7a'},
            {'\x0308', '\x1e7b'},
            {'\x0307', '\x1e9b'},
            {'\x030c', '\x01ee'},
            {'\x0304', '\x01ec'},
            {'\x0304', '\x01ed'},
            {'\x0304', '\x01e0'},
            {'\x0304', '\x01e1'},
            {'\x0306', '\x1e1c'},
            {'\x0306', '\x1e1d'},
            {'\x0304', '\x0230'},
            {'\x0304', '\x0231'},
            {'\x030c', '\x01ef'},
            {'\x0314', '\x1fec'},
            {'\x0345', '\x1fb4'},
            {'\x0345', '\x1fc4'},
            {'\x0345', '\x1ff4'},
            {'\x0308', '\x0407'},
            {'\x0301', '\x0403'},
            {'\x0308', '\x04de'},
            {'\x0301', '\x040c'},
            {'\x0308', '\x04e6'},
            {'\x0308', '\x04f4'},
            {'\x0308', '\x04f8'},
            {'\x0308', '\x04ec'},
            {'\x0301', '\x0453'},
            {'\x0308', '\x04df'},
            {'\x0301', '\x045c'},
            {'\x0308', '\x04e7'},
            {'\x0308', '\x04f5'},
            {'\x0308', '\x04f9'},
            {'\x0308', '\x04ed'},
            {'\x0308', '\x0457'},
            {'\x030f', '\x0476'},
            {'\x030f', '\x0477'},
            {'\x0308', '\x04da'},
            {'\x0308', '\x04db'},
            {'\x0308', '\x04ea'},
            {'\x0308', '\x04eb'},
            {'\x0654', '\x0624'},
            {'\x0654', '\x0626'},
            {'\x0654', '\x06c2'},
            {'\x0654', '\x06d3'},
            {'\x0654', '\x06c0'},
            {'\x093c', '\x0929'},
            {'\x093c', '\x0931'},
            {'\x093c', '\x0934'},
            {'\x0bd7', '\x0b94'},
            {'\x0bbe', '\x0bcb'},
            {'\x0c56', '\x0c48'},
            {'\x0cd5', '\x0cc0'},
            {'\x0cd5', '\x0ccb'},
            {'\x0d3e', '\x0d4b'},
            {'\x0dca', '\x0ddd'},
            {'\x102e', '\x1026'},
            {'\x0304', '\x1e38'},
            {'\x0304', '\x1e39'},
            {'\x0304', '\x1e5c'},
            {'\x0304', '\x1e5d'},
            {'\x0307', '\x1e68'},
            {'\x0307', '\x1e69'},
            {'\x0302', '\x1ec6'},
            {'\x0302', '\x1ec7'},
            {'\x0302', '\x1ed8'},
            {'\x0302', '\x1ed9'},
            {'\x0345', '\x1f82'},
            {'\x0345', '\x1f83'},
            {'\x0345', '\x1f84'},
            {'\x0345', '\x1f85'},
            {'\x0345', '\x1f86'},
            {'\x0345', '\x1f87'},
            {'\x0345', '\x1f8a'},
            {'\x0345', '\x1f8b'},
            {'\x0345', '\x1f8c'},
            {'\x0345', '\x1f8d'},
            {'\x0345', '\x1f8e'},
            {'\x0345', '\x1f8f'},
            {'\x0345', '\x1f92'},
            {'\x0345', '\x1f93'},
            {'\x0345', '\x1f94'},
            {'\x0345', '\x1f95'},
            {'\x0345', '\x1f96'},
            {'\x0345', '\x1f97'},
            {'\x0345', '\x1f9a'},
            {'\x0345', '\x1f9b'},
            {'\x0345', '\x1f9c'},
            {'\x0345', '\x1f9d'},
            {'\x0345', '\x1f9e'},
            {'\x0345', '\x1f9f'},
            {'\x0345', '\x1fa2'},
            {'\x0345', '\x1fa3'},
            {'\x0345', '\x1fa4'},
            {'\x0345', '\x1fa5'},
            {'\x0345', '\x1fa6'},
            {'\x0345', '\x1fa7'},
            {'\x0345', '\x1faa'},
            {'\x0345', '\x1fab'},
            {'\x0345', '\x1fac'},
            {'\x0345', '\x1fad'},
            {'\x0345', '\x1fae'},
            {'\x0345', '\x1faf'},
            {'\x0345', '\x1fb2'},
            {'\x0345', '\x1fc2'},
            {'\x0345', '\x1ff2'},
            {'\x0345', '\x1fb7'},
            {'\x0345', '\x1fc7'},
            {'\x0345', '\x1ff7'},
            {'\x0338', '\x219a'},
            {'\x0338', '\x219b'},
            {'\x0338', '\x21ae'},
            {'\x0338', '\x21cd'},
            {'\x0338', '\x21cf'},
            {'\x0338', '\x21ce'},
            {'\x0338', '\x2204'},
            {'\x0338', '\x2209'},
            {'\x0338', '\x220c'},
            {'\x0338', '\x2224'},
            {'\x0338', '\x2226'},
            {'\x0338', '\x2241'},
            {'\x0338', '\x2244'},
            {'\x0338', '\x2247'},
            {'\x0338', '\x2249'},
            {'\x0338', '\x226d'},
            {'\x0338', '\x2262'},
            {'\x0338', '\x2270'},
            {'\x0338', '\x2271'},
            {'\x0338', '\x2274'},
            {'\x0338', '\x2275'},
            {'\x0338', '\x2278'},
            {'\x0338', '\x2279'},
            {'\x0338', '\x2280'},
            {'\x0338', '\x2281'},
            {'\x0338', '\x22e0'},
            {'\x0338', '\x22e1'},
            {'\x0338', '\x2284'},
            {'\x0338', '\x2285'},
            {'\x0338', '\x2288'},
            {'\x0338', '\x2289'},
            {'\x0338', '\x22e2'},
            {'\x0338', '\x22e3'},
            {'\x0338', '\x22ac'},
            {'\x0338', '\x22ad'},
            {'\x0338', '\x22ae'},
            {'\x0338', '\x22af'},
            {'\x0338', '\x22ea'},
            {'\x0338', '\x22eb'},
            {'\x0338', '\x22ec'},
            {'\x0338', '\x22ed'},
            {'\x3099', '\x3094'},
            {'\x3099', '\x304c'},
            {'\x3099', '\x304e'},
            {'\x3099', '\x3050'},
            {'\x3099', '\x3052'},
            {'\x3099', '\x3054'},
            {'\x3099', '\x3056'},
            {'\x3099', '\x3058'},
            {'\x3099', '\x305a'},
            {'\x3099', '\x305c'},
            {'\x3099', '\x305e'},
            {'\x3099', '\x3060'},
            {'\x3099', '\x3062'},
            {'\x3099', '\x3065'},
            {'\x3099', '\x3067'},
            {'\x3099', '\x3069'},
            {'\x3099', '\x309e'},
            {'\x3099', '\x30f4'},
            {'\x3099', '\x30ac'},
            {'\x3099', '\x30ae'},
            {'\x3099', '\x30b0'},
            {'\x3099', '\x30b2'},
            {'\x3099', '\x30b4'},
            {'\x3099', '\x30b6'},
            {'\x3099', '\x30b8'},
            {'\x3099', '\x30ba'},
            {'\x3099', '\x30bc'},
            {'\x3099', '\x30be'},
            {'\x3099', '\x30c0'},
            {'\x3099', '\x30c2'},
            {'\x3099', '\x30c5'},
            {'\x3099', '\x30c7'},
            {'\x3099', '\x30c9'},
            {'\x3099', '\x30f7'},
            {'\x3099', '\x30f8'},
            {'\x3099', '\x30f9'},
            {'\x3099', '\x30fa'},
            {'\x3099', '\x30fe'}
        };

        /// <summary>
        /// When the offset for the second character is in the range
        /// [SECOND_SINGLE_START...), look up the corresponding
        /// character here with the offset from Data to see if it is
        /// the first character.  If not, there is no combination.
        /// </summary>
        public static readonly char[,] SecondSingle = new char[,]
        {
            {'\x0627', '\x0622'},
            {'\x0627', '\x0623'},
            {'\x0627', '\x0625'},
            {'\x09c7', '\x09cb'},
            {'\x09c7', '\x09cc'},
            {'\x0b47', '\x0b4b'},
            {'\x0b47', '\x0b48'},
            {'\x0b47', '\x0b4c'},
            {'\x0bc6', '\x0bca'},
            {'\x0bc6', '\x0bcc'},
            {'\x0cc6', '\x0cca'},
            {'\x0cc6', '\x0cc7'},
            {'\x0cc6', '\x0cc8'},
            {'\x0d46', '\x0d4a'},
            {'\x0d46', '\x0d4c'},
            {'\x0dd9', '\x0dda'},
            {'\x0dd9', '\x0ddc'},
            {'\x0dd9', '\x0dde'}
        };

        /// <summary>
        /// Array of composition pairs, indexed by offset (from Data) of first
        /// character, and offset of second character.
        /// </summary>
        public static readonly char[,] Array = new char[,]
        {
            {'\x00c0', '\x00c1', '\x00c2', '\x00c3', '\x0100', '\x0102', '\x0226', '\x00c4', '\x1ea2', '\x00c5', '\x0000', '\x01cd', '\x0200', '\x0202', '\x0000', '\x0000', '\x0000', '\x1ea0', '\x0000', '\x1e00', '\x0000', '\x0000', '\x0104', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e02', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e04', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e06', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0106', '\x0108', '\x0000', '\x0000', '\x0000', '\x010a', '\x0000', '\x0000', '\x0000', '\x0000', '\x010c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x00c7', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e0a', '\x0000', '\x0000', '\x0000', '\x0000', '\x010e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e0c', '\x0000', '\x0000', '\x0000', '\x1e10', '\x0000', '\x1e12', '\x0000', '\x0000', '\x1e0e', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00c8', '\x00c9', '\x00ca', '\x1ebc', '\x0112', '\x0114', '\x0116', '\x00cb', '\x1eba', '\x0000', '\x0000', '\x011a', '\x0204', '\x0206', '\x0000', '\x0000', '\x0000', '\x1eb8', '\x0000', '\x0000', '\x0000', '\x0228', '\x0118', '\x1e18', '\x0000', '\x1e1a', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x01f4', '\x011c', '\x0000', '\x1e20', '\x011e', '\x0120', '\x0000', '\x0000', '\x0000', '\x0000', '\x01e6', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0122', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0124', '\x0000', '\x0000', '\x0000', '\x1e22', '\x1e26', '\x0000', '\x0000', '\x0000', '\x021e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e24', '\x0000', '\x0000', '\x0000', '\x1e28', '\x0000', '\x0000', '\x1e2a', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00cc', '\x00cd', '\x00ce', '\x0128', '\x012a', '\x012c', '\x0130', '\x00cf', '\x1ec8', '\x0000', '\x0000', '\x01cf', '\x0208', '\x020a', '\x0000', '\x0000', '\x0000', '\x1eca', '\x0000', '\x0000', '\x0000', '\x0000', '\x012e', '\x0000', '\x0000', '\x1e2c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e30', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x01e8', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e32', '\x0000', '\x0000', '\x0000', '\x0136', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e34', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0139', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x013d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e36', '\x0000', '\x0000', '\x0000', '\x013b', '\x0000', '\x1e3c', '\x0000', '\x0000', '\x1e3a', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e3e', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e40', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e42', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x01f8', '\x0143', '\x0000', '\x00d1', '\x0000', '\x0000', '\x1e44', '\x0000', '\x0000', '\x0000', '\x0000', '\x0147', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e46', '\x0000', '\x0000', '\x0000', '\x0145', '\x0000', '\x1e4a', '\x0000', '\x0000', '\x1e48', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00d2', '\x00d3', '\x00d4', '\x00d5', '\x014c', '\x014e', '\x022e', '\x00d6', '\x1ece', '\x0000', '\x0150', '\x01d1', '\x020c', '\x020e', '\x0000', '\x0000', '\x01a0', '\x1ecc', '\x0000', '\x0000', '\x0000', '\x0000', '\x01ea', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e54', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e56', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0154', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e58', '\x0000', '\x0000', '\x0000', '\x0000', '\x0158', '\x0210', '\x0212', '\x0000', '\x0000', '\x0000', '\x1e5a', '\x0000', '\x0000', '\x0000', '\x0156', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e5e', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x015a', '\x015c', '\x0000', '\x0000', '\x0000', '\x1e60', '\x0000', '\x0000', '\x0000', '\x0000', '\x0160', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e62', '\x0000', '\x0000', '\x0218', '\x015e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e6a', '\x0000', '\x0000', '\x0000', '\x0000', '\x0164', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e6c', '\x0000', '\x0000', '\x021a', '\x0162', '\x0000', '\x1e70', '\x0000', '\x0000', '\x1e6e', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00d9', '\x00da', '\x00db', '\x0168', '\x016a', '\x016c', '\x0000', '\x00dc', '\x1ee6', '\x016e', '\x0170', '\x01d3', '\x0214', '\x0216', '\x0000', '\x0000', '\x01af', '\x1ee4', '\x1e72', '\x0000', '\x0000', '\x0000', '\x0172', '\x1e76', '\x0000', '\x1e74', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x1e7c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e7e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1e80', '\x1e82', '\x0174', '\x0000', '\x0000', '\x0000', '\x1e86', '\x1e84', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e88', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e8a', '\x1e8c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ef2', '\x00dd', '\x0176', '\x1ef8', '\x0232', '\x0000', '\x1e8e', '\x0178', '\x1ef6', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ef4', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0179', '\x1e90', '\x0000', '\x0000', '\x0000', '\x017b', '\x0000', '\x0000', '\x0000', '\x0000', '\x017d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e92', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e94', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00e0', '\x00e1', '\x00e2', '\x00e3', '\x0101', '\x0103', '\x0227', '\x00e4', '\x1ea3', '\x00e5', '\x0000', '\x01ce', '\x0201', '\x0203', '\x0000', '\x0000', '\x0000', '\x1ea1', '\x0000', '\x1e01', '\x0000', '\x0000', '\x0105', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e03', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e05', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e07', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0107', '\x0109', '\x0000', '\x0000', '\x0000', '\x010b', '\x0000', '\x0000', '\x0000', '\x0000', '\x010d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x00e7', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e0b', '\x0000', '\x0000', '\x0000', '\x0000', '\x010f', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e0d', '\x0000', '\x0000', '\x0000', '\x1e11', '\x0000', '\x1e13', '\x0000', '\x0000', '\x1e0f', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00e8', '\x00e9', '\x00ea', '\x1ebd', '\x0113', '\x0115', '\x0117', '\x00eb', '\x1ebb', '\x0000', '\x0000', '\x011b', '\x0205', '\x0207', '\x0000', '\x0000', '\x0000', '\x1eb9', '\x0000', '\x0000', '\x0000', '\x0229', '\x0119', '\x1e19', '\x0000', '\x1e1b', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x01f5', '\x011d', '\x0000', '\x1e21', '\x011f', '\x0121', '\x0000', '\x0000', '\x0000', '\x0000', '\x01e7', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0123', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0125', '\x0000', '\x0000', '\x0000', '\x1e23', '\x1e27', '\x0000', '\x0000', '\x0000', '\x021f', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e25', '\x0000', '\x0000', '\x0000', '\x1e29', '\x0000', '\x0000', '\x1e2b', '\x0000', '\x1e96', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00ec', '\x00ed', '\x00ee', '\x0129', '\x012b', '\x012d', '\x0000', '\x00ef', '\x1ec9', '\x0000', '\x0000', '\x01d0', '\x0209', '\x020b', '\x0000', '\x0000', '\x0000', '\x1ecb', '\x0000', '\x0000', '\x0000', '\x0000', '\x012f', '\x0000', '\x0000', '\x1e2d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0135', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x01f0', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e31', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x01e9', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e33', '\x0000', '\x0000', '\x0000', '\x0137', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e35', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x013a', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x013e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e37', '\x0000', '\x0000', '\x0000', '\x013c', '\x0000', '\x1e3d', '\x0000', '\x0000', '\x1e3b', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e3f', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e41', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e43', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x01f9', '\x0144', '\x0000', '\x00f1', '\x0000', '\x0000', '\x1e45', '\x0000', '\x0000', '\x0000', '\x0000', '\x0148', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e47', '\x0000', '\x0000', '\x0000', '\x0146', '\x0000', '\x1e4b', '\x0000', '\x0000', '\x1e49', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00f2', '\x00f3', '\x00f4', '\x00f5', '\x014d', '\x014f', '\x022f', '\x00f6', '\x1ecf', '\x0000', '\x0151', '\x01d2', '\x020d', '\x020f', '\x0000', '\x0000', '\x01a1', '\x1ecd', '\x0000', '\x0000', '\x0000', '\x0000', '\x01eb', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e55', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e57', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0155', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e59', '\x0000', '\x0000', '\x0000', '\x0000', '\x0159', '\x0211', '\x0213', '\x0000', '\x0000', '\x0000', '\x1e5b', '\x0000', '\x0000', '\x0000', '\x0157', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e5f', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x015b', '\x015d', '\x0000', '\x0000', '\x0000', '\x1e61', '\x0000', '\x0000', '\x0000', '\x0000', '\x0161', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e63', '\x0000', '\x0000', '\x0219', '\x015f', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e6b', '\x1e97', '\x0000', '\x0000', '\x0000', '\x0165', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e6d', '\x0000', '\x0000', '\x021b', '\x0163', '\x0000', '\x1e71', '\x0000', '\x0000', '\x1e6f', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x00f9', '\x00fa', '\x00fb', '\x0169', '\x016b', '\x016d', '\x0000', '\x00fc', '\x1ee7', '\x016f', '\x0171', '\x01d4', '\x0215', '\x0217', '\x0000', '\x0000', '\x01b0', '\x1ee5', '\x1e73', '\x0000', '\x0000', '\x0000', '\x0173', '\x1e77', '\x0000', '\x1e75', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x1e7d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e7f', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1e81', '\x1e83', '\x0175', '\x0000', '\x0000', '\x0000', '\x1e87', '\x1e85', '\x0000', '\x1e98', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e89', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e8b', '\x1e8d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ef3', '\x00fd', '\x0177', '\x1ef9', '\x0233', '\x0000', '\x1e8f', '\x00ff', '\x1ef7', '\x1e99', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ef5', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x017a', '\x1e91', '\x0000', '\x0000', '\x0000', '\x017c', '\x0000', '\x0000', '\x0000', '\x0000', '\x017e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e93', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1e95', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1fed', '\x0385', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fc1', '\x0000', '\x0000', '\x0000'},
            {'\x1ea6', '\x1ea4', '\x0000', '\x1eaa', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ea8', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x01fc', '\x0000', '\x0000', '\x01e2', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ec0', '\x1ebe', '\x0000', '\x1ec4', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ec2', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ed2', '\x1ed0', '\x0000', '\x1ed6', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ed4', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e4c', '\x0000', '\x0000', '\x022c', '\x0000', '\x0000', '\x1e4e', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x01db', '\x01d7', '\x0000', '\x0000', '\x01d5', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x01d9', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ea7', '\x1ea5', '\x0000', '\x1eab', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ea9', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x01fd', '\x0000', '\x0000', '\x01e3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ec1', '\x1ebf', '\x0000', '\x1ec5', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ec3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ed3', '\x1ed1', '\x0000', '\x1ed7', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ed5', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x1e4d', '\x0000', '\x0000', '\x022d', '\x0000', '\x0000', '\x1e4f', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x01dc', '\x01d8', '\x0000', '\x0000', '\x01d6', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x01da', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1eb0', '\x1eae', '\x0000', '\x1eb4', '\x0000', '\x0000', '\x0000', '\x0000', '\x1eb2', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1eb1', '\x1eaf', '\x0000', '\x1eb5', '\x0000', '\x0000', '\x0000', '\x0000', '\x1eb3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1e14', '\x1e16', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1e15', '\x1e17', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1e50', '\x1e52', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1e51', '\x1e53', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1edc', '\x1eda', '\x0000', '\x1ee0', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ede', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ee2', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1edd', '\x1edb', '\x0000', '\x1ee1', '\x0000', '\x0000', '\x0000', '\x0000', '\x1edf', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ee3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1eea', '\x1ee8', '\x0000', '\x1eee', '\x0000', '\x0000', '\x0000', '\x0000', '\x1eec', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ef0', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1eeb', '\x1ee9', '\x0000', '\x1eef', '\x0000', '\x0000', '\x0000', '\x0000', '\x1eed', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ef1', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1fba', '\x0386', '\x0000', '\x0000', '\x1fb9', '\x1fb8', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f08', '\x1f09', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fbc', '\x0000', '\x0000'},
            {'\x1fc8', '\x0388', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f18', '\x1f19', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1fca', '\x0389', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f28', '\x1f29', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fcc', '\x0000', '\x0000'},
            {'\x1fda', '\x038a', '\x0000', '\x0000', '\x1fd9', '\x1fd8', '\x0000', '\x03aa', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f38', '\x1f39', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ff8', '\x038c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f48', '\x1f49', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1fea', '\x038e', '\x0000', '\x0000', '\x1fe9', '\x1fe8', '\x0000', '\x03ab', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f59', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1ffa', '\x038f', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f68', '\x1f69', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ffc', '\x0000', '\x0000'},
            {'\x1f70', '\x03ac', '\x0000', '\x0000', '\x1fb1', '\x1fb0', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f00', '\x1f01', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fb6', '\x1fb3', '\x0000', '\x0000'},
            {'\x1f72', '\x03ad', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f10', '\x1f11', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f74', '\x03ae', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f20', '\x1f21', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fc6', '\x1fc3', '\x0000', '\x0000'},
            {'\x1f76', '\x03af', '\x0000', '\x0000', '\x1fd1', '\x1fd0', '\x0000', '\x03ca', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f30', '\x1f31', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fd6', '\x0000', '\x0000', '\x0000'},
            {'\x1f78', '\x03cc', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f40', '\x1f41', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fe4', '\x1fe5', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f7a', '\x03cd', '\x0000', '\x0000', '\x1fe1', '\x1fe0', '\x0000', '\x03cb', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f50', '\x1f51', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fe6', '\x0000', '\x0000', '\x0000'},
            {'\x1f7c', '\x03ce', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f60', '\x1f61', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1ff6', '\x1ff3', '\x0000', '\x0000'},
            {'\x1fd2', '\x0390', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fd7', '\x0000', '\x0000', '\x0000'},
            {'\x1fe2', '\x03b0', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fe7', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x03d3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x03d4', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x04d0', '\x0000', '\x04d2', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0400', '\x0000', '\x0000', '\x0000', '\x0000', '\x04d6', '\x0000', '\x0401', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x04c1', '\x0000', '\x04dc', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x040d', '\x0000', '\x0000', '\x0000', '\x04e2', '\x0419', '\x0000', '\x04e4', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x04ee', '\x040e', '\x0000', '\x04f0', '\x0000', '\x0000', '\x04f2', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x04d1', '\x0000', '\x04d3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0450', '\x0000', '\x0000', '\x0000', '\x0000', '\x04d7', '\x0000', '\x0451', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x04c2', '\x0000', '\x04dd', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x045d', '\x0000', '\x0000', '\x0000', '\x04e3', '\x0439', '\x0000', '\x04e5', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x04ef', '\x045e', '\x0000', '\x04f1', '\x0000', '\x0000', '\x04f3', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x1eac', '\x0000', '\x0000', '\x1eb6', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x1ead', '\x0000', '\x0000', '\x1eb7', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f02', '\x1f04', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f06', '\x1f80', '\x0000', '\x0000'},
            {'\x1f03', '\x1f05', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f07', '\x1f81', '\x0000', '\x0000'},
            {'\x1f0a', '\x1f0c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f0e', '\x1f88', '\x0000', '\x0000'},
            {'\x1f0b', '\x1f0d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f0f', '\x1f89', '\x0000', '\x0000'},
            {'\x1f12', '\x1f14', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f13', '\x1f15', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f1a', '\x1f1c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f1b', '\x1f1d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f22', '\x1f24', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f26', '\x1f90', '\x0000', '\x0000'},
            {'\x1f23', '\x1f25', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f27', '\x1f91', '\x0000', '\x0000'},
            {'\x1f2a', '\x1f2c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f2e', '\x1f98', '\x0000', '\x0000'},
            {'\x1f2b', '\x1f2d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f2f', '\x1f99', '\x0000', '\x0000'},
            {'\x1f32', '\x1f34', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f36', '\x0000', '\x0000', '\x0000'},
            {'\x1f33', '\x1f35', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f37', '\x0000', '\x0000', '\x0000'},
            {'\x1f3a', '\x1f3c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f3e', '\x0000', '\x0000', '\x0000'},
            {'\x1f3b', '\x1f3d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f3f', '\x0000', '\x0000', '\x0000'},
            {'\x1f42', '\x1f44', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f43', '\x1f45', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f4a', '\x1f4c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f4b', '\x1f4d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000'},
            {'\x1f52', '\x1f54', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f56', '\x0000', '\x0000', '\x0000'},
            {'\x1f53', '\x1f55', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f57', '\x0000', '\x0000', '\x0000'},
            {'\x1f5b', '\x1f5d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f5f', '\x0000', '\x0000', '\x0000'},
            {'\x1f62', '\x1f64', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f66', '\x1fa0', '\x0000', '\x0000'},
            {'\x1f63', '\x1f65', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f67', '\x1fa1', '\x0000', '\x0000'},
            {'\x1f6a', '\x1f6c', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f6e', '\x1fa8', '\x0000', '\x0000'},
            {'\x1f6b', '\x1f6d', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1f6f', '\x1fa9', '\x0000', '\x0000'},
            {'\x1fcd', '\x1fce', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fcf', '\x0000', '\x0000', '\x0000'},
            {'\x1fdd', '\x1fde', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x1fdf', '\x0000', '\x0000', '\x0000'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x3070', '\x3071'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x3073', '\x3074'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x3076', '\x3077'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x3079', '\x307a'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x307c', '\x307d'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x30d0', '\x30d1'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x30d3', '\x30d4'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x30d6', '\x30d7'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x30d9', '\x30da'},
            {'\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x0000', '\x30dc', '\x30dd'}
        };
    }
}

