# **세션과 쿠키**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)

## 세션
- **서버**에서 저장하고 관리
- 서버에서 관리하기 때문에 쿠키에 비해 **보안성**이 좋음.
- 서버의 리소스를 사용하기 때문에 많은 세션 데이터의 사용은 서버의 성능을 저하시킨다.
- 브라우저를 종료하면 세션 객체가 삭제된다.(브라우저 단위로 관리)
- 일반적으로 **로그인 정보 유지**에 사용된다.
- 세션을 통한 인증방식
    1. 클라이언트가 서버에 인증을 요청(request)
    2. 서버에서는 세션 객체를 생성하고 저장(메모리 or Cache DB)한 후 **세션ID**를 Set-cookie를 통해 클라이언트에 전달
    3. 클라이언트는 재요청(request)할 때, 이 쿠키를 이용해서 세션ID값을 서버에 전달
    4. 서버는 세션 스토리지에서 세션 객체를 검색하고 요청받은 작업에 대해 응답

## 쿠키
- **클라이언트**에 저장되는 키와 값이 들어있는 작은 데이터 파일.
- 사용자가 따로 요청하지 않아도 브라우저가 Request시에 Request Header를 넣어서 자동으로 서버에 전송한다.
- 유효시간을 설정할 수 있으며 유효시간이 만료되거나 사용자가 삭제하기 전까지는 데이터가 소멸되지 않는다.
- Response Header의 Set-Cookie 속성을 사용하여 클라이언트에 쿠키를 만들 수 있다.
- 클라이언트의 리소스를 사용하기 때문에 서버의 부하가 적다.
- 클라이언트에 **300**개까지 저장이 가능하다.
- 하나의 도메인당 **20**개의 값만 가질 수 있다.
- 하나의 쿠키값은 **4KB**(4096B)까지 저장 한다.
- 쿠키 저장 프로세스
    1. 브라우저에서 웹페이지 접속
    2. 클라이언트가 요청한 웹페이지를 받으면서 쿠키를 클라이언트 로컬에 저장
    3. 클라이언트가 재요청시 웹페이지 요청과 함께 쿠키도 전송
