# **대칭키와 공개키**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## 대칭키
- 암호화에 사용되는 키와 복호화에 사용되는 키가 동일한 암호화 기법
- 하나의 비밀키를 **클라이언트**와 **서버**가 같이 사용한다.
- 계산속도가 빠르다.
- 비밀키 하나만 알아내면 암호화된 내용을 해독이 가능하여 안전하지가 않다.
- 암호화하는 단위에 따라 **스트림암호**와 **블록암호**로 나눌 수 있다.
    - 스트림암호는 연속적인 비트/바이트를 계속해서 입력받아, 그에 대응하는 암호화 비트/바이트를 생성하는 방식이다.
    - 블록암호는 정해진 한 단위(블록)를 입력받아 그에 대응하는 암호화 블록을 생성하는 방식이다.
    - 블록암호의 경우 적절한 운용모드를 조합하면 블록 단위보다 큰 입력을 처리할 수 있다.
- 대칭키를 사용하는 암호 알고리즘 방식으로는 DES, 3-DES, AES, SEED, ARIA, MASK 등이 있다.

## 공개키
- 공개키와 비밀키의 한쌍의 키가 존재한다.
- 암호화와 복호화에 사용하는 키가 서로 다르다.(비대칭키 암호)
- 대칭키 방식에 비해 계산속도가 느리다.
- 개인키로 암호화한 정보는 쌍이 되는 공개키로만 복호화가 가능하다.
- 공개키로 암호화한 정보는 쌍이 되는 개인키로만 복호화가 가능하다.
- 공개키는 누구나 알 수 있지만, 쌍이 되는 비밀키는 키의 소유자만이 알 수 있어서 특정한 비밀키를 가지는 사용자만이 내용을 열어볼 수 있도록 하는 방식.

## 대칭키 vs 공개키
|  | 대칭키| 공개키 |
|:--------|:--------:|:--------:|
| 키 개수 | 한개 | 두개 |
| 키 보관 형태 | 비밀 | 개인키(비밀), 공개키(배포) |
| 키 교환 | 키를 교환하는것이 어렵고 위험 | 공개키를 교환 |
| 키 길이 | 주로 64,128비트 | 주로 512, 1024, 2048비트 |
| 암호화 속도 | 빠름 | 느림 |
| 암호화할 수 있는 평문의 길이| 제한없음 | 제한있음 |
| 기밀성 | 가능 | 가능 |
| 인증 | 부분적 가능 | 가능 |
| 무결성 | 부분적 가능 | 가능 |
| 부인 방지 | 불가능 | 가능 |

## Link
[참고 블로그](https://brownbears.tistory.com/332)

[참고 블로그2](https://gaeko-security-hack.tistory.com/123)
