# **Memory Structure(메모리 구조)**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## 메모리 구조
![memory](https://user-images.githubusercontent.com/21440957/64079882-6cd82000-cd28-11e9-8810-2bfe3a4944ef.png)

### 코드 영역
- 실행할 **프로그램의 코드**가 저장되는 영역으로 **텍스트 영역**이라고도 부른다.
- CPU는 코드 영역에 저장된 명령어를 하나씩 가져가서 처리한다.

### 데이터 영역
- 프로그램의 **전역 변수**와 **정적(static) 변수**가 저장되는 영역이다.
- 데이터 영역은 프로그램의 **시작과 동시에 할당**되며, 프로그램이 **종료되면 소멸**한다.

### 스택 영역
- 함수의 호출과 관계되는 **지역 변수**와 **매개변수**가 저장되는 영역이다.
- 함수의 호출과 함께 할당되며, 함수의 호출이 완료되면 소멸한다.
- 메모리의 **높은 주소**에서 **낮은 주소**의 방향으로 할당 된다.
- 컴파일 시에 크기가 결정 된다.

### 힙 영역
- 사용자가 **직접 관리**할 수 있는 영역으로 **사용자에 의해** 메모리 공간이 **동적**으로 할당되고 해제된다.
- 힙 영역은 메모리의 **낮은 주소**에서 **높은 주소**의 방향으로 할당된다.
- 런타임 시에 크기가 결정 된다.
- 할당, 해제 작업으로 인해 속도의 저하가 일어날 수 있다.
- C/C++에서는 동적으로 메모리 공간을 할당하고 해제해주는 **함수**가 있다.(malloc,free)
- C++에서는 new, delete **키워드**를 통해 동적으로 할당 한다.
- Java에서는 **가비지 컬렉터**가 자동으로 해제해준다.

### 힙 영역과 스택 영역
- 두 영역은 같은 공간을 공유한다. 
- 힙이 메모리 위쪽 주소부터 할당되면 스택은 아래쪽부터 할당된다.
- 각 영역이 상대 공간을 침범하는 일이 발생할 수 있는데 이를 각각 heap overflow, stack overflow라고 한다.
- 힙 영역이 크면 클수록 스택 영역이 작아 지고, 스택 영역이 크면 클 수록 힙 영역이 작아진다.
