# **Fragmentation(단편화)**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## 단편화?
- RAM에서 메모리의 공간이 작은 조각으로 나뉘어져 **사용가능한 메모리가 충분**하지만 **할당(사용)이 불가능**한 상태

## 단편화 종류
### 외부 단편화(External Fragmentation)
- 메모리가 할당되고 해제되는 작업이 반복되면 작은 메모리가 사이 사이에 존재하게 된다. 
- 이 과정이 반복 되면 새로운 프로세스가 할당 될 **총 메모리 공간은 만족**하나 **메모리 공간이 연속적이지 않는 문제**가 발생하는데 이것을 외부 단편화라고 한다.
- Compaction<sup>[1)](#ref)</sup>과 가비지 컬렉션을 통해서 줄일 수 있다.

### 내부 단편화(Internal Fragmentation)
- 메모리를 할당하는 최소 블록 크기가 존재한다. 4KB의 Page를 예로 들면, Page의 단위는 4KB인데, 3KB만 사용하는 경우 1KB의 사용되지 않는 공간이 발생하는데 이것을 내부 단편화라고 한다.

## 단편화 해결책
### 페이징(Paging)
- 프레임<sup>[2)](#ref)</sup>과 페이지<sup>[3)](#ref)</sup>를 대응하게 하여 연속적인 물리메모리가 아니더라도 원하는 크기의 프레임을 사용할 수 있도록 하는 방법이다.
- **Paging table**을 만들어 물리메모리(프레임)와 가상메모리(페이지)를 page mapping 과정을 통해 대응시킨다.
- 연속적이지 않은 공간을 활용할 수 있다.
- 페이지 단위에 알맞게 꽉 채워 쓰는 게 아니므로 내부 단편화 문제는 여전히 존재한다.
- 페이지 단위를 작게 하면 내부 단편화 역시 해결할 수 있지만<sup>[4)](#ref)</sup> 그 만큼, mapping 과정이 증가하므로 효율이 떨어질 수 있다.

### 세그멘테이션(Segmentation)
- 가상메모리를 **서로 크기가 다른 논리적 단위인 세그먼트**(Segment)로 분할하고 메모리를 할당하며 주소 변환을 하는 방법이다.
- 각 세그먼트는 연속적인 공간에 저장되어 있다.
- 세그먼트들의 크기가 서로 다르기 때문에 메모리를 페이징 기법처럼 미리 분할해 둘 수 없고, 메모리에 적재될 때 빈 공간을 찾아 할당하는 사용자 관점의 가상메모리 관리 기법이다.
- mapping을 위해 **Segment table**을 필요로 한다.
- 하나의 세그먼트 단위로 통제가 가능한 장점이 있다.
- 서로 다른 크기의 세그먼트들에 대해 메모리에 올리고 내리는 작업을 반복하다보면 외부 단편화가 생길 수 있다.

### Memory Pool
- 필요한 메모리 공간을 필요한 만큼 사용자가 직접 지정하여 미리 할당받아 놓고 필요할 때마다 사용하고 반납하는 기법
- 메모리 풀 없이 동적 할당과 해제를 반복하면 메모리의 랜덤한 위치에 할당과 해제가 반복되면서 단편화를 일으킬 수 있겠지만 미리 할당해놓고 가져다 쓰고 반납하기 때문에 할당과 해제로 인한 **외부 단편화**가 발생하지 않는다. 
- 필요한 만큼 할당을 해놓기 때문에 **내부 단편화**도 생기지 않는다.
- 메모리 단편화로 인한 메모리 낭비 보다 메모리 풀을 만들었지만 쓰지 않았을 때 메모리 낭비가 커질 경우 사용하지 않아야 한다.
- 메모리의 **할당, 해제가 잦은 경우에 효과적**이다.
- 미리 할당해놓고 사용하지 않는 순간에도 계속 할당해 놓으므로 **메모리 누수**가 있다.

#### 구현 방법
1) 큰 메모리 블록(페이지)을 힙에 할당한다.
2) 할당 받은 블록(페이지)을 각 객체의 크기의 블록으로 나눈다.
3) 각 객체를 위한 블록을 순차적으로 링크한다.
4) 할당할 블록을 특정 포인터가 가리키게 한다.
5) 메모리 요청이 생기면 현재 헤더 포인터가 가리키는 블록을 돌려준다.
6) 할당이 일어난 후 헤더 포인터는 할당 전에 가리키던 블록이 가리키던 블록을 가리킨다.
7) 사용되던 메모리가 해제되어 메모리 풀로 돌아올 경우 헤더 포인터는 그 블록을 가리키고 기존에 헤더 포인터가 가리키던 블록은 돌아온 블록의 다음 포인터가 가리키게 한다.

## 각주
<a href id="ref">
</a>

1. 다수의 비어있는 Hole들을 합쳐서 하나의 큰 Block으로 만들어 주는 기법. Relocation이 동적일 때와, 실행시간에만 가능하다.
2. 물리 메모리(RAM)를 일정한 크기로 나눈 블록
3. 가상 메모리를 일정한 크기로 나눈 블록
4. 페이지에 공간을 할당한 후, 남는 공간이 적어지기 때문이다.
