# **TCP와 UDP의 차이**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## TCP
- **연결형 서비스**를 지원하는 전송계층 프로토콜
- 1:1 통신 방식. 연결 후 통신
- 인터넷 환경(http, http/2)에서 기본으로 사용한다.
- host간 신뢰성있는 데이터 전달과 **흐름제어** 및 **혼잡제어**를 제공한다.
- 연속성보다 신뢰성있는 전송이 중요할 때에 사용하는 프로토콜(ex. WEB 통신, 파일 전송)
- 연결의 설정(3-hand-shaking)과 해제(4-hand-shaking)
- 헤더의 크기가 20byte로 큰 편이고 옵션 필드가 최대 40byte로 작다.
- MTU<sup>[1)](#ref)</sup>사이즈에 맞게 데이터를 분리해서 보낼 때 의미 있는 단위가 아닌 최대 크기만큼씩 ByteStream 형태로 분리해서 보낸다.

## UDP
- **비연결형 서비스**를 지원하는 전송계층 프로토콜
- 전이중(Full-Duplex), 점대점 방식
- 전송 순서를 보장하지 않는다.
- HTTP/3에서 기본으로 사용할 예정이다.
- 신뢰성이 낮지만 속도가 빠르다. 따라서 신뢰성보다는 연속성이 중요한 서비스에 사용한다.(ex. 스트리밍, 음성, 멀티미디어)
- 헤더의 Checksum 필드를 통해 최소한의 오류만 검출한다.(사용 안할 수도 있다)
- 헤더의 크기가 8byte로 굉장히 작고 옵션 필드가 따로 존재하지않아 옵션의 제한이 없다.
- MTU<sup>[1)](#ref)</sup>사이즈에 맞게 데이터를 분리해서 보낼 때 데이터를 의미있는 단위로 분리해서 전송한다.

## TCP와 UDP의 비교
| 프로토콜 | TCP | UDP 
|:---:|:---:|:---:|
|**신뢰성**|높다|낮다|
|**연결 방식**|연결형 서비스|비연결형 서비스|
|**전송 순서**|전송 순서 보장|전송 순서가 바뀔 수 있다|
|**통신 방식**|1:1|1:1 / 1:N / N:N|
|**패킷 교환 방식**|가상 회선 방식|데이터그램 방식|
|**수신 여부 확인**|수신여부 확인|수신여부 확인하지 않음|
|**속도**|느리다|빠르다|

## 각주
<a id="ref">

1) Maximum Transmission Unit(최대 전송 단위)

</a>
