# **OSI 7 Layer**

## 작성자
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## OSI 7 Layer란?
- 국제 표준화 기구에서 **개방형 시스템 상호 연결을 위한 기초 참조 모델**(Open Systems Interconnection Reference Model)로서 만들어진 계층형 모델이다.<sup>[1)](#ref1)</sup>
- 현재 네트워크 시스템의 기반이 된 모델이며 다양한 시스템의 연결은 이 계층 모델을 기반으로 통신한다.
- 물론, 현재의 인터넷은 각 계층의 역할들이 합쳐지면서 TCP/IP 4 layer 라고도 불리는 계층 모델을 기반으로 한다.
- 또한, 계층모델에 의해 프로토콜도 계층별로 구성된다.

### 왜 계층구조일까?
- 인터넷 뿐만이 아니라 한 시스템과 다른 한 시스템이 통신 하기에는 다양한 규칙들과 장비들을 필요로 하고 이를 위한 복잡한 시스템이 필요하다.
- 이런 크고 복잡한 시스템을 계층구조로 표현하면 잘 정의된 특정 부분을 논의 할 수 있게 된다.
- 이렇게 복잡한 시스템을 계층별로 단순화 하게 됨으로서 계층별로 제공하는 서비스의 구현을 변경하는것도 쉬워진다.
- 계속해서 갱신되는 복잡하고 커다란 시스템에 대해, 시스템의 다른 요소에 영향을 주지 않고 서비스 구현을 변화시키는 능력이 계층구조의 장점이다.
- 따라서 통신영역 외에도 다양한 영역에서 계층 구조를 활용한다.

### 프로토콜이란?
- 둘 이상의 통신 개체 간에 교환되는 메시지 포맷과 순서뿐 아니라, 메시지의 송수신과 다른 이벤트에 따른 행동들을 정의한다.
- 쉽게말하면 메시지를 주고받는 양식, 규칙 또는 **통신 규약**이라고 볼 수 있다.
- 연결된 통로를 통해 시스템간에 메시지를 주고받으려면, 한쪽에서 보낸 메시지를 반대쪽에서 받았을 때 이해 할 수 있어야한다.
- 마치 사람끼리 대화를 할 때 '안녕' 이란 말을 하면 반대쪽에서 '안녕'이란 메시지를 받았고 이는 인사에 해당되어 '안녕' 등의 메시지를 상대방도 보내기 시작한다.
- 이런 메시지를 주고 받을 때 언어와 대화 방법에 대해 암묵적인 규칙이 있기에 의사소통을 할 수 있게 된다.
- 이와같이 통신 모델에서도 상호간의 메시지 규칙들을 정의하게 되고, 계층 모델 형태이다보니 프로토콜도 계층별로 존재하게 된다.

## OSI 7 계층의 구조

|계층|데이터 단위|프로토콜 예제|
|:---:|:---:|:--:|
|7. [응용 계층](#application)(**Application Layer**)|message|HTTP, SMTP, FTP, SIP|
|6. [표현 계층](#presentation)(**Presentation Layer**)|message|ASCII, MPEG|
|5. [세션 계층](#session)(**Session Layer**)|message|NetBIOS, TLS|
|4. [전송 계층](#transport)(**Transport Layer**)|segment|TCP, UDP, SCTP|
|3. [네트워크 계층](#network)(**Network Layer**)|datagram, packet|IP, ICMP, ARP, RIP, BGP|
|2. [데이터 링크 계층](#datalink)(**Data Link Layer**)|frame|PPP, Ethernet, Token ring, IEE 802.11(Wifi)|
|1. [물리 계층](#physical)(**Physical Layer**)|bit|DSL, ISDN|


<a id="application"></a>
## 7계층 응용 계층(Application Layer)
- 많은 프로토콜이 존재하는 계층으로서 통신의 최종 목적지이다.
- 응용 프로그램들이 통신으로 활용하는 계층이며 새로운 응용 계층 프로토콜 추가는 굉장히 쉽다.
- 응용 프로그램과 밀접한 관계를 가지는 프로토콜들이 많다.
- 대부분 네트워크를 공부하면서 소켓 프로그래밍을 배우게 되는데 간단한 채팅 프로그램을 만들어봤던 사람들은 서버와 클라이언트간에 주고 받는 규칙들을 정의 해보았을 것이다.
- 그때 정의했던 규칙들 또한 응용 계층의 프로토콜이라고 볼 수 있다.
- 마찬가지로 소켓 프로그래밍으로 HTTP의 규격에 맞는 형태로 메시지를 만들어 보내게 되면 HTTP 통신도 할 수 있다.

<a id="presentation"></a>
## 6계층 표현 계층(Presentation Layer)
- 애플리케이션들이 교환되는 데이터의 의미를 해석하도록 하는 서비스를 제공하는 계층이다.
- 이들 서비스는 데이터가 표현되고 저장되는 내부적인 포멧 뿐만 아니라 데이터 압축과 데이터 암호화를 포함한다.
- 인터넷의 계층구조에는 포함되어 있지 않으며 필요에 따라 응용 계층에서 지원하거나 어플리케이션 개발자가 직접 개발해야한다.
- 소켓프로그래밍을 해봤다면 좀 더 잘 이해할 수 있다. 이 계층의 프로토콜이 정해지지 않았기 때문에 통신 프로그램을 개발 할 때 인코딩 방법을 결정하고 직접 형태를 변경해서 보내거나 알려줘야한다.
- 따로 처리하지않으면 시스템의 기본 형태로 인코딩해서 바이트스트림 형태로 보내게 된다.
- 만약 받는쪽과 인코딩 형태가 맞지 않으면 받은 데이터를 잘못 해석할 수 있다.

<a id="session"></a>
## 5계층 세션 계층(Session Layer)
- 데이터 교환의 경계와 동기화를 제공하는 계층이다.
- 체킹포인트와 회복방법을 세우는 수단을 포함한다.
- 표현 계층과 마찬가지로 인터넷의 계층구조에는 포함되어 있지 않으며 필요에 따라 응용 계층에서 지원하거나 어플리케이션 개발자가 직접 개발해야한다.
- 소켓프로그램의 서버를 예로 들면 한 서버는 여러 클라이언트와 동시에 통신 할 수 있다.
- 그러나 여러 클라이언트를 따로 Map등을 통해 저장해야만 각각의 통신 상태에 따라 데이터를 주거나 받는 선택을 할 수 있다.
- 또한 데이터를 상대방이 보내고 있을때 동시에 보낼지에 대한 반이중, 전이중 통신을 결정할 수 있다.
- 다만 전이중 통신을 할 경우 전송 계층의 프로토콜도 해당하는 서비스를 지원하는 프로토콜로 결정해야한다.

<a id="transport"></a>
## 4계층 전송 계층(Transport Layer)
- 상위 계층의 메시지를 전송하는 서비스를 제공하는 계층으로 인터넷 같은경우 **TCP**, **UDP** 프로토콜이 대표적이다.
- 전송 계층의 목적은 메시지의 오류를 제어하며 End-to-End로 종단간에 해당하는 지점까지 메시지를 주고 받는다.
- 또한, 메시지가 클 경우 이를 나눠서 네트워크 계층으로 전달하고, 받은 패킷을 재조립해서 상위 계층으로 전달한다.
- 이를 **Segmentation**한다고 하며 따라서 전송 계층의 단위는 Segment가 된다.
- 이 때, 나눠지는 크기는 보통 **MTU**(Maximum Transmission Unit)에 따라 결정된다.
- MTU는 Ethernet MTU, IP MTU, Path MTU등이 대표적이며 이더넷 같은경우 1500바이트로 설정되어 있어서 이더넷 헤더를 제외한 네트워크 계층 헤더와 데이터가 해당크기를 넘지않도록 잘라서 보내고 받을 때 이를 결합해서 상위 계층으로 전달해야한다.
- 이 외에도 프로토콜의 종류에 따라 다양한 서비스를 제공한다.
- TCP를 예로 들면 연결 지항형 통신을 제공하고, 패킷의 시퀸스 번호 등을 이용해서 손실, 중복, 순서에 대해 신뢰성을 보장하며 흐름제어, 혼잡제어 등의 서비스를 제공한다.
- 그와 반대로 UDP는 비연결형 통신을 제공하며, 신뢰성, 흐름제어, 혼잡제어를 제공하지않는다.

<a id="network"></a>
## 3계층 네트워크 계층(Network Layer)
- 패킷을 한 호스트에서 다른 호스트로 라우팅하는 책임을 지는 계층으로 인터넷 같은경우 **IP** 프로토콜이 대표적이다.
- 전송 계층에게 전달 받은 목적지 주소를 이용해서 패킷을 만들고 패킷을 전송해서 최종 목적지의 호스트의 전송 계층으로 Segment를 전달한다.
- IP 프로토콜의 경우 이 주소는 고유값 이지만, 변할 수 있는 논리적 주소이다.
- IP 프로토콜의 경우 종단 시스템과 라우터가 패킷이 가지고있는 데이터 필드에 대해 어떻게 동작해야하는지를 정의한 프로토콜과 이 패킷이 전송과정에서 이동 경로를 결정하는 라우팅 프로토콜로 이루어져있다.
- 따라서 IP 프로토콜의 핵심은 어디로 동작하도록 정의한 **Forwarding**과 어떤 경로로 전송할지 결정하는 **Routing**이다.
- 또한, 전송 계층의 프로토콜이 UDP이면 여기서 MTU 단위로 **Fragmentation**이 이루어진다.
- 그 외에도 데이터 전송에서 우선 순위 등을 통해서 특정 수준의 성능을 보장하는 **QoS**(Quality of Service)를 제공한다.
- 이 계층의 장비로 대표적인 것은 라우터 이다.

<a id="datalink"></a>
## 2계층 데이터 링크 계층(Data Link Layer)
- 전체 프레임을 한 네트워크 요소에서 이웃 네트워크 요소로 이동하는 계층으로 인터넷 같은경우 **Ethernet** 프로토콜이 대표적이다.
- Ethernet의 경우 MAC 주소를 이용해 Node-to-Node, Point-to-Point로 프레임을 전송하게 된다.
- 이 MAC 주소는 장치가 만들어질 때 물리적으로 할당 받아서 변할 수 없는 고유 값이다.
- 또한 프로토콜에 따라 CRC처럼 데이터의 무결성을 검증할 수 있다.
- 이 계층의 장비로 대표적인 것은 스위치, 브릿지 이다.

<a id="physical"></a>
## 1계층 물리 계층(Physical Layer)
- 프레임 내부의 각 비트를 한 노드에서 다음 노드로 실제로 이동하는 계층이다.
- 이 계층의 프로토콜들은 데이터 링크 계층에 의존하고 더 나아가 실제 전송 매체(ex. 꼬임쌍선, 단일 모드 광케이블, 무선의 경우 주파수 등)에 의존한다.
- 인터넷의 Ethernet 또한 여러 가지 물리 계층 프로토콜을 갖고 있다.
- 각 프로토콜에 따라 비트는 다른 방식으로 링크 반대편으로 이동된다.
- 이 계층의 장비로 대표적인 것은 허브, 리피터 이다.

## 데이터 전송의 흐름
- 통신하는 프로그램에서는 최초 전송하고자 하는 데이터에 응용 계층의 프로토콜에 맞는 헤더를 붙이면서 패킷을 만들게 된다.
- 만들어진 메시지들은 하위 계층으로 전송되면서 헤더가 붙게되고, 데이터 링크 계층의 Ethernet 같은 경우 테일을 뒤에 붙이기도 한다.
- 완성된 비트들은 물리 계층을 통해 전송된다.
- 인터넷 같은경우 전송을 돕는 중간 장비인 스위치, 라우터 등을 거치게 되는데 이 때, 해당 장비에 맞는 만큼만 헤더를 읽으며 내부 내용을 상위 계층으로 전달하며 해석하고, 다시 그에 맞는 하위 계층 헤더를 붙여서 전송하게 된다.
- 최종 목적지에 도착한 경우 헤더를 인식하며 그에 맞는 처리를 하며 상위 계층에 전송하고 최종적으로 데이터가 프로그램에게 전달된다.

## 참조
- Computer Networking : A Top-Down Approach 6th, James F. Kurose*Keith W. Ross 지음

## 각주
<a id="ref1" href="https://ko.wikipedia.org/wiki/OSI_%EB%AA%A8%ED%98%95"> 1) OSI 모형 wiki </a>
