# **DotProduct(벡터의 내적)**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## 내적
- 벡터의 연산중 하나
- **벡터**와 **벡터**의 연산이지만 결과값으로는 **스칼라** 값이 나온다.

### 계산 방법
1. 두 벡터의 성분을 곱해서 더해주는 방법
	- u = {1,2,3}, v = {1,2,3}, u⋅v = 2 + 4 + 6 = 12
2. 두 벡터의 크기와 두 벡터가 이루는 코사인 값을 곱해주는 방법
	- u = {1,2,3}, v = {1,2,3}, 두 벡터가 이루는 각도가 60°일때 u⋅v = 7

## 내적의 특징
### 자기 자신을 내적하면 제곱이 된다.
- 두 벡터가 이루는 cosθ 값이 1이 되기 때문에 제곱이다. 

### 두 단위벡터가 평행하면 내적의 절댓값은 1이다.
- 벡터 두개가 평행하는 경우는 같은 방향, 반대 방향으로 향하는 것이다. cosθ 값이 1 혹은 -1 이기 때문에 절댓값은 1이다.

### 교환법칙과 분배법칙이 성립한다.
- 벡터의 내적은 교환법칙과 분배법칙 모두 성립한다.
    
## 내적의 활용
### 두 벡터가 이루는 사이각을 구할 수 있다.
- cosθ = u⋅v / |u||v|
- θ = arccos(u⋅v / |u||v|)

### 게임에서 적이 플레이어의 앞에 있는지 뒤에있는지 판별할 수 있다.:star:
- 플레이어의 방향 벡터A와 플레이어와 적의 거리 차이로 나오는 벡터B를 내적한다.
- 내적시에 cosθ 값이 0보다 크면 앞쪽에, 0보다 작으면 뒤쪽에 있는 것으로 판별할 수 있다. 
- 사이각의 절댓값이 90°사이에 있으면 앞에 있는 것이고 반대는 뒤에 있는 것이다.
![dot1](https://user-images.githubusercontent.com/21440957/70377055-27dd0e80-1953-11ea-8eec-af3c3a65367c.png)

- B1, B2와 A가 이루는 각도는 90도보다 작기 때문에 cosθ값은 0보다 크다.
- B3, B4와 A가 이루는 각도는 90도보다 크기 때문에 cosθ값은 0보다 작다.

### 게임에서 적이 플레이어의 시야 안에 들어와 있는지 판별할 수 있다.:star:

![dot2](https://user-images.githubusercontent.com/21440957/70377128-28c27000-1954-11ea-827f-755b76c9540a.png)

- 플레이어의 시야각이 θ일때 플레이어의 방향 벡터A와 적과 플레이어의 거리 차이로 나오는 벡터B 간의 내적을 통해 나오는 각도 θ`를 구한다.
- θ`가 θ/2 를 넘지 않는다면 시야 내에 존재한다는 것을 판별할 수 있다. 

### 점A와 평면S간의 최단거리를 구할 수 있다.

![image](https://user-images.githubusercontent.com/21440957/70377185-b30ad400-1954-11ea-8d50-312a8c33c958.png) **=> 단면**
![image](https://user-images.githubusercontent.com/21440957/70377237-65429b80-1955-11ea-8b29-6a17d2086520.png)

- 점A에서 평면에있는 점B를 빼서 만든 벡터와 평면의 수직벡터를 내적하면 점A와 평면S간의 최단거리를 구할 수 있다.
- 이때 값이 0이면 점A는 평면S위의 점이다.
