# **드로우콜 줄이기**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## Draw Call ?
- CPU가 GPU에게 그려달라고 요청(또는 데이터를 전송)하는 것
- 값이 적을수록 가벼운 게임이라고 볼 수 있다.
- 기기의 성능에 따라 특정 수를 넘어가면 프레임 저하가 나타난다.
- 오브젝트를 그릴 때 오브젝트단위로 한 개씩 증가한다. 셰이더에 따라서 추가로 증가할 수 있다.

## 드로우콜을 줄이는 방법
### 1. Batching
#### Batching ?
- **동일한 메터리얼을 공유**하는 오브젝트들을 묶어서 드로우콜하는 기법
- **동일한 메터리얼을 공유**하는 오브젝트만 배칭할 수 있다.
- 일괄적으로 처리함으로써 효율적인 렌더링이 가능하게 한다.
- 배칭은 Static 체크 유무로 동적/정적 배칭 두 가지 종류로 나뉜다.(unity)

#### 동적 배칭
- 동일 메터리얼만 공유하면 자동적으로 적용된다.
- 동적 배칭을 사용하려면 몇 가지 조건이 필요하지만 알아서 적용이 되고, 효율도 뛰어나지 않다.
- 드로우콜 하는 것보다 효율이 안 좋은 경우도 있다.

#### 정적 배칭
- 오브젝트의 위치, 회전, 스케일값의 변동이 없어야 하며 명시적으로 설정 한다.
- 동일한 Material을 공유하고 움직이지 않는 오브젝트에 대해 Static을 체크해줄 경우 일어나는 배칭이다 (Unity)
- 변화가 없는 구조물 같은 오브젝트들의 설정에 적합하다.
- 눈에 띄는 효과가 나오기 때문에, CPU 부담을 줄일 필요가 있을 경우 사용해야한다.
- 메모리가 많이 필요하기 때문에 적은 메모리를 사용해야 한다거나 과도하게 많은 오브젝트를 사용할 때는 피해야 한다.

### 2. Texture Atlas (텍스쳐 아틀라스)
- 여러 이미지들을 한 묶음으로 만드는 방법이다.
- UGUI에서는 `Sprite Packer`, NGUI에서는 `Atlas maker`를 사용하여 아틀라스를 만들 수 있다.
- 아틀라스로 텍스쳐들을 하나로 묶어주면 매터리얼들을 일괄적으로 처리 가능하며 드로우 콜을 줄일 수 있다.

### 3. Light Map (라이트 맵)
- 빛과 관련된 실시간 연산(그림자등)이 성능에 부담되므로 미리 **맵을 이미지**로 만든다.
- 맵을 굽는다(Baked)고 하며 구워진 맵을 라이트맵이라고 한다.
- 맵을 구울 때 시간이 오래 걸리지만 성능 개선에 탁월하다.

### 4. Occulusion Culling (오클루젼 컬링)
- 어떤 오브젝트에 완전히 가려진 오브젝트의 렌더링을 무효화하는 기법이다.
- 적용 오브젝트에 Static체크를 해주어야 한다. (Unity)
