# 속도의, 속도에 의한, 속도를 위한 몽고DB (네이버 컨텐츠검색과 몽고DB)

API, File, DB를 Spring Batch로 긁어와서 가공한다음에 MongoDB에 indexing

## MongoDB index 이해
- 컬렉션당 최대 64개의 인덱스만 생성 가능
- 너무 많은 인덱스를 추가하면 오히려 부작용
    - Frequent Swap
    - Write performance 감소.
    - 인덱스가 많으면 쿼리가 엉뚱한 인덱스를 골라서 성능이 떨어질 수도

- Index Prefix의 이용
- 멀티 소팅
    - Sort Key들은 반드시 인덱스와 같은 순서로 나열되어야 한다.
    - compound 인덱스의 경우 소팅 방향이 중요함.
    - single field의 경우 소팅 방향을 걱정할 필요 없음 


## 몽고DB 속도 올리기
- 하나의 컬렉션을 여러 컬렉션으로 나누자
    - 너무 많은 문서를 가질 경우(기준은 벤치마크 응답속도에 따라 다르다.), 인덱스의 사이즈가 증가하고 인덱스 필드의 cardinality가 낮아질 가능성이 높다.
    - 컬렉션을 나눠서 중복되는 index key를 look up 을 방지해야 한다.


- 쓰레드를 이용해서 대량의 Document를 upset

- hint를 이용해 강제로 인덱스 태워보내기


index를 설정했는데 index를 안탄다 왜 ?? >> Query Planner 때문

### Query Planner
- **이전에 실행한 쿼리 플랜을 캐싱해놓음**
- 캐싱된 쿼리 플랜이 없다면 가능한 모든 쿼리 플랜들을 조회해서
- **첫 batch**(101개)를 **가장 좋은 성능**으로 가져오는 플랜을 다시 캐싱함.
- 성능이 너무 안좋아지면 위 작업을 반복 
- 동점이 나오면 in-memory-sort를 하지 않아도 되는 sort를 선택

특정 쿼리의 전체 조회는 느릴 수 있지만, 101개의 object는 빠르게 가져올 수 있다.

### 해결책. Hint vs 엄한 인덱스 지우기
- Hint
    - 확실한 쿼리플랜 보장
    - 더 효율적인 index가 생겨도 강제 고정
    - 데이터 분포에 대한 정보를 계속 follow 해야 함
    - 32MB 넘는 응답결과를 sort할 경우 에러

- **엄한 인덱스 지우기**(선택함)
    - 데이터에 따라 더 효율적인 인덱스가 생기면 자동 대응
    - 또다른 엄한 케이스가 생길수도
    - 삭제로 인해 영향 받는 다른 쿼리가 생길 수 있음
      (계속 삭제하다 보니 결국 해결함)
     