## **Template Method Pattern**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## Template Method Pattern ?
![TemplateMethod](https://user-images.githubusercontent.com/21440957/164040335-8e189af6-edbe-48b4-ace9-7846e00e06bd.png)

- 어떤 작업을 처리하는 일부분을 서브 클래스로 **캡슐화**해 전체 일을 수행하는 구조는 바꾸지 않으면서 특정 단계에서 수행하는 내역을 바꾸는 패턴이다.
- 동일한 기능을 상위 클래스에서 정의하면서 확장/변화가 필요한 부분만 서브 클래스에서 구현할 수 있도록 한다.

## 관련 용어
### AbstractClass
- 템플릿 메소드를 정의하는 클래스
- 하위 클래스에 공통 알고리즘을 정의하고 하위 클래스에서 구현될 기능을 훅 메소드로 정의하는 클래스

### ConcreteClass
- 물려받은 훅 메소드를 구현하는 클래스
- 상위 클래스에 구현된 템플릿 메소드의 일반적인 알고리즘에서 하위 클래스에 적합하게 훅 메소드를 오버라이드하는 클래스

## 특징
- 전체적으로는 동일하지만 부분적으로는 다른 구문으로 구성된 함수의 **코드 중복을 최소화** 할 때 유용하다.
- 추상 메소드와 훅 메소드를 적절히 사용해서 전체적인 뼈대를 유지하면서 **유연하게 기능을 변경**할 수 있도록 하고자 할때 유용하다.
- 전체적인 알고리즘은 상위 클래스에서 구현하면서 다른 부분은 하위 클래스에서 구현할 수 있도록 함으로써 전체적인 알고리즘 코드를 재사용하는 데 유용하다.
- **상위 클래스**형의 변수에 **하위 클래스**의 어떠한 인스턴스를 넣어도 작동하는 `LSP` 원칙에 부합한다.

## 장점
- **코드의 중복을 제거**할 수 있다.
- 자식 클래스의 역할을 감소시키면서 **핵심 로직 관리에 용이**하다.
- **객체 추가 및 확장**을 쉽게 할 수 있다.

## 단점
- 추상 메소드가 너무 많아지면 **클래스 관리**가 힘들어진다.
- 추상 클래스와 구현 클래스간 **복잡성**이 커진다.

## 예제
- [TemplateMethod](/code/TemplateMethod.cpp)