# **Singleton Pattern**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## Singleton Pattern?

![Singleton](https://user-images.githubusercontent.com/21440957/165775075-172c24ac-001d-49f8-a59d-e22669002a46.png)

- 전역 변수를 사용하지 않고 객체를 하나만 생성 하도록 하며, 생성된 객체를 어디에서든지 참조할 수 있도록 하는 패턴이다.
- 커넥션 풀, 스레드 풀, 디바이스 설정 객체 등 인스턴스를 여러 개 만들면 자원을 낭비하거나 문제를 발생시킬 수 있는 객체에 대해 하나의 객체만 생성하고 인스턴스를 사용하도록 하는것이 목적이다.
- 같은 인스턴스를 여러 개 만드는 것이 아니라 이전에 생성한 하나의 인스턴스를 사용한다.

## 구현 방법
- 외부에서 객체를 생성할 수 없도록 생성자를 `private`으로 선언한다.
- 외부에서 객체를 생성할 수 없으므로 미리 생성된 자신을 반환할 수 있도록 `getInstance()` 함수를 정의한다.
- `getInstance()` 함수를 호출했을 때
  - 객체가 할당되어 있지 않으면 새로운 객체를 생성한다.
  - 객체가 이미 있으면 그것을 반환한다.

## 장점
- 메모리 낭비를 방지할 수 있다.
  - `singleton` 객체를 사용하지 않는 경우 인스턴스를 생성하지 않는다.
- `singleton`으로 만들어진 클래스와 다른 클래스의 인스턴스들의 데이터 공유가 쉽다.
- 인스턴스가 한개만 존재하는 것을 보증하기에 실수를 줄일 수 있다.

## 단점
- 전역변수보다 사용하기가 불편하다.
- `singleton`의 역할이 커질수록 결합도가 높아져 개방 폐쇄 원칙(`OCP`)에 어긋날 수 있다.
- 멀티쓰레드 환경에서 컨트롤하기 어렵다.
- 객체의 파괴 시점을 컨트롤하기 어렵다.

## 예제
- [Singleton Pattern](/code/Singleton.cpp)