## **AbstractFactoryPattern**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## AbstractFactory Pattern ?
![AbstractFactory](https://user-images.githubusercontent.com/21440957/168207914-7e8ff443-93c6-4d52-9650-14d722a67423.png)

- 서로 관련이 있는 객체들을 통째로 묶어서 팩토리 클래스로 만들고, 이들 팩토리를 조건에 따라 생성하도록 다시 팩토리를 만들어서 객체를 생성하는 패턴
- 팩토리 메서드 패턴을 좀 더 캡슐화한 방식이다.
- 구체적인 클래스에 의존하지 않고 서로 연관되거나 의존적인 객체들의 조합을 만드는 인터페이스를 제공하는 패턴이다.
  - 관련성 있는 여러 종류의 객체를 일관된 방식으로 생성하는 경우에 유용하다.

## 특징
- 다양한 구성 요소 별로 객체의 집합을 생성해야 할 때 유용하다. 이 패턴을 사용하여 상황에 알맞은 객체를 생성할 수 있다.
- 특정 제품들을 모아서 제품 군 형태로 관리하고, 제품 군 내에서 객체를 생성하여 일관성을 지킬 수 있다.

## 사용 하는 경우
- 객체가 생성되거나 표현되는 방식과 무관하게 **시스템을 독립적**으로 만들고자 할 때
- 여러 제품군 중 하나를 선택해서 시스템을 설정하고 한번 구성한 제품을 **다른 것으로 대체**할 수 있을 때
- 관련된 제품 객체들이 함께 사용되도록 설계되었고, 이 부분에 대한 제약이 외부에도 지켜지도록 하고 싶을 때
- 제품에 대한 클래스 라이브러리를 제공하고 구현이 아닌 **인터페이스를 노출**시키고 싶을 때

## 관련 용어
### AbstractFactory
- 실제 팩토리 클래스의 공통 인터페이스

### ConcreteFactory
- 구체적인 팩토리 클래스로 `AbstractFactory` 클래스의 추상 메서드를 오버라이드하여 구체적인 제품을 생성한다.

### AbstractProduct
- 제품의 공통 인터페이스

### ConcreteProduct
- `ConcreteFactory` 클래스에서 생성되는 구체적인 제품

## 장점
- 구체적인 클래스를 분리한다.
  - 응용 프로그램이 생성할 객체의 클래스를 제어할 수 있다.
  - 팩토리는 제품 객체 생성을 캡슐화 한 것이기 때문에, 구체적인 구현 클래스가 사용자에게서 분리된다.
  - 일반 프로그램은 추상 인터페이스를 통해서만 인스턴스를 조작한다.
- 제품군을 쉽게 대체할 수 있다.
  - 구체 팩토리의 클래스는 응용프로그램에서 한 번만 나타나기 때문에 응용프로그램이 사용할 구체 팩토리를 변경하기는 쉽다.
  - 구체 팩토리를 변경함으로써 응용프로그램은 **서로 다른 제품을 사용**할 수 있게 변경된다.
  - 추상 팩토리는 필요한 모든 것을 생성하기 때문에 전체 제품군은 한 번에 변경이 가능하다.

## 단점
- 새로운 종류의 제품을 제공하기 어렵다.
  - 새롭게 생성되는 제품은 추상 팩토리가 생성할 수 있는 제품 집합에만 고정되어 있기 때문이다.
  - 새로운 종류의 제품이 등장하면 팩토리의 구현을 변경해야 한다.
  - 추상 팩토리와 모든 서브클래스의 변경을 가져온다. 

## [팩토리 메소드 패턴](/design_pattern/FactoryMethodPattern.md)과의 차이점
### 팩토리 메소드 패턴
- 상속을 통해 객체를 만든다.
- 팩토리 메소드 패턴을 이용해 객체를 만들 때는 수퍼 클래스를 확장하고 팩토리 메소드를 오버라이드 해야 한다.
- 객체 생성을 담당하는 팩토리가 서브 클래스에 구현되어 있다.
- 일반적으로 한 가지 객체를 생성할 때 사용한다.

### 추상 팩토리 패턴
- 객체 구성을 통해 만든다.
- 연관된 객체들의 집합을 만들기 위한 추상 형식을 제공한다.
- 제품이 생상되는 방법은 추상 형식의 서브 클래스에 정의된다.
- 여러 객체를 하나의 응집화된 군을 만들 때 사용한다.

## 예제
- [AbstractFactory Pattern](/code/AbstractFactory.cpp)