# **낙관적 락과 비관적 락**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## 프리뷰
```
1. A가 R1을 읽는다.
2. B가 R1을 읽는다.
3. A가 R1을 수정한다.
4. B가 R1을 수정한다.
```
- 일반적으로 B는 A의 수정이 끝나기전의 데이터를 읽었기 때문에 최종적으로는 B의 수정사항만 반영된다.
- 이처럼 동시성 프로그래밍에서 고려해야할 사항으로 `transaction` 처리가 존재한다.
- `transaction`을 어떤방향으로 처리하면 좋을까?

## 낙관적 락?
- 충돌이 발생하지 않는다고 가정한다. (비선점 락)
- 락을 해야하는 상황이 **발생하면 대응**한다.
- 레코드를 읽고 버전 번호를 기록하고 레코드를 다시 쓰기 전에 버전이 변경되지 않았는지 확인하는 전략이다.

### 특징
- 레코드를 다시 쓸 때 버전에 대한 업데이트를 필터링하여 `atomic`함을 확인한다.
- 레코드의 버전이 다르면 `transaction`을 중단하고 다시 시작할 수 있다.
- 버전 번호를 체크할때는 날짜, 타임 스탬프, 체크섬, 해시등의 방법을 사용한다.

## 비관적 락?
- 충돌이 발생한다고 가정하고 락을 건다. (선점 락)
- 무조건 **잠그고 작업**한다.
- 완료할때까지 독점 사용을 위해 레코드를 잠그는 전략이다.

### 특징
- 낙관적 락보다 무결성이 우수하다.
- 교착상태가 발생할 수 있다.

## Link
- [stackoverflow](https://stackoverflow.com/questions/129329/optimistic-vs-pessimistic-locking)