# **트랜잭션의 ACID 속성**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## 트랜잭션이란?
- 데이터베이스의 상태를 변환시키는 하나의 기능을 수행하기 위한 **논리적 단위**
- query가 수행될 때
    - 중단이 됐을 경우 처음부터 다시 실행하는 **Rollback**
    - 모든 작업을 마쳤을 경우 **Commit**
> A가 B에게 돈을 송금하는 과정에서 오류로 인해 A의 돈은 출금되었지만 B에게 입금이 되지 않았을 때, A의 돈을 다시 복구(Rollback)해야 하는데 이러한 일련의 과정을 트랜잭션이라고 한다.

## ACID란?
- 트랜잭션이 **안전하게 수행**된다는 것을 **보장**하기 위한 성질이다.
- **동시성제어**와 **회복 기법**을 활용하여 보장한다.

### 원자성(Atomicity)
- 하나의 트랜잭션은 하나의 원자적 수행단위이다.
- 트랜잭션은 **완전히 수행**되거나 **전혀 수행되지 않아야** 한다.(**All or Nothing**)
- **회복 기법**을 활용하여 보장한다.

### 일관성(Consistency)
- 트랜잭션을 완전히 실행하면 데이터베이스를 하나의 **일관된 상태**에서 또 다른 **일관된 상태**로 바꿔야한다.
- **동시성제어**와 **회복 기법**을 활용하여 보장한다.

### 고립성(Isolation)
- 하나의 트랜잭션은 다른 트랜잭션들과는 **독립적으로 실행**되는것 처럼 보여야 한다.
- 하나의 트랜잭션 실행시 동시에 실행중인 다른 트랜잭션의 간섭을 받으면 안된다.
- 성능 관련 문제로 인해 유연하게 조절할 수 있도록 고립 수준을 단계별로 구분한다.
- **동시성 제어**를 활용하여 보장한다.

### 지속성(Durability)
- 성공적으로 완료된 트랜잭션의 결과는 시스템이 고장나더라도 **영구적으로 반영**되어야 한다.
- **회복 기법**을 활용하여 보장한다.

## 사전지식
### 동시성 제어
- 다양한 Lock 기법을 이용해 동시성 제어
- **Locking** 기법(2단계 로킹) : Shared Lock, Exclusive Lock을 활용한 제어
- **TimeStamp** 기법 : 트랜잭션의 시작 시간을 이용해 제어
- **낙관적**(검증) 기법 : 각 트랜잭션마다 Copy해서 작업 후 변동 부분을 검증하며 한꺼번에 반영
- Locking, TimeStamp등을 활용한 **다중버전**(MVCC) 기법(유명한 DBMS에서 많이 사용:+1:) : 한 데이터 항목에 대해 여러개의 버전을 이용하여 이전 버전의 데이터를 활용한 처리방법

### 회복 기법
- 트랜잭션 고장, 시스템 고장, 매체 고장 등으로 문제가 생겼을때 회복하는 방법
- **트랜잭션 고장** : Rollback을 통한 undo
- **시스템 고장** : WAL 기법을 통한 undo, redo
- **매체 고장** : 백업
