# **형 변환 연산자**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## 형 변환 연산자
### 1. dynamic_cast
#### dynamic_cast <T>(expr)
- 상속관계에서의 안전한 형 변환
- 기초 클래스의 포인터 형을 유도 클래스의 포인터 형으로 형 변환하는 것은 일반적인 경우의 형 변환이 아니다.
-  상속관계에 있는 유도 클래스의 포인터 및 참조형 데이터를 기초 클래스의 포인터 및 참조형 데이터로 형 변환한다.
- 컴파일 시간이 아닌 실행시간에 안전성을 검사하도록 컴파일러가 바이너리 코드를 생성한다.
- <> 사이에 변환하고자 하는 자료형의 이름을 두되, 객체의 포인터 또는 참조형이 와야 하며, () 사이에는 변환의 대상이 와야 한다.
- 요구한 형 변환이 적절하지 않은 경우에는 컴파일 시 에러가 발생한다.

```cpp
// A <- B일 때
A * a = new B();
B * b = dynamic_cast<B*>(a); // 컴파일 에러
A * a = new a();
B * b = dynamic_cast<B*>(a); // 컴파일 에러
B * b = new B();
A * a = dynamic_cast<A*>(b); // 컴파일 OK
```

### 2. static_cast
#### static_cast <T>(expr)
- A타입에서 B타입으로 변환한다.
- 기본 자료형 간의 형 변환에서 사용된다.
- 클래스의 상속관계에서의 형 변환에서 사용된다.
- **유도 클래스**의 포인터 및 참조형 데이터를 **기초 클래스**의 포인터 및 참조형 데이터로 뿐만 아니라, **기초 클래스**의 포인터 및 참조형 데이터도 **유도 클래스**의 포인터 및 참조형 데이터로 아무런 조건 없이 형 변환할 수 있다.
- dynamic_cast 연산자와 달리보다 많은 형 변환을 허용한다.
- 형 변환으로 인한 책임도 프로그래머가 져야 한다.

### 3. const_cast
#### const_cast <T>(expr)
- **const의 성향을 삭제**한다.
- const 선언으로 인한 형의 불일치가 발생해서 인자의 전달이 불가능한 경우에 유용하게 사용이 된다.

### 4. reinterpret_cast
#### reinterpret_cast <T>(expr)
- 상관없는 자료형으로의 형 변환. 결과는 예측하지 못한다.
- 포인터를 대상으로 하는, 그리고 포인터와 관련이 있는 모든 유형의 형 변환을 허용한다.

```cpp
int num=72;
int * ptr = &num;
int adr=reinterpret_cast<int>(ptr); //주소 값을 정수로 변환
cout<<"Addr : "<<adr<<endl; //주소 값 출력
int * rptr = reinterpret_cast<int*>(adr); //정수를 다시 주소 값으로 변환
cout<<"value: "<<*rptr<<endl; // 주소값에 저장된 정수 출력
상속관계에 놓여있는 두 클래스 사이
``` 

## 정리
1) **유도 클래스**의 포인터 및 참조형 데이터를 **기초 클래스**의 포인터 및 참조형 데이터로 형 변환할 경우에는 **dynamic_cast** 연산자를 사용한다.
2) **기초 클래스**의 포인터 및 참조형 데이터를 **유도 클래스**의 포인터 및 참조형 데이터로 형 변환할 경우에는 **static_cast** 연산자를 사용한다.
3) dynamic_cast 연산자도 기초 클래스의 포인터 및 참조형 데이터를 유도 클래스의 포인터 및 참조형으로의 형 변환을 허용한다.
단, 기초 클래스가 Polymorphic<sup>[1)](#ref1)</sup> 클래스일 때만 허용한다.

## 각주
<a id="ref1">

1) 하나 이상의 가상 함수를 지니는 클래스

</a>
