# **inline**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## inline
```cpp
inline int max(int x, int y)
{
    return x > y ? x : y;
}

int main()
{
    std::cout << max(1, 6) << std::endl; // std::cout << (1 > 6 ? 1 : 6) << std::endl;
    return 0;
}
```
- 호출 부분을 함수 전체 코드로 **치환하여 컴파일**한다.
- 함수처럼 보이고 함수처럼 동작하며 매크로보다 안전하고 쓰기 좋다.
- 함수 호출 시 발생하는 오버헤드를 걱정할 필요가 없다.
- 컴파일러가 함수 본문에 문맥별 최적화 걸기에 용이하다.
- 본문 길이가 짧은 인라인 함수를 사용하면, **함수 본문**에 대해 만들어지는 코드의 크기가 **함수 호출문**에 대해 만들어지는 코드보다 작아질 수 있다.
    - 목적 코드의 크기가 **작아**진다.
    - 명령어 **캐시 적중률**이 높아진다.
- 어떤 템플릿으로부터 만들어지는 모든 함수가 인라인 함수였으면 싶은 경우 템플릿에 `inline`을 붙여 선언한다.

## 주의할 점
- 남발하면 프로그램 크기가 커질 수 있다.
    - 기계에서 쓸 수 있는 공간을 넘을 수 있다.
    - 가상 메모리를 쓰더라도 성능의 걸림돌이 될 수 있다.
    - 페이징 횟수가 늘어난다.
    - 명령어 캐시 적중률이 떨어진다.
- 인라인 함수는 대체적으로 **헤더 파일**에 들어 있어야 한다.
    - 대부분의 빌드 환경에서 인라인을 **컴파일 도중에 수행**하기 때문이다.
- 컴파일러 입장에서 디버깅이 매우 어렵다.
- **생성자**와 **소멸자**는 인라인 하기 좋지 않은 함수이다.

## 인라인 함수의 후보를 결정하는 방법
- 컴파일러가 인라인 함수의 후보들을 결정한다.
- 컴파일러 선에서 무시할 수 있는 **요청**이고 컴파일러가 판단하여 인라인 함수로 바꾼다.
- 인라인 함수로 선언되어 있어도 컴파일러가 보기에 복잡한 함수는 인라인 확장 대상에 넣지 않는다.
- 간단한 함수여도 **가상 함수 호출**은 절대로 인라인해 주지 않는다.

### 클래스 정의 안에 함수를 정의해 넣으면 컴파일러는 함수를 인라인 후보로 찍는다.
```cpp
class Person{
public:
    int age() const {return theAge;} // 암시적인 인라인 요청
private:
    int theAge;
}
```

### 함수 정의 앞에 inline 키워드를 붙인다.
- 표준 라이브러리의 `max` 템플릿이 있다.
```cpp
template<typename T>
inline const T& std::max(const T& a, const T& b)
{
    return a < b ? b : a;
}
```

## 참고
- Effective C++ (이펙티브 C++)