## **Dangling Pointer**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## Dangling Pointer ?
- 적절한 타입의 유효한 객체를 가리키고 있지 않는 포인터이다.
- 메모리가 해제 된 곳을 가리키고 있는 포인터이다.

## 발생하는 상황
- 객체에 대한 참조가 포인터 값에 대한 수정 없이 삭제되거나 할당 해제돼서 포인터가 계속 할당 해제된 메모리를 가리킬 때이다.
- 기존 프로그램이 `Dangling pointer`를 역참조하면 메모리는 전혀 다른 데이터를 갖고 있을 것이므로 예측할 수 없는 행동이 발생한다.
- 포인터가 알려진 상태로 초기화되기 전에 사용될 때 발생한다.
- 프로그램이 **허상 포인터**가 가리키는 메모리에 쓰기를 하면 관련되지 않은 데이터의 오염이 발생하게 된다.
- 리눅스, 유닉스의 경우에는 세그멘테이션 오류가 발생한다.
- 윈도우의 경우에는 일반 보호 오류가 발생한다.
- 객체 지향 프로그래밍의 경우 쓰레기 수집으로 허상 참조들은 참조되지 않는 객체를 파괴함으로써 예방된다.
- **추적**이나 **참조 횟수 계산 방식**에 의해 보증된다.

## 문제점
- 메모리 접근 시 예측 불가능한 동작을 일으킬 수 있다.
- 메모리에 접근이 불가능 하면 `Segmentation fault`가 발생한다.
- **보안 위협**이 존재 한다.

## 예제 1

```cpp
int* ptr = new int(1);
*ptr = 1;
cout << *ptr << endl;

delete ptr;
*ptr = 2;
cout << *ptr << endl;
```

- `*ptr`을 1로 출력하고 메모리를 해제하였지만 할당된 메모리 영역을 가리키고 있다.
- 이 상황에서 해제된 메모리 영역에 접근하게 되면 댕글링 포인터가 된다.
- `visual studio`에서는 `*ptr = 2;`에서 예외가 발생한다(액세스 위반)

![dangling1](https://user-images.githubusercontent.com/21440957/174468624-95075103-b8a9-45f1-a7f3-223e3f4c4819.PNG)

## 예제 2

```cpp
int* a = new int(1);
*a = 1;
int* b = a;
cout << *a << " " << *b << endl;

delete a;
cout << *b << endl;
```

- 위 상황에서 두번째 `b`를 출력할때는 `b`가 댕글링 포인터이기 때문에 쓰레기값을 출력하게 된다.

![dangling2](https://user-images.githubusercontent.com/21440957/174468629-02c0b509-7667-41ed-a19d-d3c0092f85b1.PNG)

## 해결방법
- 메모리를 해제한 다음에는 포인터를 `null`로 설정한다.

```cpp
delete(ptr);
ptr = nullptr;
```

### 스마트 포인터
- 레퍼런스 기반의 스마트 포인터인 `WeakPtr`, `SharedPtr`을 사용한다.