# **Const**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)

## const
- 상수를 선언할 수 있도록 도와주는 **키워드** 
- const로 선언된 값은 변경할 수 없다.
- 한번 설정된 값은 read-only memeory에 올라가게 되고 변경할 수 없다. 

```cpp
const int k = 10; 
k = 20; // 에러 발생. 값 변경 불가
```
- **int형 변수 k**를 **상수화** 한다.

## 상수를 가리키는 포인터
- 상수만을 가리키는 포인터. 포인터를 이용해서 가리키는 값을 변경할 수 없다.
- **가리키는 대상**은 변경이 가능하지만, **가리키는 값**은 변경할 수 없다.

```cpp
int a = 5;
int b = 10;
const int * ptr = &a;
// *ptr = 10; // 에러 발생. 포인터가 가리키는 값 변경 불가
std::cout << *ptr << std::endl; // 5
ptr = &b; // 포인터가 가리키는 대상은 변경 가능
std::cout << *ptr << std::endl; // 10
```

## 상수 포인터
- 포인터를 상수화 시킨다.
- 포인터가 **가리키는 대상**은 변경할 수 없고, **가리키는 값**은 변경이 가능하다.

```cpp
int a = 5;
int b = 10;
int * const ptr = &a;
*ptr = 7; // 포인터가 가리키는 값은 변경 가능
std::cout << *ptr << std::endl; // 7
// ptr = &b; // 에러 발생. 포인터가 가리키는 대상 변경 불가
```
- 포인터가 상수기 때문에 포인터 값을 변경할 수가 없다.

## 상수를 가리키는 상수 포인터
- **가리키는 대상** 및 **값**의 변경이 불가능하다.
```cpp
int a = 5;
int b = 11;
const int * const ptr = &a;
// *ptr = 10; // 에러 발생. 포인터가 가리키는 값 변경 불가
// ptr = &b; // 에러 발생. 포인터가 가리키는 대상 변경 불가
```
- 포인터 ptr가 상수화 되었으며, ptr을 가리키는 대상을 a에서 b로 변경하는것이 불가능하고 현재 포인터가 가리키는 a의 값도 변경할 수 없다.

## const 함수
- 함수 뒤에 const 선언을 하면 함수 내에서는 멤버 변수에 저장된 값을 변경하지 않겠다는 뜻을 가진다.
- const함수 내에서는 const가 아닌 함수의 호출이 제한된다.
```cpp
void func(int a) const
{
    std::cout<<"FUNC"<<std::endl;
}
```
