# **컴퓨터에서의 실수 표현방법**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## 컴퓨터에서 실수를 어떻게 표현할까?
- 실수 `3.625`를 컴퓨터에 저장한다고 생각해보자
- 위 수를 이진법으로 변환하면 정수부는 `11`<sub>(2)</sub>의 값이 되고 소수부는 `0.101`<sub>(2)</sub> 가 된다. 참조 - [2진수10진수 변환](https://github.com/jobhope/TechnicalNote/blob/master/computer_architecture/BinaryDecimalConversion.md)
- 이진수로 변환한 `11.101`을 컴퓨터에 저장할 때 사용할 수 있는 방법이 두가지가 있는데 이것이 고정 소수점과 부동 소수점이다.

## 고정 소수점과 부동 소수점
### 고정 소수점
- 수를 표현할 때 고정된 위치를 기준으로 정수부와 소수부로 나누어서 값을 표현하는 방식이다.
- 소수부에 할당된 비트의 숫자에 따라 정밀도가 달라진다.
- 단점으로는 소수점의 위치가 고정이어서 표현 가능한 실수의 범위가 제한적이라 잘 사용하지 않는다.
- 32비트의 수 일때 **부호 표현 1비트**, **정수 표현 15비트**, **소수 표현 16비트**를 사용하는 방법이다.

#### 위에서 변환한 수 11.101을 부동소수점 방식으로 표현해 보자.(32bit 기준) 
1) 부호부를 0으로 지정한다(양수 0, 음수 1)
2) 정수부인 11뒤에 15비트에 맞춰 0을 채운다 (000000000000011)
3) 소수부의 101뒤에 16비트에 맞춰 0을 채운다 (1010000000000000)

| 부호 | 정수 | 소수 |
|:---:|:---:|:---:|
| 0 | 000000000000011 | 1010000000000000 |
> 00000000000000111010000000000000

### 부동 소수점
- 수를 표현할 때 고정 소수점 방식처럼 정수와 소수 부분으로 나누지 않고, 지수 부분과 가수 부분으로 나눠서 표현한다.

#### IEEE 754
- 대표적인 부동 소수점 표현 방식이다.
- IEEE 754의 부동 소수점 표현은 크게 세 부분으로 구성되는데, **최상위 비트**는 부호를 표시하는 데 사용되며, **부호 부분**(1bit), **지수 부분**(8bit), **가수 부분**(23bit)이 있다.<sup>[1)](#ref)</sup>
- IEEE 754에는 32 비트 단정도, 64 비트 배정도, 43 비트 이상의 확장 단정도, 79 비트 이상의 확장 배정도에 대한 형식을 정의하고 있다.

#### 위에서 변환한 수 11.101을 부동소수점 방식으로 표현해 보자.(32bit 기준)
1) 부호부를 0으로 지정한다(양수 0, 음수 1)
2) 소수점을 왼쪽으로 이동시켜 왼쪽에 수가 한개만 남도록 한다(11.101 -> 1.1101 * 2<sup>1</sup>)
3) 소수점을 제거하고 가수부의 비트 수에 맞춰 부족한 만큼을 0으로 채우면 이게 가수부가 된다 (11101뒤에 0을18개 붙여주면 된다 11101000000000000000000)
4) 위에서 계산한 지수는 1이므로 (1.1101 * 2<sup>1</sup>) 1에 Bias(127)를 더한 128을 이진법으로 표현한 10000000이 지수부가 된다.
5) 위에서 구한 부모, 지수, 가수를 차례대로 표현해주면된다.

| 부호 | 지수 | 가수 |
|:--------:|:--------:|:--------:|
| 0 | 10000000 | 11101000000000000000000 |
> 01000000011101000000000000000000

## LINK
<a id="ref"></a>
1) [Wiki](https://en.wikipedia.org/wiki/IEEE_754)

