# **DiceProblem**
## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## Problem
### 주사위 확장
- 일반적인 주사위는 1부터 6까지 같은 확률로 나오게 된다.
- 이 주사위를 1부터 18까지 같은 확률로 나오도록 확장해보자.
- 주사위는 여러번 굴리거나 여러개 사용할 수 있지만 주사위 자체는 바꿀수없다.

## Solve1
![주사위](https://user-images.githubusercontent.com/28692938/63511091-2e1dbb00-c51b-11e9-868a-a8c7b3814e94.png)

1. 주사위 6면에 각 2면씩을 빨강, 노랑, 파랑으로 칠한다. 
2. 첫 번째로 주사위 던져 눈을 기록한다.
3. 두 번째로 주사위를 던져서 나온 색깔에 해당하는 수를 곱한다.
ex) 빨강은 1, 노랑은 2, 파랑은 3

최소 1에서 최대 18까지 구현할 수 있다.

### 오류 수정
- 위 방식대로 하면 모든 수가 동일한 확률로 나오지 않는다. 예를 들어 1이 나오는 경우의 수는 (1,빨강) 으로 1/18 이지만 6이 나오는 경우의 수는 (2,파랑), (3, 노랑), (6, 빨강) 으로 3/18 이 된다. 

- 이를 해결하기 위해서는 주사위의 한 면에 숫자를 3개를 넣는다. 
- (1,7,13), (2, 8, 14) ... (6, 12, 18) 

- 첫 번째 주사위에서 한 면의 숫자 3개가 나온 것을 기록하고 
- 두 번째 주사위를 한 번 더 던져서 나온 색깔에 따라 앞선 3가지의 수 중 하나를 선택한다.
ex) 빨강=첫 번째 숫자, 노랑 = 두 번째 숫자, 파랑= 세 번째 숫자 

첫 번째 주사위에서 숫자가 나올 확률 : 1/6 
두 번째 주사위에서 한 개의 색깔이 나올 확률 : 1/3 

## Solve2
![주사위 결과](https://user-images.githubusercontent.com/35564566/63700338-ace95f80-c85d-11e9-8515-72e02c256eed.png)

1) 일반적인 주사위는 1/6으로 1 ~ 6이 같은 확률로 나오게 된다.
2) 이를 2번 연속으로 던질 때, 순서가 존재한다면 1/6의 확률로 독립시행되어 반드시  1/36의 확률로 위의 표의 값중 1가지 값이 나오게 된다.
3) 따라서 나올 수 있는 모든 경우의 수를 한 쌍으로 잡으면 위의 표 처럼 총 18가지 쌍(표의 색상) 이 나오게 되고, 이를 1 ~ 18의 숫자로 치환하면 1 ~ 18의 값을 얻을 수 있다.
4) 또한, 1 ~ 18의 값은 각각 한 쌍의 순열로 이루어져 있으므로 나올 확률은 2/36으로 1/18로 모두 같다.
5) 결과적으로 두번 연속으로 주사위를 던져서 나오는 값들을 이용해 1 ~ 18을 같은 확률로 얻을 수 있다.

## Solve3
1) 주사위를 2번 굴린다.
2) 첫번째 굴린 값(1 ~ 6)에서 %3연산을 한 후 6을 곱해 0,6,12의 값을 얻는다.
3) 두번째 굴린 값은 1 ~ 6의 값이 나온다.
4) 첫번째와 두번째 주사위의 값을 더하면 1~18까지의 값을 동일한 확률로 얻을 수 있다.
