<a id="top">

</a>

:book: TechnicalNote
===
[![GitHub contributors](https://img.shields.io/github/contributors/jobhope/technicalnote)](https://github.com/jobhope/TechnicalNote/graphs/contributors)
[![GitHub](https://img.shields.io/github/license/jobhope/technicalnote)](LICENSE)
[![GitHub issues](https://img.shields.io/github/issues/jobhope/technicalnote)](https://github.com/jobhope/TechnicalNote/issues)

### :two_men_holding_hands: **created by** 
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

### :frowning_man: **도움을 주신 분들**
<a href="https://github.com/Kaminari-j">
<img width=100 height=100 src="https://avatars2.githubusercontent.com/u/5924648?s=100&v=4"></img>
</a>
<a href="https://github.com/sojeongw">
<img width=100 height=100 src="https://avatars3.githubusercontent.com/u/33208821?s=100&v=4"></img>
</a>
<a href="https://github.com/yoogle96">
<img width=100 height=100 src="https://avatars3.githubusercontent.com/u/37542374?s=100&v=4"></img>
</a>
<a href="https://github.com/Endki">
<img width=100 height=100 src="https://avatars3.githubusercontent.com/u/24868601?s=100&v=4"></img>
</a>
<a href="https://github.com/JAlthea">
<img width=100 height=100 src="https://avatars3.githubusercontent.com/u/50026903?s=100&v=4"></img>
</a>

**도움에 감사드립니다.** :pray:

## TechnicalNote ?
- **개발 관련 지식**을 정리해 놓은 저장소입니다.
- 필기시험과 면접에서 **직접 겪었던** 내용 위주로 구성되어 있습니다.
- 잘못된 부분이 있을 수도 있으니 **가이드라인**으로 참고해주시면 되겠습니다.

## :microphone: 실제 면접 질문 모음  
- [실제 면접 질문 모음](InterviewQuestions.md)

## :books: Algorithm [:top:](#top)
- [Bubble Sort](algorithm/BubbleSort.md)
- [Selection Sort](algorithm/SelectionSort.md)
- [Insertion Sort](algorithm/InsertionSort.md)
- [Merge Sort](algorithm/MergeSort.md)
- [Quick Sort](algorithm/QuickSort.md)
- [Topology Sort](algorithm/TopologySort.md)
- [Radix Sort](algorithm/RadixSort.md)
- [Counting Sort](algorithm/CountingSort.md)
- [DiceProblem](algorithm/DiceProblem.md)
- [Kruskal](algorithm/Kruskal.md)
- [스택으로 큐 구현](algorithm/QueueImplementationWithStack.md)
- [좌표 압축 기법](algorithm/CoordinateCompression.md)
- [하노이의 탑](algorithm/TowerOfHanoi.md)

## :moneybag: C++ [:top:](#top)
- [형변환 연산자](cplusplus/TypeCastingOperator.md)
- [Const](cplusplus/Const.md)
- [Vector](cplusplus/Vector.md)
- [Virtual](cplusplus/Virtual.md)
- [가상함수의 동작 원리](cplusplus/PrincipleOfVirtualFunctionInCpp.md)
- [EnumHack](cplusplus/EnumHack.md)
- [inline](cplusplus/Inline.md)
- [EmptyClass](cplusplus/EmptyClass.md)
- [DanglingPointer](cplusplus/DanglingPointer.md)

## :computer: Computer Architecture [:top:](#top)
- [빅엔디언과 리틀엔디언](computer_architecture/BigEndianAndLittleEndian.md)
- [실행파일의 생성과정](computer_architecture/ExecutionProcess.md)
- [컴퓨터에서의 실수 표현방법](computer_architecture/RealNumberRepresentation.md)
- [10진수와 2진수의 변환](computer_architecture/BinaryDecimalConversion.md)
- [유니코드](computer_architecture/Unicode.md)

## :evergreen_tree: Data Structure [:top:](#top)
- [Stack](data_structure/Stack.md)
- [Queue](data_structure/Queue.md)
- [Deque](data_structure/Deque.md)
- [트리](data_structure/Tree.md)
- [이진트리](data_structure/BinaryTree.md)
- [트리의 순회](data_structure/TreeTraversal.md)
- [최소신장트리(MST)](data_structure/MST.md)
- [자료구조를 이용한 스택의 구현](data_structure/StackImplementation.md)
- [해싱](data_structure/Hashing.md)

## :floppy_disk: Database [:top:](#top)
- [DB 쿼리문 정리](database/DBQuery.md)
- [JOIN의 종류](database/AboutJoin.md)
- [DDL,DML,DCL](database/DDLAndDMLAndDCL.md)
- [트랜잭션의 ACID 속성](database/ACID.md)
- [트랜잭션 격리수준](database/IsolationLevel.md)
- [RDBMS와 NoSQL의 차이](database/RDBMSAndNoSQL.md)
- [낙관적 락과 비관적 락](database/OptimisticLockAndPessimisticLock.md)

## 🦉 Design Pattern [:top:](#top)
- [Command Pattern](design_pattern/CommandPattern.md)
- [Observer Pattern](design_pattern/ObserverPattern.md)
- [Strategy Pattern](design_pattern/StrategyPattern.md)
- [TemplateMethod Pattern](design_pattern/TemplateMethodPattern.md)
- [Singleton Pattern](design_pattern/SingletonPattern.md)
- [FactoryMethod Pattern](design_pattern/FactoryMethodPattern.md)
- [AbstractFactory Pattern](design_pattern/AbstractFactoryPattern.md)
- [Adapter Pattern](design_pattern/AdapterPattern.md)
- [Decorator Pattern](design_pattern/DecoratorPattern.md)
- [Composite Pattern](design_pattern/CompositePattern.md)
- [Bridge Pattern](design_pattern/BridgePattern.md)

## :video_game: Game [:top:](#top)
- [드로우콜 줄이기](game/ReduceDrawCall.md)

## :octocat: Github [:top:](#top)
- [repository를 clone할 때 모든 branch를 local에 받기](github/CloneRepository.md)
- [Pull Request 방법](github/GithubPullRequestProcess.md)

## :lips: Java [:top:](#top)
- [JVM](java/JVM.md)
- [Eclipse Attach Source 설정하기](java/EclipseAttachSourceSetting.md)
- [String, StringBuffer, StringBuilder의 차이](java/StringAndStringBufferAndStringBuilder.md)
- [HashMap과 Hashtable의 차이](java/HashMapAndHashTable.md)
- [final](java/final.md)
- [Interface와 abstract의 차이](java/InterfaceAndAbstract.md)

## :stars: JavaScript [:top:](#top)
- [Hoisting](javascript/Hoisting.md)

## :1234: Linear Algebra [:top:](#top)
- [행렬](linear_algebra/matrix.md)
- [벡터의 내적](linear_algebra/DotProduct.md)

## :globe_with_meridians: Network [:top:](#top)
- [OSI 7 Layer](network/OSI7layer.md)
- [URI, URL, URN 개념](network/URIAndURLAndURN.md)
- [포트와 소켓](network/PortAndSocket.md)
- [서브넷마스크](network/SubnetMask.md)
- [Nagle 알고리즘](network/Nagle.md)
- [TCP와 UDP의 차이](network/TCPAndUDP.md)
- [HTTP와 HTTPS](network/HTTPAndHTTPS.md)

## :bus: Operating System [:top:](#top)
- [메모리 구조](operating_system/MemoryStructure.md)
- [프로세스와 스레드](operating_system/ProcessAndThread.md)
- [Context Switching](operating_system/ContextSwitching.md)
- [동시성과 병렬성](operating_system/ConcurrencyAndParallelism.md)
- [Deadlock](operating_system/Deadlock.md)
- [CPU 스케줄링](operating_system/CPUScheduling.md)
- [페이지 교체 알고리즘](operating_system/PageReplacementAlgorithm.md)
- [메모리 단편화](operating_system/Fragmentation.md)

## :speech_balloon: Programming Language [:top:](#top)
- [객체지향 프로그래밍](programming_language/OOP.md)
- [객체 지향 원칙](programming_language/ObjectOrientedPrinciples.md)
- [자료형](programming_language/DataType.md)
- [Call by Sharing](programming_language/call-by-sharing.md)
- [Short Circuit](programming_language/ShortCircuit.md)
- [함수의 인자 전달 방식](programming_language/CallByParameterType.md)
- [접근 제한자](programming_language/AccessModifier.md)

## :lock: Security [:top:](#top)
- [대칭키와 공개키](security/encryptionKey.md)
- [파일 완전 삭제](security/DeleteFilePermanently.md)
- [DMZ(Demilitarized zone)](security/DMZ.md)

## :hammer: Software Engineering [:top:](#top)
- [디자인 패턴](software_engineering/Design%20Pattern.md)
- [오픈소스 라이센스](software_engineering/Opensource%20license.md)
- [Naming Convention](software_engineering/Naming%20Convention.md)
- [클린 코드](software_engineering/CleanCode.md)
- [MVC 패턴](software_engineering/MVCPattern.md)

## :earth_asia: Web [:top:](#top)
- [AMP와 PWA](web/AWPAndPWA.md)
- [REST란 무엇인가?](web/AboutREST.md)
- [Reverse Proxy와 Load Balancing](web/ReverseProxyAndLoadBalancing.md)
- [세션과 쿠키](web/SessionAndCookie.md)
- [Open API Architecture](web/OpenAPIArchitecture.md)
- [HTTP Cache](web/HttpCache.md)
- [HTTP Method](web/HTTPMethod.md)
- [웹 페이지 속도 개선 방법](web/PageSpeedInsights.md)
- [DI와 IoC](web/DIAndIoC.md)
- [GET과 POST의 차이](web/GETAndPOST.md)

## :open_file_folder: Window [:top:](#top)
- [메시지 루프](windows/MessageLoop.md)
- [SendMessage, PostMessage](windows/SendMessageAndPostMessage.md)
- [DLL](windows/DLL.md)
 
## :guitar: ETC [:top:](#top)
- [NAVER DEVELOPER OPEN CLASS 2019](etc/NAVER_DEVELOPER_OPEN_CLASS_2019.md)
- [DEVIEW - MongoDB](etc/DEVIEW_MongoDB.md)
- [DEVIEW - Android WebView](etc/DEVIEW_WebView.md)
- [DEVIEW - Whale 2.0](etc/DEVIEW_Whale.md)
- [template](etc/template.md)
- [마크다운 공유 편집 - hackmd](https://hackmd.io/)
